/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.geom.Point;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.map.Map;
import com.google.googlenav.map.Tile;
import com.google.map.MapPoint;
import com.google.map.MapState;
import com.google.map.Zoom;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class MapBiller {
    static final int BILLING_POINT_REQUEST_ID = 7;
    private MapPoint lastBilled = null;
    private Zoom lastBilledZoom = null;
    private Map.BillingPointListener listener = null;
    private MapPoint previousBilled = null;
    private Zoom previousBilledZoom = null;

    MapBiller() {
    }

    void doBilling(boolean bl, boolean bl2, Map map) {
        MapState mapState = map.getMapState();
        if (mapState.isSatellite() && !MapBiller.isBillingRequiredForSatellite()) {
            return;
        }
        if (this.lastBilled == null || this.lastBilledZoom != mapState.getZoom()) {
            this.sendBill(mapState.getCenterPoint(), bl, bl2, map);
        } else {
            MapPoint mapPoint = null;
            Point point = map.getPixelOffsetFromCenter(this.lastBilled);
            int n = map.getWidth();
            int n2 = map.getHeight();
            int n3 = n / 2;
            int n4 = n2 / 2;
            if (Math.abs(point.x) > n || Math.abs(point.y) > n2) {
                mapPoint = mapState.getCenterPoint();
            } else {
                int n5 = 0;
                int n6 = 0;
                if (point.x < -n3) {
                    n5 = n;
                } else if (point.x > n3) {
                    n5 = -n;
                }
                if (point.y < -n4) {
                    n6 = n2;
                } else if (point.y > n4) {
                    n6 = -n2;
                }
                if (n6 != 0 || n5 != 0) {
                    mapPoint = this.lastBilled.pixelOffset(n5, n6, mapState.getZoom());
                }
            }
            if (mapPoint != null && (this.previousBilled == null || this.previousBilledZoom != this.lastBilledZoom || mapState.getCenterPoint().distanceSquared(mapPoint) < mapState.getCenterPoint().distanceSquared(this.lastBilled))) {
                this.sendBill(mapPoint, bl, bl2, map);
            }
        }
    }

    private void sendBill(MapPoint mapPoint, boolean bl, boolean bl2, Map map) {
        MapState mapState = map.getMapState();
        this.previousBilled = this.lastBilled;
        this.previousBilledZoom = this.lastBilledZoom;
        this.lastBilled = mapPoint;
        this.lastBilledZoom = mapState.getZoom();
        MapBiller.sendBillingPointToServer(mapPoint, bl, bl2, map);
        if (this.listener != null) {
            this.listener.billingPointSent(mapState);
        }
    }

    private static boolean isBillingRequiredForSatellite() {
        return Tile.getSatType() == 6;
    }

    private static void sendBillingPointToServer(MapPoint mapPoint, boolean bl, boolean bl2, Map map) {
        MapState mapState = map.getMapState();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            MapPoint.writePoint(mapPoint, dataOutputStream);
            MapPoint.writePoint(mapState.getCenterPoint(), dataOutputStream);
            dataOutputStream.writeShort(mapState.getZoom().getZoomLevel());
            dataOutputStream.writeInt(map.getLatitudeSpan(mapState));
            dataOutputStream.writeInt(map.getLongitudeSpan(mapState));
            dataOutputStream.writeBoolean(bl);
            dataOutputStream.writeBoolean(bl2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        DataRequestDispatcher.getInstance().addSimpleRequest(7, byteArrayOutputStream.toByteArray(), false, false);
    }

    void setBillingPointListener(Map.BillingPointListener billingPointListener) {
        this.listener = billingPointListener;
    }
}

