/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Clock;
import com.google.common.Config;
import com.google.common.Log;
import com.google.common.geom.Point;
import com.google.common.graphics.GoogleGraphics;
import com.google.common.ui.RepaintListener;
import com.google.common.util.RuntimeCheck;
import com.google.googlenav.map.FlashRecord;
import com.google.googlenav.map.LayerService;
import com.google.googlenav.map.LayerTile;
import com.google.googlenav.map.MapBiller;
import com.google.googlenav.map.MapService;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.MapTileStorage;
import com.google.googlenav.map.Tile;
import com.google.googlenav.map.TileOverlayRenderer;
import com.google.map.GoogleMap;
import com.google.map.MapPoint;
import com.google.map.MapState;
import com.google.map.Zoom;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Map
implements GoogleMap {
    private final MapService mapService;
    private final Vector layerServices = new Vector();
    private int displayHeight = 0;
    private int displayWidth = 0;
    private int halfWidth = 0;
    private int halfHeight = 0;
    private int xTiles = 0;
    private int yTiles = 0;
    private int centerPixelX;
    private int centerPixelY;
    private Tile topLeftTile;
    private Tile[] tiles;
    private static final String INFO_RECORD_STORE_NAME = "Map info";
    private static final String TILE_RECORD_STORE_NAME = "Tiles";
    private static final int INFO_RECORD_FORMAT_VERSION = 2;
    private static final int SATELLITE_FLAG = 1;
    private TileOverlayRenderer tileOverlayRenderer;
    private static final long MAX_PAINT_TIME = 500L;
    private boolean running;
    static final int CHINA_MAP_MAX_ZOOM = 18;
    static final int JAPAN_MAP_MAX_ZOOM = 20;
    static final int DEFAULT_MAP_MAX_ZOOM = 19;
    static final int KOREA_SATELLITE_MAP_MAX_ZOOM = 16;
    static final int JAPAN_MAX_INITIAL_ZOOM = 16;
    static final int MAX_INITIAL_ZOOM = 15;
    private MapState mapState;
    protected static int MAX_PRELOAD_MAP_TILES = 38;
    protected static int MAX_PRELOAD_SAT_TILES = 24;
    private int completeTilesInViewport = 0;
    private boolean isViewportAllNew;
    private long earliestTileNeededTime;
    private long lastPaintStartTime;
    private final MapBiller biller = new MapBiller();
    private PixelMapper pixelMapper = null;
    private static final int PRECACHE_BASE_PRIORITY = 8000000;
    private static final int E6 = 1000000;
    private static final int E6_360 = 360000000;

    public Map(int n, int n2, int n3, MapPoint mapPoint, Zoom zoom, int n4) {
        this.mapService = new MapService(n, n2, n3, n4, TILE_RECORD_STORE_NAME);
        this.mapState = new MapState(mapPoint, Zoom.getZoom(3), false);
        this.load(mapPoint, zoom);
        this.running = true;
    }

    public void setRepaintListener(RepaintListener repaintListener) {
        MapTile.setRepaintListener(repaintListener);
        this.mapService.setRepaintListener(repaintListener);
    }

    public int getRamCacheSize() {
        return this.mapService.getCacheSize();
    }

    public int getFlashCacheSize() {
        MapTileStorage mapTileStorage = this.mapService.getMapFlashService();
        return mapTileStorage != null ? mapTileStorage.getSize() : 0;
    }

    public synchronized void setCenterPoint(MapPoint mapPoint) {
        if (mapPoint != null) {
            this.setMapState(this.mapState.newMapState(mapPoint));
        }
    }

    public synchronized void setZoom(Zoom zoom) {
        if (zoom != null) {
            this.setMapState(this.mapState.newMapState(zoom));
        }
    }

    public synchronized void setMapState(MapState mapState) {
        if (mapState == null) {
            return;
        }
        this.mapState = mapState;
        int n = this.getMaxMapZoomForPoint(this.getCenterPoint());
        if (mapState.getZoom().getZoomLevel() > n) {
            this.mapState = mapState.newMapState(Zoom.getZoom(n));
        }
        this.calculateCenterPixel();
        this.updateTopLeftTile(false);
        this.mapService.mapChanged();
        this.completeTilesInViewport = 0;
        this.isViewportAllNew = false;
    }

    public MapState getMapState() {
        return this.mapState;
    }

    public Zoom getZoom() {
        return this.mapState.getZoom();
    }

    public MapPoint getCenterPoint() {
        return this.mapState.getCenterPoint();
    }

    public int getManualSelectionAccuracy() {
        int n = this.getMaxMapZoomForPoint(this.getCenterPoint());
        int n2 = this.getZoom().getZoomLevel();
        int n3 = 5000 / n;
        int n4 = n - n2;
        int n5 = n3 * n4;
        return n5;
    }

    private void updateTopLeftTile(boolean bl) {
        Tile tile = this.topLeftTile;
        MapPoint mapPoint = this.mapState.getCenterPoint();
        Zoom zoom = this.mapState.getZoom();
        int n = Tile.getXTileIndex(mapPoint, zoom) - this.xTiles / 2;
        int n2 = Tile.getYTileIndex(mapPoint, zoom) - this.yTiles / 2;
        Tile tile2 = Tile.getTile(this.getTileFlags(), mapPoint, zoom);
        boolean bl2 = this.xTiles % 2 == 0;
        int n3 = this.centerPixelX - tile2.getXPixelTopLeft();
        if (bl2 && n3 > 64) {
            ++n;
        }
        boolean bl3 = this.yTiles % 2 == 0;
        int n4 = this.centerPixelY - tile2.getYPixelTopLeft();
        if (bl3 && n4 > 64) {
            ++n2;
        }
        this.topLeftTile = Tile.getTile(this.getTileFlags(), n, n2, zoom);
        if (bl || tile == null || !tile.equals(this.topLeftTile)) {
            this.precalculateTiles();
        }
    }

    private void precalculateTiles() {
        if (this.tiles != null) {
            int n = 0;
            byte by = this.getTileFlags();
            for (int i = 0; i < this.xTiles; ++i) {
                for (int j = 0; j < this.yTiles; ++j) {
                    this.tiles[n++] = Tile.getTile(by, this.topLeftTile.getXIndex() + i, this.topLeftTile.getYIndex() + j, this.mapState.getZoom());
                }
            }
        }
    }

    public synchronized void zoomToSpan(int n, int n2) {
        this.setZoom(this.findZoom(n, n2, this.mapState));
    }

    private synchronized Zoom findZoom(int n, int n2, MapState mapState) {
        Zoom zoom = Zoom.getZoom(this.getMaxMapZoomForPoint(mapState.getCenterPoint()));
        while (zoom.getNextLowerZoom() != null && (this.getLatitudeSpan(mapState.newMapState(zoom)) < n || this.getLongitudeSpan(mapState.newMapState(zoom)) < n2)) {
            zoom = zoom.getNextLowerZoom();
        }
        return zoom;
    }

    public synchronized Zoom getZoomForViewport(MapPoint[] mapPointArray, MapPoint mapPoint) {
        int n;
        int n2;
        int n3;
        int n4;
        if (mapPointArray == null || mapPointArray.length < 2) {
            throw new IllegalArgumentException();
        }
        int n5 = n4 = mapPointArray[0].getLatitude();
        int n6 = n3 = mapPointArray[0].getLongitude();
        for (n2 = 0; n2 < mapPointArray.length; ++n2) {
            n = mapPointArray[n2].getLatitude();
            int n7 = mapPointArray[n2].getLongitude();
            if (n < n5) {
                n5 = n;
            }
            if (n > n4) {
                n4 = n;
            }
            if (n7 < n6) {
                n6 = n7;
            }
            if (n7 <= n3) continue;
            n3 = n7;
        }
        n2 = n4 - n5;
        n = n3 - n6;
        MapState mapState = this.mapState;
        if (mapPoint != null) {
            int n8 = (n4 + n5) / 2;
            int n9 = Math.abs(mapPoint.getLatitude() - n8);
            n2 += n9 * 2;
            int n10 = (n3 + n6) / 2;
            int n11 = Math.abs(mapPoint.getLongitude() - n10);
            n += n11 * 2;
            mapState = this.mapState.newMapState(mapPoint);
        }
        return this.findZoom(n2, n, mapState);
    }

    private void calculateCenterPixel() {
        this.centerPixelX = this.mapState.getCenterPoint().getXPixel(this.mapState.getZoom());
        this.centerPixelY = this.mapState.getCenterPoint().getYPixel(this.mapState.getZoom());
    }

    public Point getPointXY(MapPoint mapPoint) {
        Point point = new Point();
        this.getPointXY(mapPoint, point);
        return point;
    }

    public void getPointXY(MapPoint mapPoint, Point point) {
        this.getPixelOffsetFromCenter(mapPoint, point);
        point.x += this.halfWidth;
        point.y += this.halfHeight;
    }

    public Point getPixelOffsetFromCenter(MapPoint mapPoint) {
        Point point = new Point();
        this.getPixelOffsetFromCenter(mapPoint, point);
        return point;
    }

    public void getPixelOffsetFromCenter(MapPoint mapPoint, Point point) {
        point.x = mapPoint.getXPixel(this.mapState.getZoom()) - this.centerPixelX;
        int n = this.mapState.getZoom().getEquatorPixels();
        if (point.x < -n / 2) {
            point.x += n;
        } else if (point.x > n / 2) {
            point.x -= n;
        }
        point.y = mapPoint.getYPixel(this.mapState.getZoom()) - this.centerPixelY;
        if (this.pixelMapper != null) {
            point.x += this.halfWidth;
            point.y += this.halfHeight;
            this.pixelMapper.transformPoint(point);
            point.x -= this.halfWidth;
            point.y -= this.halfHeight;
        }
    }

    public MapPoint getMapPoint(int n, int n2) {
        return this.getMapPoint(this.mapState.getCenterPoint(), n, n2);
    }

    public MapPoint getMapPoint(MapPoint mapPoint, int n, int n2) {
        int n3 = n - this.halfWidth;
        int n4 = n2 - this.halfHeight;
        return mapPoint.pixelOffset(n3, n4, this.mapState.getZoom());
    }

    public synchronized void saveState() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(14);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(2);
            MapPoint.writePoint(this.mapState.getCenterPoint(), dataOutputStream);
            dataOutputStream.writeInt(this.mapState.getZoom().getZoomLevel());
            int n = this.mapState.isSatellite() ? 1 : 0;
            dataOutputStream.writeByte(n);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            Config.getInstance().getPersistentStore().setPreference(INFO_RECORD_STORE_NAME, byArray);
        }
        catch (IOException iOException) {
            Log.logThrowable((String)"MAP", (Throwable)iOException);
        }
    }

    private void load(MapPoint mapPoint, Zoom zoom) {
        byte[] byArray = Config.getInstance().getPersistentStore().readPreference(INFO_RECORD_STORE_NAME);
        MapPoint mapPoint2 = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (byArray != null) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n3 = dataInputStream.readUnsignedShort();
                if (n3 == 2) {
                    mapPoint2 = MapPoint.readPoint(dataInputStream);
                    n = dataInputStream.readInt();
                    n2 = dataInputStream.readUnsignedByte();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                Log.logThrowable((String)"MAP", (Throwable)iOException);
                Config.getInstance().getPersistentStore().deleteBlock(INFO_RECORD_STORE_NAME);
            }
        }
        if (bl) {
            boolean bl2 = n2 & true;
            this.setMapState(new MapState(mapPoint2, Zoom.getZoom(Math.min(n, Map.getMaxMapInitialZoomForPoint(mapPoint2))), bl2));
        } else {
            this.setMapState(new MapState(mapPoint, zoom, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preLoad(MapPoint mapPoint) {
        MapPoint mapPoint2 = this.mapState.getCenterPoint();
        try {
            this.setCenterPoint(mapPoint);
            this.drawMapBackground(null, true, false);
        }
        finally {
            this.setCenterPoint(mapPoint2);
        }
    }

    public Tile[] getTiles() {
        return this.tiles;
    }

    public boolean drawMap(GoogleGraphics googleGraphics, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.displayHeight == 0 || this.displayWidth == 0) {
            throw new IllegalStateException("Map has zero size");
        }
        if (googleGraphics != null) {
            this.biller.doBilling(bl2, bl3, this);
        }
        return this.drawMapBackground(googleGraphics, bl, bl4);
    }

    private boolean drawMapBackground(GoogleGraphics googleGraphics, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4 = this.halfHeight + this.topLeftTile.getYPixelTopLeft() - this.mapState.getCenterPoint().getYPixel(this.mapState.getZoom());
        for (n3 = this.halfWidth + this.topLeftTile.getXPixelTopLeft() - this.mapState.getCenterPoint().getXPixel(this.mapState.getZoom()); n3 > 0; n3 -= this.mapState.getZoom().getEquatorPixels()) {
        }
        if (this.tileOverlayRenderer != null) {
            this.tileOverlayRenderer.begin();
        }
        int n5 = 0;
        int n6 = 0;
        Clock clock = Config.getInstance().getClock();
        long l = clock.relativeTimeMillis();
        long l2 = clock.currentTimeMillis();
        boolean bl3 = true;
        this.earliestTileNeededTime = Long.MAX_VALUE;
        for (n2 = 0; n2 < this.xTiles; ++n2) {
            for (n = 0; n < this.yTiles; ++n) {
                long l3;
                n6 += this.drawTile(this.tiles[n5++], n2, n, googleGraphics, n3, n4, bl, bl2, bl3, l, l3 = l2 + (long)n5) ? 1 : 0;
                if (!bl3 || !Map.checkPaintTimeExceeded(l)) continue;
                bl3 = false;
            }
        }
        if (googleGraphics != null) {
            this.logPerceivedTileLatency(n6);
        }
        if (bl) {
            this.mapService.requestTiles(true);
        }
        n = this.layerServices.size();
        for (n2 = 0; n2 < n; ++n2) {
            LayerService layerService = (LayerService)this.layerServices.elementAt(n2);
            if (!layerService.needFetchLayerTiles()) continue;
            layerService.requestTiles();
        }
        if (this.tileOverlayRenderer != null) {
            this.tileOverlayRenderer.end();
        }
        FlashRecord.clearDataCache();
        this.lastPaintStartTime = l;
        return !Map.checkPaintTimeExceeded(l);
    }

    private void logPerceivedTileLatency(int n) {
        String string;
        if (this.earliestTileNeededTime == Long.MAX_VALUE) {
            this.completeTilesInViewport = n;
            return;
        }
        switch (this.getTileFlags()) {
            case 3: {
                string = "s";
                break;
            }
            case 6: {
                string = "h";
                break;
            }
            case 2: {
                string = "m";
                break;
            }
            default: {
                return;
            }
        }
        long l = Config.getInstance().getClock().relativeTimeMillis() - this.earliestTileNeededTime;
        if (this.completeTilesInViewport == 0) {
            Log.addEvent((short)22, (String)("tf" + string), (String)("" + l));
            this.isViewportAllNew = true;
        }
        if (this.completeTilesInViewport < n && n == this.xTiles * this.yTiles) {
            String string2 = this.isViewportAllNew ? "tc" : "tp";
            Log.addEvent((short)22, (String)(string2 + string), (String)("" + l));
        }
        this.completeTilesInViewport = n;
    }

    private void updatePerceivedTileLatency(MapTile mapTile) {
        if (mapTile.getCompletePaintCount() == 1) {
            this.earliestTileNeededTime = Math.min(mapTile.getFirstPaintTime(), this.earliestTileNeededTime);
        }
    }

    private void logIfPreCached(MapTile mapTile) {
        if (mapTile.getIsPreCached() && mapTile.getCompletePaintCount() == 1) {
            long l = Config.getInstance().getClock().relativeTimeMillis();
            Log.addEvent((short)22, (String)"pc", (String)("" + (l - mapTile.getFirstPaintTime())));
        }
    }

    private boolean drawTile(Tile tile, int n, int n2, GoogleGraphics googleGraphics, int n3, int n4, boolean bl, boolean bl2, boolean bl3, long l, long l2) {
        int n5 = n3 + n * 128;
        int n6 = n4 + n2 * 128;
        if (tile.notValid()) {
            if (googleGraphics != null) {
                googleGraphics.setColor(0xFFFFFF);
                googleGraphics.fillRect(n5, n6, 128, 128);
                return true;
            }
            return false;
        }
        int n7 = this.halfWidth - (n5 + 64);
        int n8 = this.halfHeight - (n6 + 64);
        int n9 = n7 * n7 + n8 * n8;
        MapTile mapTile = this.mapService.getTile(tile, n9, bl, bl3, l2);
        if (this.tileOverlayRenderer != null && bl3) {
            this.tileOverlayRenderer.renderTile(mapTile, bl);
        }
        boolean bl4 = false;
        if (googleGraphics != null && (mapTile.hasImage() || bl2)) {
            googleGraphics.drawImage(mapTile.getImage(l2), n5, n6);
            mapTile.setPaint(l, this.lastPaintStartTime);
            if (mapTile.getCompletePaintCount() > 0) {
                this.updatePerceivedTileLatency(mapTile);
                this.logIfPreCached(mapTile);
                bl4 = true;
            }
        }
        int n10 = this.layerServices.size();
        for (int i = 0; i < n10; ++i) {
            LayerService layerService = (LayerService)this.layerServices.elementAt(i);
            if (!layerService.needFetchLayerTiles()) continue;
            Tile tile2 = Tile.getTile((byte)8, tile);
            LayerTile layerTile = layerService.getTile(tile2, bl);
            if (googleGraphics == null || layerTile == null || !layerTile.hasImage()) continue;
            googleGraphics.drawImage(layerTile.getImage(), n5, n6);
        }
        return bl4;
    }

    private static boolean checkPaintTimeExceeded(long l) {
        return Config.getInstance().getClock().relativeTimeMillis() - l > 500L;
    }

    public synchronized void move(int n, int n2) {
        this.setCenterPoint(this.mapState.getCenterPoint().pixelOffset(n, n2, this.mapState.getZoom()));
    }

    public void close(boolean bl) {
        if (bl) {
            this.saveState();
        }
        this.mapService.close(bl);
        int n = this.layerServices.size();
        for (int i = 0; i < n; ++i) {
            ((LayerService)this.layerServices.elementAt(i)).close();
        }
        this.layerServices.removeAllElements();
    }

    public void pause() {
        if (this.running) {
            this.running = false;
            this.mapService.pause();
            MapTile.stopDecodeThread();
        }
    }

    public void resume() {
        if (!this.running) {
            this.running = true;
            this.mapService.resume();
        }
    }

    public void notifyUserInput() {
        this.mapService.notifyUserInput();
    }

    public void resize(int n, int n2) {
        this.displayHeight = n2;
        this.displayWidth = n;
        this.halfWidth = n / 2;
        this.halfHeight = n2 / 2;
        this.xTiles = (n + 128 - 1) / 128 + 1;
        this.yTiles = (n2 + 128 - 1) / 128 + 1;
        this.tiles = new Tile[this.xTiles * this.yTiles];
        this.updateTopLeftTile(true);
        this.mapService.mapChanged();
        this.completeTilesInViewport = 0;
        this.isViewportAllNew = false;
    }

    public void eraseAll() {
        this.mapService.eraseAll();
    }

    private byte getTileFlags() {
        return this.mapState.isSatellite() ? Tile.getSatType() : (byte)2;
    }

    public void toggleSatellite() {
        this.setMapState(this.mapState.toggleTileMode());
    }

    public int getLatitudeSpan(MapState mapState) {
        MapPoint mapPoint = mapState.getCenterPoint();
        Zoom zoom = mapState.getZoom();
        MapPoint mapPoint2 = mapPoint.pixelOffset(this.halfWidth, this.halfHeight, zoom);
        MapPoint mapPoint3 = mapPoint.pixelOffset(-this.halfWidth, -this.halfHeight, zoom);
        return Math.abs(mapPoint3.getLatitude() - mapPoint2.getLatitude());
    }

    public int getLongitudeSpan(MapState mapState) {
        MapPoint mapPoint = mapState.getCenterPoint();
        Zoom zoom = mapState.getZoom();
        MapPoint mapPoint2 = mapPoint.pixelOffset(this.halfWidth, this.halfHeight, zoom);
        MapPoint mapPoint3 = mapPoint.pixelOffset(-this.halfWidth, -this.halfHeight, zoom);
        int n = mapPoint2.getLongitude() - mapPoint3.getLongitude();
        if (n < 0) {
            n += 360000000;
        }
        return n;
    }

    public synchronized int getLatitudeSpan() {
        return this.getLatitudeSpan(this.mapState);
    }

    public synchronized int getLongitudeSpan() {
        return this.getLongitudeSpan(this.mapState);
    }

    public boolean canCover(MapPoint mapPoint, boolean bl) {
        return this.canCover(mapPoint, bl, this.mapState.getZoom());
    }

    public boolean canCover(MapPoint mapPoint, boolean bl, Zoom zoom) {
        MapTile mapTile = this.mapService.getTile(Tile.getTile(this.getTileFlags(), mapPoint, zoom), 0, false, bl);
        return bl && mapTile.hasScaledImage() || mapTile.isComplete();
    }

    public boolean loadToCover(MapPoint mapPoint) {
        Tile tile = Tile.getTile(this.getTileFlags(), mapPoint, this.mapState.getZoom());
        if (this.mapService.isTileInMemoryOrQueued(tile)) {
            return false;
        }
        this.mapService.getTile(tile, 8000000, true, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Tile[] getCoveringTiles(MapPoint[] mapPointArray, boolean bl) {
        Hashtable<Tile, Tile> hashtable = new Hashtable<Tile, Tile>();
        if (mapPointArray == null || mapPointArray.length == 0) {
            return new Tile[0];
        }
        if (bl) {
            MapPoint mapPoint = this.mapState.getCenterPoint();
            try {
                for (int i = 0; i < mapPointArray.length; ++i) {
                    this.setCenterPoint(mapPointArray[i]);
                    for (int j = 0; j < this.tiles.length; ++j) {
                        hashtable.put(this.tiles[j], this.tiles[j]);
                    }
                }
            }
            finally {
                this.setCenterPoint(mapPoint);
            }
        } else {
            for (int i = 0; i < mapPointArray.length; ++i) {
                MapPoint mapPoint = mapPointArray[i];
                if (this.canCover(mapPoint, false)) continue;
                Tile tile = Tile.getTile(this.getTileFlags(), mapPoint, this.mapState.getZoom());
                hashtable.put(tile, tile);
            }
        }
        Tile[] tileArray = new Tile[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            tileArray[n] = (Tile)enumeration.nextElement();
            ++n;
        }
        return tileArray;
    }

    public int preCache(Tile[] tileArray) {
        if (tileArray == null || tileArray.length == 0) {
            return 0;
        }
        int n = this.isSatellite() ? 4177 : 2637;
        int n2 = this.isSatellite() ? MAX_PRELOAD_SAT_TILES : MAX_PRELOAD_MAP_TILES;
        int n3 = Math.min(n2, this.mapService.getMaxCacheDataSize() / n / 2);
        int n4 = 8000000;
        int n5 = 0;
        for (int i = 0; i < tileArray.length; ++i) {
            MapTile mapTile;
            if (this.mapService.isTileInMemoryOrQueued(tileArray[i])) continue;
            if ((mapTile = this.mapService.getTile(tileArray[i], n4++, true, true)).getDataSize() == 0) {
                mapTile.setIsPreCached(true);
                ++n5;
            }
            if (n5 >= n3) break;
        }
        this.mapService.requestTiles(false);
        return n5;
    }

    public boolean isSatellite() {
        return this.mapState.isSatellite();
    }

    public void setTileOverlayRenderer(TileOverlayRenderer tileOverlayRenderer) {
        this.tileOverlayRenderer = tileOverlayRenderer;
    }

    public void addLayerService(LayerService layerService) {
        if (layerService != null && !this.layerServices.contains(layerService)) {
            this.layerServices.addElement(layerService);
        }
    }

    public void removeLayerService(LayerService layerService) {
        this.layerServices.removeElement(layerService);
    }

    public int getHeight() {
        return this.displayHeight;
    }

    public int getWidth() {
        return this.displayWidth;
    }

    public int getMaxMapZoomForPoint(MapPoint mapPoint) {
        if (this.isSatellite()) {
            return 22;
        }
        if (Config.isChinaVersion()) {
            return 18;
        }
        if (Map.isMapPointInKoreaBoundingBox(mapPoint)) {
            return 19;
        }
        if (Map.isMapPointInJapanBoundingBox(mapPoint)) {
            return 20;
        }
        return 19;
    }

    public static int getMaxMapInitialZoomForPoint(MapPoint mapPoint) {
        if (Map.isMapPointInKoreaBoundingBox(mapPoint)) {
            return 15;
        }
        if (Map.isMapPointInJapanBoundingBox(mapPoint)) {
            return 16;
        }
        return 15;
    }

    public static boolean isMapPointInJapanBoundingBox(MapPoint mapPoint) {
        if (mapPoint != null) {
            int n = mapPoint.getLatitude();
            int n2 = mapPoint.getLongitude();
            if (n > 23883332 && n < 46072278 && n2 > 123748627 && n2 < 143789063) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMapPointInKoreaBoundingBox(MapPoint mapPoint) {
        if (mapPoint != null) {
            int n = mapPoint.getLatitude();
            int n2 = mapPoint.getLongitude();
            if (n > 32989084 && n < 38693013 && n2 > 124605560 && n2 < 128496094 || n > 34464674 && n < 38693013 && n2 > 128496094 && n2 < 128847656 || n > 35027747 && n < 38693013 && n2 > 128847656 && n2 < 131053162 || n > 37027773 && n < 38693013 && n2 > 131053162 && n2 < 132003479) {
                return true;
            }
        }
        return false;
    }

    public void setBillingPointListener(BillingPointListener billingPointListener) {
        this.biller.setBillingPointListener(billingPointListener);
    }

    public void setPixelMapper(PixelMapper pixelMapper) {
        this.pixelMapper = pixelMapper;
    }

    public int getPixelsForDistance(int n) {
        if (this.pixelMapper != null) {
            return this.pixelMapper.getPixelsForDistance(n);
        }
        return this.mapState.getZoom().getPixelsForDistance(n);
    }

    public Vector getLayerServicesForTest() {
        RuntimeCheck.checkUnitTest();
        return this.layerServices;
    }

    public static interface PixelMapper {
        public int getPixelsForDistance(int var1);

        public void transformPoint(Point var1);
    }

    public static interface BillingPointListener {
        public void billingPointSent(MapState var1);
    }
}

