/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.Log;
import com.google.common.util.text.TextUtil;
import com.google.googlenav.GmmLogger;
import com.google.googlenav.datarequest.BaseDataRequest;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public abstract class BaseTileRequest
extends BaseDataRequest {
    static final int TILE_OK = 0;
    public static final int TILE3_REQUEST_ID = 26;
    protected final long createTime = Config.getInstance().getClock().relativeTimeMillis();
    private final int requestType;
    private int writeLatency;

    protected BaseTileRequest(int n) {
        this.requestType = n;
    }

    public int getRequestType() {
        return this.requestType;
    }

    protected void writeRequestForTiles(Tile[] tileArray, DataOutput dataOutput) throws IOException {
        if (this.requestType == 26) {
            dataOutput.writeShort(tileArray.length);
            dataOutput.writeShort(MapTile.textSize);
            dataOutput.writeShort(128);
            dataOutput.writeLong(175L);
        }
        for (int i = 0; i < tileArray.length; ++i) {
            Tile tile = tileArray[i];
            tile.write(dataOutput);
        }
        long l = Config.getInstance().getClock().relativeTimeMillis();
        this.writeLatency = (int)(l - this.createTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readResponseData(DataInput dataInput) throws IOException {
        int n = 0;
        try {
            String string;
            byte[] byArray;
            Tile tile;
            long l = Config.getInstance().getClock().relativeTimeMillis();
            int n2 = (int)(l - this.createTime);
            int n3 = dataInput.readUnsignedShort();
            this.setTileEdition(n3);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (this.requestType == 26) {
                int n7 = dataInput.readUnsignedByte();
                if (n7 != 0) {
                    throw new IOException("Server returned: " + n7);
                }
                n4 = dataInput.readUnsignedShort();
            }
            for (n = 0; n < n4 && !this.processDownloadedTile(n, tile = Tile.read(dataInput), byArray = this.readImageData(dataInput)); ++n) {
                n5 += byArray.length;
                n6 |= 1 << tile.getFlags();
            }
            long l2 = Config.getInstance().getClock().relativeTimeMillis();
            int n8 = (int)(l2 - this.createTime);
            String string2 = null;
            if (!this.isForeground()) {
                string = "t-pc";
                string2 = "pc";
            } else {
                string = "t";
            }
            Log.addEvent((short)22, (String)string, (String)("" + n8));
            GmmLogger.logTimingTileLatency(BaseTileRequest.formatTileTypesForLog(n6), this.writeLatency, n2, n8, n4, n5, string2);
        }
        finally {
            this.handleEndOfResponse(n);
        }
        return true;
    }

    protected abstract void setTileEdition(int var1);

    protected abstract boolean processDownloadedTile(int var1, Tile var2, byte[] var3) throws IOException;

    protected abstract void handleEndOfResponse(int var1);

    private byte[] readImageData(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return byArray;
    }

    private static String formatTileTypesForLog(int n) {
        Vector<String> vector = new Vector<String>();
        if ((n & 4) != 0) {
            vector.addElement("m");
        }
        if ((n & 8) != 0) {
            vector.addElement("s");
        }
        if ((n & 0x40) != 0) {
            vector.addElement("h");
        }
        if ((n & 0x10) != 0 || (n & 0x80) != 0) {
            vector.addElement("t");
        }
        return TextUtil.join(vector, (String)",");
    }
}

