/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.layer;

import com.google.common.Config;
import com.google.common.graphics.GoogleImage;
import com.google.common.graphics.ImageFactory;
import com.google.common.io.protocol.ProtoBuf;
import com.google.common.io.protocol.ProtoBufUtil;
import com.google.common.util.RuntimeCheck;
import com.google.googlenav.proto.GmmMessageTypes;

public class LayerInfo {
    private final ProtoBuf layerInfo;
    private final String id;
    private String name;
    private String description;
    private ProtoBuf[] parameters;
    private byte iconClass;
    private int detailMode;
    private int enableMode;
    private int minZoomLevel;
    private int maxZoomLevel;
    private GoogleImage[] icons;
    public static final int DETAIL_IN_GMM = 0;
    public static final int DETAIL_IN_BROWSER = 1;
    public static final int DETAIL_NONE = 2;

    public LayerInfo(String string) {
        this.id = string;
        this.layerInfo = new ProtoBuf(GmmMessageTypes.LAYER_INFO_PROTO);
        this.minZoomLevel = 1;
        this.maxZoomLevel = 22;
    }

    public LayerInfo(ProtoBuf protoBuf) {
        this.layerInfo = protoBuf;
        this.id = protoBuf.getString(1);
        this.name = ProtoBufUtil.getProtoValueOrEmpty((ProtoBuf)protoBuf, (int)2);
        this.description = ProtoBufUtil.getProtoValueOrEmpty((ProtoBuf)protoBuf, (int)3);
        this.detailMode = ProtoBufUtil.getProtoValueOrDefault((ProtoBuf)protoBuf, (int)5, (int)2);
        this.enableMode = ProtoBufUtil.getProtoValueOrDefault((ProtoBuf)protoBuf, (int)4, (int)2);
        int n = protoBuf.getCount(18);
        this.parameters = new ProtoBuf[n];
        for (int i = 0; i < n; ++i) {
            this.parameters[i] = protoBuf.getProtoBuf(18, i);
        }
        ImageFactory imageFactory = Config.getInstance().getImageFactory();
        int n2 = protoBuf.getCount(17);
        if (n2 == 0) {
            this.iconClass = (byte)16;
        } else {
            this.icons = new GoogleImage[n2];
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = protoBuf.getBytes(17, i);
                this.icons[i] = imageFactory.createImage(byArray, 0, byArray.length);
            }
            this.iconClass = (byte)17;
        }
        this.minZoomLevel = ProtoBufUtil.getProtoValueOrDefault((ProtoBuf)protoBuf, (int)61, (int)1);
        this.maxZoomLevel = ProtoBufUtil.getProtoValueOrDefault((ProtoBuf)protoBuf, (int)62, (int)22);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public ProtoBuf[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ProtoBuf[] protoBufArray) {
        this.parameters = protoBufArray;
    }

    public byte getIconClass() {
        return this.iconClass;
    }

    public void setIconClass(byte by) {
        this.iconClass = by;
    }

    public GoogleImage getImage(int n) {
        return this.icons == null ? null : this.icons[n];
    }

    public int getDetailMode() {
        return this.detailMode;
    }

    public long getLayerTileExpirationTime() {
        return ProtoBufUtil.getProtoValueOrNegativeOne((ProtoBuf)this.layerInfo, (int)8);
    }

    public long getItemDetailExpirationTime() {
        return ProtoBufUtil.getProtoValueOrNegativeOne((ProtoBuf)this.layerInfo, (int)9);
    }

    public boolean isLayerAlwaysEnabled() {
        return this.enableMode == 0;
    }

    public boolean isLayerHiddenInList() {
        return this.layerInfo.getBool(20);
    }

    public boolean isValidZoomLevel(int n) {
        return n >= this.minZoomLevel && n <= this.maxZoomLevel;
    }

    public ProtoBuf toLayerInfoProtoBuf() {
        return this.layerInfo;
    }

    public String toString() {
        return "id=" + this.id + ", name=" + this.name + ", description=" + this.description;
    }

    public void setLayerTileExpirationTimeForTest(long l) {
        RuntimeCheck.checkUnitTest();
        this.layerInfo.setLong(8, l);
    }

    public void setZoomLevelsForTest(int n, int n2) {
        RuntimeCheck.checkUnitTest();
        this.minZoomLevel = n;
        this.maxZoomLevel = n2;
    }
}

