/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.layer;

import com.google.common.io.protocol.ProtoBuf;
import com.google.common.io.protocol.ProtoBufUtil;
import com.google.googlenav.layer.LayerItem;
import com.google.map.MapPoint;

public class ClickableArea {
    private final int type;
    private final MapPoint centerPoint;
    private final int width;
    private final int height;
    private final int iconIndex;
    private final int iconInactiveIndex;
    private final int iconShadowIndex;
    private LayerItem[] items;

    public ClickableArea(ProtoBuf protoBuf) {
        this.type = protoBuf.getInt(1);
        ProtoBuf protoBuf2 = protoBuf.getProtoBuf(3);
        ProtoBuf protoBuf3 = protoBuf2.getProtoBuf(31);
        this.centerPoint = MapPoint.getMapPointFromXY(protoBuf3.getInt(1), protoBuf3.getInt(2), protoBuf3.getInt(3));
        this.width = ProtoBufUtil.getProtoValueOrZero((ProtoBuf)protoBuf2, (int)32);
        this.height = ProtoBufUtil.getProtoValueOrZero((ProtoBuf)protoBuf2, (int)33);
        this.iconIndex = (int)ProtoBufUtil.getProtoValueOrNegativeOne((ProtoBuf)protoBuf2, (int)34);
        this.iconInactiveIndex = ProtoBufUtil.getProtoValueOrDefault((ProtoBuf)protoBuf2, (int)35, (int)this.iconIndex);
        this.iconShadowIndex = (int)ProtoBufUtil.getProtoValueOrNegativeOne((ProtoBuf)protoBuf2, (int)36);
        int n = protoBuf.getCount(2);
        this.items = new LayerItem[n];
        for (int i = 0; i < n; ++i) {
            this.items[i] = new LayerItem(protoBuf.getProtoBuf(2, i));
        }
    }

    public int getType() {
        return this.type;
    }

    public MapPoint getCenterPoint() {
        return this.centerPoint;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public int getIconInactiveIndex() {
        return this.iconInactiveIndex;
    }

    public int getIconShadowIndex() {
        return this.iconShadowIndex;
    }

    public LayerItem[] getItems() {
        return this.items;
    }

    public boolean equals(ClickableArea clickableArea) {
        return this.centerPoint.equals(clickableArea.getCenterPoint()) && this.width == clickableArea.getWidth() && this.height == clickableArea.getHeight();
    }

    public String toString() {
        return "CenterPoint: " + this.centerPoint + ", " + this.items.length + " items";
    }
}

