/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util;

import com.google.common.Clock;
import com.google.common.Config;

public class Stopwatch {
    private final Clock clock;
    private long startedTime = Long.MIN_VALUE;
    private long stoppedTime = Long.MIN_VALUE;

    public Stopwatch(Clock clock) {
        this.clock = clock;
        this.reset();
    }

    public Stopwatch() {
        this(Config.getInstance().getClock());
    }

    public Stopwatch start() {
        long l = 0L;
        if (this.isRunning()) {
            throw new IllegalStateException("Stopwatch already running");
        }
        if (this.stoppedTime != Long.MIN_VALUE) {
            l = this.stoppedTime - this.startedTime;
            this.stoppedTime = Long.MIN_VALUE;
        }
        this.startedTime = this.now() - l;
        return this;
    }

    public Stopwatch stop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Stopwatch already stopped");
        }
        this.stoppedTime = this.now();
        return this;
    }

    public Stopwatch reset() {
        this.startedTime = Long.MIN_VALUE;
        this.stoppedTime = Long.MIN_VALUE;
        return this;
    }

    public long elapsedTime() {
        if (this.isRunning()) {
            return this.now() - this.startedTime;
        }
        return this.stoppedTime - this.startedTime;
    }

    public boolean isRunning() {
        return this.startedTime != Long.MIN_VALUE && this.stoppedTime == Long.MIN_VALUE;
    }

    private long now() {
        return this.clock.relativeTimeMillis();
    }
}

