/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Log;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.PixelConverter;
import com.google.map.Zoom;

class ZoomHelper {
    private static final String LOG_TAG = "ZoomHelper";
    public static final long DELAY_MILLIS = 600L;
    private static final long SCALE_DURATION = 500L;
    private static final long FADE_DURATION = 300L;
    private final MapView mMapView;
    private final MapController mController;
    private final Transformation mLastDrawnScale = new Transformation();
    private final AnimationSet mAnimations = new AnimationSet(false);
    private final Paint mBitmapPaint = new Paint();
    private Snapshot mSnapshot = null;
    private boolean mFading = false;
    private long mCommitTime = Long.MAX_VALUE;
    protected final Point mTempPoint = new Point();

    ZoomHelper(MapView mapView, MapController controller) {
        this.mMapView = mapView;
        this.mController = controller;
        this.mBitmapPaint.setFilterBitmap(true);
    }

    boolean doZoom(boolean zoomIn, boolean delay, int xOffset, int yOffset) {
        Zoom newZoom;
        Zoom currentZoom = this.mMapView.getZoom();
        Zoom zoom = newZoom = zoomIn ? currentZoom.getNextHigherZoom() : currentZoom.getNextLowerZoom();
        if (newZoom == null || newZoom.getZoomLevel() > this.mMapView.getMaxZoomLevel()) {
            return false;
        }
        return this.doZoom(newZoom, delay, xOffset, yOffset);
    }

    boolean doZoom(Zoom newZoom, boolean delay, int xOffset, int yOffset) {
        if (this.mSnapshot == null) {
            this.createSnapshot();
        }
        PixelConverter pc = (PixelConverter)this.mMapView.getProjection();
        this.mSnapshot.fixedPoint = pc.fromPixels(xOffset, yOffset);
        this.mSnapshot.fixedPointCoords[0] = xOffset;
        this.mSnapshot.fixedPointCoords[1] = yOffset;
        Matrix inverse = new Matrix();
        if (!this.mLastDrawnScale.getMatrix().invert(inverse)) {
            Log.e((String)LOG_TAG, (String)("Singular matrix " + this.mLastDrawnScale.getMatrix()));
        }
        inverse.mapPoints(this.mSnapshot.fixedPointCoords);
        this.mController.zoomTo(newZoom);
        if (xOffset != this.mMapView.getWidth() / 2 || yOffset != this.mMapView.getHeight() / 2) {
            Point realLocationOfFixedPoint = pc.toPixels(this.mSnapshot.fixedPoint, null, false);
            this.mController.scrollBy(realLocationOfFixedPoint.x - xOffset, realLocationOfFixedPoint.y - yOffset);
        }
        this.addScale();
        this.stepAnimation(AnimationUtils.currentAnimationTimeMillis(), pc);
        if (delay) {
            this.mCommitTime = AnimationUtils.currentAnimationTimeMillis() + 600L;
        } else {
            this.mMapView.preLoad();
        }
        return true;
    }

    boolean onDraw(Canvas canvas, MapView mapView, long when) {
        if (this.mSnapshot == null) {
            return false;
        }
        PixelConverter converter = (PixelConverter)this.mMapView.getProjection();
        if (!this.shouldDrawMap(when)) {
            canvas.drawARGB(255, 255, 255, 255);
        }
        if (when > this.mCommitTime) {
            this.mMapView.preLoad();
            this.mCommitTime = Long.MAX_VALUE;
        }
        this.stepAnimation(when, converter);
        this.mBitmapPaint.setAlpha((int)(255.0f * this.mLastDrawnScale.getAlpha()));
        canvas.save();
        canvas.concat(this.mLastDrawnScale.getMatrix());
        canvas.drawBitmap(this.mSnapshot.bitmap, 0.0f, 0.0f, this.mBitmapPaint);
        canvas.restore();
        if (this.mAnimations.hasEnded()) {
            if (this.mFading) {
                this.mAnimations.getAnimations().clear();
                this.mSnapshot = null;
                this.mFading = false;
                converter.resetMatrix();
                return false;
            }
            if (this.mMapView.canCoverCenter()) {
                this.mFading = true;
                this.addFade();
                return true;
            }
            this.mMapView.mRepainter.repaint();
            return false;
        }
        return true;
    }

    private float getScale(Zoom numerator, Zoom denominator) {
        return denominator.isMoreZoomedIn(numerator) ? (float)numerator.getZoomRatio(denominator) : 1.0f / (float)denominator.getZoomRatio(numerator);
    }

    private void addScale() {
        float fromFactor = this.mLastDrawnScale.getMatrix().mapRadius(1.0f);
        float toFactor = this.getScale(this.mSnapshot.zoom, this.mMapView.getZoom());
        ScaleAnimation scale = new ScaleAnimation(fromFactor, toFactor, fromFactor, toFactor, this.mSnapshot.fixedPointCoords[0], this.mSnapshot.fixedPointCoords[1]);
        scale.setFillAfter(true);
        scale.setDuration(500L);
        scale.initialize(0, 0, 0, 0);
        scale.startNow();
        scale.setInterpolator((Interpolator)new LinearInterpolator());
        this.mFading = false;
        this.mAnimations.getAnimations().clear();
        this.mAnimations.addAnimation((Animation)scale);
    }

    private void addFade() {
        AlphaAnimation fade = new AlphaAnimation(1.0f, 0.0f);
        fade.setFillAfter(true);
        fade.setDuration(300L);
        fade.initialize(0, 0, 0, 0);
        fade.startNow();
        this.mAnimations.addAnimation((Animation)fade);
    }

    boolean shouldDrawMap(long when) {
        return this.mSnapshot == null || this.mFading || this.mAnimations.hasEnded();
    }

    private void createSnapshot() {
        Snapshot snapshot = new Snapshot();
        Rect rect = new Rect();
        snapshot.bitmap = Bitmap.createBitmap((int)this.mMapView.getWidth(), (int)this.mMapView.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(snapshot.bitmap);
        canvas.drawColor((int)AnimationUtils.currentAnimationTimeMillis());
        this.mMapView.drawMap(canvas, false);
        snapshot.zoom = this.mMapView.getZoom();
        this.mLastDrawnScale.clear();
        this.mSnapshot = snapshot;
    }

    private void stepAnimation(long when, PixelConverter converter) {
        this.mAnimations.getTransformation(when, this.mLastDrawnScale);
        converter.setMatrix(this.mLastDrawnScale.getMatrix(), this.getScale(this.mMapView.getZoom(), this.mSnapshot.zoom), this.mSnapshot.fixedPoint, this.mSnapshot.fixedPointCoords[0], this.mSnapshot.fixedPointCoords[1]);
    }

    private static class Snapshot {
        public Bitmap bitmap;
        public GeoPoint fixedPoint;
        public Zoom zoom;
        public final float[] fixedPointCoords = new float[2];

        private Snapshot() {
        }
    }
}

