/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.os.Handler;
import android.view.MotionEvent;

public class TrackballGestureDetector {
    private Handler mHandler;
    private Runnable mUserLongPressRunnable;
    private Runnable mOurLongPressRunnable;
    private boolean mIsScroll;
    private boolean mIsTap;
    private boolean mIsDoubleTap;
    private float mScrollX;
    private float mScrollY;
    private static final int TAP_TIME_MS = 300;
    private static final int DOUBLE_TAP_TIME_MS = 600;
    private static final int LONGPRESS_TIME_MS = 1500;
    private static final int TAP_REGION_MANHATTAN_DISTANCE = 5;
    private boolean mAlwaysInTapRegion;
    private boolean mInLongPress;
    private float mCurrentDownX;
    private float mCurrentDownY;
    private float mFirstDownX;
    private float mFirstDownY;
    private long mDownTime;
    private long mPreviousDownTime;
    private float mLastMotionY;
    private float mLastMotionX;

    TrackballGestureDetector(Handler handler) {
        this.mHandler = handler;
        this.mOurLongPressRunnable = new Runnable(){

            public void run() {
                TrackballGestureDetector.this.dispatchLongPress();
            }
        };
    }

    public void analyze(MotionEvent ev) {
        int action = ev.getAction();
        float y = ev.getY();
        float x = ev.getX();
        this.mIsScroll = false;
        this.mIsTap = false;
        this.mIsDoubleTap = false;
        switch (action) {
            case 0: {
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                this.mFirstDownX = this.mCurrentDownX;
                this.mFirstDownY = this.mCurrentDownY;
                this.mCurrentDownX = x;
                this.mCurrentDownY = y;
                this.mPreviousDownTime = this.mDownTime;
                this.mDownTime = ev.getDownTime();
                this.mAlwaysInTapRegion = true;
                this.mInLongPress = false;
                this.mHandler.removeCallbacks(this.mOurLongPressRunnable);
                this.mHandler.postAtTime(this.mOurLongPressRunnable, this.mDownTime + 1500L);
                break;
            }
            case 2: {
                if (this.mInLongPress) break;
                this.mScrollX = this.mLastMotionX - x;
                this.mScrollY = this.mLastMotionY - y;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                int manhattanTapDistance = (int)(Math.abs(x - this.mCurrentDownX) + Math.abs(y - this.mCurrentDownY));
                if (manhattanTapDistance > 5) {
                    this.mAlwaysInTapRegion = false;
                    this.mHandler.removeCallbacks(this.mOurLongPressRunnable);
                }
                this.mIsScroll = true;
                break;
            }
            case 1: {
                if (this.mInLongPress) {
                    this.mInLongPress = false;
                    break;
                }
                if (this.mAlwaysInTapRegion) {
                    long eventTime = ev.getEventTime();
                    if (eventTime - this.mPreviousDownTime < 600L) {
                        this.mIsDoubleTap = true;
                    } else if (eventTime - this.mDownTime < 300L) {
                        this.mIsTap = true;
                    }
                }
                this.mHandler.removeCallbacks(this.mOurLongPressRunnable);
            }
        }
    }

    public void registerLongPressCallback(Runnable runnable) {
        this.mUserLongPressRunnable = runnable;
    }

    private void dispatchLongPress() {
        this.mInLongPress = true;
        if (this.mUserLongPressRunnable != null) {
            this.mUserLongPressRunnable.run();
        }
    }

    public boolean isScroll() {
        return this.mIsScroll;
    }

    public float scrollX() {
        return this.mScrollX;
    }

    public float scrollY() {
        return this.mScrollY;
    }

    public boolean isTap() {
        return this.mIsTap;
    }

    public float getCurrentDownX() {
        return this.mCurrentDownX;
    }

    public float getCurrentDownY() {
        return this.mCurrentDownY;
    }

    public boolean isDoubleTap() {
        return this.mIsDoubleTap;
    }

    public float getFirstDownX() {
        return this.mFirstDownX;
    }

    public float getFirstDownY() {
        return this.mFirstDownY;
    }
}

