/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.Canvas;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OverlayBundle {
    private final List<Overlay> mOverlays = Collections.synchronizedList(new ArrayList());

    OverlayBundle() {
    }

    boolean draw(Canvas canvas, MapView mapView, long drawTime) {
        boolean again = false;
        for (Overlay overlay : this.mOverlays) {
            again |= overlay.draw(canvas, mapView, true, drawTime);
        }
        for (Overlay overlay : this.mOverlays) {
            again |= overlay.draw(canvas, mapView, false, drawTime);
        }
        return again;
    }

    boolean onTouchEvent(MotionEvent e, MapView mapView) {
        int size = this.mOverlays.size();
        for (int i = size - 1; i >= 0; --i) {
            Overlay overlay = this.mOverlays.get(i);
            if (!overlay.onTouchEvent(e, mapView)) continue;
            return true;
        }
        return false;
    }

    boolean onTap(GeoPoint p, MapView mapView) {
        int size = this.mOverlays.size();
        for (int i = size - 1; i >= 0; --i) {
            Overlay overlay = this.mOverlays.get(i);
            if (!overlay.onTap(p, mapView)) continue;
            return true;
        }
        return false;
    }

    boolean onKeyDown(int keyCode, KeyEvent event, MapView mapView) {
        int size = this.mOverlays.size();
        for (int i = size - 1; i >= 0; --i) {
            Overlay overlay = this.mOverlays.get(i);
            if (!overlay.onKeyDown(keyCode, event, mapView)) continue;
            return true;
        }
        return false;
    }

    boolean onKeyUp(int keyCode, KeyEvent event, MapView mapView) {
        int size = this.mOverlays.size();
        for (int i = size - 1; i >= 0; --i) {
            Overlay overlay = this.mOverlays.get(i);
            if (!overlay.onKeyUp(keyCode, event, mapView)) continue;
            return true;
        }
        return false;
    }

    boolean onTrackballEvent(MotionEvent event, MapView mapView) {
        int size = this.mOverlays.size();
        for (int i = size - 1; i >= 0; --i) {
            Overlay overlay = this.mOverlays.get(i);
            if (!overlay.onTrackballEvent(event, mapView)) continue;
            return true;
        }
        return false;
    }

    public List<Overlay> getOverlays() {
        return this.mOverlays;
    }
}

