/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;

public abstract class Overlay {
    protected static final float SHADOW_X_SKEW = -0.9f;
    protected static final float SHADOW_Y_SCALE = 0.5f;

    protected static void drawAt(Canvas canvas, Drawable drawable2, int x, int y, boolean shadow) {
        int MAX = 16000;
        if (x > 16000 || y > 16000 || x < -16000 || y < -16000) {
            return;
        }
        if (shadow) {
            drawable2.setColorFilter(0x7F000000, PorterDuff.Mode.SRC_IN);
        }
        canvas.save();
        canvas.translate((float)x, (float)y);
        if (shadow) {
            canvas.skew(-0.9f, 0.0f);
            canvas.scale(1.0f, 0.5f);
        }
        drawable2.draw(canvas);
        if (shadow) {
            drawable2.clearColorFilter();
        }
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onTrackballEvent(MotionEvent event, MapView mapView) {
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event, MapView mapView) {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event, MapView mapView) {
        return false;
    }

    public boolean onTap(GeoPoint p, MapView mapView) {
        return false;
    }

    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
    }

    public boolean draw(Canvas canvas, MapView mapView, boolean shadow, long when) {
        this.draw(canvas, mapView, shadow);
        return false;
    }

    public static interface Snappable {
        public boolean onSnapToItem(int var1, int var2, Point var3, MapView var4);
    }
}

