/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LevelListDrawable;
import android.hardware.SensorListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.Projection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

public class MyLocationOverlay
extends Overlay
implements SensorListener,
LocationListener,
Overlay.Snappable {
    private static final String LOG_TAG = "Maps.MyLocationOverlay";
    private static final boolean VERBOSE_LOGGING = false;
    private static final boolean SHOW_TICKS = false;
    private static final boolean SHOW_EDGES = true;
    private static final String PACKAGE_NAME = "com.google.android.maps";
    private static final String[] DESIRED_PROVIDER_NAMES = new String[]{"gps", "network"};
    private static final String PREFERRED_PROVIDER_NAME = "gps";
    private static final Paint LOCATION_ACCURACY_FILL_PAINT = new Paint();
    private static final Paint LOCATION_ACCURACY_STROKE_PAINT;
    private static final long LOCATION_UPDATE_MILLIS = 0L;
    private final Context mContext;
    private final MapController mController;
    private final MapView mMapView;
    private volatile boolean mIsCompassEnabled = false;
    private volatile float mOrientation = Float.NaN;
    private Drawable mCompassBase;
    private Drawable mCompassArrow;
    private static final int COMPASS_CENTER_X = 50;
    private static final int COMPASS_CENTER_Y = 58;
    private static final long LOCATION_FRESHNESS_CUTOFF = 60000L;
    private volatile boolean mIsMyLocationEnabled = false;
    private volatile Location mLastFix = null;
    private volatile GeoPoint mMyLocation = null;
    private volatile long mMyLocationTime;
    private volatile GeoPoint mPreviousMyLocation = null;
    private volatile boolean mLocationChangedSinceLastDraw = false;
    private volatile boolean mIsOnScreen = true;
    private final ArrayList<NameAndDate> mEnabledProviders = new ArrayList(2);
    private static final long FALLBACK_PROVIDER_THRESHOLD_MILLIS = 10000L;
    private final Point mTempPoint = new Point();
    private final Rect mTempRect = new Rect();
    private final Queue<Runnable> mRunOnFirstFix = new LinkedList<Runnable>();
    private LevelListDrawable mLocationDot;
    private int mLocationDotHalfWidth;
    private int mLocationDotHalfHeight;
    private static final int ANIMATION_TIME_MILLIS = 1000;
    private static final int ANIMATION_LEVELS = 4;
    private PowerManager mPowerManager;
    private Runnable mUserActivityReporter = new Runnable(){

        public void run() {
            MyLocationOverlay.this.mPowerManager.userActivity(SystemClock.uptimeMillis(), true);
        }
    };
    Location mNetworkLocation = null;
    Handler mNetworkLocationHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (MyLocationOverlay.this.mNetworkLocation != null) {
                MyLocationOverlay.this.onLocationChanged(MyLocationOverlay.this.mNetworkLocation);
            }
        }
    };

    public MyLocationOverlay(Context context, MapView mapView) {
        if (mapView == null) {
            throw new IllegalArgumentException("mapView == null");
        }
        this.mContext = context;
        this.mMapView = mapView;
        this.mController = mapView.getController();
        this.mPowerManager = (PowerManager)context.getSystemService("power");
    }

    private LevelListDrawable getLocationDot() {
        if (this.mLocationDot == null) {
            this.mLocationDot = (LevelListDrawable)this.mContext.getResources().getDrawable(17301881);
            this.mLocationDotHalfWidth = this.mLocationDot.getIntrinsicWidth() / 2;
            this.mLocationDotHalfHeight = this.mLocationDot.getIntrinsicHeight() / 2;
            this.mLocationDot.setBounds(-this.mLocationDotHalfWidth, -this.mLocationDotHalfHeight, this.mLocationDotHalfWidth, this.mLocationDotHalfHeight);
        }
        return this.mLocationDot;
    }

    private Drawable getCompassBase() {
        if (this.mCompassBase == null) {
            this.mCompassBase = this.mContext.getResources().getDrawable(17301814);
            int w = this.mCompassBase.getIntrinsicWidth() / 2;
            int h = this.mCompassBase.getIntrinsicHeight() / 2;
            this.mCompassBase.setBounds(-w, -h, w, h);
        }
        return this.mCompassBase;
    }

    private Drawable getCompassArrow() {
        if (this.mCompassArrow == null) {
            this.mCompassArrow = this.mContext.getResources().getDrawable(17301813);
            int w = this.mCompassArrow.getIntrinsicWidth() / 2;
            int h = this.mCompassArrow.getIntrinsicHeight();
            this.mCompassArrow.setBounds(-w, -28, w, h - 28);
        }
        return this.mCompassArrow;
    }

    public synchronized boolean enableCompass() {
        if (!this.mIsCompassEnabled) {
            SensorManager sm = (SensorManager)this.mContext.getSystemService("sensor");
            if (sm != null) {
                sm.registerListener((SensorListener)this, 128, 2);
                this.mIsCompassEnabled = true;
                this.mMapView.postInvalidate();
            } else {
                Log.w((String)LOG_TAG, (String)"Compass SensorManager was unavailable.");
            }
        }
        return this.mIsCompassEnabled;
    }

    public synchronized void disableCompass() {
        if (this.mIsCompassEnabled) {
            SensorManager sm = (SensorManager)this.mContext.getSystemService("sensor");
            if (sm != null) {
                sm.unregisterListener((SensorListener)this, 128);
            }
            this.mMapView.postInvalidate();
            this.mIsCompassEnabled = false;
        }
    }

    public boolean isCompassEnabled() {
        return this.mIsCompassEnabled;
    }

    public synchronized boolean enableMyLocation() {
        LocationManager service = (LocationManager)this.mContext.getSystemService("location");
        service.removeUpdates((LocationListener)this);
        this.mEnabledProviders.clear();
        this.mIsMyLocationEnabled = false;
        for (String name : DESIRED_PROVIDER_NAMES) {
            try {
                boolean isProviderEnabled = service.isProviderEnabled(name);
                if (!isProviderEnabled) continue;
                this.mIsMyLocationEnabled = true;
                this.mEnabledProviders.add(new NameAndDate(name));
                service.requestLocationUpdates(name, 0L, 0.0f, (LocationListener)this);
                Log.i((String)LOG_TAG, (String)("Request updates from " + name));
            }
            catch (SecurityException e) {
                Log.w((String)LOG_TAG, (String)("Couldn't get provider " + name + ": " + e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                Log.w((String)LOG_TAG, (String)("Couldn't get provider " + name + ": " + e.getMessage()));
            }
        }
        if (!this.mIsMyLocationEnabled) {
            Log.w((String)LOG_TAG, (String)"None of the desired Location Providers are available");
        }
        return this.mIsMyLocationEnabled;
    }

    public synchronized void disableMyLocation() {
        LocationManager service = (LocationManager)this.mContext.getSystemService("location");
        service.removeUpdates((LocationListener)this);
        this.mEnabledProviders.clear();
        this.mIsMyLocationEnabled = false;
        this.mNetworkLocation = null;
        this.mNetworkLocationHandler.removeMessages(1);
    }

    public synchronized void onSensorChanged(int sensor, float[] values) {
        if (this.mIsCompassEnabled) {
            this.mOrientation = values[0];
            Rect r = this.getCompassBase().getBounds();
            this.mMapView.postInvalidate(r.left + 50, r.top + 58, r.right + 50, r.bottom + 58);
        }
    }

    private boolean isLocationOnScreen(MapView mapView, GeoPoint location) {
        Point tempPoint = new Point();
        mapView.getProjection().toPixels(location, tempPoint);
        Rect screen = new Rect();
        screen.set(0, 0, mapView.getWidth(), mapView.getHeight());
        return screen.contains(tempPoint.x, tempPoint.y);
    }

    public synchronized void onLocationChanged(Location location) {
        Runnable runnable;
        if (location.getProvider().equals("network")) {
            this.mNetworkLocationHandler.removeMessages(1);
            if (this.mNetworkLocation == null) {
                this.mNetworkLocation = new Location(location);
            } else {
                this.mNetworkLocation.set(location);
            }
            Message msg = this.mNetworkLocationHandler.obtainMessage(1);
            this.mNetworkLocationHandler.sendMessageDelayed(msg, 15000L);
        }
        if (!this.mIsMyLocationEnabled) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        long then = now - 10000L;
        String name = location.getProvider();
        for (NameAndDate provider : this.mEnabledProviders) {
            if (provider.name.equals(name)) {
                provider.date = now;
                break;
            }
            if (!provider.name.equals(PREFERRED_PROVIDER_NAME) || provider.date <= then) continue;
            Log.i((String)LOG_TAG, (String)"Got fallback update soon after preferred udpate, ignoring");
            return;
        }
        this.mLocationChangedSinceLastDraw = true;
        this.mPreviousMyLocation = this.mMyLocation;
        this.mMyLocation = new GeoPoint((int)(location.getLatitude() * 1000000.0), (int)(location.getLongitude() * 1000000.0));
        this.mMyLocationTime = SystemClock.elapsedRealtime();
        this.mLastFix = location;
        if (this.isLocationOnScreen(this.mMapView, this.mMyLocation)) {
            this.mMapView.postInvalidate();
        }
        while ((runnable = this.mRunOnFirstFix.poll()) != null) {
            Log.i((String)LOG_TAG, (String)("Running deferred on first fix: " + runnable));
            new Thread(runnable).start();
        }
    }

    private void clearNetworkLocationRebroadcasts() {
        this.mNetworkLocation = null;
        this.mNetworkLocationHandler.removeMessages(1);
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        if (provider.equals("network") && status != 2) {
            this.clearNetworkLocationRebroadcasts();
        }
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
        if (provider.equals("network")) {
            this.clearNetworkLocationRebroadcasts();
        }
    }

    public boolean onSnapToItem(int x, int y, Point snapPoint, MapView mapView) {
        if (this.isCloseToPoint(x, y, mapView)) {
            snapPoint.x = this.mTempPoint.x;
            snapPoint.y = this.mTempPoint.y;
            return true;
        }
        return false;
    }

    public boolean onTap(GeoPoint p, MapView map) {
        if (this.mMyLocation != null) {
            map.getProjection().toPixels(p, this.mTempPoint);
            if (this.isCloseToPoint(this.mTempPoint.x, this.mTempPoint.y, map)) {
                this.dispatchTap();
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isCloseToPoint(int x, int y, MapView mapView) {
        if (this.mMyLocation == null) {
            return false;
        }
        mapView.getProjection().toPixels(this.mMyLocation, this.mTempPoint);
        long dx = Math.abs((long)x - (long)this.mTempPoint.x);
        long dy = Math.abs((long)y - (long)this.mTempPoint.y);
        float tapRadius = 32.0f;
        return (float)(dx * dx + dy * dy) < tapRadius * tapRadius;
    }

    protected boolean dispatchTap() {
        return false;
    }

    public synchronized boolean draw(Canvas canvas, MapView mapView, boolean shadow, long when) {
        if (shadow) {
            return false;
        }
        if (this.mMyLocation != null) {
            if (SystemClock.elapsedRealtime() - this.mMyLocationTime < 60000L) {
                this.drawMyLocation(canvas, mapView, this.mLastFix, this.mMyLocation, when);
            } else {
                this.mMyLocation = null;
                this.mMapView.postInvalidate();
            }
        }
        if (this.mIsCompassEnabled && !Float.isNaN(this.mOrientation)) {
            this.drawCompass(canvas, this.mOrientation);
        }
        return false;
    }

    private float isect(float c, float radius, float isect) {
        float disc = radius * radius - c * c + 2.0f * c * isect - isect * isect;
        if (disc > 0.0f) {
            return (float)Math.sqrt(disc);
        }
        return 0.0f;
    }

    protected void drawMyLocation(Canvas canvas, MapView mapView, Location lastFix, GeoPoint myLocation, long when) {
        if (!this.mIsMyLocationEnabled) {
            return;
        }
        LevelListDrawable locationDot = this.getLocationDot();
        Rect bounds = locationDot.getBounds();
        Projection converter = mapView.getProjection();
        converter.toPixels(myLocation, this.mTempPoint);
        int x = this.mTempPoint.x;
        int y = this.mTempPoint.y;
        float radius = 0.0f;
        if (lastFix.hasAccuracy()) {
            radius = converter.metersToEquatorPixels((int)lastFix.getAccuracy());
        }
        int level = (int)(when % 1000L) * 10000 / 1000;
        locationDot.setLevel(level);
        int width = mapView.getWidth();
        int height = mapView.getHeight();
        if (radius > 0.0f) {
            canvas.drawCircle((float)x, (float)y, radius, LOCATION_ACCURACY_FILL_PAINT);
            canvas.drawCircle((float)x, (float)y, radius, LOCATION_ACCURACY_STROKE_PAINT);
            float lineCenter = 1.0f;
            float halfChord = this.isect(y, radius, lineCenter);
            if (halfChord > 0.0f) {
                canvas.drawLine((float)x - halfChord, lineCenter, (float)x + halfChord, lineCenter, LOCATION_ACCURACY_STROKE_PAINT);
            }
            if ((halfChord = this.isect(y, radius, (float)height - lineCenter)) > 0.0f) {
                canvas.drawLine((float)x - halfChord, (float)height - lineCenter, (float)x + halfChord, (float)height - lineCenter, LOCATION_ACCURACY_STROKE_PAINT);
            }
            if ((halfChord = this.isect(x, radius, lineCenter)) > 0.0f) {
                canvas.drawLine(lineCenter, (float)y - halfChord, lineCenter, (float)y + halfChord, LOCATION_ACCURACY_STROKE_PAINT);
            }
            if ((halfChord = this.isect(x, radius, (float)width - lineCenter)) > 0.0f) {
                canvas.drawLine((float)width - lineCenter, (float)y - halfChord, (float)width - lineCenter, (float)y + halfChord, LOCATION_ACCURACY_STROKE_PAINT);
            }
        }
        MyLocationOverlay.drawAt(canvas, (Drawable)locationDot, x, y, false);
        this.mTempRect.set(0, 0, width, height);
        this.mIsOnScreen = this.mTempRect.intersects(bounds.left + x, bounds.top + y, bounds.right + x, bounds.bottom + y);
        if (this.mLocationChangedSinceLastDraw && this.mController != null) {
            this.mTempRect.inset(width / 20, height / 20);
            boolean isOnScreenInset = this.mTempRect.contains(x, y);
            if (!isOnScreenInset) {
                boolean wasOnScreen = false;
                if (this.mPreviousMyLocation != null) {
                    converter.toPixels(this.mPreviousMyLocation, this.mTempPoint);
                    wasOnScreen = this.mTempRect.contains(this.mTempPoint.x, this.mTempPoint.y);
                }
                if (wasOnScreen) {
                    converter.toPixels(this.mMyLocation, this.mTempPoint);
                    this.mController.animateTo(this.mMyLocation);
                    this.mMapView.post(this.mUserActivityReporter);
                }
            }
        }
        if (this.mIsOnScreen) {
            int w = this.mLocationDotHalfWidth;
            int h = this.mLocationDotHalfHeight;
            this.mMapView.postInvalidateDelayed(250L, x - w, y - h, x + w, y + h);
        }
        this.mLocationChangedSinceLastDraw = false;
    }

    protected void drawCompass(Canvas canvas, float bearing) {
        canvas.save();
        canvas.translate(50.0f, 58.0f);
        MyLocationOverlay.drawAt(canvas, this.getCompassBase(), 0, 0, false);
        canvas.rotate(-bearing);
        MyLocationOverlay.drawAt(canvas, this.getCompassArrow(), 0, 0, false);
        canvas.restore();
    }

    public GeoPoint getMyLocation() {
        return this.mMyLocation;
    }

    public Location getLastFix() {
        return this.mLastFix;
    }

    public float getOrientation() {
        return this.mOrientation;
    }

    public boolean isMyLocationEnabled() {
        return this.mIsMyLocationEnabled;
    }

    public synchronized boolean runOnFirstFix(Runnable runnable) {
        if (this.mMyLocation != null) {
            runnable.run();
            return true;
        }
        this.mRunOnFirstFix.offer(runnable);
        return false;
    }

    public void onAccuracyChanged(int sensor, int accuracy) {
    }

    static {
        LOCATION_ACCURACY_FILL_PAINT.setARGB(30, 0, 0, 255);
        LOCATION_ACCURACY_FILL_PAINT.setStyle(Paint.Style.FILL);
        LOCATION_ACCURACY_STROKE_PAINT = new Paint();
        LOCATION_ACCURACY_STROKE_PAINT.setARGB(100, 0, 0, 255);
        LOCATION_ACCURACY_STROKE_PAINT.setStrokeWidth(2.5f);
        LOCATION_ACCURACY_STROKE_PAINT.setStyle(Paint.Style.STROKE);
        LOCATION_ACCURACY_STROKE_PAINT.setAntiAlias(true);
    }

    private static class NameAndDate {
        public String name;
        public long date;

        public NameAndDate(String name) {
            this.name = name;
            this.date = Long.MIN_VALUE;
        }
    }
}

