/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Scroller;
import android.widget.ZoomButtonsController;
import android.widget.ZoomControls;
import com.android.internal.R;
import com.google.android.maps.AndroidTileOverlayRenderer;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayBundle;
import com.google.android.maps.PixelConverter;
import com.google.android.maps.Projection;
import com.google.android.maps.TrackballGestureDetector;
import com.google.android.maps.ZoomHelper;
import com.google.common.graphics.GoogleGraphics;
import com.google.common.graphics.android.AndroidGraphics;
import com.google.common.ui.RepaintListener;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.map.Map;
import com.google.googlenav.map.TrafficService;
import com.google.map.MapPoint;
import com.google.map.MapState;
import com.google.map.Zoom;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends ViewGroup {
    private static final String LOG_TAG = "MapView";
    private static final String KEY_ZOOM_DISPLAYED = MapView.class.getName() + ".zoomDisplayed";
    private static final String KEY_CENTER_LATITUDE = MapView.class.getName() + ".centerLatitude";
    private static final String KEY_CENTER_LONGITUDE = MapView.class.getName() + ".centerLongitude";
    private static final String KEY_ZOOM_LEVEL = MapView.class.getName() + ".zoomLevel";
    private static final long ZOOM_CONTROLS_TIMEOUT = ViewConfiguration.getZoomControlsTimeout();
    private static final int MAX_FLING_DISTANCE = 800;
    private Handler mHandler;
    private final AndroidGraphics mDrawer = new AndroidGraphics(null);
    private Map mMap;
    private PixelConverter mConverter;
    private OverlayBundle mOverlayBundle = null;
    private ZoomHelper mZoomHelper;
    private ZoomControls mZoomControls;
    private Runnable mZoomControlRunnable;
    private ZoomButtonsController mZoomButtonsController;
    private boolean mBuiltInZoomControlsEnabled;
    private MapController mController;
    private Drawable mReticle = null;
    private ReticleDrawMode mReticleDrawMode;
    private final Scroller mScroller;
    private int mLastFlingX;
    private int mLastFlingY;
    private AndroidTileOverlayRenderer mOverlayRenderer;
    private GestureDetector mGestureDetector;
    private TrackballGestureDetector mTrackballGestureDetector;
    private final Drawable mGoogleLogo;
    private final int mGoogleLogoHeight;
    private final int mGoogleLogoWidth;
    final String mKey;
    final Repainter mRepainter = new Repainter();

    public MapView(Context context, String apiKey) {
        this(context, null, 16842890, apiKey);
    }

    public MapView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842890);
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, null);
    }

    private MapView(Context context, AttributeSet attrs, int defStyle, String apiKey) {
        super(context, attrs, defStyle);
        if (apiKey == null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MapView);
            this.mKey = a.getString(0);
            a.recycle();
        } else {
            this.mKey = apiKey;
        }
        if (this.mKey == null) {
            throw new IllegalArgumentException("You need to specify an API Key for each MapView.  See the MapView documentation for details.");
        }
        this.setWillNotDraw(false);
        if (!(context instanceof MapActivity)) {
            throw new IllegalArgumentException("MapViews can only be created inside instances of MapActivity.");
        }
        ((MapActivity)context).setupMapView(this);
        this.mScroller = new Scroller(context);
        this.mGoogleLogo = context.getResources().getDrawable(17301954);
        this.mGoogleLogoWidth = this.mGoogleLogo.getIntrinsicWidth();
        this.mGoogleLogoHeight = this.mGoogleLogo.getIntrinsicHeight();
    }

    void setup(Map map, TrafficService traffic, DataRequestDispatcher dispatcher) {
        this.mMap = map;
        this.mConverter = new PixelConverter(map);
        this.mMap.setRepaintListener(this.mRepainter);
        this.mOverlayBundle = new OverlayBundle();
        this.mController = new MapController(this.mMap, this);
        this.mZoomHelper = new ZoomHelper(this, this.mController);
        this.mReticle = this.mContext.getResources().getDrawable(17302013);
        this.mReticleDrawMode = ReticleDrawMode.DRAW_RETICLE_OVER;
        this.mOverlayRenderer = new AndroidTileOverlayRenderer(traffic, dispatcher);
        map.setTileOverlayRenderer(this.mOverlayRenderer);
        this.mHandler = new Handler();
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                if (!MapView.this.mScroller.isFinished()) {
                    MapView.this.mScroller.abortAnimation();
                }
                MapView.this.displayZoomControls(false);
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                MapView.this.displayZoomControls(false);
                MapView.this.mController.scrollBy((int)distanceX, (int)distanceY);
                return true;
            }

            public boolean onSingleTapUp(MotionEvent e) {
                GeoPoint point = MapView.this.mConverter.fromPixels((int)e.getX(), (int)e.getY());
                return MapView.this.mOverlayBundle.onTap(point, MapView.this);
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                MapView.this.mScroller.abortAnimation();
                MapView.this.mLastFlingX = 400;
                MapView.this.mLastFlingY = 400;
                MapView.this.mScroller.fling(MapView.this.mLastFlingX, MapView.this.mLastFlingX, (int)(-velocityX) / 2, (int)(-velocityY) / 2, 0, 800, 0, 800);
                MapView.this.postInvalidate();
                return false;
            }
        });
        this.mGestureDetector.setIsLongpressEnabled(false);
        this.mTrackballGestureDetector = new TrackballGestureDetector(this.mHandler);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mMap.resize(w, h);
        if (this.mReticle != null) {
            int left = w / 2 - this.mReticle.getIntrinsicWidth() / 2;
            int top = h / 2 - this.mReticle.getIntrinsicHeight() / 2;
            int right = left + this.mReticle.getIntrinsicWidth();
            int bottom = top + this.mReticle.getIntrinsicHeight();
            this.mReticle.setBounds(left, top, right, bottom);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mZoomButtonsController != null) {
            this.mZoomButtonsController.setVisible(false);
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int x = this.mScroller.getCurrX() - this.mLastFlingX;
            int y = this.mScroller.getCurrY() - this.mLastFlingY;
            this.mLastFlingX = this.mScroller.getCurrX();
            this.mLastFlingY = this.mScroller.getCurrY();
            this.mController.scrollBy(x, y);
            this.postInvalidate();
        } else {
            super.computeScroll();
        }
    }

    public boolean isOpaque() {
        return true;
    }

    protected final void onDraw(Canvas canvas) {
        if (this.mController.isDirty()) {
            this.onLayout(true, 0, 0, 0, 0);
        }
        boolean fetchTiles = true;
        boolean drawAgain = false;
        long drawTime = this.getDrawingTime();
        boolean bl = fetchTiles = !drawAgain;
        if (this.mZoomHelper.shouldDrawMap(drawTime)) {
            drawAgain |= !this.drawMap(canvas, fetchTiles);
        }
        if (this.mReticleDrawMode == ReticleDrawMode.DRAW_RETICLE_UNDER && !this.isInTouchMode()) {
            this.mReticle.draw(canvas);
        }
        drawAgain |= this.mZoomHelper.onDraw(canvas, this, drawTime);
        drawAgain |= this.mOverlayBundle.draw(canvas, this, drawTime);
        if (this.mReticleDrawMode == ReticleDrawMode.DRAW_RETICLE_OVER && !this.isInTouchMode()) {
            this.mReticle.draw(canvas);
        }
        this.mGoogleLogo.draw(canvas);
        if (drawAgain |= this.mController.stepAnimation(drawTime)) {
            this.requestLayout();
            this.invalidate();
        }
    }

    protected final void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int maxWidth = this.mMeasuredWidth;
        int maxHeight = this.mMeasuredHeight;
        if (maxWidth == 0 || maxHeight == 0) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            if (maxWidth == 0) {
                maxWidth = display.getWidth();
            }
            if (maxHeight == 0) {
                maxHeight = display.getHeight();
            }
        }
        this.setMeasuredDimension(MapView.resolveSize((int)maxWidth, (int)widthMeasureSpec), MapView.resolveSize((int)maxHeight, (int)heightMeasureSpec));
        this.mGoogleLogo.setBounds(10, this.mMeasuredHeight - this.mGoogleLogoHeight - 10, this.mGoogleLogoWidth + 10, this.mMeasuredHeight - 10);
        this.mMap.resize(this.mMeasuredWidth, this.mMeasuredHeight);
        this.mController.onMeasure();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        if (!hasFocus) {
            this.mController.stopPanning();
        }
        super.onWindowFocusChanged(hasFocus);
    }

    public void onFocusChanged(boolean hasFocus, int direction, Rect unused) {
        if (!hasFocus) {
            this.mController.stopPanning();
        }
        super.onWindowFocusChanged(hasFocus);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mOverlayBundle.onKeyDown(keyCode, event, this)) {
            return true;
        }
        if (this.mController.onKey((View)this, keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mOverlayBundle.onKeyUp(keyCode, event, this)) {
            return true;
        }
        if (this.mController.onKey((View)this, keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        this.postInvalidate();
        if (this.mOverlayBundle.onTrackballEvent(event, this)) {
            return true;
        }
        this.mTrackballGestureDetector.analyze(event);
        if (this.mTrackballGestureDetector.isScroll()) {
            float TRACKBALL_SCALE = 10.0f;
            this.mController.scrollByTrackball((int)(event.getX() * 10.0f), (int)(event.getY() * 10.0f));
        } else if (this.mTrackballGestureDetector.isTap()) {
            this.mOverlayBundle.onTap(new GeoPoint(this.mMap.getCenterPoint()), this);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || !this.isClickable()) {
            return false;
        }
        this.postInvalidate();
        if (this.mOverlayBundle.onTouchEvent(ev, this)) {
            return true;
        }
        this.mGestureDetector.onTouchEvent(ev);
        return true;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, new GeoPoint(0, 0), 17);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.updateZoomControls();
        int count = this.getChildCount();
        Point point = new Point();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.mode == 0) {
                this.mConverter.toPixels(lp.point, point);
                point.x += lp.x;
                point.y += lp.y;
            } else {
                point.x = lp.x;
                point.y = lp.y;
            }
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int x = point.x;
            int y = point.y;
            int alignment = lp.alignment;
            switch (alignment & 7) {
                case 3: {
                    break;
                }
                case 1: {
                    x -= width / 2;
                    break;
                }
                case 5: {
                    x -= width - 1;
                }
            }
            switch (alignment & 0x70) {
                case 48: {
                    break;
                }
                case 16: {
                    y -= height / 2;
                    break;
                }
                case 80: {
                    y -= height - 1;
                }
            }
            int childLeft = this.mPaddingLeft + x;
            int childTop = this.mPaddingTop + y;
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
        this.mController.clean();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public void displayZoomControls(boolean takeFocus) {
        if (this.mBuiltInZoomControlsEnabled) {
            if (this.mZoomButtonsController != null && !this.mZoomButtonsController.isVisible()) {
                this.mZoomButtonsController.setFocusable(takeFocus);
                this.mZoomButtonsController.setVisible(true);
            }
        } else if (this.mZoomControls != null) {
            if (this.mZoomControls.getVisibility() == 8) {
                this.mZoomControls.show();
            }
            if (takeFocus) {
                this.mZoomControls.requestFocus();
            }
            this.mHandler.removeCallbacks(this.mZoomControlRunnable);
            this.mHandler.postDelayed(this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
        }
    }

    private boolean isLocationDisplayed() {
        if (this.mContext instanceof MapActivity) {
            return ((MapActivity)this.mContext).isLocationDisplayed();
        }
        return false;
    }

    private boolean isRouteDisplayed() {
        if (this.mContext instanceof MapActivity) {
            return ((MapActivity)this.mContext).isRouteDisplayed();
        }
        return false;
    }

    boolean drawMap(Canvas canvas, boolean fetchTiles) {
        this.mDrawer.setCanvas(canvas);
        boolean drawIncompleteTiles = true;
        try {
            return this.mMap.drawMap((GoogleGraphics)this.mDrawer, fetchTiles, this.isLocationDisplayed(), this.isRouteDisplayed(), true);
        }
        catch (IllegalStateException e) {
            Log.e((String)LOG_TAG, (String)"IllegalStateException on drawMap. Wiping cache.", (Throwable)e);
            this.mMap.eraseAll();
            return true;
        }
    }

    public boolean canCoverCenter() {
        return this.mMap.canCover(this.mMap.getCenterPoint(), true);
    }

    public void preLoad() {
        this.mMap.preLoad(this.mMap.getCenterPoint());
    }

    Zoom getZoom() {
        return this.mMap.getZoom();
    }

    public int getZoomLevel() {
        return this.mMap.getZoom().getZoomLevel();
    }

    public void setSatellite(boolean on) {
        if (this.isSatellite() != on) {
            this.mMap.toggleSatellite();
            int maxMapZoom = this.mMap.getMaxMapZoomForPoint(this.mMap.getCenterPoint());
            if (this.mMap.getZoom().getZoomLevel() > maxMapZoom) {
                this.mMap.setZoom(Zoom.getZoom(maxMapZoom));
            }
            this.updateZoomControls();
            this.postInvalidate();
        }
    }

    public boolean isSatellite() {
        return this.mMap.isSatellite();
    }

    public void setTraffic(boolean on) {
        this.mOverlayRenderer.setShowTraffic(on);
        this.postInvalidate();
    }

    public boolean isTraffic() {
        return this.mOverlayRenderer.isShowTraffic();
    }

    public void setStreetView(boolean on) {
        this.mOverlayRenderer.setShowStreetView(on);
        this.postInvalidate();
    }

    public boolean isStreetView() {
        return this.mOverlayRenderer.isShowStreetView();
    }

    public GeoPoint getMapCenter() {
        return new GeoPoint(this.mMap.getCenterPoint());
    }

    public MapController getController() {
        return this.mController;
    }

    public final List<Overlay> getOverlays() {
        return this.mOverlayBundle.getOverlays();
    }

    public int getLatitudeSpan() {
        return this.mMap.getLatitudeSpan();
    }

    public int getLongitudeSpan() {
        MapState mapState = this.mMap.getMapState();
        MapPoint point = mapState.getCenterPoint();
        Zoom zoom = mapState.getZoom();
        int halfWidth = this.mMap.getWidth() / 2;
        int shift = 0;
        if (zoom.getZoomLevel() == 1) {
            shift = 2;
            halfWidth >>= 2;
        }
        MapPoint left = point.pixelOffset(-halfWidth, 0, zoom);
        MapPoint right = point.pixelOffset(halfWidth, 0, zoom);
        int diff = right.getLongitude() - left.getLongitude();
        if (diff <= 0) {
            diff += 360000000;
        }
        return diff << shift;
    }

    public void setReticleDrawMode(ReticleDrawMode mode) {
        if (mode == null) {
            throw new NullPointerException("The ReticleDrawMode cannot be null");
        }
        this.mReticleDrawMode = mode;
    }

    public int getMaxZoomLevel() {
        return this.mMap.getMaxMapZoomForPoint(this.mMap.getCenterPoint());
    }

    public void onSaveInstanceState(Bundle state) {
        state.putInt(KEY_CENTER_LATITUDE, this.mMap.getCenterPoint().getLatitude());
        state.putInt(KEY_CENTER_LONGITUDE, this.mMap.getCenterPoint().getLongitude());
        state.putInt(KEY_ZOOM_LEVEL, this.getZoomLevel());
        if (this.mZoomButtonsController != null && this.mZoomButtonsController.isVisible() || this.mZoomControls != null && this.mZoomControls.getVisibility() == 0) {
            state.putInt(KEY_ZOOM_DISPLAYED, 1);
        } else {
            state.putInt(KEY_ZOOM_DISPLAYED, 0);
        }
    }

    public void onRestoreInstanceState(Bundle state) {
        boolean zoomDisplayed;
        if (state == null) {
            return;
        }
        if (this.mController != null) {
            int zoomLevel;
            int invalid = Integer.MAX_VALUE;
            int latitude = state.getInt(KEY_CENTER_LATITUDE, invalid);
            int longitude = state.getInt(KEY_CENTER_LONGITUDE, invalid);
            if (latitude != invalid && longitude != invalid) {
                this.mController.setCenter(new GeoPoint(latitude, longitude));
            }
            if ((zoomLevel = state.getInt(KEY_ZOOM_LEVEL, invalid)) != invalid) {
                this.mController.setZoom(zoomLevel);
            }
        }
        boolean bl = zoomDisplayed = state.getInt(KEY_ZOOM_DISPLAYED, 0) != 0;
        if (zoomDisplayed) {
            this.displayZoomControls(false);
        }
    }

    @Deprecated
    public View getZoomControls() {
        if (this.mZoomControls == null) {
            this.mZoomControls = this.createZoomControls();
            this.mZoomControls.setVisibility(8);
            this.mZoomControlRunnable = new Runnable(){

                public void run() {
                    if (!MapView.this.mZoomControls.hasFocus()) {
                        MapView.this.mZoomControls.hide();
                    } else {
                        MapView.this.mHandler.removeCallbacks(MapView.this.mZoomControlRunnable);
                        MapView.this.mHandler.postDelayed(MapView.this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
                    }
                }
            };
        }
        return this.mZoomControls;
    }

    private ZoomControls createZoomControls() {
        ZoomControls zoomControls = new ZoomControls(this.mContext);
        zoomControls.setZoomSpeed(2000L);
        zoomControls.setOnZoomInClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapView.this.doZoom(true);
            }
        });
        zoomControls.setOnZoomOutClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapView.this.doZoom(false);
            }
        });
        return zoomControls;
    }

    public ZoomButtonsController getZoomButtonsController() {
        return this.mZoomButtonsController;
    }

    private ZoomButtonsController createZoomButtonsController() {
        final ZoomButtonsController controller = new ZoomButtonsController((View)this);
        controller.setZoomSpeed(2000L);
        controller.setOnZoomListener(new ZoomButtonsController.OnZoomListener(){
            private Point mTempPoint = new Point();

            public void onCenter(int x, int y) {
                List<Overlay> overlays = MapView.this.mOverlayBundle.getOverlays();
                for (int i = overlays.size() - 1; i >= 0; --i) {
                    Overlay.Snappable snappable;
                    Overlay overlay = overlays.get(i);
                    if (!(overlay instanceof Overlay.Snappable) || !(snappable = (Overlay.Snappable)((Object)overlay)).onSnapToItem(x, y, this.mTempPoint, MapView.this)) continue;
                    x = this.mTempPoint.x;
                    y = this.mTempPoint.y;
                    break;
                }
                GeoPoint point = MapView.this.mConverter.fromPixels(x, y);
                MapView.this.mController.animateTo(point);
            }

            public void onVisibilityChanged(boolean visible) {
                if (visible) {
                    MapView.this.updateZoomControls();
                } else {
                    controller.setFocusable(false);
                }
            }

            public void onZoom(boolean zoomIn) {
                MapView.this.doZoom(zoomIn);
            }
        });
        return controller;
    }

    public void setBuiltInZoomControls(boolean on) {
        this.mBuiltInZoomControlsEnabled = on;
        if (this.mZoomButtonsController == null) {
            this.mZoomButtonsController = this.createZoomButtonsController();
        }
    }

    boolean doZoom(boolean zoomIn, int xOffset, int yOffset) {
        boolean success = false;
        if (zoomIn ? this.canZoomIn() : this.canZoomOut()) {
            this.mZoomHelper.doZoom(zoomIn, true, xOffset, yOffset);
            success = true;
        }
        this.updateZoomControls();
        this.displayZoomControls(false);
        return success;
    }

    boolean doZoom(boolean zoomIn) {
        return this.doZoom(zoomIn, this.mMeasuredWidth / 2, this.mMeasuredHeight / 2);
    }

    private void updateZoomControls() {
        if (this.mZoomControls != null) {
            this.mZoomControls.setIsZoomInEnabled(this.canZoomIn());
            this.mZoomControls.setIsZoomOutEnabled(this.canZoomOut());
        }
        if (this.mZoomButtonsController != null) {
            this.mZoomButtonsController.setZoomInEnabled(this.canZoomIn());
            this.mZoomButtonsController.setZoomOutEnabled(this.canZoomOut());
        }
    }

    private boolean canZoomOut() {
        return this.mMap.getZoom().getZoomLevel() > 1;
    }

    private boolean canZoomIn() {
        return this.mMap.getZoom().getZoomLevel() < this.getMaxZoomLevel();
    }

    public Projection getProjection() {
        return this.mConverter;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int MODE_MAP = 0;
        public static final int MODE_VIEW = 1;
        public int mode;
        public GeoPoint point;
        public int x;
        public int y;
        public int alignment;
        public static final int LEFT = 3;
        public static final int RIGHT = 5;
        public static final int TOP = 48;
        public static final int BOTTOM = 80;
        public static final int CENTER_HORIZONTAL = 1;
        public static final int CENTER_VERTICAL = 16;
        public static final int CENTER = 17;
        public static final int TOP_LEFT = 51;
        public static final int BOTTOM_CENTER = 81;

        public LayoutParams(int width, int height, GeoPoint point, int alignment) {
            this(width, height, point, 0, 0, alignment);
        }

        public LayoutParams(int width, int height, GeoPoint point, int x, int y, int alignment) {
            super(width, height);
            this.mode = 0;
            this.point = point;
            this.x = x;
            this.y = y;
            this.alignment = alignment;
        }

        public LayoutParams(int width, int height, int x, int y, int alignment) {
            super(width, height);
            this.mode = 1;
            this.x = x;
            this.y = y;
            this.alignment = alignment;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
            this.mode = 1;
            this.alignment = 51;
        }

        public String debug(String output) {
            return output + "MapView.LayoutParams={width=" + LayoutParams.sizeToString((int)this.width) + ", height=" + LayoutParams.sizeToString((int)this.height) + " mode=" + this.mode + " lat=" + this.point.getLatitudeE6() + " lng=" + this.point.getLongitudeE6() + " x= " + this.x + " y= " + this.y + " alignment=" + this.alignment + "}";
        }
    }

    class Repainter
    implements RepaintListener {
        private Thread mThread;

        Repainter() {
        }

        public void repaint() {
            if (this.mThread == null || !this.mThread.isAlive()) {
                this.mThread = new Thread(){

                    public void run() {
                        try {
                            1.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        MapView.this.postInvalidate();
                    }
                };
                this.mThread.start();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReticleDrawMode {
        DRAW_RETICLE_OVER,
        DRAW_RETICLE_UNDER,
        DRAW_RETICLE_NEVER;

    }
}

