/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkConnectivityListener;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.R;
import com.google.android.maps.KeyHelper;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;
import com.google.android.maps.Overlay;
import com.google.android.providers.GoogleSettings;
import com.google.common.Config;
import com.google.common.android.AndroidConfig;
import com.google.common.io.android.AndroidHttpConnectionFactory;
import com.google.common.io.android.GoogleHttpClient;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.map.Map;
import com.google.googlenav.map.TrafficService;
import com.google.map.MapPoint;
import com.google.map.Zoom;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;

public abstract class MapActivity
extends Activity {
    protected static final int MAP_DATA_SOURCE_DEFAULT = 0;
    protected static final int MAP_DATA_SOURCE_CHINA = 1;
    private TrafficService mTrafficService;
    private Map mMap = null;
    private MapView mMapView;
    private DataRequestDispatcher mDataRequestDispatcher;
    private AndroidConfig mConfig;
    private static final String LOG_TAG = "MapActivity";
    private NetworkConnectivityListener mNetworkWatcher;
    private static volatile WeakReference<Map> sMapReference = new WeakReference<Object>(null);
    private static volatile WeakReference<MapActivity> sActivityReference = new WeakReference<Object>(null);
    private final Handler mNetworkHandler = new Handler(){

        public void handleMessage(Message message) {
            if (MapActivity.this.mNetworkWatcher == null) {
                return;
            }
            NetworkConnectivityListener.State state = MapActivity.this.mNetworkWatcher.getState();
            Log.i((String)MapActivity.LOG_TAG, (String)("Handling network change notification:" + state.toString()));
            if (MapActivity.this.mDataRequestDispatcher != null) {
                MapActivity.this.mDataRequestDispatcher.stop();
                if (state == NetworkConnectivityListener.State.CONNECTED) {
                    MapActivity.this.mDataRequestDispatcher.start();
                }
            }
            try {
                AndroidHttpConnectionFactory factory = MapActivity.this.mConfig.getConnectionFactory();
                if (factory == null) {
                    Log.e((String)MapActivity.LOG_TAG, (String)"Couldn't get connection factory");
                    return;
                }
                GoogleHttpClient client = factory.getClient();
                if (client == null) {
                    Log.e((String)MapActivity.LOG_TAG, (String)"Couldn't get connection factory client");
                    return;
                }
                ClientConnectionManager manager = client.getConnectionManager();
                if (manager == null) {
                    Log.e((String)MapActivity.LOG_TAG, (String)"Couldn't get client connection manager");
                    return;
                }
                manager.closeIdleConnections(1L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Log.e((String)MapActivity.LOG_TAG, (String)"Couldn't reset connection pool.", (Throwable)e);
            }
        }
    };

    void setupMapView(MapView mapView) {
        if (this.mMapView != null) {
            throw new IllegalStateException("You are only allowed to have a single MapView in a MapActivity");
        }
        this.mDataRequestDispatcher.setAndroidMapKey(mapView.mKey);
        this.mDataRequestDispatcher.setAndroidLoggingId2(Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"logging_id2"));
        this.mMapView = mapView;
        this.mMapView.setup(this.mMap, this.mTrafficService, this.mDataRequestDispatcher);
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mNetworkWatcher = new NetworkConnectivityListener();
        this.mNetworkWatcher.registerHandler(this.mNetworkHandler, 0);
        if (Config.getInstance() instanceof AndroidConfig) {
            ((AndroidConfig)Config.getInstance()).getConnectionFactory().close();
        }
        this.mConfig = new AndroidConfig((Context)this);
        this.mConfig.getImageFactory().setDrawableResourceClass(R.drawable.class);
        Config.setConfig((Config)this.mConfig);
        this.createMap();
        if (icicle == null) {
            this.sendStartSession();
        }
    }

    public void onNewIntent(Intent newIntent) {
        super.onNewIntent(newIntent);
        this.sendStartSession();
    }

    protected void onResume() {
        super.onResume();
        this.mTrafficService.start();
        this.mDataRequestDispatcher.start();
        this.mNetworkWatcher.startListening((Context)this);
        this.mMap.resume();
    }

    protected void onPause() {
        super.onPause();
        if (sActivityReference.get() == this) {
            this.mTrafficService.stop();
            this.mMap.pause();
            this.mDataRequestDispatcher.stop();
            this.mNetworkWatcher.stopListening();
            this.mMap.saveState();
            this.mConfig.getPersistentStore().savePreferences();
        } else {
            Log.d((String)LOG_TAG, (String)("onPause leaving the lights on for " + sActivityReference.get()));
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (sActivityReference.get() == this) {
            this.mNetworkWatcher.unregisterHandler(this.mNetworkHandler);
            this.mNetworkWatcher = null;
            this.mTrafficService.close();
            this.mMap.close(false);
        } else {
            Log.d((String)LOG_TAG, (String)("onDestroy leaving the lights on for " + sActivityReference.get()));
        }
        this.mConfig.getConnectionFactory().close();
    }

    private String getServerUrl() {
        switch (this.onGetMapDataSource()) {
            case 1: {
                return "http://www.google.cn/glm/mmap/a";
            }
        }
        return "http://www.google.com/glm/mmap/a";
    }

    private void createMap() {
        this.mDataRequestDispatcher = DataRequestDispatcher.getInstance();
        if (this.mDataRequestDispatcher != null) {
            Log.w((String)LOG_TAG, (String)("Recycling dispatcher " + this.mDataRequestDispatcher));
            this.mDataRequestDispatcher.resetConnectionFactory();
        } else {
            String serverUrl = this.getServerUrl();
            String version = "1.6";
            String platformId = "android:" + SystemProperties.get((String)"ro.product.manufacturer", (String)"unknown").replace('-', '_') + "-" + SystemProperties.get((String)"ro.product.device", (String)"unknown").replace('-', '_') + "-" + SystemProperties.get((String)"ro.product.model", (String)"unknown").replace('-', '_');
            String distChannel = GoogleSettings.Partner.getString(this.getContentResolver(), "client_id", "unknown");
            distChannel = "gmm-" + distChannel;
            this.mDataRequestDispatcher = DataRequestDispatcher.createInstance(serverUrl, platformId, version, distChannel);
        }
        String signature = KeyHelper.getSignatureFingerprint(super.getPackageManager(), super.getPackageName());
        this.mDataRequestDispatcher.setAndroidSignature(signature);
        this.mDataRequestDispatcher.setApplicationName(((Object)((Object)this)).getClass().getName());
        MapPoint startPoint = null;
        Zoom zoom = null;
        int[] startingLatLng = this.getResources().getIntArray(0x1070007);
        startPoint = new MapPoint(startingLatLng[0], startingLatLng[1]);
        int[] startingZoom = this.getResources().getIntArray(17235976);
        zoom = Zoom.getZoom(startingZoom[0]);
        this.mMap = (Map)sMapReference.get();
        if (this.mMap == null) {
            this.mMap = new Map(819200, 409600, 409600, startPoint, zoom, 10);
        } else {
            Log.v((String)LOG_TAG, (String)"Recycling map object.");
        }
        sMapReference = new WeakReference<Map>(this.mMap);
        sActivityReference = new WeakReference<MapActivity>(this);
        this.mTrafficService = new TrafficService(120000);
    }

    protected abstract boolean isRouteDisplayed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLocationDisplayed() {
        List<Overlay> overlays;
        if (this.mMapView == null) {
            return false;
        }
        List<Overlay> list = overlays = this.mMapView.getOverlays();
        synchronized (list) {
            for (Overlay overlay : overlays) {
                if (!(overlay instanceof MyLocationOverlay) || !((MyLocationOverlay)overlay).isMyLocationEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    private void sendStartSession() {
        int startType = this.getIntent() != null && !"android.intent.action.MAIN".equals(this.getIntent().getAction()) ? 1 : 0;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(baos);
            dataOut.writeInt(startType);
            DataRequestDispatcher.getInstance().addSimpleRequest(16, baos.toByteArray(), false, false);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Error sending start session request", (Throwable)e);
        }
    }

    protected int onGetMapDataSource() {
        return 0;
    }
}

