/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Vector;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.harmony.xnet.provider.jsse.AlertException;
import org.apache.harmony.xnet.provider.jsse.CertificateMessage;
import org.apache.harmony.xnet.provider.jsse.CertificateRequest;
import org.apache.harmony.xnet.provider.jsse.CertificateVerify;
import org.apache.harmony.xnet.provider.jsse.ClientHello;
import org.apache.harmony.xnet.provider.jsse.ClientKeyExchange;
import org.apache.harmony.xnet.provider.jsse.Finished;
import org.apache.harmony.xnet.provider.jsse.HandshakeIODataStream;
import org.apache.harmony.xnet.provider.jsse.Message;
import org.apache.harmony.xnet.provider.jsse.PRF;
import org.apache.harmony.xnet.provider.jsse.SSLEngineImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParameters;
import org.apache.harmony.xnet.provider.jsse.SSLRecordProtocol;
import org.apache.harmony.xnet.provider.jsse.SSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.SSLv3Constants;
import org.apache.harmony.xnet.provider.jsse.ServerHello;
import org.apache.harmony.xnet.provider.jsse.ServerHelloDone;
import org.apache.harmony.xnet.provider.jsse.ServerKeyExchange;

public abstract class HandshakeProtocol {
    public static final int NEED_UNWRAP = 1;
    public static final int NOT_HANDSHAKING = 2;
    public static final int FINISHED = 3;
    public static final int NEED_TASK = 4;
    public int status = 2;
    public HandshakeIODataStream io_stream = new HandshakeIODataStream();
    public SSLRecordProtocol recordProtocol;
    public SSLParameters parameters;
    public Vector delegatedTasks = new Vector();
    public boolean nonBlocking;
    public SSLSessionImpl session;
    public ClientHello clientHello;
    public ServerHello serverHello;
    public CertificateMessage serverCert;
    public ServerKeyExchange serverKeyExchange;
    public CertificateRequest certificateRequest;
    public ServerHelloDone serverHelloDone;
    public CertificateMessage clientCert;
    public ClientKeyExchange clientKeyExchange;
    public CertificateVerify certificateVerify;
    public Finished clientFinished;
    public Finished serverFinished;
    public boolean changeCipherSpecReceived = false;
    public boolean isResuming = false;
    public byte[] preMasterSecret;
    public Exception delegatedTaskErr;
    public byte[] verify_data = new byte[12];
    public byte[] master_secret_bytes = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    public boolean needSendCCSpec = false;
    public boolean needSendHelloRequest = false;
    public SSLEngineImpl engineOwner;

    public HandshakeProtocol(Object owner) {
        if (owner instanceof SSLEngineImpl) {
            this.engineOwner = (SSLEngineImpl)owner;
            this.nonBlocking = true;
            this.parameters = this.engineOwner.sslParameters;
        }
    }

    public void setRecordProtocol(SSLRecordProtocol recordProtocol) {
        this.recordProtocol = recordProtocol;
    }

    public abstract void start();

    public void stop() {
        this.clearMessages();
        this.status = 2;
    }

    public SSLEngineResult.HandshakeStatus getStatus() {
        if (this.io_stream.hasData() || this.needSendCCSpec || this.needSendHelloRequest || this.delegatedTaskErr != null) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (!this.delegatedTasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        switch (this.status) {
            case 1: {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            case 3: {
                this.status = 2;
                this.clearMessages();
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public SSLSessionImpl getSession() {
        return this.session;
    }

    public void sendChangeCipherSpec() {
        this.needSendCCSpec = true;
    }

    public void sendHelloRequest() {
        this.needSendHelloRequest = true;
    }

    public abstract void receiveChangeCipherSpec();

    public abstract void makeFinished();

    public abstract void unwrap(byte[] var1);

    public abstract void unwrapSSLv2(byte[] var1);

    public byte[] wrap() {
        if (this.delegatedTaskErr != null) {
            Exception e = this.delegatedTaskErr;
            this.delegatedTaskErr = null;
            this.fatalAlert((byte)40, "Error occured in delegated task:" + e.getMessage(), e);
        }
        if (this.io_stream.hasData()) {
            return this.recordProtocol.wrap((byte)22, this.io_stream);
        }
        if (this.needSendCCSpec) {
            this.makeFinished();
            this.needSendCCSpec = false;
            return this.recordProtocol.getChangeCipherSpecMesage(this.getSession());
        }
        if (this.needSendHelloRequest) {
            this.needSendHelloRequest = false;
            return this.recordProtocol.wrap((byte)22, new byte[]{0, 0, 0, 0}, 0, 4);
        }
        return null;
    }

    public void sendWarningAlert(byte description) {
        this.recordProtocol.alert((byte)1, description);
    }

    public void fatalAlert(byte description, String reason) {
        throw new AlertException(description, new SSLHandshakeException(reason));
    }

    public void fatalAlert(byte description, String reason, Exception cause) {
        throw new AlertException(description, new SSLException(reason, cause));
    }

    public void fatalAlert(byte description, SSLException cause) {
        throw new AlertException(description, cause);
    }

    public void computerReferenceVerifyDataTLS(String label) {
        this.computerVerifyDataTLS(label, this.verify_data);
    }

    public void computerVerifyDataTLS(String label, byte[] buf) {
        byte[] md5_digest = this.io_stream.getDigestMD5();
        byte[] sha_digest = this.io_stream.getDigestSHA();
        byte[] digest = new byte[md5_digest.length + sha_digest.length];
        System.arraycopy(md5_digest, 0, digest, 0, md5_digest.length);
        System.arraycopy(sha_digest, 0, digest, md5_digest.length, sha_digest.length);
        try {
            PRF.computePRF(buf, this.session.master_secret, label.getBytes(), digest);
        }
        catch (GeneralSecurityException e) {
            this.fatalAlert((byte)80, "PRF error", e);
        }
    }

    public void computerReferenceVerifyDataSSLv3(byte[] sender) {
        this.verify_data = new byte[36];
        this.computerVerifyDataSSLv3(sender, this.verify_data);
    }

    public void computerVerifyDataSSLv3(byte[] sender, byte[] buf) {
        MessageDigest sha;
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            this.fatalAlert((byte)80, "Could not initialize the Digest Algorithms.", e);
            return;
        }
        try {
            byte[] hanshake_messages = this.io_stream.getMessages();
            md5.update(hanshake_messages);
            md5.update(sender);
            md5.update(this.session.master_secret);
            byte[] b = md5.digest(SSLv3Constants.MD5pad1);
            md5.update(this.session.master_secret);
            md5.update(SSLv3Constants.MD5pad2);
            System.arraycopy(md5.digest(b), 0, buf, 0, 16);
            sha.update(hanshake_messages);
            sha.update(sender);
            sha.update(this.session.master_secret);
            b = sha.digest(SSLv3Constants.SHApad1);
            sha.update(this.session.master_secret);
            sha.update(SSLv3Constants.SHApad2);
            System.arraycopy(sha.digest(b), 0, buf, 16, 20);
        }
        catch (Exception e) {
            this.fatalAlert((byte)80, "INTERNAL ERROR", e);
        }
    }

    public void verifyFinished(byte[] data) {
        if (!Arrays.equals(this.verify_data, data)) {
            this.fatalAlert((byte)40, "Incorrect FINISED");
        }
    }

    public void unexpectedMessage() {
        this.fatalAlert((byte)10, "UNEXPECTED MESSAGE");
    }

    public void send(Message message) {
        this.io_stream.writeUint8(message.getType());
        this.io_stream.writeUint24(message.length());
        message.send(this.io_stream);
    }

    public void computerMasterSecret() {
        byte[] seed = new byte[64];
        System.arraycopy(this.clientHello.getRandom(), 0, seed, 0, 32);
        System.arraycopy(this.serverHello.getRandom(), 0, seed, 32, 32);
        this.session.master_secret = new byte[48];
        if (this.serverHello.server_version[1] == 1) {
            try {
                PRF.computePRF(this.session.master_secret, this.preMasterSecret, this.master_secret_bytes, seed);
            }
            catch (GeneralSecurityException e) {
                this.fatalAlert((byte)80, "PRF error", e);
            }
        } else {
            PRF.computePRF_SSLv3(this.session.master_secret, this.preMasterSecret, seed);
        }
        Arrays.fill(this.preMasterSecret, (byte)0);
        this.preMasterSecret = null;
    }

    public Runnable getTask() {
        if (this.delegatedTasks.isEmpty()) {
            return null;
        }
        Runnable task = (Runnable)this.delegatedTasks.firstElement();
        this.delegatedTasks.remove(0);
        return task;
    }

    public void clearMessages() {
        this.io_stream.clearBuffer();
        this.clientHello = null;
        this.serverHello = null;
        this.serverCert = null;
        this.serverKeyExchange = null;
        this.certificateRequest = null;
        this.serverHelloDone = null;
        this.clientCert = null;
        this.clientKeyExchange = null;
        this.certificateVerify = null;
        this.clientFinished = null;
        this.serverFinished = null;
    }

    public static int getRSAKeyLength(PublicKey pk) throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger mod;
        if (pk instanceof RSAKey) {
            mod = ((RSAKey)((Object)pk)).getModulus();
        } else {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            mod = kf.getKeySpec(pk, RSAPublicKeySpec.class).getModulus();
        }
        return mod.bitLength();
    }

    public void shutdown() {
        this.clearMessages();
        this.session = null;
        this.preMasterSecret = null;
        this.delegatedTasks.clear();
    }
}

