/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Logger;
import org.apache.harmony.xml.ExpatParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class ExpatReader
implements XMLReader {
    public static final Logger logger = Logger.getLogger(ExpatReader.class.getName());
    public ContentHandler contentHandler;
    public EntityResolver entityResolver;
    public ErrorHandler errorHandler;
    public LexicalHandler lexicalHandler;
    public boolean processNamespaces = true;
    public boolean processNamespacePrefixes = false;
    public static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("http://xml.org/sax/features/validation")) {
            return false;
        }
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return this.processNamespaces;
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this.processNamespacePrefixes;
        }
        if (name.equals("http://xml.org/sax/features/string-interning")) {
            return true;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("http://xml.org/sax/features/validation")) {
            if (value) {
                throw new SAXNotSupportedException("Cannot enable " + name);
            }
            return;
        }
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            this.processNamespaces = value;
            return;
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.processNamespacePrefixes = value;
            return;
        }
        if (name.equals("http://xml.org/sax/features/string-interning")) {
            if (value) {
                return;
            }
            throw new SAXNotSupportedException("Cannot disable " + name);
        }
        throw new SAXNotRecognizedException(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals(LEXICAL_HANDLER_PROPERTY)) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals(LEXICAL_HANDLER_PROPERTY)) {
            if (value instanceof LexicalHandler) {
                this.lexicalHandler = (LexicalHandler)value;
                return;
            }
            throw new SAXNotSupportedException("value doesn't implement org.xml.sax.ext.LexicalHandler");
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler ignored) {
        logger.warning("DTD handlers aren't supported.");
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public boolean isNamespaceProcessingEnabled() {
        return this.processNamespaces;
    }

    public void setNamespaceProcessingEnabled(boolean processNamespaces) {
        this.processNamespaces = processNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.processNamespacePrefixes == this.processNamespaces) {
            throw new SAXNotSupportedException("The 'namespace-prefix' feature is not supported while the 'namespaces' feature is enabled.");
        }
        Reader reader = input.getCharacterStream();
        if (reader != null) {
            try {
                this.parse(reader, input.getPublicId(), input.getSystemId());
            }
            finally {
                reader.close();
            }
            return;
        }
        InputStream in = input.getByteStream();
        String encoding = input.getEncoding();
        if (in != null) {
            try {
                this.parse(in, encoding, input.getPublicId(), input.getSystemId());
            }
            finally {
                in.close();
            }
            return;
        }
        String systemId = input.getSystemId();
        if (systemId == null) {
            throw new SAXException("No input specified.");
        }
        in = ExpatParser.openUrl(systemId);
        try {
            this.parse(in, encoding, input.getPublicId(), systemId);
        }
        finally {
            in.close();
        }
    }

    public void parse(Reader in, String publicId, String systemId) throws IOException, SAXException {
        ExpatParser parser = new ExpatParser("UTF-16", this, this.processNamespaces, publicId, systemId);
        parser.parseDocument(in);
    }

    public void parse(InputStream in, String encoding, String publicId, String systemId) throws IOException, SAXException {
        ExpatParser parser = new ExpatParser(encoding, this, this.processNamespaces, publicId, systemId);
        parser.parseDocument(in);
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public static class Feature {
        public static final String BASE_URI = "http://xml.org/sax/features/";
        public static final String VALIDATION = "http://xml.org/sax/features/validation";
        public static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
        public static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
        public static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    }
}

