/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import com.android.layoutlib.api.ILayoutResult;
import java.awt.image.BufferedImage;

public final class LayoutResult
implements ILayoutResult {
    private final ILayoutResult.ILayoutViewInfo mRootView;
    private final BufferedImage mImage;
    private final int mSuccess;
    private final String mErrorMessage;

    public LayoutResult(ILayoutResult.ILayoutViewInfo rootView, BufferedImage image) {
        this.mSuccess = 0;
        this.mErrorMessage = null;
        this.mRootView = rootView;
        this.mImage = image;
    }

    public LayoutResult(int code, String message) {
        this.mSuccess = code;
        this.mErrorMessage = message;
        this.mRootView = null;
        this.mImage = null;
    }

    public int getSuccess() {
        return this.mSuccess;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public ILayoutResult.ILayoutViewInfo getRootView() {
        return this.mRootView;
    }

    public static final class LayoutViewInfo
    implements ILayoutResult.ILayoutViewInfo {
        private final Object mKey;
        private final String mName;
        private final int mLeft;
        private final int mRight;
        private final int mTop;
        private final int mBottom;
        private ILayoutResult.ILayoutViewInfo[] mChildren;

        public LayoutViewInfo(String name, Object key, int left, int top, int right, int bottom) {
            this.mName = name;
            this.mKey = key;
            this.mLeft = left;
            this.mRight = right;
            this.mTop = top;
            this.mBottom = bottom;
        }

        public void setChildren(ILayoutResult.ILayoutViewInfo[] children) {
            this.mChildren = children;
        }

        public ILayoutResult.ILayoutViewInfo[] getChildren() {
            return this.mChildren;
        }

        public Object getViewKey() {
            return this.mKey;
        }

        public String getName() {
            return this.mName;
        }

        public int getLeft() {
            return this.mLeft;
        }

        public int getTop() {
            return this.mTop;
        }

        public int getRight() {
            return this.mRight;
        }

        public int getBottom() {
            return this.mBottom;
        }
    }
}

