/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.api.IStyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.BridgeContext;
import com.android.layoutlib.bridge.BridgeResources;
import com.android.layoutlib.bridge.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.ResourceHelper;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;

public final class BridgeTypedArray
extends TypedArray {
    private BridgeResources mResources;
    private BridgeContext mContext;
    private IResourceValue[] mData;
    private String[] mNames;
    private final boolean mPlatformFile;

    public BridgeTypedArray(BridgeResources resources, BridgeContext context, int len, boolean platformFile) {
        super(null, null, null, 0);
        this.mResources = resources;
        this.mContext = context;
        this.mPlatformFile = platformFile;
        this.mData = new IResourceValue[len];
        this.mNames = new String[len];
    }

    public void bridgeSetValue(int index, String name, IResourceValue value) {
        this.mData[index] = value;
        this.mNames[index] = name;
    }

    public void sealArray() {
        int count = 0;
        for (IResourceValue data : this.mData) {
            if (data == null) continue;
            ++count;
        }
        this.mIndices = new int[count + 1];
        this.mIndices[0] = count;
        int index = 1;
        for (int i = 0; i < this.mData.length; ++i) {
            if (this.mData[i] == null) continue;
            this.mIndices[index++] = i;
        }
    }

    public int length() {
        return this.mData.length;
    }

    public Resources getResources() {
        return this.mResources;
    }

    public CharSequence getText(int index) {
        if (this.mData[index] != null) {
            return this.mData[index].getValue();
        }
        return null;
    }

    public String getString(int index) {
        if (this.mData[index] != null) {
            return this.mData[index].getValue();
        }
        return null;
    }

    public boolean getBoolean(int index, boolean defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String s = this.mData[index].getValue();
        if (s != null) {
            return XmlUtils.convertValueToBoolean(s, defValue);
        }
        return defValue;
    }

    public int getInt(int index, int defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String s = this.mData[index].getValue();
        try {
            return s == null ? defValue : XmlUtils.convertValueToInt(s, defValue);
        }
        catch (NumberFormatException e) {
            Map<String, Integer> map = Bridge.getEnumValues(this.mNames[index]);
            if (map != null) {
                String[] keywords;
                int result = 0;
                for (String keyword : keywords = s.split("\\|")) {
                    Integer i = map.get(keyword.trim());
                    if (i != null) {
                        result |= i.intValue();
                        continue;
                    }
                    this.mContext.getLogger().warning(String.format("Unknown constant \"%s\" in attribute \"%2$s\"", keyword, this.mNames[index]));
                }
                return result;
            }
            return defValue;
        }
    }

    public float getFloat(int index, float defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String s = this.mData[index].getValue();
        if (s != null) {
            try {
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                this.mContext.getLogger().warning(String.format("Unable to convert \"%s\" into a float in attribute \"%2$s\"", s, this.mNames[index]));
            }
        }
        return defValue;
    }

    public int getColor(int index, int defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String s = this.mData[index].getValue();
        try {
            return ResourceHelper.getColor(s);
        }
        catch (NumberFormatException e) {
            this.mContext.getLogger().warning(String.format("Unable to convert \"%s\" into a color in attribute \"%2$s\"", s, this.mNames[index]));
            return defValue;
        }
    }

    public ColorStateList getColorStateList(int index) {
        if (this.mData[index] == null) {
            return null;
        }
        String value = this.mData[index].getValue();
        if (value == null) {
            return null;
        }
        try {
            int color2 = ResourceHelper.getColor(value);
            return ColorStateList.valueOf(color2);
        }
        catch (NumberFormatException e) {
            try {
                File f = new File(value);
                if (f.isFile()) {
                    KXmlParser parser = new KXmlParser();
                    parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    parser.setInput((Reader)new FileReader(f));
                    ColorStateList colorStateList = ColorStateList.createFromXml(this.mContext.getResources(), new BridgeXmlBlockParser((XmlPullParser)parser, this.mContext, false));
                    return colorStateList;
                }
            }
            catch (Exception e2) {
                this.mContext.getLogger().error((Throwable)e2);
            }
            this.mContext.getLogger().warning(String.format("Unable to resolve color value \"%1$s\" in attribute \"%2$s\"", value, this.mNames[index]));
            return null;
        }
    }

    public int getInteger(int index, int defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String s = this.mData[index].getValue();
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.mContext.getLogger().warning(String.format("Unable to convert \"%s\" into a integer in attribute \"%2$s\"", s, this.mNames[index]));
            }
        }
        return defValue;
    }

    public float getDimension(int index, float defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String s = this.mData[index].getValue();
        if (s == null) {
            return defValue;
        }
        if (s.equals("fill_parent")) {
            return -1.0f;
        }
        if (s.equals("wrap_content")) {
            return -2.0f;
        }
        if (ResourceHelper.stringToFloat(s, this.mValue)) {
            return this.mValue.getDimension(this.mResources.mMetrics);
        }
        this.mContext.getLogger().warning(String.format("Unable to resolve dimension value \"%1$s\" in attribute \"%2$s\"", s, this.mNames[index]));
        return defValue;
    }

    public int getDimensionPixelOffset(int index, int defValue) {
        return (int)this.getDimension(index, defValue);
    }

    public int getDimensionPixelSize(int index, int defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String s = this.mData[index].getValue();
        if (s == null) {
            return defValue;
        }
        if (s.equals("fill_parent")) {
            return -1;
        }
        if (s.equals("wrap_content")) {
            return -2;
        }
        float f = this.getDimension(index, defValue);
        int res = (int)(f + 0.5f);
        if (res != 0) {
            return res;
        }
        if (f == 0.0f) {
            return 0;
        }
        if (f > 0.0f) {
            return 1;
        }
        throw new UnsupportedOperationException("Can't convert to dimension: " + Integer.toString(index));
    }

    public int getLayoutDimension(int index, String name) {
        return this.getDimensionPixelSize(index, 0);
    }

    public int getLayoutDimension(int index, int defValue) {
        return this.getDimensionPixelSize(index, defValue);
    }

    public float getFraction(int index, int base, int pbase, float defValue) {
        if (this.mData[index] == null) {
            return defValue;
        }
        String value = this.mData[index].getValue();
        if (value == null) {
            return defValue;
        }
        if (ResourceHelper.stringToFloat(value, this.mValue)) {
            return this.mValue.getFraction(base, pbase);
        }
        this.mContext.getLogger().warning(String.format("Unable to resolve fraction value \"%1$s\" in attribute \"%2$s\"", value, this.mNames[index]));
        return defValue;
    }

    public int getResourceId(int index, int defValue) {
        IResourceValue resValue = this.mData[index];
        if (resValue == null) {
            return defValue;
        }
        if (resValue instanceof IStyleResourceValue) {
            return this.mContext.getDynamicIdByStyle((IStyleResourceValue)resValue);
        }
        if (resValue.getType() != null && resValue.getType().equals("id")) {
            if (this.mPlatformFile || resValue.isFramework()) {
                return this.mContext.getFrameworkIdValue(resValue.getName(), defValue);
            }
            return this.mContext.getProjectIdValue(resValue.getName(), defValue);
        }
        String value = resValue.getValue();
        if (value == null) {
            return defValue;
        }
        try {
            int i = Integer.parseInt(value);
            if (Integer.toString(i).equals(value)) {
                return i;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (value.startsWith("@id/") || value.startsWith("@+") || value.startsWith("@android:id/")) {
            int pos = value.indexOf(47);
            String idName = value.substring(pos + 1);
            if (this.mPlatformFile || value.startsWith("@android") || value.startsWith("@+android")) {
                return this.mContext.getFrameworkIdValue(idName, defValue);
            }
            return this.mContext.getProjectIdValue(idName, defValue);
        }
        Integer idValue = null;
        idValue = resValue.isFramework() ? Bridge.getResourceValue(resValue.getType(), resValue.getName()) : this.mContext.getProjectCallback().getResourceValue(resValue.getType(), resValue.getName());
        if (idValue != null) {
            return idValue;
        }
        this.mContext.getLogger().warning(String.format("Unable to resolve id \"%1$s\" for attribute \"%2$s\"", value, this.mNames[index]));
        return defValue;
    }

    public Drawable getDrawable(int index) {
        if (this.mData[index] == null) {
            return null;
        }
        String value = this.mData[index].getValue();
        if (value == null || "@null".equals(value)) {
            return null;
        }
        Drawable d = ResourceHelper.getDrawable(value, this.mContext, this.mData[index].isFramework());
        if (d != null) {
            return d;
        }
        this.mContext.getLogger().warning(String.format("Unable to resolve drawable \"%1$s\" in attribute \"%2$s\"", value, this.mNames[index]));
        return null;
    }

    public CharSequence[] getTextArray(int index) {
        if (this.mData[index] == null) {
            return null;
        }
        String value = this.mData[index].getValue();
        if (value != null) {
            return new CharSequence[]{value};
        }
        this.mContext.getLogger().warning(String.format(String.format("Unknown value for getTextArray(%d) => %s", index, this.mData[index].getName()), new Object[0]));
        return null;
    }

    public boolean getValue(int index, TypedValue outValue) {
        if (this.mData[index] == null) {
            return false;
        }
        String s = this.mData[index].getValue();
        return ResourceHelper.stringToFloat(s, outValue);
    }

    public boolean hasValue(int index) {
        return this.mData[index] != null;
    }

    public TypedValue peekValue(int index) {
        if (this.getValue(index, this.mValue)) {
            return this.mValue;
        }
        return null;
    }

    public String getPositionDescription() {
        return "<internal -- stub if needed>";
    }

    public void recycle() {
    }

    public boolean getValueAt(int index, TypedValue outValue) {
        return false;
    }

    public String toString() {
        return this.mData.toString();
    }
}

