/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.layoutlib.api.IProjectCallback;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.BridgeContext;
import com.android.layoutlib.bridge.BridgeTypedArray;
import com.android.layoutlib.bridge.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.ResourceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class BridgeResources
extends Resources {
    private BridgeContext mContext;
    private IProjectCallback mProjectCallback;
    private boolean[] mPlatformResourceFlag = new boolean[1];

    static Resources initSystem(BridgeContext context, AssetManager assets, DisplayMetrics metrics, Configuration config, IProjectCallback projectCallback) {
        if (!(Resources.mSystem instanceof BridgeResources)) {
            Resources.mSystem = new BridgeResources(context, assets, metrics, config, projectCallback);
        }
        return Resources.mSystem;
    }

    static void clearSystem() {
        if (Resources.mSystem instanceof BridgeResources) {
            ((BridgeResources)Resources.mSystem).mContext = null;
            ((BridgeResources)Resources.mSystem).mProjectCallback = null;
        }
        Resources.mSystem = null;
    }

    private BridgeResources(BridgeContext context, AssetManager assets, DisplayMetrics metrics, Configuration config, IProjectCallback projectCallback) {
        super(assets, metrics, config);
        this.mContext = context;
        this.mProjectCallback = projectCallback;
    }

    public BridgeTypedArray newTypeArray(int numEntries, boolean platformFile) {
        return new BridgeTypedArray(this, this.mContext, numEntries, platformFile);
    }

    private IResourceValue getResourceValue(int id2, boolean[] platformResFlag_out) {
        String[] resourceInfo = Bridge.resolveResourceValue(id2);
        if (resourceInfo != null) {
            platformResFlag_out[0] = true;
            return this.mContext.getFrameworkResource(resourceInfo[1], resourceInfo[0]);
        }
        if (this.mProjectCallback != null && (resourceInfo = this.mProjectCallback.resolveResourceValue(id2)) != null) {
            platformResFlag_out[0] = false;
            return this.mContext.getProjectResource(resourceInfo[1], resourceInfo[0]);
        }
        return null;
    }

    public Drawable getDrawable(int id2) throws Resources.NotFoundException {
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            return ResourceHelper.getDrawable(value.getValue(), this.mContext, value.isFramework());
        }
        this.throwException(id2);
        return null;
    }

    public int getColor(int id2) throws Resources.NotFoundException {
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            try {
                return ResourceHelper.getColor(value.getValue());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        this.throwException(id2);
        return 0;
    }

    public ColorStateList getColorStateList(int id2) throws Resources.NotFoundException {
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            try {
                int color2 = ResourceHelper.getColor(value.getValue());
                return ColorStateList.valueOf(color2);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        this.throwException(id2);
        return null;
    }

    public CharSequence getText(int id2) throws Resources.NotFoundException {
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null) {
            return value.getValue();
        }
        this.throwException(id2);
        return null;
    }

    public XmlResourceParser getLayout(int id2) throws Resources.NotFoundException {
        File xml2;
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (xml2 = new File(value.getValue())).isFile()) {
            try {
                KXmlParser parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((Reader)new FileReader(xml2));
                return new BridgeXmlBlockParser((XmlPullParser)parser, this.mContext, this.mPlatformResourceFlag[0]);
            }
            catch (XmlPullParserException e) {
                this.mContext.getLogger().error((Throwable)e);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        this.throwException(id2);
        return null;
    }

    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        return this.mContext.obtainStyledAttributes(set, attrs);
    }

    public TypedArray obtainTypedArray(int id2) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    public float getDimension(int id2) throws Resources.NotFoundException {
        String v;
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = value.getValue()) != null) {
            if (v.equals("fill_parent")) {
                return -1.0f;
            }
            if (v.equals("wrap_content")) {
                return -2.0f;
            }
            if (ResourceHelper.stringToFloat(v, this.mTmpValue) && this.mTmpValue.type == 5) {
                return this.mTmpValue.getDimension(this.mMetrics);
            }
        }
        this.throwException(id2);
        return 0.0f;
    }

    public int getDimensionPixelOffset(int id2) throws Resources.NotFoundException {
        String v;
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = value.getValue()) != null && ResourceHelper.stringToFloat(v, this.mTmpValue) && this.mTmpValue.type == 5) {
            return TypedValue.complexToDimensionPixelOffset(this.mTmpValue.data, this.mMetrics);
        }
        this.throwException(id2);
        return 0;
    }

    public int getDimensionPixelSize(int id2) throws Resources.NotFoundException {
        String v;
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = value.getValue()) != null && ResourceHelper.stringToFloat(v, this.mTmpValue) && this.mTmpValue.type == 5) {
            return TypedValue.complexToDimensionPixelSize(this.mTmpValue.data, this.mMetrics);
        }
        this.throwException(id2);
        return 0;
    }

    public int getInteger(int id2) throws Resources.NotFoundException {
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && value.getValue() != null) {
            String v = value.getValue();
            int radix = 10;
            if (v.startsWith("0x")) {
                v = v.substring(2);
                radix = 16;
            }
            try {
                return Integer.parseInt(v, radix);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.throwException(id2);
        return 0;
    }

    public String getResourceEntryName(int resid) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    public String getResourceName(int resid) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    public String getResourceTypeName(int resid) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    public String getString(int id2, Object ... formatArgs) throws Resources.NotFoundException {
        String s = this.getString(id2);
        if (s != null) {
            return String.format(s, formatArgs);
        }
        this.throwException(id2);
        return null;
    }

    public String getString(int id2) throws Resources.NotFoundException {
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && value.getValue() != null) {
            return value.getValue();
        }
        this.throwException(id2);
        return null;
    }

    public void getValue(int id2, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        String v;
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = value.getValue()) != null) {
            if (ResourceHelper.stringToFloat(v, outValue)) {
                return;
            }
            outValue.type = 3;
            outValue.string = v;
            return;
        }
        this.throwException(id2);
    }

    public void getValue(String name, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    public XmlResourceParser getXml(int id2) throws Resources.NotFoundException {
        File f;
        String v;
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = value.getValue()) != null && (f = new File(value.getValue())).isFile()) {
            try {
                KXmlParser parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((Reader)new FileReader(f));
                return new BridgeXmlBlockParser((XmlPullParser)parser, this.mContext, this.mPlatformResourceFlag[0]);
            }
            catch (XmlPullParserException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
        }
        this.throwException(id2);
        return null;
    }

    public XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        this.getResourceValue(id2, this.mPlatformResourceFlag);
        File f = new File(file);
        try {
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)new FileReader(f));
            return new BridgeXmlBlockParser((XmlPullParser)parser, this.mContext, this.mPlatformResourceFlag[0]);
        }
        catch (XmlPullParserException e) {
            Resources.NotFoundException newE = new Resources.NotFoundException();
            newE.initCause(e);
            throw newE;
        }
        catch (FileNotFoundException e) {
            Resources.NotFoundException newE = new Resources.NotFoundException();
            newE.initCause(e);
            throw newE;
        }
    }

    public InputStream openRawResource(int id2) throws Resources.NotFoundException {
        File f;
        String v;
        IResourceValue value = this.getResourceValue(id2, this.mPlatformResourceFlag);
        if (value != null && (v = value.getValue()) != null && (f = new File(value.getValue())).isFile()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
        }
        this.throwException(id2);
        return null;
    }

    public InputStream openRawResource(int id2, TypedValue value) throws Resources.NotFoundException {
        this.getValue(id2, value, true);
        File f = new File(((Object)value.string).toString());
        if (f.isFile()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException exception = new Resources.NotFoundException();
                exception.initCause(e);
                throw exception;
            }
        }
        throw new Resources.NotFoundException();
    }

    public AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    private void throwException(int id2) throws Resources.NotFoundException {
        String[] resourceInfo = Bridge.resolveResourceValue(id2);
        if (resourceInfo == null && this.mProjectCallback != null) {
            resourceInfo = this.mProjectCallback.resolveResourceValue(id2);
        }
        String message = null;
        message = resourceInfo != null ? String.format("Could not find %1$s resource matching value 0x%2$X (resolved name: %3$s) in current configuration.", resourceInfo[1], id2, resourceInfo[0]) : String.format("Could not resolve resource value: 0x%1$X.", id2);
        throw new Resources.NotFoundException(message);
    }
}

