/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.INetStatService;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Checkin;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.PdpConnection;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsmDataConnectionTracker
extends DataConnectionTracker {
    public static final String LOG_TAG = "GSM";
    public static final boolean DBG = true;
    public GSMPhone mGsmPhone;
    public INetStatService netstat;
    public boolean noAutoAttach = false;
    public long nextReconnectDelay = 5000L;
    public boolean mReregisterOnReconnectFailure = false;
    public ContentResolver mResolver;
    public boolean mPingTestActive = false;
    public int mPdpResetCount = 0;
    public boolean mIsScreenOn = true;
    public boolean failNextConnect = false;
    public ArrayList<ApnSetting> allApns = null;
    public ArrayList<ApnSetting> waitingApns = null;
    public ApnSetting preferredApn = null;
    public ArrayList<DataConnection> pdpList;
    public String mRequestedApnType = "default";
    public ApnSetting mActiveApn;
    public PdpConnection mActivePdp;
    public static int APN_DEFAULT_ID = 0;
    public static int APN_MMS_ID = 1;
    public static int APN_SUPL_ID = 2;
    public static int APN_NUM_TYPES = 3;
    public boolean[] dataEnabled = new boolean[APN_NUM_TYPES];
    public boolean mIsPsRestricted = false;
    public static final int PDP_CONNECTION_POOL_SIZE = 1;
    public static final int POLL_PDP_MILLIS = 5000;
    public static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.gprs-reconnect";
    public static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    public static final Uri PREFERAPN_URI = Uri.parse("content://telephony/carriers/preferapn");
    public static final String APN_ID = "apn_id";
    public boolean canSetPreferApn = false;
    public BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                GsmDataConnectionTracker.this.mIsScreenOn = true;
                GsmDataConnectionTracker.this.stopNetStatPoll();
                GsmDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                GsmDataConnectionTracker.this.mIsScreenOn = false;
                GsmDataConnectionTracker.this.stopNetStatPoll();
                GsmDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                Log.d(GsmDataConnectionTracker.LOG_TAG, "GPRS reconnect alarm. Previous state was " + (Object)((Object)GsmDataConnectionTracker.this.state));
                String reason = intent.getStringExtra(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                if (GsmDataConnectionTracker.this.state == DataConnectionTracker.State.FAILED) {
                    Message msg = GsmDataConnectionTracker.this.obtainMessage(34);
                    msg.arg1 = 0;
                    msg.obj = reason;
                    GsmDataConnectionTracker.this.sendMessage(msg);
                }
                GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(5));
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                GsmDataConnectionTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    GsmDataConnectionTracker.this.mIsWifiConnected = false;
                }
            }
        }
    };
    public ApnChangeObserver apnObserver;
    public Runnable mPollNetStat = new Runnable(){

        public void run() {
            long preTxPkts = -1L;
            long preRxPkts = -1L;
            preTxPkts = GsmDataConnectionTracker.this.txPkts;
            preRxPkts = GsmDataConnectionTracker.this.rxPkts;
            try {
                GsmDataConnectionTracker.this.txPkts = GsmDataConnectionTracker.this.netstat.getMobileTxPackets();
                GsmDataConnectionTracker.this.rxPkts = GsmDataConnectionTracker.this.netstat.getMobileRxPackets();
            }
            catch (RemoteException e) {
                GsmDataConnectionTracker.this.txPkts = 0L;
                GsmDataConnectionTracker.this.rxPkts = 0L;
            }
            if (GsmDataConnectionTracker.this.netStatPollEnabled && (preTxPkts > 0L || preRxPkts > 0L)) {
                DataConnectionTracker.Activity newActivity;
                long sent = GsmDataConnectionTracker.this.txPkts - preTxPkts;
                long received = GsmDataConnectionTracker.this.rxPkts - preRxPkts;
                if (sent > 0L && received > 0L) {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAINANDOUT;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent > 0L && received == 0L) {
                    if (GsmDataConnectionTracker.this.phone.getState() == Phone.State.IDLE) {
                        GsmDataConnectionTracker.this.sentSinceLastRecv += sent;
                    } else {
                        GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    }
                    newActivity = DataConnectionTracker.Activity.DATAOUT;
                } else if (sent == 0L && received > 0L) {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAIN;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent == 0L && received == 0L) {
                    newActivity = DataConnectionTracker.Activity.NONE;
                } else {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.NONE;
                }
                if (GsmDataConnectionTracker.this.activity != newActivity && GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.activity = newActivity;
                    GsmDataConnectionTracker.this.phone.notifyDataActivity();
                }
            }
            int watchdogTrigger = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
            if (GsmDataConnectionTracker.this.sentSinceLastRecv >= (long)watchdogTrigger) {
                if (GsmDataConnectionTracker.this.mNoRecvPollCount == 0) {
                    EventLog.writeEvent(50101, GsmDataConnectionTracker.this.sentSinceLastRecv);
                }
                int noRecvPollLimit = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_count", 24);
                if (GsmDataConnectionTracker.this.mNoRecvPollCount < noRecvPollLimit) {
                    GsmDataConnectionTracker.this.log("no DATAIN in a while; polling PDP");
                    ((GsmDataConnectionTracker)GsmDataConnectionTracker.this).phone.mCM.getDataCallList(GsmDataConnectionTracker.this.obtainMessage(11));
                    GsmDataConnectionTracker.this.mNoRecvPollCount++;
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_interval_ms", 5000);
                } else {
                    GsmDataConnectionTracker.this.log("Sent " + String.valueOf(GsmDataConnectionTracker.this.sentSinceLastRecv) + " pkts since last received");
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    Thread pingTest = new Thread(){

                        public void run() {
                            GsmDataConnectionTracker.this.runPingTest();
                        }
                    };
                    GsmDataConnectionTracker.this.mPingTestActive = true;
                    pingTest.start();
                }
            } else {
                GsmDataConnectionTracker.this.mNoRecvPollCount = 0;
                if (GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000);
                } else {
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
                }
            }
            if (GsmDataConnectionTracker.this.netStatPollEnabled) {
                GsmDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, GsmDataConnectionTracker.this.netStatPollPeriod);
            }
        }
    };

    public GsmDataConnectionTracker(GSMPhone p) {
        super(p);
        this.mGsmPhone = p;
        p.mCM.registerForAvailable(this, 3, null);
        p.mCM.registerForOffOrNotAvailable(this, 12, null);
        p.mSIMRecords.registerForRecordsLoaded(this, 4, null);
        p.mCM.registerForDataStateChanged(this, 6, null);
        p.mCT.registerForVoiceCallEnded(this, 15, null);
        p.mCT.registerForVoiceCallStarted(this, 14, null);
        p.mSST.registerForGprsAttached(this, 26, null);
        p.mSST.registerForGprsDetached(this, 19, null);
        p.mSST.registerForRoamingOn(this, 21, null);
        p.mSST.registerForRoamingOff(this, 22, null);
        p.mSST.registerForPsRestrictedEnabled(this, 32, null);
        p.mSST.registerForPsRestrictedDisabled(this, 33, null);
        this.netstat = INetStatService.Stub.asInterface(ServiceManager.getService("netstat"));
        IntentFilter filter = new IntentFilter();
        filter.addAction(INTENT_RECONNECT_ALARM);
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        p.getContext().registerReceiver(this.mIntentReceiver, filter, null, p.h);
        this.mDataConnectionTracker = this;
        this.mResolver = this.phone.getContext().getContentResolver();
        this.apnObserver = new ApnChangeObserver();
        p.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.apnObserver);
        this.createAllPdpList();
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        this.dataEnabled[GsmDataConnectionTracker.APN_DEFAULT_ID] = !sp.getBoolean("disabled_on_boot_key", false);
        this.noAutoAttach = !this.dataEnabled[APN_DEFAULT_ID];
    }

    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mGsmPhone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mGsmPhone.mSST.unregisterForGprsAttached(this);
        this.mGsmPhone.mSST.unregisterForGprsDetached(this);
        this.mGsmPhone.mSST.unregisterForRoamingOn(this);
        this.mGsmPhone.mSST.unregisterForRoamingOff(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedEnabled(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedDisabled(this);
        this.phone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.phone.getContext().getContentResolver().unregisterContentObserver(this.apnObserver);
        this.destroyAllPdpList();
    }

    public void finalize() {
        Log.d(LOG_TAG, "GsmDataConnectionTracker finalized");
    }

    public void setState(DataConnectionTracker.State s) {
        this.log("setState: " + (Object)((Object)s));
        if (this.state != s) {
            if (s == DataConnectionTracker.State.INITING) {
                Checkin.updateStats(this.phone.getContext().getContentResolver(), Checkin.Stats.Tag.PHONE_GPRS_ATTEMPTED, 1, 0.0);
            }
            if (s == DataConnectionTracker.State.CONNECTED) {
                Checkin.updateStats(this.phone.getContext().getContentResolver(), Checkin.Stats.Tag.PHONE_GPRS_CONNECTED, 1, 0.0);
            }
        }
        this.state = s;
        if (this.state == DataConnectionTracker.State.FAILED && this.waitingApns != null) {
            this.waitingApns.clear();
        }
    }

    public String[] getActiveApnTypes() {
        String[] result = this.mActiveApn != null ? this.mActiveApn.types : new String[]{"default"};
        return result;
    }

    public String getActiveApnString() {
        String result = null;
        if (this.mActiveApn != null) {
            result = this.mActiveApn.apn;
        }
        return result;
    }

    public int enableApnType(String type) {
        if (!TextUtils.equals(type, "mms") && !TextUtils.equals(type, "supl")) {
            return 3;
        }
        Log.d(LOG_TAG, "enableApnType(" + type + ")");
        if (this.isApnTypeActive(type)) {
            this.setEnabled(type, true);
            this.removeMessages(24);
            this.sendMessageDelayed(this.obtainMessage(24), this.getRestoreDefaultApnDelay());
            if (this.state == DataConnectionTracker.State.INITING) {
                return 1;
            }
            if (this.state == DataConnectionTracker.State.CONNECTED) {
                return 0;
            }
        }
        if (!this.isApnTypeAvailable(type)) {
            return 2;
        }
        this.setEnabled(type, true);
        this.mRequestedApnType = type;
        this.sendMessage(this.obtainMessage(23));
        return 1;
    }

    public int disableApnType(String type) {
        Log.d(LOG_TAG, "disableApnType(" + type + ")");
        if ((TextUtils.equals(type, "mms") || TextUtils.equals(type, "supl")) && this.isEnabled(type)) {
            this.removeMessages(24);
            this.setEnabled(type, false);
            if (this.isApnTypeActive("default")) {
                this.mRequestedApnType = "default";
                if (this.dataEnabled[APN_DEFAULT_ID]) {
                    return 0;
                }
                Message msg = this.obtainMessage(34);
                msg.arg1 = 1;
                msg.obj = "dataDisabled";
                this.sendMessage(msg);
                return 1;
            }
            this.sendMessage(this.obtainMessage(24));
            return 1;
        }
        return 3;
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean roaming = this.getDataRoaming();
        if (!(!this.mGsmPhone.mSIMRecords.getRecordsLoaded() || this.mGsmPhone.mSST.getCurrentGprsState() != 0 || roaming && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected || this.mIsPsRestricted)) {
            return this.state == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    public boolean getDataRoaming() {
        return this.mGsmPhone.mSST.getDataRoaming();
    }

    public boolean isApnTypeActive(String type) {
        return this.mActiveApn != null && this.mActiveApn.canHandleType(type);
    }

    public boolean isApnTypeAvailable(String type) {
        if (this.allApns != null) {
            for (ApnSetting apn : this.allApns) {
                if (!apn.canHandleType(type)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled(String apnType) {
        if (TextUtils.equals(apnType, "default")) {
            return this.dataEnabled[APN_DEFAULT_ID];
        }
        if (TextUtils.equals(apnType, "mms")) {
            return this.dataEnabled[APN_MMS_ID];
        }
        if (TextUtils.equals(apnType, "supl")) {
            return this.dataEnabled[APN_SUPL_ID];
        }
        return false;
    }

    public void setEnabled(String apnType, boolean enable) {
        Log.d(LOG_TAG, "setEnabled(" + apnType + ", " + enable + ')');
        if (TextUtils.equals(apnType, "default")) {
            this.dataEnabled[GsmDataConnectionTracker.APN_DEFAULT_ID] = enable;
        } else if (TextUtils.equals(apnType, "mms")) {
            this.dataEnabled[GsmDataConnectionTracker.APN_MMS_ID] = enable;
        } else if (TextUtils.equals(apnType, "supl")) {
            this.dataEnabled[GsmDataConnectionTracker.APN_SUPL_ID] = enable;
        }
        Log.d(LOG_TAG, "dataEnabled[DEFAULT_APN]=" + this.dataEnabled[APN_DEFAULT_ID] + " dataEnabled[MMS_APN]=" + this.dataEnabled[APN_MMS_ID] + " dataEnabled[SUPL_APN]=" + this.dataEnabled[APN_SUPL_ID]);
    }

    @Override
    public boolean setDataEnabled(boolean enable) {
        boolean isEnabled = this.isEnabled("default");
        Log.d(LOG_TAG, "setDataEnabled(" + enable + ") isEnabled=" + isEnabled);
        if (!isEnabled && enable) {
            this.setEnabled("default", true);
            this.sendMessage(this.obtainMessage(5));
            return true;
        }
        if (!enable) {
            this.setEnabled("default", false);
            if (this.isApnTypeActive("mms") && this.isEnabled("mms") || this.isApnTypeActive("supl") && this.isEnabled("supl")) {
                return false;
            }
            Message msg = this.obtainMessage(34);
            msg.arg1 = 1;
            msg.obj = "dataDisabled";
            this.sendMessage(msg);
            return true;
        }
        return true;
    }

    @Override
    public boolean getDataEnabled() {
        return this.dataEnabled[APN_DEFAULT_ID];
    }

    @Override
    public boolean getAnyDataEnabled() {
        return this.dataEnabled[APN_DEFAULT_ID] || this.dataEnabled[APN_MMS_ID] || this.dataEnabled[APN_SUPL_ID];
    }

    public ArrayList<DataConnection> getAllDataConnections() {
        ArrayList pdps = (ArrayList)this.pdpList.clone();
        return pdps;
    }

    public boolean isDataAllowed() {
        boolean roaming = this.getDataRoaming();
        return this.getAnyDataEnabled() && (!roaming || this.getDataOnRoamingEnabled());
    }

    public void onGprsDetached() {
        this.stopNetStatPoll();
        this.phone.notifyDataConnection("gprsDetached");
    }

    public void onGprsAttached() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("gprsAttached");
        } else {
            if (this.state == DataConnectionTracker.State.FAILED) {
                this.cleanUpConnection(false, "gprsAttached");
                this.nextReconnectDelay = 5000L;
            }
            this.trySetupData("gprsAttached");
        }
    }

    public boolean trySetupData(String reason) {
        this.log("***trySetupData due to " + (reason == null ? "(unspecified)" : reason));
        Log.d(LOG_TAG, "[DSAC DEB] trySetupData with mIsPsRestricted=" + this.mIsPsRestricted);
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(reason);
            Log.i(LOG_TAG, "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int gprsState = this.mGsmPhone.mSST.getCurrentGprsState();
        boolean roaming = this.getDataRoaming();
        boolean desiredPowerState = this.mGsmPhone.mSST.getDesiredPowerState();
        if ((this.state == DataConnectionTracker.State.IDLE || this.state == DataConnectionTracker.State.SCANNING) && (gprsState == 0 || this.noAutoAttach) && this.mGsmPhone.mSIMRecords.getRecordsLoaded() && this.phone.getState() == Phone.State.IDLE && this.isDataAllowed() && !this.mIsPsRestricted && desiredPowerState) {
            if (this.state == DataConnectionTracker.State.IDLE) {
                this.waitingApns = this.buildWaitingApns();
                if (this.waitingApns.isEmpty()) {
                    this.log("No APN found");
                    this.notifyNoData(DataConnection.FailCause.MISSING_UKNOWN_APN);
                    return false;
                }
                this.log("Create from allApns : " + this.apnListToString(this.allApns));
            }
            this.log("Setup watingApns : " + this.apnListToString(this.waitingApns));
            return this.setupData(reason);
        }
        this.log("trySetupData: Not ready for data:  dataState=" + (Object)((Object)this.state) + " gprsState=" + gprsState + " sim=" + this.mGsmPhone.mSIMRecords.getRecordsLoaded() + " UMTS=" + this.mGsmPhone.mSST.isConcurrentVoiceAndData() + " phoneState=" + (Object)((Object)this.phone.getState()) + " dataEnabled=" + this.getAnyDataEnabled() + " roaming=" + roaming + " dataOnRoamingEnable=" + this.getDataOnRoamingEnabled() + " ps restricted=" + this.mIsPsRestricted + " desiredPowerState=" + desiredPowerState);
        return false;
    }

    public void cleanUpConnection(boolean tearDown, String reason) {
        this.log("Clean up connection due to " + reason);
        if (this.mReconnectIntent != null) {
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            am.cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        for (DataConnection conn : this.pdpList) {
            PdpConnection pdp = (PdpConnection)conn;
            if (tearDown) {
                Message msg = this.obtainMessage(25, reason);
                pdp.disconnect(msg);
                continue;
            }
            pdp.clearSettings();
        }
        this.stopNetStatPoll();
        if (!tearDown) {
            this.setState(DataConnectionTracker.State.IDLE);
            this.phone.notifyDataConnection(reason);
            this.mActiveApn = null;
        }
    }

    public String[] parseTypes(String types) {
        String[] result = types == null || types.equals("") ? new String[]{"*"} : types.split(",");
        return result;
    }

    public ArrayList<ApnSetting> createApnList(Cursor cursor) {
        ArrayList<ApnSetting> result = new ArrayList<ApnSetting>();
        if (cursor.moveToFirst()) {
            do {
                String[] types = this.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
                ApnSetting apn = new ApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getString(cursor.getColumnIndexOrThrow("proxy")), cursor.getString(cursor.getColumnIndexOrThrow("port")), cursor.getString(cursor.getColumnIndexOrThrow("mmsc")), cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy")), cursor.getString(cursor.getColumnIndexOrThrow("mmsport")), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), types);
                result.add(apn);
            } while (cursor.moveToNext());
        }
        return result;
    }

    public PdpConnection findFreePdp() {
        for (DataConnection conn : this.pdpList) {
            PdpConnection pdp = (PdpConnection)conn;
            if (pdp.getState() != DataConnection.State.INACTIVE) continue;
            return pdp;
        }
        return null;
    }

    public boolean setupData(String reason) {
        ApnSetting apn = this.getNextApn();
        if (apn == null) {
            return false;
        }
        PdpConnection pdp = this.findFreePdp();
        if (pdp == null) {
            this.log("setupData: No free PdpConnection found!");
            return false;
        }
        this.mActiveApn = apn;
        this.mActivePdp = pdp;
        Message msg = this.obtainMessage();
        msg.what = 1;
        msg.obj = reason;
        pdp.connect(apn, msg);
        this.setState(DataConnectionTracker.State.INITING);
        this.phone.notifyDataConnection(reason);
        return true;
    }

    public String getInterfaceName(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getInterface();
        }
        return null;
    }

    public String getIpAddress(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getIpAddress();
        }
        return null;
    }

    public String getGateway(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getGatewayAddress();
        }
        return null;
    }

    public String[] getDnsServers(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getDnsServers();
        }
        return null;
    }

    public boolean pdpStatesHasCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid) continue;
            return true;
        }
        return false;
    }

    public boolean pdpStatesHasActiveCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid || states.get((int)i).active == 0) continue;
            return true;
        }
        return false;
    }

    public void onApnChanged() {
        boolean isConnected = this.state != DataConnectionTracker.State.IDLE && this.state != DataConnectionTracker.State.FAILED;
        this.mGsmPhone.updateCurrentCarrierInProvider();
        this.createAllApnList();
        if (this.state != DataConnectionTracker.State.DISCONNECTING) {
            this.cleanUpConnection(isConnected, "apnChanged");
            if (!isConnected) {
                this.nextReconnectDelay = 5000L;
                this.mReregisterOnReconnectFailure = false;
                this.trySetupData("apnChanged");
            }
        }
    }

    public void onPdpStateChanged(AsyncResult ar, boolean explicitPoll) {
        ArrayList pdpStates = (ArrayList)ar.result;
        if (ar.exception != null) {
            return;
        }
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.pdpStatesHasCID(pdpStates, this.cidActive)) {
                Log.i(LOG_TAG, "PDP connection has dropped. Reconnecting");
                int cid = -1;
                GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                if (loc != null) {
                    cid = loc.getCid();
                }
                EventLog.List val = new EventLog.List(cid, TelephonyManager.getDefault().getNetworkType());
                EventLog.writeEvent(50109, val);
                this.cleanUpConnection(true, null);
                return;
            }
            if (!this.pdpStatesHasActiveCID(pdpStates, this.cidActive)) {
                if (!explicitPoll) {
                    this.phone.mCM.getPDPContextList(this.obtainMessage(11));
                } else {
                    Log.i(LOG_TAG, "PDP connection has dropped (active=false case).  Reconnecting");
                    int cid = -1;
                    GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                    if (loc != null) {
                        cid = loc.getCid();
                    }
                    EventLog.List val = new EventLog.List(cid, TelephonyManager.getDefault().getNetworkType());
                    EventLog.writeEvent(50109, val);
                    this.cleanUpConnection(true, null);
                }
            }
        }
    }

    public void notifyDefaultData(String reason) {
        this.setupDnsProperties();
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.phone.notifyDataConnection(reason);
        this.startNetStatPoll();
        this.nextReconnectDelay = 5000L;
        this.mReregisterOnReconnectFailure = false;
    }

    public void setupDnsProperties() {
        String propVal;
        int i;
        int mypid = android.os.Process.myPid();
        String[] servers = this.getDnsServers(null);
        int count = 0;
        for (i = 0; i < servers.length; ++i) {
            String serverAddr = servers[i];
            if (TextUtils.equals(serverAddr, "0.0.0.0")) continue;
            SystemProperties.set("net.dns" + (i + 1) + "." + mypid, serverAddr);
            ++count;
        }
        for (i = count + 1; i <= 4; ++i) {
            String propName = "net.dns" + i + "." + mypid;
            propVal = SystemProperties.get(propName);
            if (propVal.length() == 0) continue;
            SystemProperties.set(propName, "");
        }
        propVal = SystemProperties.get("net.dnschange");
        if (propVal.length() != 0) {
            try {
                int n = Integer.parseInt(propVal);
                SystemProperties.set("net.dnschange", "" + (n + 1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public void startPeriodicPdpPoll() {
        this.removeMessages(7);
        this.sendMessageDelayed(this.obtainMessage(7), 5000L);
    }

    public void resetPollStats() {
        this.txPkts = -1L;
        this.rxPkts = -1L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    public void doRecovery() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            int maxPdpReset = Settings.Gservices.getInt(this.mResolver, "pdp_watchdog_max_pdp_reset_fail_count", 3);
            if (this.mPdpResetCount < maxPdpReset) {
                ++this.mPdpResetCount;
                EventLog.writeEvent(50103, this.sentSinceLastRecv);
                this.cleanUpConnection(true, "pdpReset");
            } else {
                this.mPdpResetCount = 0;
                EventLog.writeEvent(50104, this.sentSinceLastRecv);
                this.mGsmPhone.mSST.reRegisterNetwork(null);
            }
        }
    }

    @Override
    public void startNetStatPoll() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mPingTestActive && !this.netStatPollEnabled) {
            Log.d(LOG_TAG, "[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.netStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    public void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        Log.d(LOG_TAG, "[DataConnection] Stop poll NetStat");
    }

    @Override
    public void restartRadio() {
        Log.d(LOG_TAG, "************TURN OFF RADIO**************");
        this.cleanUpConnection(true, "radioTurnedOff");
        this.phone.mCM.setRadioPower(false, null);
        int reset = Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"));
        SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(reset + 1));
    }

    public void runPingTest() {
        int status = -1;
        try {
            String address = Settings.Gservices.getString(this.mResolver, "pdp_watchdog_ping_address");
            int deadline = Settings.Gservices.getInt(this.mResolver, "pdp_watchdog_ping_deadline", 5);
            this.log("pinging " + address + " for " + deadline + "s");
            if (address != null && !"0.0.0.0".equals(address)) {
                Process p = Runtime.getRuntime().exec("ping -c 1 -i 1 -w " + deadline + " " + address);
                status = p.waitFor();
            }
        }
        catch (IOException e) {
            Log.w(LOG_TAG, "ping failed: IOException");
        }
        catch (Exception e) {
            Log.w(LOG_TAG, "exception trying to ping");
        }
        if (status == 0) {
            EventLog.writeEvent(50103, -1);
            this.mPdpResetCount = 0;
            this.sendMessage(this.obtainMessage(27));
        } else {
            this.sendMessage(this.obtainMessage(28));
        }
    }

    public boolean shouldPostNotification(DataConnection.FailCause cause) {
        boolean shouldPost = true;
        return shouldPost && cause != DataConnection.FailCause.UNKNOWN;
    }

    public boolean retryAfterDisconnected(String reason) {
        boolean retry = true;
        if ("radioTurnedOff".equals(reason) || "dataDisabled".equals(reason)) {
            retry = false;
        }
        return retry;
    }

    public void reconnectAfterFail(DataConnection.FailCause lastFailCauseCode, String reason) {
        if (this.state == DataConnectionTracker.State.FAILED) {
            if (this.nextReconnectDelay > 1800000L) {
                if (this.mReregisterOnReconnectFailure) {
                    this.nextReconnectDelay = 1800000L;
                } else {
                    Log.d(LOG_TAG, "PDP activate failed, Reregistering to the network");
                    this.mReregisterOnReconnectFailure = true;
                    this.mGsmPhone.mSST.reRegisterNetwork(null);
                    this.nextReconnectDelay = 5000L;
                    return;
                }
            }
            Log.d(LOG_TAG, "PDP activate failed. Scheduling next attempt for " + this.nextReconnectDelay / 1000L + "s");
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            Intent intent = new Intent(INTENT_RECONNECT_ALARM);
            intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, reason);
            this.mReconnectIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
            am.set(2, SystemClock.elapsedRealtime() + this.nextReconnectDelay, this.mReconnectIntent);
            this.nextReconnectDelay *= 2L;
            if (!this.shouldPostNotification(lastFailCauseCode)) {
                Log.d(LOG_TAG, "NOT Posting GPRS Unavailable notification -- likely transient error");
            } else {
                this.notifyNoData(lastFailCauseCode);
            }
        }
    }

    public void notifyNoData(DataConnection.FailCause lastFailCauseCode) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    public void onRecordsLoaded() {
        this.createAllApnList();
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    public void onEnableNewApn() {
        this.cleanUpConnection(true, "apnSwitched");
    }

    @Override
    public void onTrySetupData(String reason) {
        this.trySetupData(reason);
    }

    public void onRestoreDefaultApn() {
        Log.d(LOG_TAG, "Restore default APN");
        this.setEnabled("mms", false);
        this.mRequestedApnType = "default";
        if (!this.isApnTypeActive("default")) {
            this.cleanUpConnection(true, "restoreDefaultApn");
        }
    }

    @Override
    public void onRoamingOff() {
        if (!this.getDataRoaming()) {
            this.trySetupData("roamingOff");
        } else {
            this.sendMessage(this.obtainMessage(21));
        }
    }

    @Override
    public void onRoamingOn() {
        if (this.getDataRoaming()) {
            if (this.getDataOnRoamingEnabled()) {
                this.trySetupData("roamingOn");
            } else {
                this.log("Tear down data connection on roaming.");
                this.cleanUpConnection(true, "roamingOn");
            }
        } else {
            this.sendMessage(this.obtainMessage(22));
        }
    }

    @Override
    public void onRadioAvailable() {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(null);
            Log.i(LOG_TAG, "We're on the simulator; assuming data is connected");
        }
        if (this.state != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    public void onRadioOffOrNotAvailable() {
        this.nextReconnectDelay = 5000L;
        this.mReregisterOnReconnectFailure = false;
        if (this.phone.getSimulatedRadioControl() != null) {
            Log.i(LOG_TAG, "We're on the simulator; assuming radio off is meaningless");
        } else {
            this.log("Radio is off and clean up all connection");
            this.cleanUpConnection(false, "radioTurnedOff");
        }
    }

    @Override
    public void onDataSetupComplete(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        if (ar.exception == null) {
            if (this.dataEnabled[APN_MMS_ID] || this.dataEnabled[APN_SUPL_ID]) {
                this.removeMessages(24);
                this.sendMessageDelayed(this.obtainMessage(24), this.getRestoreDefaultApnDelay());
            }
            if (this.isApnTypeActive("default")) {
                SystemProperties.set("gsm.defaultpdpcontext.active", "true");
                if (this.canSetPreferApn && this.preferredApn == null) {
                    Log.d(LOG_TAG, "PREFERED APN is null");
                    this.preferredApn = this.mActiveApn;
                    this.setPreferredApn(this.preferredApn.id);
                }
            } else {
                SystemProperties.set("gsm.defaultpdpcontext.active", "false");
            }
            this.notifyDefaultData(reason);
        } else {
            DataConnection.FailCause cause = (DataConnection.FailCause)((Object)ar.result);
            this.log("PDP setup failed " + (Object)((Object)cause));
            if (cause.isEventLoggable()) {
                int cid = -1;
                GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                if (loc != null) {
                    cid = loc.getCid();
                }
                EventLog.List val = new EventLog.List(cause.ordinal(), cid, TelephonyManager.getDefault().getNetworkType());
                EventLog.writeEvent(50105, val);
            }
            if (cause.isPermanentFail()) {
                this.notifyNoData(cause);
                return;
            }
            this.waitingApns.remove(0);
            if (this.waitingApns.isEmpty()) {
                this.startDelayedRetry(cause, reason);
            } else {
                this.setState(DataConnectionTracker.State.SCANNING);
                this.sendMessageDelayed(this.obtainMessage(5, reason), 5000L);
            }
        }
    }

    @Override
    public void onDisconnectDone(AsyncResult ar) {
        String reason = null;
        this.log("EVENT_DISCONNECT_DONE");
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(reason);
        this.mActiveApn = null;
        if (this.retryAfterDisconnected(reason)) {
            this.trySetupData(reason);
        }
    }

    public void onPollPdp() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.phone.mCM.getPDPContextList(this.obtainMessage(11));
            this.sendMessageDelayed(this.obtainMessage(7), 5000L);
        }
    }

    @Override
    public void onVoiceCallStarted() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.phone.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    public void onVoiceCallEnded() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        } else {
            this.nextReconnectDelay = 5000L;
            this.mReregisterOnReconnectFailure = false;
            this.trySetupData("2GVoiceCallEnded");
        }
    }

    @Override
    public void onCleanUpConnection(boolean tearDown, String reason) {
        this.cleanUpConnection(tearDown, reason);
    }

    public int getRestoreDefaultApnDelay() {
        String restoreApnDelayStr = SystemProperties.get("android.telephony.apn-restore");
        if (restoreApnDelayStr != null && restoreApnDelayStr.length() != 0) {
            try {
                return Integer.valueOf(restoreApnDelayStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 60000;
    }

    public void createAllApnList() {
        this.allApns = new ArrayList();
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (operator != null) {
            String selection = "numeric = '" + operator + "'";
            Cursor cursor = this.phone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    this.allApns = this.createApnList(cursor);
                }
                cursor.close();
            }
        }
        if (this.allApns.isEmpty()) {
            this.log("No APN found for carrier: " + operator);
            this.preferredApn = null;
            this.notifyNoData(DataConnection.FailCause.MISSING_UKNOWN_APN);
        } else {
            this.preferredApn = this.getPreferredApn();
            Log.d(LOG_TAG, "Get PreferredAPN");
            if (this.preferredApn != null && !this.preferredApn.numeric.equals(operator)) {
                this.preferredApn = null;
                this.setPreferredApn(-1);
            }
        }
    }

    public void createAllPdpList() {
        this.pdpList = new ArrayList();
        for (int i = 0; i < 1; ++i) {
            PdpConnection pdp = new PdpConnection(this.mGsmPhone);
            this.pdpList.add(pdp);
        }
    }

    public void destroyAllPdpList() {
        if (this.pdpList != null) {
            this.pdpList.removeAll(this.pdpList);
        }
    }

    public ArrayList<ApnSetting> buildWaitingApns() {
        ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (this.mRequestedApnType.equals("default") && this.canSetPreferApn && this.preferredApn != null) {
            Log.i(LOG_TAG, "Preferred APN:" + operator + ":" + this.preferredApn.numeric + ":" + this.preferredApn);
            if (this.preferredApn.numeric.equals(operator)) {
                Log.i(LOG_TAG, "Waiting APN set to preferred APN");
                apnList.add(this.preferredApn);
                return apnList;
            }
            this.setPreferredApn(-1);
            this.preferredApn = null;
        }
        if (this.allApns != null) {
            for (ApnSetting apn : this.allApns) {
                if (!apn.canHandleType(this.mRequestedApnType)) continue;
                apnList.add(apn);
            }
        }
        return apnList;
    }

    public ApnSetting getNextApn() {
        ArrayList<ApnSetting> list = this.waitingApns;
        ApnSetting apn = null;
        if (list != null && !list.isEmpty()) {
            apn = list.get(0);
        }
        return apn;
    }

    public String apnListToString(ArrayList<ApnSetting> apns) {
        StringBuilder result = new StringBuilder();
        int size = apns.size();
        for (int i = 0; i < size; ++i) {
            result.append('[').append(apns.get(i).toString()).append(']');
        }
        return result.toString();
    }

    public void startDelayedRetry(DataConnection.FailCause cause, String reason) {
        this.notifyNoData(cause);
        if (this.mRequestedApnType != "default") {
            this.sendMessage(this.obtainMessage(24));
        } else {
            this.reconnectAfterFail(cause, reason);
        }
    }

    public void setPreferredApn(int pos) {
        if (!this.canSetPreferApn) {
            return;
        }
        ContentResolver resolver = this.phone.getContext().getContentResolver();
        resolver.delete(PREFERAPN_URI, null, null);
        if (pos >= 0) {
            ContentValues values = new ContentValues();
            values.put(APN_ID, pos);
            resolver.insert(PREFERAPN_URI, values);
        }
    }

    public ApnSetting getPreferredApn() {
        if (this.allApns.isEmpty()) {
            return null;
        }
        Cursor cursor = this.phone.getContext().getContentResolver().query(PREFERAPN_URI, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.canSetPreferApn = cursor != null;
        if (this.canSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int pos = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting p : this.allApns) {
                if (p.id != pos || !p.canHandleType(this.mRequestedApnType)) continue;
                cursor.close();
                return p;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        return null;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 4: {
                this.onRecordsLoaded();
                break;
            }
            case 23: {
                this.onEnableNewApn();
                break;
            }
            case 24: {
                this.onRestoreDefaultApn();
                break;
            }
            case 19: {
                this.onGprsDetached();
                break;
            }
            case 26: {
                this.onGprsAttached();
                break;
            }
            case 6: {
                this.onPdpStateChanged((AsyncResult)msg.obj, false);
                break;
            }
            case 11: {
                this.onPdpStateChanged((AsyncResult)msg.obj, true);
                break;
            }
            case 7: {
                this.onPollPdp();
                break;
            }
            case 27: {
                this.mPingTestActive = false;
                this.startNetStatPoll();
                break;
            }
            case 28: {
                this.mPingTestActive = false;
                this.doRecovery();
                break;
            }
            case 29: {
                this.onApnChanged();
                break;
            }
            case 32: {
                Log.d(LOG_TAG, "[DSAC DEB] EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.mIsPsRestricted = true;
                break;
            }
            case 33: {
                Log.d(LOG_TAG, "[DSAC DEB] EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
                this.mIsPsRestricted = false;
                if (this.state == DataConnectionTracker.State.CONNECTED) {
                    this.startNetStatPoll();
                    break;
                }
                if (this.state == DataConnectionTracker.State.FAILED) {
                    this.cleanUpConnection(false, "psRestrictEnabled");
                    this.nextReconnectDelay = 5000L;
                    this.mReregisterOnReconnectFailure = false;
                }
                this.trySetupData("psRestrictEnabled");
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    public void log(String s) {
        Log.d(LOG_TAG, "[GsmDataConnectionTracker] " + s);
    }

    public class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            super(GsmDataConnectionTracker.this.mDataConnectionTracker);
        }

        public void onChange(boolean selfChange) {
            GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(29));
        }
    }
}

