/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.telephony.SmsRawData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ISms
extends IInterface {
    public List<SmsRawData> getAllMessagesFromIccEf() throws RemoteException;

    public boolean updateMessageOnIccEf(int var1, int var2, byte[] var3) throws RemoteException;

    public boolean copyMessageToIccEf(int var1, byte[] var2, byte[] var3) throws RemoteException;

    public void sendRawPdu(byte[] var1, byte[] var2, PendingIntent var3, PendingIntent var4) throws RemoteException;

    public void sendMultipartText(String var1, String var2, List<String> var3, List<PendingIntent> var4, List<PendingIntent> var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISms {
        public static final String DESCRIPTOR = "com.android.internal.telephony.ISms";
        public static final int TRANSACTION_getAllMessagesFromIccEf = 1;
        public static final int TRANSACTION_updateMessageOnIccEf = 2;
        public static final int TRANSACTION_copyMessageToIccEf = 3;
        public static final int TRANSACTION_sendRawPdu = 4;
        public static final int TRANSACTION_sendMultipartText = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISms asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISms) {
                return (ISms)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    List<SmsRawData> _result = this.getAllMessagesFromIccEf();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    boolean _result = this.updateMessageOnIccEf(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    boolean _result = this.copyMessageToIccEf(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _arg0 = data.createByteArray();
                    byte[] _arg1 = data.createByteArray();
                    PendingIntent _arg2 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg3 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    this.sendRawPdu(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    ArrayList<PendingIntent> _arg3 = data.createTypedArrayList(PendingIntent.CREATOR);
                    ArrayList<PendingIntent> _arg4 = data.createTypedArrayList(PendingIntent.CREATOR);
                    this.sendMultipartText(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Proxy
        implements ISms {
            public IBinder mRemote;

            public Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SmsRawData> getAllMessagesFromIccEf() throws RemoteException {
                ArrayList<SmsRawData> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SmsRawData.CREATOR);
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateMessageOnIccEf(int messageIndex, int newStatus, byte[] pdu) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageIndex);
                    _data.writeInt(newStatus);
                    _data.writeByteArray(pdu);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var8_7 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean copyMessageToIccEf(int status, byte[] pdu, byte[] smsc) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeByteArray(pdu);
                    _data.writeByteArray(smsc);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var8_7 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRawPdu(byte[] smsc, byte[] pdu, PendingIntent sentIntent, PendingIntent deliveryIntent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(smsc);
                    _data.writeByteArray(pdu);
                    if (sentIntent != null) {
                        _data.writeInt(1);
                        sentIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (deliveryIntent != null) {
                        _data.writeInt(1);
                        deliveryIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    Object var8_7 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMultipartText(String destinationAddress, String scAddress, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(destinationAddress);
                    _data.writeString(scAddress);
                    _data.writeStringList(parts);
                    _data.writeTypedList(sentIntents);
                    _data.writeTypedList(deliveryIntents);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    Object var9_8 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }
        }
    }
}

