/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.DataLinkInterface;
import com.android.internal.telephony.PhoneBase;

public abstract class DataConnection
extends Handler {
    public static final int EVENT_SETUP_DATA_CONNECTION_DONE = 1;
    public static final int EVENT_GET_LAST_FAIL_DONE = 2;
    public static final int EVENT_LINK_STATE_CHANGED = 3;
    public static final int EVENT_DEACTIVATE_DONE = 4;
    public static final int EVENT_FORCE_RETRY = 5;
    public static final int EVENT_LOG_BAD_DNS_ADDRESS = 50100;
    public PhoneBase phone;
    public Message onConnectCompleted;
    public Message onDisconnect;
    public int cid;
    public String interfaceName;
    public String ipAddress;
    public String gatewayAddress;
    public String[] dnsServers;
    public State state;
    public long createTime;
    public long lastFailTime;
    public FailCause lastFailCause;
    public static final String NULL_IP = "0.0.0.0";
    public Object userData;
    public boolean receivedDisconnectReq;

    public abstract void onSetupConnectionCompleted(AsyncResult var1);

    public abstract void onDeactivated(AsyncResult var1);

    public abstract void disconnect(Message var1);

    public abstract void notifyFail(FailCause var1, Message var2);

    public abstract void notifyDisconnect(Message var1);

    public abstract void onLinkStateChanged(DataLinkInterface.LinkState var1);

    public abstract FailCause getFailCauseFromRequest(int var1);

    public abstract String toString();

    public abstract void log(String var1);

    public DataConnection(PhoneBase phone) {
        this.phone = phone;
        this.onConnectCompleted = null;
        this.onDisconnect = null;
        this.cid = -1;
        this.receivedDisconnectReq = false;
        this.dnsServers = new String[2];
        this.clearSettings();
    }

    public void setHttpProxy(String httpProxy, String httpPort) {
        if (httpProxy == null || httpProxy.length() == 0) {
            this.phone.setSystemProperty("net.gprs.http-proxy", null);
            return;
        }
        if (httpPort == null || httpPort.length() == 0) {
            httpPort = "8080";
        }
        this.phone.setSystemProperty("net.gprs.http-proxy", "http://" + httpProxy + ":" + httpPort + "/");
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public String[] getDnsServers() {
        return this.dnsServers;
    }

    public void clearSettings() {
        this.log("DataConnection.clearSettings()");
        this.state = State.INACTIVE;
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = FailCause.NONE;
        this.receivedDisconnectReq = false;
        this.onConnectCompleted = null;
        this.interfaceName = null;
        this.ipAddress = null;
        this.gatewayAddress = null;
        this.dnsServers[0] = null;
        this.dnsServers[1] = null;
    }

    public void onGetLastFailCompleted(AsyncResult ar) {
        if (this.receivedDisconnectReq) {
            this.notifyDisconnect(this.onDisconnect);
        } else {
            FailCause cause = FailCause.UNKNOWN;
            if (ar.exception == null) {
                int rilFailCause = ((int[])ar.result)[0];
                cause = this.getFailCauseFromRequest(rilFailCause);
            }
            this.notifyFail(cause, this.onConnectCompleted);
        }
    }

    public void onForceRetry() {
        if (this.receivedDisconnectReq) {
            this.notifyDisconnect(this.onDisconnect);
        } else {
            this.notifyFail(FailCause.RADIO_ERROR_RETRY, this.onConnectCompleted);
        }
    }

    public void handleMessage(Message msg) {
        this.log("DataConnection.handleMessage()");
        switch (msg.what) {
            case 1: {
                this.onSetupConnectionCompleted((AsyncResult)msg.obj);
                break;
            }
            case 5: {
                this.onForceRetry();
                break;
            }
            case 2: {
                this.onGetLastFailCompleted((AsyncResult)msg.obj);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                DataLinkInterface.LinkState ls = (DataLinkInterface.LinkState)((Object)ar.result);
                this.onLinkStateChanged(ls);
                break;
            }
            case 4: {
                this.onDeactivated((AsyncResult)msg.obj);
            }
        }
    }

    public State getState() {
        this.log("DataConnection.getState()");
        return this.state;
    }

    public long getConnectionTime() {
        this.log("DataConnection.getConnectionTime()");
        return this.createTime;
    }

    public long getLastFailTime() {
        this.log("DataConnection.getLastFailTime()");
        return this.lastFailTime;
    }

    public FailCause getLastFailCause() {
        this.log("DataConnection.getLastFailCause()");
        return this.lastFailCause;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailCause {
        NONE,
        OPERATOR_BARRED,
        INSUFFICIENT_RESOURCES,
        MISSING_UKNOWN_APN,
        UNKNOWN_PDP_ADDRESS,
        USER_AUTHENTICATION,
        ACTIVATION_REJECT_GGSN,
        ACTIVATION_REJECT_UNSPECIFIED,
        SERVICE_OPTION_NOT_SUPPORTED,
        SERVICE_OPTION_NOT_SUBSCRIBED,
        SERVICE_OPTION_OUT_OF_ORDER,
        NSAPI_IN_USE,
        PROTOCOL_ERRORS,
        REGISTRATION_FAIL,
        GPRS_REGISTRATION_FAIL,
        UNKNOWN,
        RADIO_NOT_AVAILABLE,
        RADIO_ERROR_RETRY;


        public boolean isPermanentFail() {
            return this == OPERATOR_BARRED || this == MISSING_UKNOWN_APN || this == UNKNOWN_PDP_ADDRESS || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public boolean isEventLoggable() {
            return this == OPERATOR_BARRED || this == INSUFFICIENT_RESOURCES || this == UNKNOWN_PDP_ADDRESS || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_OUT_OF_ORDER || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public String toString() {
            switch (this) {
                case NONE: {
                    return "No Error";
                }
                case OPERATOR_BARRED: {
                    return "Operator Barred";
                }
                case INSUFFICIENT_RESOURCES: {
                    return "Insufficient Resources";
                }
                case MISSING_UKNOWN_APN: {
                    return "Missing / Unknown APN";
                }
                case UNKNOWN_PDP_ADDRESS: {
                    return "Unknown PDP Address";
                }
                case USER_AUTHENTICATION: {
                    return "Error User Autentication";
                }
                case ACTIVATION_REJECT_GGSN: {
                    return "Activation Reject GGSN";
                }
                case ACTIVATION_REJECT_UNSPECIFIED: {
                    return "Activation Reject unspecified";
                }
                case SERVICE_OPTION_NOT_SUPPORTED: {
                    return "Data Not Supported";
                }
                case SERVICE_OPTION_NOT_SUBSCRIBED: {
                    return "Data Not subscribed";
                }
                case SERVICE_OPTION_OUT_OF_ORDER: {
                    return "Data Services Out of Order";
                }
                case NSAPI_IN_USE: {
                    return "NSAPI in use";
                }
                case PROTOCOL_ERRORS: {
                    return "Protocol Errors";
                }
                case REGISTRATION_FAIL: {
                    return "Network Registration Failure";
                }
                case GPRS_REGISTRATION_FAIL: {
                    return "Data Network Registration Failure";
                }
                case RADIO_NOT_AVAILABLE: {
                    return "Radio Not Available";
                }
                case RADIO_ERROR_RETRY: {
                    return "Transient Radio Rrror";
                }
            }
            return "Unknown Data Error";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ACTIVE,
        ACTIVATING,
        INACTIVE;


        public String toString() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ACTIVATING: {
                    return "setting up";
                }
            }
            return "inactive";
        }

        public boolean isActive() {
            return this == ACTIVE;
        }

        public boolean isInactive() {
            return this == INACTIVE;
        }
    }
}

