/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;

public abstract class CallTracker
extends Handler {
    public static final boolean DBG_POLL = false;
    public static final int POLL_DELAY_MSEC = 250;
    public int pendingOperations;
    public boolean needsPoll;
    public Message lastRelevantPoll;
    public CommandsInterface cm;
    public static final int EVENT_POLL_CALLS_RESULT = 1;
    public static final int EVENT_CALL_STATE_CHANGE = 2;
    public static final int EVENT_REPOLL_AFTER_DELAY = 3;
    public static final int EVENT_OPERATION_COMPLETE = 4;
    public static final int EVENT_GET_LAST_CALL_FAIL_CAUSE = 5;
    public static final int EVENT_SWITCH_RESULT = 8;
    public static final int EVENT_RADIO_AVAILABLE = 9;
    public static final int EVENT_RADIO_NOT_AVAILABLE = 10;
    public static final int EVENT_CONFERENCE_RESULT = 11;
    public static final int EVENT_SEPARATE_RESULT = 12;
    public static final int EVENT_ECT_RESULT = 13;
    public static final int EVENT_EXIT_ECM_RESPONSE_CDMA = 14;
    public static final int EVENT_CALL_WAITING_INFO_CDMA = 15;
    public static final int EVENT_THREE_WAY_DIAL_L2_RESULT_CDMA = 16;

    public void pollCallsWhenSafe() {
        this.needsPoll = true;
        if (this.checkNoOperationsPending()) {
            this.lastRelevantPoll = this.obtainMessage(1);
            this.cm.getCurrentCalls(this.lastRelevantPoll);
        }
    }

    public void pollCallsAfterDelay() {
        Message msg = this.obtainMessage();
        msg.what = 3;
        this.sendMessageDelayed(msg, 250L);
    }

    public boolean isCommandExceptionRadioNotAvailable(Throwable e) {
        return e != null && e instanceof CommandException && ((CommandException)e).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE;
    }

    public abstract void handlePollCalls(AsyncResult var1);

    public void handleRadioAvailable() {
        this.pollCallsWhenSafe();
    }

    public Message obtainNoPollCompleteMessage(int what) {
        ++this.pendingOperations;
        this.lastRelevantPoll = null;
        return this.obtainMessage(what);
    }

    public boolean checkNoOperationsPending() {
        return this.pendingOperations == 0;
    }

    public abstract void handleMessage(Message var1);

    public abstract void log(String var1);
}

