/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;
import java.util.WeakHashMap;

public class SimpleCursorAdapter
extends ResourceCursorAdapter {
    public int[] mFrom;
    public int[] mTo;
    public int mStringConversionColumn = -1;
    public CursorToStringConverter mCursorToStringConverter;
    public ViewBinder mViewBinder;
    public String[] mOriginalFrom;
    public final WeakHashMap<View, View[]> mHolders = new WeakHashMap();

    public SimpleCursorAdapter(Context context, int layout2, Cursor c, String[] from, int[] to) {
        super(context, layout2, c);
        this.mTo = to;
        this.mOriginalFrom = from;
        this.findColumns(from);
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        return this.generateViewHolder(super.newView(context, cursor, parent));
    }

    public View newDropDownView(Context context, Cursor cursor, ViewGroup parent) {
        return this.generateViewHolder(super.newDropDownView(context, cursor, parent));
    }

    public View generateViewHolder(View v) {
        int[] to = this.mTo;
        int count = to.length;
        View[] holder = new View[count];
        for (int i = 0; i < count; ++i) {
            holder[i] = v.findViewById(to[i]);
        }
        this.mHolders.put(v, holder);
        return v;
    }

    public void bindView(View view, Context context, Cursor cursor) {
        View[] holder = this.mHolders.get(view);
        ViewBinder binder = this.mViewBinder;
        int count = this.mTo.length;
        int[] from = this.mFrom;
        for (int i = 0; i < count; ++i) {
            View v = holder[i];
            if (v == null) continue;
            boolean bound = false;
            if (binder != null) {
                bound = binder.setViewValue(v, cursor, from[i]);
            }
            if (bound) continue;
            String text = cursor.getString(from[i]);
            if (text == null) {
                text = "";
            }
            if (v instanceof TextView) {
                this.setViewText((TextView)v, text);
                continue;
            }
            if (v instanceof ImageView) {
                this.setViewImage((ImageView)v, text);
                continue;
            }
            throw new IllegalStateException(v.getClass().getName() + " is not a " + " view that can be bounds by this SimpleCursorAdapter");
        }
    }

    public ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    public void setViewBinder(ViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
    }

    public void setViewImage(ImageView v, String value) {
        try {
            v.setImageResource(Integer.parseInt(value));
        }
        catch (NumberFormatException nfe) {
            v.setImageURI(Uri.parse(value));
        }
    }

    public void setViewText(TextView v, String text) {
        v.setText(text);
    }

    public int getStringConversionColumn() {
        return this.mStringConversionColumn;
    }

    public void setStringConversionColumn(int stringConversionColumn) {
        this.mStringConversionColumn = stringConversionColumn;
    }

    public CursorToStringConverter getCursorToStringConverter() {
        return this.mCursorToStringConverter;
    }

    public void setCursorToStringConverter(CursorToStringConverter cursorToStringConverter) {
        this.mCursorToStringConverter = cursorToStringConverter;
    }

    public CharSequence convertToString(Cursor cursor) {
        if (this.mCursorToStringConverter != null) {
            return this.mCursorToStringConverter.convertToString(cursor);
        }
        if (this.mStringConversionColumn > -1) {
            return cursor.getString(this.mStringConversionColumn);
        }
        return super.convertToString(cursor);
    }

    public void findColumns(String[] from) {
        if (this.mCursor != null) {
            int count = from.length;
            if (this.mFrom == null || this.mFrom.length != count) {
                this.mFrom = new int[count];
            }
            for (int i = 0; i < count; ++i) {
                this.mFrom[i] = this.mCursor.getColumnIndexOrThrow(from[i]);
            }
        } else {
            this.mFrom = null;
        }
    }

    public void changeCursor(Cursor c) {
        super.changeCursor(c);
        this.findColumns(this.mOriginalFrom);
    }

    public void changeCursorAndColumns(Cursor c, String[] from, int[] to) {
        this.mOriginalFrom = from;
        this.mTo = to;
        super.changeCursor(c);
        this.findColumns(this.mOriginalFrom);
    }

    public static interface CursorToStringConverter {
        public CharSequence convertToString(Cursor var1);
    }

    public static interface ViewBinder {
        public boolean setViewValue(View var1, Cursor var2, int var3);
    }
}

