/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;

public class MotionEvent
implements Parcelable {
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final boolean TRACK_RECYCLED_LOCATION = false;
    public static final int EDGE_TOP = 1;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int MAX_RECYCLED = 10;
    public static Object gRecyclerLock = new Object();
    public static int gRecyclerUsed = 0;
    public static MotionEvent gRecyclerTop = null;
    public long mDownTime;
    public long mEventTime;
    public int mAction;
    public float mX;
    public float mY;
    public float mRawX;
    public float mRawY;
    public float mPressure;
    public float mSize;
    public int mMetaState;
    public int mNumHistory;
    public float[] mHistory;
    public long[] mHistoryTimes;
    public float mXPrecision;
    public float mYPrecision;
    public int mDeviceId;
    public int mEdgeFlags;
    public MotionEvent mNext;
    public RuntimeException mRecycledLocation;
    public boolean mRecycled;
    public static final Parcelable.Creator<MotionEvent> CREATOR = new Parcelable.Creator<MotionEvent>(){

        @Override
        public MotionEvent createFromParcel(Parcel in) {
            MotionEvent ev = MotionEvent.obtain();
            ev.readFromParcel(in);
            return ev;
        }

        public MotionEvent[] newArray(int size) {
            return new MotionEvent[size];
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MotionEvent obtain() {
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerTop == null) {
                return new MotionEvent();
            }
            MotionEvent ev = gRecyclerTop;
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
            ev.mRecycledLocation = null;
            ev.mRecycled = false;
            return ev;
        }
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = deviceId;
        ev.mEdgeFlags = edgeFlags;
        ev.mDownTime = downTime;
        ev.mEventTime = eventTime;
        ev.mAction = action;
        ev.mX = ev.mRawX = x;
        ev.mY = ev.mRawY = y;
        ev.mPressure = pressure;
        ev.mSize = size;
        ev.mMetaState = metaState;
        ev.mXPrecision = xPrecision;
        ev.mYPrecision = yPrecision;
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int metaState) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = 0;
        ev.mEdgeFlags = 0;
        ev.mDownTime = downTime;
        ev.mEventTime = eventTime;
        ev.mAction = action;
        ev.mX = ev.mRawX = x;
        ev.mY = ev.mRawY = y;
        ev.mPressure = 1.0f;
        ev.mSize = 1.0f;
        ev.mMetaState = metaState;
        ev.mXPrecision = 1.0f;
        ev.mYPrecision = 1.0f;
        return ev;
    }

    public void scale(float scale) {
        this.mX *= scale;
        this.mY *= scale;
        this.mRawX *= scale;
        this.mRawY *= scale;
        this.mSize *= scale;
        this.mXPrecision *= scale;
        this.mYPrecision *= scale;
        if (this.mHistory != null) {
            float[] history = this.mHistory;
            int length = history.length;
            for (int i = 0; i < length; i += 4) {
                int n = i;
                history[n] = history[n] * scale;
                int n2 = i + 1;
                history[n2] = history[n2] * scale;
                int n3 = i + 3;
                history[n3] = history[n3] * scale;
            }
        }
    }

    public void translate(float dx, float dy) {
        this.mX += dx;
        this.mY += dy;
        this.mRawX += dx;
        this.mRawY += dx;
        if (this.mHistory != null) {
            float[] history = this.mHistory;
            int length = history.length;
            for (int i = 0; i < length; i += 4) {
                int n = i;
                history[n] = history[n] + dx;
                int n2 = i + 1;
                history[n2] = history[n2] + dy;
            }
        }
    }

    public static MotionEvent obtain(MotionEvent o) {
        int N;
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = o.mDeviceId;
        ev.mEdgeFlags = o.mEdgeFlags;
        ev.mDownTime = o.mDownTime;
        ev.mEventTime = o.mEventTime;
        ev.mAction = o.mAction;
        ev.mX = o.mX;
        ev.mRawX = o.mRawX;
        ev.mY = o.mY;
        ev.mRawY = o.mRawY;
        ev.mPressure = o.mPressure;
        ev.mSize = o.mSize;
        ev.mMetaState = o.mMetaState;
        ev.mXPrecision = o.mXPrecision;
        ev.mYPrecision = o.mYPrecision;
        ev.mNumHistory = N = o.mNumHistory;
        if (N > 0) {
            ev.mHistory = (float[])o.mHistory.clone();
            ev.mHistoryTimes = (long[])o.mHistoryTimes.clone();
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNumHistory = 0;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    public int getAction() {
        return this.mAction;
    }

    public long getDownTime() {
        return this.mDownTime;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getPressure() {
        return this.mPressure;
    }

    public float getSize() {
        return this.mSize;
    }

    public int getMetaState() {
        return this.mMetaState;
    }

    public float getRawX() {
        return this.mRawX;
    }

    public float getRawY() {
        return this.mRawY;
    }

    public float getXPrecision() {
        return this.mXPrecision;
    }

    public float getYPrecision() {
        return this.mYPrecision;
    }

    public int getHistorySize() {
        return this.mNumHistory;
    }

    public long getHistoricalEventTime(int pos) {
        return this.mHistoryTimes[pos];
    }

    public float getHistoricalX(int pos) {
        return this.mHistory[pos * 4];
    }

    public float getHistoricalY(int pos) {
        return this.mHistory[pos * 4 + 1];
    }

    public float getHistoricalPressure(int pos) {
        return this.mHistory[pos * 4 + 2];
    }

    public float getHistoricalSize(int pos) {
        return this.mHistory[pos * 4 + 3];
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public int getEdgeFlags() {
        return this.mEdgeFlags;
    }

    public void setEdgeFlags(int flags) {
        this.mEdgeFlags = flags;
    }

    public void setAction(int action) {
        this.mAction = action;
    }

    public void offsetLocation(float deltaX, float deltaY) {
        this.mX += deltaX;
        this.mY += deltaY;
        int N = this.mNumHistory * 4;
        if (N <= 0) {
            return;
        }
        float[] pos = this.mHistory;
        for (int i = 0; i < N; i += 4) {
            int n = i;
            pos[n] = pos[n] + deltaX;
            int n2 = i + 1;
            pos[n2] = pos[n2] + deltaY;
        }
    }

    public void setLocation(float x, float y) {
        float deltaX = x - this.mX;
        float deltaY = y - this.mY;
        if (deltaX != 0.0f || deltaY != 0.0f) {
            this.offsetLocation(deltaX, deltaY);
        }
    }

    public void addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) {
        int N;
        float[] history = this.mHistory;
        long[] historyTimes = this.mHistoryTimes;
        if (history == null) {
            this.mHistory = history = new float[32];
            this.mHistoryTimes = historyTimes = new long[8];
            N = 0;
            this.mNumHistory = 0;
            int avail = 8;
        } else {
            N = this.mNumHistory;
            int avail = history.length / 4;
            if (N == avail) {
                float[] newHistory = new float[(avail += 8) * 4];
                System.arraycopy(history, 0, newHistory, 0, N * 4);
                history = newHistory;
                this.mHistory = newHistory;
                long[] newHistoryTimes = new long[avail];
                System.arraycopy(historyTimes, 0, newHistoryTimes, 0, N);
                historyTimes = newHistoryTimes;
                this.mHistoryTimes = newHistoryTimes;
            }
        }
        historyTimes[N] = this.mEventTime;
        int pos = N * 4;
        history[pos] = this.mX;
        history[pos + 1] = this.mY;
        history[pos + 2] = this.mPressure;
        history[pos + 3] = this.mSize;
        this.mNumHistory = N + 1;
        this.mEventTime = eventTime;
        this.mX = this.mRawX = x;
        this.mY = this.mRawY = y;
        this.mPressure = pressure;
        this.mSize = size;
        this.mMetaState |= metaState;
    }

    public String toString() {
        return "MotionEvent{" + Integer.toHexString(System.identityHashCode(this)) + " action=" + this.mAction + " x=" + this.mX + " y=" + this.mY + " pressure=" + this.mPressure + " size=" + this.mSize + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mDownTime);
        out.writeLong(this.mEventTime);
        out.writeInt(this.mAction);
        out.writeFloat(this.mX);
        out.writeFloat(this.mY);
        out.writeFloat(this.mPressure);
        out.writeFloat(this.mSize);
        out.writeInt(this.mMetaState);
        out.writeFloat(this.mRawX);
        out.writeFloat(this.mRawY);
        int N = this.mNumHistory;
        out.writeInt(N);
        if (N > 0) {
            int i;
            int N4 = N * 4;
            float[] history = this.mHistory;
            for (i = 0; i < N4; ++i) {
                out.writeFloat(history[i]);
            }
            long[] times = this.mHistoryTimes;
            for (i = 0; i < N; ++i) {
                out.writeLong(times[i]);
            }
        }
        out.writeFloat(this.mXPrecision);
        out.writeFloat(this.mYPrecision);
        out.writeInt(this.mDeviceId);
        out.writeInt(this.mEdgeFlags);
    }

    public void readFromParcel(Parcel in) {
        this.mDownTime = in.readLong();
        this.mEventTime = in.readLong();
        this.mAction = in.readInt();
        this.mX = in.readFloat();
        this.mY = in.readFloat();
        this.mPressure = in.readFloat();
        this.mSize = in.readFloat();
        this.mMetaState = in.readInt();
        this.mRawX = in.readFloat();
        this.mRawY = in.readFloat();
        int N = in.readInt();
        this.mNumHistory = N;
        if (this.mNumHistory > 0) {
            int N4 = N * 4;
            float[] history = this.mHistory;
            if (history == null || history.length < N4) {
                this.mHistory = history = new float[N4 + 16];
            }
            for (int i = 0; i < N4; ++i) {
                history[i] = in.readFloat();
            }
            long[] times = this.mHistoryTimes;
            if (times == null || times.length < N) {
                this.mHistoryTimes = times = new long[N + 4];
            }
            for (int i = 0; i < N; ++i) {
                times[i] = in.readLong();
            }
        }
        this.mXPrecision = in.readFloat();
        this.mYPrecision = in.readFloat();
        this.mDeviceId = in.readInt();
        this.mEdgeFlags = in.readInt();
    }
}

