/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.cdma;

import android.os.Bundle;
import android.telephony.CellLocation;

public class CdmaCellLocation
extends CellLocation {
    public int mBaseStationId = -1;
    public int mBaseStationLatitude = -1;
    public int mBaseStationLongitude = -1;
    public int mSystemId = -1;
    public int mNetworkId = -1;

    public CdmaCellLocation() {
        this.mBaseStationId = -1;
        this.mBaseStationLatitude = -1;
        this.mBaseStationLongitude = -1;
        this.mSystemId = -1;
        this.mNetworkId = -1;
    }

    public CdmaCellLocation(Bundle bundleWithValues) {
        this.mBaseStationId = bundleWithValues.getInt("baseStationId");
        this.mBaseStationLatitude = bundleWithValues.getInt("baseStationLatitude");
        this.mBaseStationLongitude = bundleWithValues.getInt("baseStationLongitude");
        this.mSystemId = bundleWithValues.getInt("systemId");
        this.mNetworkId = bundleWithValues.getInt("networkId");
    }

    public int getBaseStationId() {
        return this.mBaseStationId;
    }

    public int getBaseStationLatitude() {
        return this.mBaseStationLatitude;
    }

    public int getBaseStationLongitude() {
        return this.mBaseStationLongitude;
    }

    public int getSystemId() {
        return this.mSystemId;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public void setStateInvalid() {
        this.mBaseStationId = -1;
        this.mBaseStationLatitude = -1;
        this.mBaseStationLongitude = -1;
        this.mSystemId = -1;
        this.mNetworkId = -1;
    }

    public void setCellLocationData(int baseStationId, int baseStationLatitude, int baseStationLongitude) {
        this.mBaseStationId = baseStationId;
        this.mBaseStationLatitude = baseStationLatitude;
        this.mBaseStationLongitude = baseStationLongitude;
    }

    public void setCellLocationData(int baseStationId, int baseStationLatitude, int baseStationLongitude, int systemId, int networkId) {
        this.mBaseStationId = baseStationId;
        this.mBaseStationLatitude = baseStationLatitude;
        this.mBaseStationLongitude = baseStationLongitude;
        this.mSystemId = systemId;
        this.mNetworkId = networkId;
    }

    public int hashCode() {
        return this.mBaseStationId ^ this.mBaseStationLatitude ^ this.mBaseStationLongitude ^ this.mSystemId ^ this.mNetworkId;
    }

    public boolean equals(Object o) {
        CdmaCellLocation s;
        try {
            s = (CdmaCellLocation)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return CdmaCellLocation.equalsHandlesNulls(this.mBaseStationId, s.mBaseStationId) && CdmaCellLocation.equalsHandlesNulls(this.mBaseStationLatitude, s.mBaseStationLatitude) && CdmaCellLocation.equalsHandlesNulls(this.mBaseStationLongitude, s.mBaseStationLongitude) && CdmaCellLocation.equalsHandlesNulls(this.mSystemId, s.mSystemId) && CdmaCellLocation.equalsHandlesNulls(this.mNetworkId, s.mNetworkId);
    }

    public String toString() {
        return "[" + this.mBaseStationId + "," + this.mBaseStationLatitude + "," + this.mBaseStationLongitude + "," + this.mSystemId + "," + this.mNetworkId + "]";
    }

    public static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public void fillInNotifierBundle(Bundle bundleToFill) {
        bundleToFill.putInt("baseStationId", this.mBaseStationId);
        bundleToFill.putInt("baseStationLatitude", this.mBaseStationLatitude);
        bundleToFill.putInt("baseStationLongitude", this.mBaseStationLongitude);
        bundleToFill.putInt("systemId", this.mSystemId);
        bundleToFill.putInt("networkId", this.mNetworkId);
    }
}

