/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.SystemProperties;
import android.telephony.JapanesePhoneNumberFormatter;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.SparseIntArray;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumberUtils {
    public static final char PAUSE = ',';
    public static final char WAIT = ';';
    public static final char WILD = 'N';
    public static final int TOA_International = 145;
    public static final int TOA_Unknown = 129;
    public static final Pattern GLOBAL_PHONE_NUMBER_PATTERN = Pattern.compile("[\\+]?[0-9.-]+");
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_NANP = 1;
    public static final int FORMAT_JAPAN = 2;
    public static final String[] NANP_COUNTRIES = new String[]{"US", "CA", "AS", "AI", "AG", "BS", "BB", "BM", "VG", "KY", "DM", "DO", "GD", "GU", "JM", "PR", "MS", "NP", "KN", "LC", "VC", "TT", "TC", "VI"};
    public static final int NANP_STATE_DIGIT = 1;
    public static final int NANP_STATE_PLUS = 2;
    public static final int NANP_STATE_ONE = 3;
    public static final int NANP_STATE_DASH = 4;
    public static final int MIN_MATCH = 5;
    public static final SparseIntArray KEYPAD_MAP = new SparseIntArray();

    public static boolean isISODigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean is12Key(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#';
    }

    public static boolean isDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N';
    }

    public static boolean isReallyDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+';
    }

    public static boolean isNonSeparator(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N' || c == ';' || c == ',';
    }

    public static boolean isStartsPostDial(char c) {
        return c == ',' || c == ';';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumberFromIntent(Intent intent, Context context) {
        String number = null;
        Uri uri = intent.getData();
        String scheme = uri.getScheme();
        if (scheme.equals("tel")) {
            return uri.getSchemeSpecificPart();
        }
        if (scheme.equals("voicemail")) {
            return TelephonyManager.getDefault().getVoiceMailNumber();
        }
        if (context == null) {
            return null;
        }
        String type = intent.resolveType(context);
        Cursor c = context.getContentResolver().query(uri, new String[]{"number"}, null, null, null);
        if (c != null) {
            try {
                if (c.moveToFirst()) {
                    number = c.getString(c.getColumnIndex("number"));
                }
                Object var8_7 = null;
                c.close();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                c.close();
                throw throwable;
            }
        }
        return number;
    }

    public static String extractNetworkPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        boolean firstCharAdded = false;
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (PhoneNumberUtils.isDialable(c) && (c != '+' || !firstCharAdded)) {
                firstCharAdded = true;
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return ret.toString();
    }

    public static String stripSeparators(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static int minPositive(int a, int b) {
        if (a >= 0 && b >= 0) {
            return a < b ? a : b;
        }
        if (a >= 0) {
            return a;
        }
        if (b >= 0) {
            return b;
        }
        return -1;
    }

    public static int indexOfLastNetworkChar(String a) {
        int wIndex;
        int origLength = a.length();
        int pIndex = a.indexOf(44);
        int trimIndex = PhoneNumberUtils.minPositive(pIndex, wIndex = a.indexOf(59));
        if (trimIndex < 0) {
            return origLength - 1;
        }
        return trimIndex - 1;
    }

    public static String extractPostDialPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        int trimIndex = PhoneNumberUtils.indexOfLastNetworkChar(phoneNumber);
        int s = phoneNumber.length();
        for (int i = trimIndex + 1; i < s; ++i) {
            char c = phoneNumber.charAt(i);
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static boolean compare(String a, String b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 || b.length() == 0) {
            return false;
        }
        int ia = PhoneNumberUtils.indexOfLastNetworkChar(a);
        int ib = PhoneNumberUtils.indexOfLastNetworkChar(b);
        int matched = 0;
        while (ia >= 0 && ib >= 0) {
            char cb;
            boolean skipCmp = false;
            char ca = a.charAt(ia);
            if (!PhoneNumberUtils.isDialable(ca)) {
                --ia;
                skipCmp = true;
            }
            if (!PhoneNumberUtils.isDialable(cb = b.charAt(ib))) {
                --ib;
                skipCmp = true;
            }
            if (skipCmp) continue;
            if (cb != ca && ca != 'N' && cb != 'N') break;
            --ia;
            --ib;
            ++matched;
        }
        if (matched < 5) {
            int aLen = a.length();
            return aLen == b.length() && aLen == matched;
        }
        if (matched >= 5 && (ia < 0 || ib < 0)) {
            return true;
        }
        if (PhoneNumberUtils.matchIntlPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefix(b, ib + 1)) {
            return true;
        }
        if (PhoneNumberUtils.matchTrunkPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(b, ib + 1)) {
            return true;
        }
        return PhoneNumberUtils.matchTrunkPrefix(b, ib + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(a, ia + 1);
    }

    public static String toCallerIDMinMatch(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortion(phoneNumber);
        return PhoneNumberUtils.internalGetStrippedReversed(np, 5);
    }

    public static String getStrippedReversed(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortion(phoneNumber);
        if (np == null) {
            return null;
        }
        return PhoneNumberUtils.internalGetStrippedReversed(np, np.length());
    }

    public static String internalGetStrippedReversed(String np, int numDigits) {
        if (np == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(numDigits);
        int length = np.length();
        int s = length;
        for (int i = length - 1; i >= 0 && s - i <= numDigits; --i) {
            char c = np.charAt(i);
            ret.append(c);
        }
        return ret.toString();
    }

    public static String stringFromStringAndTOA(String s, int TOA) {
        if (s == null) {
            return null;
        }
        if (TOA == 145 && s.length() > 0 && s.charAt(0) != '+') {
            return "+" + s;
        }
        return s;
    }

    public static int toaFromString(String s) {
        if (s != null && s.length() > 0 && s.charAt(0) == '+') {
            return 145;
        }
        return 129;
    }

    public static boolean matchIntlPrefix(String a, int len) {
        int state = 0;
        block5: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block5;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block5;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
            }
        }
        return state == 1 || state == 3 || state == 5;
    }

    public static String calledPartyBCDToString(byte[] bytes, int offset, int length) {
        boolean prependPlus = false;
        StringBuilder ret = new StringBuilder(1 + length * 2);
        if (length < 2) {
            return "";
        }
        if ((bytes[offset] & 0xFF) == 145) {
            prependPlus = true;
        }
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset + 1, length - 1);
        if (prependPlus && ret.length() == 0) {
            return "";
        }
        if (prependPlus) {
            String retString = ret.toString();
            Pattern p = Pattern.compile("(^[#*])(.*)([#*])(.*)(#)$");
            Matcher m = p.matcher(retString);
            if (m.matches()) {
                if ("".equals(m.group(2))) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(3));
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                    ret.append("+");
                } else {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append("+");
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                }
            } else {
                p = Pattern.compile("(^[#*])(.*)([#*])(.*)");
                m = p.matcher(retString);
                if (m.matches()) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append("+");
                    ret.append(m.group(4));
                } else {
                    ret = new StringBuilder();
                    ret.append('+');
                    ret.append(retString);
                }
            }
        }
        return ret.toString();
    }

    public static void internalCalledPartyBCDFragmentToString(StringBuilder sb, byte[] bytes, int offset, int length) {
        for (int i = offset; i < length + offset; ++i) {
            char c = PhoneNumberUtils.bcdToChar((byte)(bytes[i] & 0xF));
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
            byte b = (byte)(bytes[i] >> 4 & 0xF);
            if (b == 15 && i + 1 == length + offset) break;
            c = PhoneNumberUtils.bcdToChar(b);
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
        }
    }

    public static String calledPartyBCDFragmentToString(byte[] bytes, int offset, int length) {
        StringBuilder ret = new StringBuilder(length * 2);
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset, length);
        return ret.toString();
    }

    public static char bcdToChar(byte b) {
        if (b < 10) {
            return (char)(48 + b);
        }
        switch (b) {
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return ',';
            }
            case 13: {
                return 'N';
            }
        }
        return '\u0000';
    }

    public static int charToBCD(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c == '*') {
            return 10;
        }
        if (c == '#') {
            return 11;
        }
        if (c == ',') {
            return 12;
        }
        if (c == 'N') {
            return 13;
        }
        throw new RuntimeException("invalid char for BCD " + c);
    }

    public static boolean isWellFormedSmsAddress(String address) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(address);
        return !networkPortion.equals("+") && !TextUtils.isEmpty(networkPortion) && PhoneNumberUtils.isDialable(networkPortion);
    }

    public static boolean isGlobalPhoneNumber(String phoneNumber) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return false;
        }
        Matcher match = GLOBAL_PHONE_NUMBER_PATTERN.matcher(phoneNumber);
        return match.matches();
    }

    public static boolean isDialable(String address) {
        int count = address.length();
        for (int i = 0; i < count; ++i) {
            if (PhoneNumberUtils.isDialable(address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte[] networkPortionToCalledPartyBCD(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, false);
    }

    public static byte[] networkPortionToCalledPartyBCDWithLength(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, true);
    }

    public static byte[] numberToCalledPartyBCD(String number) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(number, false);
    }

    public static byte[] numberToCalledPartyBCDHelper(String number, boolean includeLength) {
        boolean hasPlus;
        int numberLenReal;
        int numberLenEffective = numberLenReal = number.length();
        boolean bl = hasPlus = number.indexOf(43) != -1;
        if (hasPlus) {
            --numberLenEffective;
        }
        if (numberLenEffective == 0) {
            return null;
        }
        int resultLen = (numberLenEffective + 1) / 2;
        int extraBytes = 1;
        if (includeLength) {
            ++extraBytes;
        }
        byte[] result = new byte[resultLen += extraBytes];
        int digitCount = 0;
        for (int i = 0; i < numberLenReal; ++i) {
            char c = number.charAt(i);
            if (c == '+') continue;
            int shift = digitCount & true ? 4 : 0;
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | (byte)((PhoneNumberUtils.charToBCD(c) & 0xF) << shift));
            ++digitCount;
        }
        if (digitCount & true) {
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | 0xF0);
        }
        int offset = 0;
        if (includeLength) {
            result[offset++] = (byte)(resultLen - 1);
        }
        result[offset] = (byte)(hasPlus ? 145 : 129);
        return result;
    }

    public static boolean matchTrunkPrefix(String a, int len) {
        boolean found = false;
        for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            if (c == '0' && !found) {
                found = true;
                continue;
            }
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            return false;
        }
        return found;
    }

    public static boolean matchIntlPrefixAndCC(String a, int len) {
        int state = 0;
        block7: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block7;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 1: 
                case 3: 
                case 5: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        state = 6;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 6: 
                case 7: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        ++state;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
            }
        }
        return state == 6 || state == 7 || state == 8;
    }

    public static String formatNumber(String source) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, PhoneNumberUtils.getFormatTypeForLocale(Locale.getDefault()));
        return text.toString();
    }

    public static int getFormatTypeForLocale(Locale locale) {
        String country = locale.getCountry();
        int length = NANP_COUNTRIES.length;
        for (int i = 0; i < length; ++i) {
            if (!NANP_COUNTRIES[i].equals(country)) continue;
            return 1;
        }
        if (locale.equals(Locale.JAPAN)) {
            return 2;
        }
        return 0;
    }

    public static void formatNumber(Editable text, int defaultFormattingType) {
        int formatType = defaultFormattingType;
        if (text.length() > 2 && text.charAt(0) == '+') {
            if (text.charAt(1) == '1') {
                formatType = 1;
            } else if (text.length() >= 3 && text.charAt(1) == '8' && text.charAt(2) == '1') {
                formatType = 2;
            } else {
                return;
            }
        }
        switch (formatType) {
            case 1: {
                PhoneNumberUtils.formatNanpNumber(text);
                return;
            }
            case 2: {
                PhoneNumberUtils.formatJapaneseNumber(text);
                return;
            }
        }
    }

    public static void formatNanpNumber(Editable text) {
        int i;
        int length = text.length();
        if (length > "+1-nnn-nnn-nnnn".length()) {
            return;
        }
        CharSequence saved = text.subSequence(0, length);
        int p = 0;
        while (p < text.length()) {
            if (text.charAt(p) == '-') {
                text.delete(p, p + 1);
                continue;
            }
            ++p;
        }
        length = text.length();
        int[] dashPositions = new int[3];
        int numDashes = 0;
        int state = 1;
        int numDigits = 0;
        block7: for (i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '1': {
                    if (numDigits == 0 || state == 2) {
                        state = 3;
                        continue block7;
                    }
                }
                case '0': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 2) {
                        text.replace(0, length, saved);
                        return;
                    }
                    if (state == 3) {
                        dashPositions[numDashes++] = i;
                    } else if (state != 4 && (numDigits == 3 || numDigits == 6)) {
                        dashPositions[numDashes++] = i;
                    }
                    state = 1;
                    ++numDigits;
                    continue block7;
                }
                case '-': {
                    state = 4;
                    continue block7;
                }
                case '+': {
                    if (i == 0) {
                        state = 2;
                        continue block7;
                    }
                }
                default: {
                    text.replace(0, length, saved);
                    return;
                }
            }
        }
        if (numDigits == 7) {
            --numDashes;
        }
        for (i = 0; i < numDashes; ++i) {
            int pos = dashPositions[i];
            text.replace(pos + i, pos + i, "-");
        }
        for (int len = text.length(); len > 0 && text.charAt(len - 1) == '-'; --len) {
            text.delete(len - 1, len);
        }
    }

    public static void formatJapaneseNumber(Editable text) {
        JapanesePhoneNumberFormatter.format(text);
    }

    public static boolean isEmergencyNumber(String number) {
        number = PhoneNumberUtils.extractNetworkPortion(number);
        String numbers = SystemProperties.get("ro.ril.ecclist");
        if (!TextUtils.isEmpty(numbers)) {
            for (String emergencyNum : numbers.split(",")) {
                if (!emergencyNum.equals(number)) continue;
                return true;
            }
            return false;
        }
        return number.equals("112") || number.equals("911");
    }

    public static String convertKeypadLettersToDigits(String input) {
        if (input == null) {
            return input;
        }
        int len = input.length();
        if (len == 0) {
            return input;
        }
        char[] out = input.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = out[i];
            out[i] = (char)KEYPAD_MAP.get(c, c);
        }
        return new String(out);
    }

    static {
        KEYPAD_MAP.put(97, 50);
        KEYPAD_MAP.put(98, 50);
        KEYPAD_MAP.put(99, 50);
        KEYPAD_MAP.put(65, 50);
        KEYPAD_MAP.put(66, 50);
        KEYPAD_MAP.put(67, 50);
        KEYPAD_MAP.put(100, 51);
        KEYPAD_MAP.put(101, 51);
        KEYPAD_MAP.put(102, 51);
        KEYPAD_MAP.put(68, 51);
        KEYPAD_MAP.put(69, 51);
        KEYPAD_MAP.put(70, 51);
        KEYPAD_MAP.put(103, 52);
        KEYPAD_MAP.put(104, 52);
        KEYPAD_MAP.put(105, 52);
        KEYPAD_MAP.put(71, 52);
        KEYPAD_MAP.put(72, 52);
        KEYPAD_MAP.put(73, 52);
        KEYPAD_MAP.put(106, 53);
        KEYPAD_MAP.put(107, 53);
        KEYPAD_MAP.put(108, 53);
        KEYPAD_MAP.put(74, 53);
        KEYPAD_MAP.put(75, 53);
        KEYPAD_MAP.put(76, 53);
        KEYPAD_MAP.put(109, 54);
        KEYPAD_MAP.put(110, 54);
        KEYPAD_MAP.put(111, 54);
        KEYPAD_MAP.put(77, 54);
        KEYPAD_MAP.put(78, 54);
        KEYPAD_MAP.put(79, 54);
        KEYPAD_MAP.put(112, 55);
        KEYPAD_MAP.put(113, 55);
        KEYPAD_MAP.put(114, 55);
        KEYPAD_MAP.put(115, 55);
        KEYPAD_MAP.put(80, 55);
        KEYPAD_MAP.put(81, 55);
        KEYPAD_MAP.put(82, 55);
        KEYPAD_MAP.put(83, 55);
        KEYPAD_MAP.put(116, 56);
        KEYPAD_MAP.put(117, 56);
        KEYPAD_MAP.put(118, 56);
        KEYPAD_MAP.put(84, 56);
        KEYPAD_MAP.put(85, 56);
        KEYPAD_MAP.put(86, 56);
        KEYPAD_MAP.put(119, 57);
        KEYPAD_MAP.put(120, 57);
        KEYPAD_MAP.put(121, 57);
        KEYPAD_MAP.put(122, 57);
        KEYPAD_MAP.put(87, 57);
        KEYPAD_MAP.put(88, 57);
        KEYPAD_MAP.put(89, 57);
        KEYPAD_MAP.put(90, 57);
    }
}

