/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.RemoteException;
import com.android.internal.os.RuntimeInit;

public class PowerManager {
    public static final String TAG = "PowerManager";
    public static final int WAKE_BIT_CPU_STRONG = 1;
    public static final int WAKE_BIT_CPU_WEAK = 2;
    public static final int WAKE_BIT_SCREEN_DIM = 4;
    public static final int WAKE_BIT_SCREEN_BRIGHT = 8;
    public static final int WAKE_BIT_KEYBOARD_BRIGHT = 16;
    public static final int LOCK_MASK = 31;
    public static final int PARTIAL_WAKE_LOCK = 1;
    public static final int FULL_WAKE_LOCK = 26;
    public static final int SCREEN_BRIGHT_WAKE_LOCK = 10;
    public static final int SCREEN_DIM_WAKE_LOCK = 6;
    public static final int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    public static final int ON_AFTER_RELEASE = 0x20000000;
    public IPowerManager mService;
    public Handler mHandler;

    public WakeLock newWakeLock(int flags, String tag) {
        return new WakeLock(flags, tag);
    }

    public void userActivity(long when, boolean noChangeLights) {
        try {
            this.mService.userActivity(when, noChangeLights);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void goToSleep(long time) {
        try {
            this.mService.goToSleep(time);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public PowerManager() {
    }

    public PowerManager(IPowerManager service, Handler handler) {
        this.mService = service;
        this.mHandler = handler;
    }

    public class WakeLock {
        public static final int RELEASE_WAKE_LOCK = 1;
        public Runnable mReleaser = new Runnable(){

            public void run() {
                WakeLock.this.release();
            }
        };
        public int mFlags;
        public String mTag;
        public IBinder mToken;
        public int mCount = 0;
        public boolean mRefCounted = true;
        public boolean mHeld = false;

        public WakeLock(int flags, String tag) {
            switch (flags & 0x1F) {
                case 1: 
                case 6: 
                case 10: 
                case 26: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.mFlags = flags;
            this.mTag = tag;
            this.mToken = new Binder();
        }

        public void setReferenceCounted(boolean value) {
            this.mRefCounted = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (!this.mRefCounted || this.mCount++ == 0) {
                    try {
                        PowerManager.this.mService.acquireWakeLock(this.mFlags, this.mToken, this.mTag);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mHeld = true;
                }
            }
        }

        public void acquire(long timeout) {
            this.acquire();
            PowerManager.this.mHandler.postDelayed(this.mReleaser, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (!this.mRefCounted || --this.mCount == 0) {
                    try {
                        PowerManager.this.mService.releaseWakeLock(this.mToken);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mHeld = false;
                }
                if (this.mCount < 0) {
                    throw new RuntimeException("WakeLock under-locked " + this.mTag);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return "WakeLock{" + Integer.toHexString(System.identityHashCode(this)) + " held=" + this.mHeld + ", refCount=" + this.mCount + "}";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize() throws Throwable {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    try {
                        PowerManager.this.mService.releaseWakeLock(this.mToken);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    RuntimeInit.crash(PowerManager.TAG, new Exception("WakeLock finalized while still held: " + this.mTag));
                }
            }
        }
    }
}

