/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkConnectivityListener;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.ConnectionThread;
import android.net.http.EventHandler;
import android.net.http.HttpLog;
import android.net.http.IdleCache;
import android.net.http.LoggingEventHandler;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestHandle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.http.HttpHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestQueue
implements RequestFeeder {
    public Context mContext;
    public LinkedHashMap<HttpHost, LinkedList<Request>> mPending;
    public boolean mClientWaiting = false;
    public boolean mNetworkConnected = true;
    public HttpHost mProxyHost = null;
    public BroadcastReceiver mProxyChangeReceiver;
    public ActivePool mActivePool;
    public static final int CONNECTION_COUNT = 4;
    public static final String HTTP_NETWORK_STATE_CHANGED_INTENT = "android.net.http.NETWORK_STATE";
    public static final String HTTP_NETWORK_STATE_UP = "up";
    public NetworkStateTracker mNetworkStateTracker;

    public RequestQueue(Context context) {
        this(context, 4);
    }

    public RequestQueue(Context context, int connectionCount) {
        this.mContext = context;
        this.mPending = new LinkedHashMap(32);
        this.mActivePool = new ActivePool(connectionCount);
        this.mActivePool.startup();
    }

    public synchronized void enablePlatformNotifications() {
        String device;
        boolean simulation;
        if (this.mProxyChangeReceiver == null) {
            this.mProxyChangeReceiver = new BroadcastReceiver(){

                public void onReceive(Context ctx, Intent intent) {
                    RequestQueue.this.setProxyConfig();
                }
            };
            this.mContext.registerReceiver(this.mProxyChangeReceiver, new IntentFilter("android.intent.action.PROXY_CHANGE"));
        }
        if (!(simulation = TextUtils.isEmpty(device = SystemProperties.get("ro.product.device")))) {
            if (this.mNetworkStateTracker == null) {
                this.mNetworkStateTracker = new NetworkStateTracker(this.mContext);
            }
            this.mNetworkStateTracker.enable();
        }
    }

    public synchronized void disablePlatformNotifications() {
        if (this.mNetworkStateTracker != null) {
            this.mNetworkStateTracker.disable();
        }
        if (this.mProxyChangeReceiver != null) {
            this.mContext.unregisterReceiver(this.mProxyChangeReceiver);
            this.mProxyChangeReceiver = null;
        }
    }

    public synchronized void setProxyConfig() {
        if (this.mNetworkStateTracker.getCurrentNetworkType() == 1) {
            this.mProxyHost = null;
        } else {
            String host = Proxy.getHost(this.mContext);
            if (host == null) {
                this.mProxyHost = null;
            } else {
                this.mActivePool.disablePersistence();
                this.mProxyHost = new HttpHost(host, Proxy.getPort(this.mContext), "http");
            }
        }
    }

    public HttpHost getProxyHost() {
        return this.mProxyHost;
    }

    public RequestHandle queueRequest(String url, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength, boolean highPriority) {
        WebAddress uri = new WebAddress(url);
        return this.queueRequest(url, uri, method, headers, eventHandler, bodyProvider, bodyLength, highPriority);
    }

    public RequestHandle queueRequest(String url, WebAddress uri, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength, boolean highPriority) {
        if (eventHandler == null) {
            eventHandler = new LoggingEventHandler();
        }
        HttpHost httpHost = new HttpHost(uri.mHost, uri.mPort, uri.mScheme);
        Request req = new Request(method, httpHost, this.mProxyHost, uri.mPath, bodyProvider, bodyLength, eventHandler, headers, highPriority);
        this.queueRequest(req, highPriority);
        this.mActivePool.mTotalRequest++;
        this.mActivePool.startConnectionThread();
        return new RequestHandle(this, url, uri, method, headers, bodyProvider, bodyLength, req);
    }

    public void setNetworkState(boolean isNetworkConnected) {
        this.mNetworkConnected = isNetworkConnected;
        if (isNetworkConnected) {
            this.mActivePool.startConnectionThread();
        }
    }

    public synchronized boolean requestsPending() {
        return !this.mPending.isEmpty();
    }

    public synchronized void dump() {
        HttpLog.v("dump()");
        StringBuilder dump = new StringBuilder();
        int count = 0;
        if (!this.mPending.isEmpty()) {
            Iterator<Map.Entry<HttpHost, LinkedList<Request>>> iter = this.mPending.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<HttpHost, LinkedList<Request>> entry = iter.next();
                String hostName = entry.getKey().getHostName();
                StringBuilder line = new StringBuilder("p" + count++ + " " + hostName + " ");
                LinkedList<Request> reqList = entry.getValue();
                ListIterator<Request> reqIter = reqList.listIterator(0);
                while (iter.hasNext()) {
                    Request request = (Request)((Object)iter.next());
                    line.append(request + " ");
                }
                dump.append((CharSequence)line);
                dump.append("\n");
            }
        }
        HttpLog.v(dump.toString());
    }

    @Override
    public synchronized Request getRequest() {
        Request ret = null;
        if (this.mNetworkConnected && !this.mPending.isEmpty()) {
            ret = this.removeFirst(this.mPending);
        }
        return ret;
    }

    @Override
    public synchronized Request getRequest(HttpHost host) {
        Request ret = null;
        if (this.mNetworkConnected && this.mPending.containsKey(host)) {
            LinkedList<Request> reqList = this.mPending.get(host);
            ret = reqList.removeFirst();
            if (reqList.isEmpty()) {
                this.mPending.remove(host);
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean haveRequest(HttpHost host) {
        return this.mPending.containsKey(host);
    }

    @Override
    public void requeueRequest(Request request) {
        this.queueRequest(request, true);
    }

    public void shutdown() {
        this.mActivePool.shutdown();
    }

    public synchronized void queueRequest(Request request, boolean head) {
        LinkedList<Object> reqList;
        HttpHost host;
        HttpHost httpHost = host = request.mProxyHost == null ? request.mHost : request.mProxyHost;
        if (this.mPending.containsKey(host)) {
            reqList = this.mPending.get(host);
        } else {
            reqList = new LinkedList();
            this.mPending.put(host, reqList);
        }
        if (head) {
            reqList.addFirst(request);
        } else {
            reqList.add(request);
        }
    }

    public void startTiming() {
        this.mActivePool.startTiming();
    }

    public void stopTiming() {
        this.mActivePool.stopTiming();
    }

    public Request removeFirst(LinkedHashMap<HttpHost, LinkedList<Request>> requestQueue) {
        Request ret = null;
        Iterator<Map.Entry<HttpHost, LinkedList<Request>>> iter = requestQueue.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<HttpHost, LinkedList<Request>> entry = iter.next();
            LinkedList<Request> reqList = entry.getValue();
            ret = reqList.removeFirst();
            if (reqList.isEmpty()) {
                requestQueue.remove(entry.getKey());
            }
        }
        return ret;
    }

    public static interface ConnectionManager {
        public boolean isNetworkConnected();

        public HttpHost getProxyHost();

        public Connection getConnection(Context var1, HttpHost var2);

        public boolean recycleConnection(HttpHost var1, Connection var2);
    }

    public class ActivePool
    implements ConnectionManager {
        public ConnectionThread[] mThreads;
        public IdleCache mIdleCache = new IdleCache();
        public int mTotalRequest;
        public int mTotalConnection;
        public int mConnectionCount;

        public ActivePool(int connectionCount) {
            this.mConnectionCount = connectionCount;
            this.mThreads = new ConnectionThread[this.mConnectionCount];
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i] = new ConnectionThread(RequestQueue.this.mContext, i, this, RequestQueue.this);
            }
        }

        public void startup() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].start();
            }
        }

        public void shutdown() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].requestStop();
            }
        }

        public boolean isNetworkConnected() {
            return RequestQueue.this.mNetworkConnected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startConnectionThread() {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                RequestQueue.this.notify();
            }
        }

        public void startTiming() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].mStartThreadTime = this.mThreads[i].mCurrentThreadTime;
            }
            this.mTotalRequest = 0;
            this.mTotalConnection = 0;
        }

        public void stopTiming() {
            int totalTime = 0;
            for (int i = 0; i < this.mConnectionCount; ++i) {
                ConnectionThread rt = this.mThreads[i];
                totalTime = (int)((long)totalTime + (rt.mCurrentThreadTime - rt.mStartThreadTime));
                rt.mStartThreadTime = -1L;
            }
            Log.d("Http", "Http thread used " + totalTime + " ms " + " for " + this.mTotalRequest + " requests and " + this.mTotalConnection + " connections");
        }

        public void logState() {
            StringBuilder dump = new StringBuilder();
            for (int i = 0; i < this.mConnectionCount; ++i) {
                dump.append(this.mThreads[i] + "\n");
            }
            HttpLog.v(dump.toString());
        }

        public HttpHost getProxyHost() {
            return RequestQueue.this.mProxyHost;
        }

        public void disablePersistence() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                Connection connection = this.mThreads[i].mConnection;
                if (connection == null) continue;
                connection.setCanPersist(false);
            }
            this.mIdleCache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionThread getThread(HttpHost host) {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                for (int i = 0; i < this.mThreads.length; ++i) {
                    ConnectionThread ct = this.mThreads[i];
                    Connection connection = ct.mConnection;
                    if (connection == null || !connection.mHost.equals((Object)host)) continue;
                    return ct;
                }
            }
            return null;
        }

        public Connection getConnection(Context context, HttpHost host) {
            Connection con = this.mIdleCache.getConnection(host);
            if (con == null) {
                ++this.mTotalConnection;
                con = Connection.getConnection(RequestQueue.this.mContext, host, this, RequestQueue.this);
            }
            return con;
        }

        public boolean recycleConnection(HttpHost host, Connection connection) {
            return this.mIdleCache.cacheConnection(host, connection);
        }
    }

    public class NetworkStateTracker {
        public static final int EVENT_DATA_STATE_CHANGED = 100;
        public Context mContext;
        public NetworkConnectivityListener mConnectivityListener;
        public NetworkInfo.State mLastNetworkState = NetworkInfo.State.CONNECTED;
        public int mCurrentNetworkType;
        public Handler mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        NetworkStateTracker.this.networkStateChanged();
                    }
                }
            }
        };

        public NetworkStateTracker(Context context) {
            this.mContext = context;
        }

        public void enable() {
            if (this.mConnectivityListener == null) {
                this.mCurrentNetworkType = 1;
                this.mConnectivityListener = new NetworkConnectivityListener();
                this.mConnectivityListener.registerHandler(this.mHandler, 100);
                this.mConnectivityListener.startListening(this.mContext);
            }
        }

        public void disable() {
            if (this.mConnectivityListener != null) {
                this.mConnectivityListener.unregisterHandler(this.mHandler);
                this.mConnectivityListener.stopListening();
                this.mConnectivityListener = null;
            }
        }

        public int getCurrentNetworkType() {
            return this.mCurrentNetworkType;
        }

        public void networkStateChanged() {
            boolean newConnection;
            if (this.mConnectivityListener == null) {
                return;
            }
            NetworkConnectivityListener.State connectivityState = this.mConnectivityListener.getState();
            NetworkInfo info = this.mConnectivityListener.getNetworkInfo();
            if (info == null) {
                HttpLog.v("NetworkStateTracker: connectivity broadcast has null network info - ignoring");
                return;
            }
            NetworkInfo.State state = info.getState();
            boolean bl = newConnection = state != this.mLastNetworkState && state == NetworkInfo.State.CONNECTED;
            if (state == NetworkInfo.State.CONNECTED) {
                this.mCurrentNetworkType = info.getType();
                RequestQueue.this.setProxyConfig();
            }
            this.mLastNetworkState = state;
            if (connectivityState == NetworkConnectivityListener.State.NOT_CONNECTED) {
                RequestQueue.this.setNetworkState(false);
                this.broadcastState(false);
            } else if (newConnection) {
                RequestQueue.this.setNetworkState(true);
                this.broadcastState(true);
            }
        }

        public void broadcastState(boolean connected) {
            Intent intent = new Intent(RequestQueue.HTTP_NETWORK_STATE_CHANGED_INTENT);
            intent.putExtra(RequestQueue.HTTP_NETWORK_STATE_UP, connected);
            this.mContext.sendBroadcast(intent);
        }
    }
}

