/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics._Original_Bitmap;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NinePatchDrawable
extends Drawable {
    public NinePatchState mNinePatchState;
    public NinePatch mNinePatch;
    public Rect mPadding;
    public Paint mPaint;
    public boolean mMutated;
    public int mTargetDensity = 160;
    public int mBitmapWidth;
    public int mBitmapHeight;

    public NinePatchDrawable() {
    }

    public NinePatchDrawable(Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
        this(new NinePatchState(new NinePatch(bitmap, chunk, srcName), padding));
    }

    public NinePatchDrawable(Resources res, Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
        this(new NinePatchState(new NinePatch(bitmap, chunk, srcName), padding));
        if (res != null) {
            this.setTargetDensity(res.getDisplayMetrics());
            this.mNinePatchState.mTargetDensity = this.mTargetDensity;
        }
    }

    public NinePatchDrawable(NinePatch patch) {
        this(new NinePatchState(patch, null));
    }

    public NinePatchDrawable(Resources res, NinePatch patch) {
        this(new NinePatchState(patch, null));
        if (res != null) {
            this.setTargetDensity(res.getDisplayMetrics());
            this.mNinePatchState.mTargetDensity = this.mTargetDensity;
        }
    }

    public void setNinePatchState(NinePatchState state) {
        this.mNinePatchState = state;
        this.mNinePatch = state.mNinePatch;
        this.mPadding = state.mPadding;
        this.mTargetDensity = state.mTargetDensity;
        if (state.mDither) {
            this.setDither(state.mDither);
        }
        if (this.mNinePatch != null) {
            this.computeBitmapSize();
        }
    }

    public void setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(DisplayMetrics metrics) {
        this.mTargetDensity = metrics.densityDpi;
        if (this.mNinePatch != null) {
            this.computeBitmapSize();
        }
    }

    public void setTargetDensity(int density) {
        int n = this.mTargetDensity = density == 0 ? 160 : density;
        if (this.mNinePatch != null) {
            this.computeBitmapSize();
        }
    }

    public void computeBitmapSize() {
        int sdensity = this.mNinePatch.getDensity();
        int tdensity = this.mTargetDensity;
        this.mBitmapWidth = Bitmap.scaleFromDensity(this.mNinePatch.getWidth(), sdensity, tdensity);
        this.mBitmapHeight = Bitmap.scaleFromDensity(this.mNinePatch.getHeight(), sdensity, tdensity);
    }

    public void draw(Canvas canvas) {
        this.mNinePatch.draw(canvas, this.getBounds(), this.mPaint);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mNinePatchState.mChangingConfigurations;
    }

    public boolean getPadding(Rect padding) {
        padding.set(this.mPadding);
        return true;
    }

    public void setAlpha(int alpha) {
        this.getPaint().setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.getPaint().setColorFilter(cf);
    }

    public void setDither(boolean dither) {
        this.getPaint().setDither(dither);
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.NinePatchDrawable);
        int id2 = a.getResourceId(0, 0);
        if (id2 == 0) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <nine-patch> requires a valid src attribute");
        }
        boolean dither = a.getBoolean(1, false);
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (dither) {
            options.inDither = false;
        }
        options.inScreenDensity = DisplayMetrics.DENSITY_DEVICE;
        Rect padding = new Rect();
        _Original_Bitmap bitmap = null;
        try {
            TypedValue value = new TypedValue();
            InputStream is = r.openRawResource(id2, value);
            bitmap = BitmapFactory.decodeResourceStream(r, value, is, padding, options);
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (bitmap == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <nine-patch> requires a valid src attribute");
        }
        if (bitmap.getNinePatchChunk() == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <nine-patch> requires a valid 9-patch source image");
        }
        this.setNinePatchState(new NinePatchState(new NinePatch((Bitmap)bitmap, bitmap.getNinePatchChunk(), "XML 9-patch"), padding, dither));
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
        a.recycle();
    }

    public Paint getPaint() {
        if (this.mPaint == null) {
            this.mPaint = new Paint();
        }
        return this.mPaint;
    }

    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    public int getMinimumWidth() {
        return this.mBitmapWidth;
    }

    public int getMinimumHeight() {
        return this.mBitmapHeight;
    }

    public int getOpacity() {
        return this.mNinePatch.hasAlpha() || this.mPaint != null && this.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    public Region getTransparentRegion() {
        return this.mNinePatch.getTransparentRegion(this.getBounds());
    }

    public Drawable.ConstantState getConstantState() {
        this.mNinePatchState.mChangingConfigurations = super.getChangingConfigurations();
        return this.mNinePatchState;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mNinePatchState = new NinePatchState(this.mNinePatchState);
            this.mNinePatch = this.mNinePatchState.mNinePatch;
            this.mPadding = this.mNinePatchState.mPadding;
            this.mMutated = true;
        }
        return this;
    }

    public NinePatchDrawable(NinePatchState state) {
        this.setNinePatchState(state);
    }

    public /* synthetic */ NinePatchDrawable(NinePatchState x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static class NinePatchState
    extends Drawable.ConstantState {
        public final NinePatch mNinePatch;
        public final Rect mPadding;
        public final boolean mDither;
        public int mChangingConfigurations;
        public int mTargetDensity = 160;

        public NinePatchState(NinePatch ninePatch, Rect padding) {
            this(ninePatch, padding, false);
        }

        public NinePatchState(NinePatch ninePatch, Rect rect, boolean dither) {
            this.mNinePatch = ninePatch;
            this.mPadding = rect;
            this.mDither = dither;
        }

        public NinePatchState(NinePatchState state) {
            this.mNinePatch = new NinePatch(state.mNinePatch);
            this.mPadding = new Rect(state.mPadding);
            this.mDither = state.mDither;
            this.mChangingConfigurations = state.mChangingConfigurations;
            this.mTargetDensity = state.mTargetDensity;
        }

        public Drawable newDrawable() {
            return new NinePatchDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

