/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedRotateDrawable
extends Drawable
implements Drawable.Callback,
Runnable,
Animatable {
    public AnimatedRotateState mState;
    public boolean mMutated;
    public float mCurrentDegrees;
    public float mIncrement;
    public boolean mRunning;

    public AnimatedRotateDrawable() {
        this(null);
    }

    public AnimatedRotateDrawable(AnimatedRotateState rotateState) {
        this.mState = new AnimatedRotateState(rotateState, this);
        this.init();
    }

    public void init() {
        AnimatedRotateState state = this.mState;
        this.mIncrement = 360.0f / (float)state.mFramesCount;
        Drawable drawable2 = state.mDrawable;
        if (drawable2 != null) {
            drawable2.setFilterBitmap(true);
            if (drawable2 instanceof BitmapDrawable) {
                ((BitmapDrawable)drawable2).setAntiAlias(true);
            }
        }
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        AnimatedRotateState st = this.mState;
        Drawable drawable2 = st.mDrawable;
        Rect bounds = drawable2.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        canvas.rotate(this.mCurrentDegrees, px, py);
        drawable2.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public void start() {
        if (!this.mRunning) {
            this.mRunning = true;
            this.nextFrame();
        }
    }

    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this);
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void nextFrame() {
        this.unscheduleSelf(this);
        this.scheduleSelf(this, SystemClock.uptimeMillis() + (long)this.mState.mFrameDuration);
    }

    public void run() {
        this.mCurrentDegrees += this.mIncrement;
        if (this.mCurrentDegrees > 360.0f - this.mIncrement) {
            this.mCurrentDegrees = 0.0f;
        }
        this.invalidateSelf();
        this.nextFrame();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.mState.mDrawable.setVisible(visible, restart);
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (changed || restart) {
                this.mCurrentDegrees = 0.0f;
                this.nextFrame();
            }
        } else {
            this.unscheduleSelf(this);
        }
        return changed;
    }

    public Drawable getDrawable() {
        return this.mState.mDrawable;
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations | this.mState.mDrawable.getChangingConfigurations();
    }

    public void setAlpha(int alpha) {
        this.mState.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mState.mDrawable.setColorFilter(cf);
    }

    public int getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    public void invalidateDrawable(Drawable who) {
        if (this.mCallback != null) {
            this.mCallback.invalidateDrawable(this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (this.mCallback != null) {
            this.mCallback.scheduleDrawable(this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (this.mCallback != null) {
            this.mCallback.unscheduleDrawable(this, what);
        }
    }

    public boolean getPadding(Rect padding) {
        return this.mState.mDrawable.getPadding(padding);
    }

    public boolean isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    public void onBoundsChange(Rect bounds) {
        this.mState.mDrawable.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public int getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = super.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        TypedArray a = r.obtainAttributes(attrs, R.styleable.AnimatedRotateDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        TypedValue tv = a.peekValue(2);
        boolean pivotXRel = tv.type == 6;
        float pivotX = pivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        tv = a.peekValue(3);
        boolean pivotYRel = tv.type == 6;
        float pivotY = pivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        int framesCount = a.getInt(5, 12);
        int frameDuration = a.getInt(4, 150);
        int res = a.getResourceId(1, 0);
        Drawable drawable2 = null;
        if (res > 0) {
            drawable2 = r.getDrawable(res);
        }
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2 || (drawable2 = Drawable.createFromXmlInner(r, parser, attrs)) != null) continue;
            Log.w("drawable", "Bad element under <animated-rotate>: " + parser.getName());
        }
        if (drawable2 == null) {
            Log.w("drawable", "No drawable specified for <animated-rotate>");
        }
        AnimatedRotateState rotateState = this.mState;
        rotateState.mDrawable = drawable2;
        rotateState.mPivotXRel = pivotXRel;
        rotateState.mPivotX = pivotX;
        rotateState.mPivotYRel = pivotYRel;
        rotateState.mPivotY = pivotY;
        rotateState.mFramesCount = framesCount;
        rotateState.mFrameDuration = frameDuration;
        this.init();
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    public /* synthetic */ AnimatedRotateDrawable(AnimatedRotateState x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static class AnimatedRotateState
    extends Drawable.ConstantState {
        public Drawable mDrawable;
        public int mChangingConfigurations;
        public boolean mPivotXRel;
        public float mPivotX;
        public boolean mPivotYRel;
        public float mPivotY;
        public int mFrameDuration;
        public int mFramesCount;
        public boolean mCanConstantState;
        public boolean mCheckedConstantState;

        public AnimatedRotateState(AnimatedRotateState source, AnimatedRotateDrawable owner) {
            if (source != null) {
                this.mDrawable = source.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mPivotXRel = source.mPivotXRel;
                this.mPivotX = source.mPivotX;
                this.mPivotYRel = source.mPivotYRel;
                this.mPivotY = source.mPivotY;
                this.mFramesCount = source.mFramesCount;
                this.mFrameDuration = source.mFrameDuration;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
            }
        }

        public Drawable newDrawable() {
            return new AnimatedRotateDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }
    }
}

