/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics._Original_Paint;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.SpannedString;
import android.text.TextUtils;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Paint
extends _Original_Paint {
    private int mColor = -1;
    private float mTextSize = 20.0f;
    private float mScaleX = 1.0f;
    private float mSkewX = 0.0f;
    private Align mAlign = Align.LEFT;
    private Style mStyle = Style.FILL;
    private int mFlags = 0;
    private Font mFont;
    private final FontRenderContext mFontContext = new FontRenderContext(new AffineTransform(), true, true);
    private java.awt.FontMetrics mMetrics;
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int DITHER_FLAG = 4;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int DEV_KERN_TEXT_FLAG = 256;

    public Paint() {
        this(0);
    }

    public Paint(int flags) {
        this.setFlags(flags | 0x100);
        this.initFont();
    }

    public Paint(Paint paint) {
        this.set(paint);
        this.initFont();
    }

    public void finalize() throws Throwable {
    }

    public Font getFont() {
        return this.mFont;
    }

    private void initFont() {
        this.mTypeface = Typeface.DEFAULT;
        this.updateFontObject();
    }

    private void updateFontObject() {
        if (this.mTypeface != null) {
            this.mFont = this.mTypeface.getFont().deriveFont(this.mTextSize);
            if ((double)this.mScaleX != 1.0 || this.mSkewX != 0.0f) {
                this.mFont = this.mFont.deriveFont(new AffineTransform(this.mScaleX, this.mSkewX, 0.0f, 0.0f, 1.0f, 0.0f));
            }
            this.mMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.mFont);
        }
    }

    public void set(Paint src) {
        if (this != src) {
            this.mColor = src.mColor;
            this.mTextSize = src.mTextSize;
            this.mScaleX = src.mScaleX;
            this.mSkewX = src.mSkewX;
            this.mAlign = src.mAlign;
            this.mStyle = src.mStyle;
            this.mFlags = src.mFlags;
            super.set(src);
        }
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setFlags(int flags) {
        this.mFlags = flags;
    }

    public float getFontMetrics(FontMetrics metrics) {
        if (this.mMetrics != null) {
            if (metrics != null) {
                metrics.top = -this.mMetrics.getMaxAscent();
                metrics.ascent = -this.mMetrics.getAscent();
                metrics.descent = this.mMetrics.getDescent();
                metrics.bottom = this.mMetrics.getMaxDescent();
                metrics.leading = this.mMetrics.getLeading();
            }
            return this.mMetrics.getHeight();
        }
        return 0.0f;
    }

    public int getFontMetricsInt(FontMetricsInt metrics) {
        if (this.mMetrics != null) {
            if (metrics != null) {
                metrics.top = -this.mMetrics.getMaxAscent();
                metrics.ascent = -this.mMetrics.getAscent();
                metrics.descent = this.mMetrics.getDescent();
                metrics.bottom = this.mMetrics.getMaxDescent();
                metrics.leading = this.mMetrics.getLeading();
            }
            return this.mMetrics.getHeight();
        }
        return 0;
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    public float getFontMetrics(_Original_Paint.FontMetrics metrics) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public int getFontMetricsInt(_Original_Paint.FontMetricsInt metrics) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public Typeface setTypeface(Typeface typeface) {
        this.mTypeface = typeface != null ? typeface : Typeface.DEFAULT;
        this.updateFontObject();
        return typeface;
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color2) {
        this.mColor = color2;
    }

    public void setAlpha(int alpha) {
        this.mColor = alpha << 24 | this.mColor & 0xFFFFFF;
    }

    public int getAlpha() {
        return this.mColor >>> 24;
    }

    public Shader setShader(Shader shader) {
        this.mShader = shader;
        return this.mShader;
    }

    public ColorFilter setColorFilter(ColorFilter filter) {
        int filterNative = 0;
        if (filter != null) {
            filterNative = filter.native_instance;
        }
        this.mColorFilter = filter;
        return filter;
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        this.mXfermode = xfermode;
        return this.mXfermode;
    }

    public void setTextAlign(Align align) {
        this.mAlign = align;
    }

    public void setTextAlign(_Original_Paint.Align align) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public Align getTextAlign() {
        return this.mAlign;
    }

    public void setStyle(Style style2) {
        this.mStyle = style2;
    }

    public void setStyle(_Original_Paint.Style style2) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public Style getStyle() {
        return this.mStyle;
    }

    public void setDither(boolean dither) {
        this.mFlags |= dither ? 4 : -5;
    }

    public void setAntiAlias(boolean aa) {
        this.mFlags |= aa ? 1 : -2;
    }

    public void setFakeBoldText(boolean flag) {
        this.mFlags |= flag ? 32 : -33;
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.updateFontObject();
    }

    public float getTextScaleX() {
        return this.mScaleX;
    }

    public void setTextScaleX(float scaleX) {
        this.mScaleX = scaleX;
        this.updateFontObject();
    }

    public float getTextSkewX() {
        return this.mSkewX;
    }

    public void setTextSkewX(float skewX) {
        this.mSkewX = skewX;
        this.updateFontObject();
    }

    public float ascent() {
        if (this.mMetrics != null) {
            return -this.mMetrics.getAscent();
        }
        return 0.0f;
    }

    public float descent() {
        if (this.mMetrics != null) {
            return this.mMetrics.getDescent();
        }
        return 0.0f;
    }

    public float measureText(char[] text, int index, int count) {
        if (this.mFont != null && text != null && text.length > 0) {
            Rectangle2D bounds = this.mFont.getStringBounds(text, index, index + count, this.mFontContext);
            return (float)bounds.getWidth();
        }
        return 0.0f;
    }

    public float measureText(String text, int start, int end) {
        return this.measureText(text.toCharArray(), start, end - start);
    }

    public float measureText(String text) {
        return this.measureText(text.toCharArray(), 0, text.length());
    }

    public float measureText(CharSequence text, int start, int end) {
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(((Object)text).toString(), start, end);
        }
        if (text instanceof SpannableStringBuilder) {
            return ((SpannableStringBuilder)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        int inc = count > 0 ? 1 : -1;
        int measureIndex = 0;
        float measureAcc = 0.0f;
        int i = index;
        while (i != index + count) {
            int end;
            int start;
            if (i < index) {
                start = i;
                end = index;
            } else {
                start = index;
                end = i;
            }
            float res = this.measureText(text, start, end - start + 1);
            if (measuredWidth != null) {
                measuredWidth[measureIndex] = res;
            }
            measureAcc += res;
            if (res > maxWidth) {
                return measureIndex;
            }
            i += inc;
            ++measureIndex;
        }
        return measureIndex;
    }

    public int breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        return this.breakText(text, 0, text.length(), measureForwards, maxWidth, measuredWidth);
    }

    public int getTextWidths(char[] text, int index, int count, float[] widths) {
        if (this.mMetrics != null) {
            if ((index | count) < 0 || index + count > text.length || count > widths.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < count; ++i) {
                widths[i] = this.mMetrics.charWidth(text[i + index]);
            }
            return count;
        }
        return 0;
    }

    public int getTextWidths(String text, int start, int end, float[] widths) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getTextWidths(text.toCharArray(), start, end - start, widths);
    }

    public int getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(((Object)text).toString(), start, end, widths);
        }
        if (text instanceof SpannableStringBuilder) {
            return ((SpannableStringBuilder)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public void getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("IMPLEMENT AS NEEDED");
    }

    public void getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.getTextPath(text.toCharArray(), start, end - start, x, y, path);
    }

    public void getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        this.getTextBounds(text.toCharArray(), start, end - start, bounds);
    }

    public void getTextBounds(char[] text, int index, int count, Rect bounds) {
        if (this.mFont != null) {
            if ((index | count) < 0 || index + count > text.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (bounds == null) {
                throw new NullPointerException("need bounds Rect");
            }
            Rectangle2D rect = this.mFont.getStringBounds(text, index, index + count, this.mFontContext);
            bounds.set(0, 0, (int)rect.getWidth(), (int)rect.getHeight());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        final int nativeInt;

        private Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        final int nativeInt;

        private Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        final int nativeInt;

        private Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        final int nativeInt;

        private Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static class FontMetricsInt
    extends _Original_Paint.FontMetricsInt {
    }

    public static class FontMetrics
    extends _Original_Paint.FontMetrics {
    }
}

