/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteDatabase;
import com.android.tools.layoutlib.create.OverrideMethod;

public abstract class SQLiteProgram
extends SQLiteClosable {
    public static final String TAG = "SQLiteProgram";
    public SQLiteDatabase mDatabase;
    public int nHandle = 0;
    public int nStatement = 0;
    public StackTraceElement[] mStackTraceElements;

    public SQLiteProgram(SQLiteDatabase db, String sql) {
        this.mDatabase = db;
        db.acquireReference();
        db.addSQLiteClosable(this);
        this.nHandle = db.mNativeHandle;
        this.compile(sql, false);
    }

    public void onAllReferencesReleased() {
        this.native_finalize();
        this.mDatabase.releaseReference();
        this.mDatabase.removeSQLiteClosable(this);
    }

    public void onAllReferencesReleasedFromContainer() {
        this.native_finalize();
        this.mDatabase.releaseReference();
    }

    public int getUniqueId() {
        return this.nStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(String sql, boolean forceCompilation) {
        if (this.nStatement == 0 || forceCompilation) {
            this.mDatabase.lock();
            try {
                this.acquireReference();
                this.native_compile(sql);
            }
            finally {
                this.releaseReference();
                this.mDatabase.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindNull(int index) {
        this.acquireReference();
        try {
            this.native_bind_null(index);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindLong(int index, long value) {
        this.acquireReference();
        try {
            this.native_bind_long(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindDouble(int index, double value) {
        this.acquireReference();
        try {
            this.native_bind_double(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindString(int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.acquireReference();
        try {
            this.native_bind_string(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindBlob(int index, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.acquireReference();
        try {
            this.native_bind_blob(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBindings() {
        this.acquireReference();
        try {
            this.native_clear_bindings();
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.mDatabase.lock();
        try {
            this.releaseReference();
        }
        finally {
            this.mDatabase.unlock();
        }
    }

    public void finalize() {
        if (this.nStatement != 0) {
            this.onAllReferencesReleasedFromContainer();
        }
    }

    public void native_compile(String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_compile(Ljava/lang/String;)V", true, this);
    }

    public void native_finalize() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_finalize()V", true, this);
    }

    public void native_bind_null(int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_null(I)V", true, this);
    }

    public void native_bind_long(int n, long l) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_long(IJ)V", true, this);
    }

    public void native_bind_double(int n, double d) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_double(ID)V", true, this);
    }

    public void native_bind_string(int n, String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_string(ILjava/lang/String;)V", true, this);
    }

    public void native_bind_blob(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_blob(I[B)V", true, this);
    }

    public void native_clear_bindings() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_clear_bindings()V", true, this);
    }
}

