/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDirectCursorDriver;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.os.Debug;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends SQLiteClosable {
    public static final String TAG = "Database";
    public static final int DB_OPERATION_EVENT = 52000;
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final int OPEN_READWRITE = 0;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_READ_MASK = 1;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public boolean mInnerTransactionIsSuccessful;
    public boolean mTransactionIsSuccessful;
    public final ReentrantLock mLock = new ReentrantLock(true);
    public long mLockAcquiredWallTime = 0L;
    public long mLockAcquiredThreadTime = 0L;
    public static final int LOCK_WARNING_WINDOW_IN_MS = 20000;
    public static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS = 300;
    public static final int LOCK_ACQUIRED_WARNING_THREAD_TIME_IN_MS = 100;
    public static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS_ALWAYS_PRINT = 2000;
    public long mLastLockMessageTime = 0L;
    public int mNativeHandle = 0;
    public int mTempTableSequence = 0;
    public String mPath;
    public int mFlags;
    public CursorFactory mFactory;
    public WeakHashMap<SQLiteClosable, Object> mPrograms;
    public final RuntimeException mLeakedException;
    public final boolean mLogStats;
    public boolean mLockingEnabled = true;
    public final Map<String, SyncUpdateInfo> mSyncUpdateInfo = new HashMap<String, SyncUpdateInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.put(closable, null);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.remove(closable);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void onAllReferencesReleased() {
        if (this.isOpen()) {
            this.dbclose();
        }
    }

    public static int releaseMemory() {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteDatabase#releaseMemory()I", true, null);
    }

    public void setLockingEnabled(boolean lockingEnabled) {
        this.mLockingEnabled = lockingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCorruption() {
        try {
            this.close();
        }
        finally {
            Log.e(TAG, "Removing corrupt database: " + this.mPath);
            new File(this.mPath).delete();
        }
    }

    public void lock() {
        if (!this.mLockingEnabled) {
            return;
        }
        this.mLock.lock();
    }

    public void lockForced() {
        this.mLock.lock();
    }

    public void unlock() {
        if (!this.mLockingEnabled) {
            return;
        }
        this.mLock.unlock();
    }

    public void unlockForced() {
        this.mLock.unlock();
    }

    public void checkLockHoldTime() {
        int threadTime;
        long elapsedTime = SystemClock.elapsedRealtime();
        long lockedTime = elapsedTime - this.mLockAcquiredWallTime;
        if (lockedTime < 2000L && !Log.isLoggable(TAG, 2) && elapsedTime - this.mLastLockMessageTime < 20000L) {
            return;
        }
        if (lockedTime > 300L && ((threadTime = (int)((Debug.threadCpuTimeNanos() - this.mLockAcquiredThreadTime) / 1000000L)) > 100 || lockedTime > 2000L)) {
            this.mLastLockMessageTime = elapsedTime;
            String msg = "lock held on " + this.mPath + " for " + lockedTime + "ms. Thread time was " + threadTime + "ms";
            Log.d(TAG, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction() {
        this.lockForced();
        boolean ok = false;
        try {
            if (this.mLock.getHoldCount() > 1) {
                if (this.mInnerTransactionIsSuccessful) {
                    String msg = "Cannot call beginTransaction between calling setTransactionSuccessful and endTransaction";
                    IllegalStateException e = new IllegalStateException(msg);
                    Log.e(TAG, "beginTransaction() failed", e);
                    throw e;
                }
                ok = true;
                return;
            }
            this.execSQL("BEGIN EXCLUSIVE;");
            this.mTransactionIsSuccessful = true;
            this.mInnerTransactionIsSuccessful = false;
            ok = true;
        }
        finally {
            if (!ok) {
                this.unlockForced();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("no transaction pending");
        }
        try {
            if (this.mInnerTransactionIsSuccessful) {
                this.mInnerTransactionIsSuccessful = false;
            } else {
                this.mTransactionIsSuccessful = false;
            }
            if (this.mLock.getHoldCount() != 1) {
                return;
            }
            if (this.mTransactionIsSuccessful) {
                this.execSQL("COMMIT;");
            } else {
                try {
                    this.execSQL("ROLLBACK;");
                }
                catch (SQLException e) {
                    Log.d(TAG, "exception during rollback, maybe the DB previously performed an auto-rollback");
                }
            }
        }
        finally {
            this.unlockForced();
        }
    }

    public void setTransactionSuccessful() {
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("no transaction pending");
        }
        if (this.mInnerTransactionIsSuccessful) {
            throw new IllegalStateException("setTransactionSuccessful may only be called once per call to beginTransaction");
        }
        this.mInnerTransactionIsSuccessful = true;
    }

    public boolean inTransaction() {
        return this.mLock.getHoldCount() > 0;
    }

    public boolean isDbLockedByCurrentThread() {
        return this.mLock.isHeldByCurrentThread();
    }

    public boolean isDbLockedByOtherThreads() {
        return !this.mLock.isHeldByCurrentThread() && this.mLock.isLocked();
    }

    public boolean yieldIfContended() {
        return this.yieldIfContendedHelper(false);
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true);
    }

    public boolean yieldIfContendedHelper(boolean checkFullyYielded) {
        if (this.mLock.getQueueLength() == 0) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
            return false;
        }
        this.setTransactionSuccessful();
        this.endTransaction();
        if (checkFullyYielded && this.isDbLockedByCurrentThread()) {
            throw new IllegalStateException("Db locked more than once. yielfIfContended cannot yield");
        }
        this.beginTransaction();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSyncedTables() {
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            HashMap<String, String> tables = new HashMap<String, String>();
            for (String table : this.mSyncUpdateInfo.keySet()) {
                SyncUpdateInfo info = this.mSyncUpdateInfo.get(table);
                if (info.deletedTable == null) continue;
                tables.put(table, info.deletedTable);
            }
            return tables;
        }
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags) {
        Object db = null;
        try {
            return new SQLiteDatabase(path, factory, flags);
        }
        catch (SQLiteDatabaseCorruptException e) {
            Log.e(TAG, "Deleting and re-creating corrupt database " + path, e);
            new File(path).delete();
            return new SQLiteDatabase(path, factory, flags);
        }
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), factory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000);
    }

    public static SQLiteDatabase create(CursorFactory factory) {
        return SQLiteDatabase.openDatabase(":memory:", factory, 0x10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock();
        try {
            this.closeClosable();
            this.releaseReference();
        }
        finally {
            this.unlock();
        }
    }

    public void closeClosable() {
        for (Map.Entry<SQLiteClosable, Object> entry : this.mPrograms.entrySet()) {
            SQLiteClosable program = entry.getKey();
            if (program == null) continue;
            program.onAllReferencesReleasedFromContainer();
        }
    }

    public void dbclose() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#dbclose()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        SQLiteStatement prog = null;
        this.lock();
        try {
            prog = new SQLiteStatement(this, "PRAGMA user_version;");
            long version = prog.simpleQueryForLong();
            int n = (int)version;
            return n;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    public void setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaximumSize() {
        SQLiteStatement prog = null;
        this.lock();
        try {
            prog = new SQLiteStatement(this, "PRAGMA max_page_count;");
            long pageCount = prog.simpleQueryForLong();
            long l = pageCount * this.getPageSize();
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setMaximumSize(long numBytes) {
        SQLiteProgram prog = null;
        this.lock();
        try {
            long pageSize = this.getPageSize();
            long numPages = numBytes / pageSize;
            if (numBytes % pageSize != 0L) {
                ++numPages;
            }
            prog = new SQLiteStatement(this, "PRAGMA max_page_count = " + numPages);
            long newPageCount = ((SQLiteStatement)prog).simpleQueryForLong();
            long l = newPageCount * pageSize;
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPageSize() {
        SQLiteStatement prog = null;
        this.lock();
        try {
            long size;
            prog = new SQLiteStatement(this, "PRAGMA page_size;");
            long l = size = prog.simpleQueryForLong();
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    public void setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    public void markTableSyncable(String table, String deletedTable) {
        this.markTableSyncable(table, "_id", table, deletedTable);
    }

    public void markTableSyncable(String table, String foreignKey, String updateTable) {
        this.markTableSyncable(table, foreignKey, updateTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markTableSyncable(String table, String foreignKey, String updateTable, String deletedTable) {
        this.lock();
        try {
            this.native_execSQL("SELECT _sync_dirty FROM " + updateTable + " LIMIT 0");
            this.native_execSQL("SELECT " + foreignKey + " FROM " + table + " LIMIT 0");
        }
        finally {
            this.unlock();
        }
        SyncUpdateInfo info = new SyncUpdateInfo(updateTable, deletedTable, foreignKey);
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            this.mSyncUpdateInfo.put(table, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowUpdated(String table, long rowId) {
        SyncUpdateInfo info;
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            info = this.mSyncUpdateInfo.get(table);
        }
        if (info != null) {
            this.execSQL("UPDATE " + info.masterTable + " SET _sync_dirty=1 WHERE _id=(SELECT " + info.foreignKey + " FROM " + table + " WHERE _id=" + rowId + ")");
        }
    }

    public static String findEditTable(String tables) {
        if (!TextUtils.isEmpty(tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement compileStatement(String sql) throws SQLException {
        this.lock();
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, sql);
            return sQLiteStatement;
        }
        finally {
            this.unlock();
        }
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table));
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable) {
        long timeStart = 0L;
        SQLiteDirectCursorDriver driver = new SQLiteDirectCursorDriver(this, sql, editTable);
        Cursor cursor = driver.query(cursorFactory != null ? cursorFactory : this.mFactory, selectionArgs);
        return cursor;
    }

    public Cursor rawQuery(String sql, String[] selectionArgs, int initialRead, int maxRead) {
        SQLiteCursor c = (SQLiteCursor)this.rawQueryWithFactory(null, sql, selectionArgs, null);
        c.setLoadStyle(initialRead, maxRead);
        return c;
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, null);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + values, e);
            return -1L;
        }
    }

    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, null);
    }

    public long replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, ConflictAlgorithm.REPLACE);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + initialValues, e);
            return -1L;
        }
    }

    public long replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, ConflictAlgorithm.REPLACE);
    }

    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, ConflictAlgorithm algorithm) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        StringBuilder sql = new StringBuilder(152);
        sql.append("INSERT");
        if (algorithm != null) {
            sql.append(" OR ");
            sql.append(algorithm.value());
        }
        sql.append(" INTO ");
        sql.append(table);
        StringBuilder values = new StringBuilder(40);
        Set<Map.Entry<String, Object>> entrySet = null;
        if (initialValues != null && initialValues.size() > 0) {
            entrySet = initialValues.valueSet();
            Iterator<Map.Entry<String, Object>> entriesIter = entrySet.iterator();
            sql.append('(');
            boolean needSeparator = false;
            while (entriesIter.hasNext()) {
                if (needSeparator) {
                    sql.append(", ");
                    values.append(", ");
                }
                needSeparator = true;
                Map.Entry<String, Object> entry = entriesIter.next();
                sql.append(entry.getKey());
                values.append('?');
            }
            sql.append(')');
        } else {
            sql.append("(" + nullColumnHack + ") ");
            values.append("NULL");
        }
        sql.append(" VALUES(");
        sql.append((CharSequence)values);
        sql.append(");");
        this.lock();
        SQLiteStatement statement = null;
        try {
            statement = this.compileStatement(sql.toString());
            if (entrySet != null) {
                int size = entrySet.size();
                Iterator<Map.Entry<String, Object>> entriesIter = entrySet.iterator();
                for (int i = 0; i < size; ++i) {
                    Map.Entry<String, Object> entry = entriesIter.next();
                    DatabaseUtils.bindObjectToProgram(statement, i + 1, entry.getValue());
                }
            }
            statement.execute();
            long insertedRowId = this.lastInsertRow();
            if (insertedRowId == -1L) {
                Log.e(TAG, "Error inserting " + initialValues + " using " + sql);
            } else if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "Inserting row " + insertedRowId + " from " + initialValues + " using " + sql);
            }
            long l = insertedRowId;
            return l;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        this.lock();
        SQLiteProgram statement = null;
        try {
            int numArgs;
            statement = this.compileStatement("DELETE FROM " + table + (!TextUtils.isEmpty(whereClause) ? " WHERE " + whereClause : ""));
            if (whereArgs != null) {
                numArgs = whereArgs.length;
                for (int i = 0; i < numArgs; ++i) {
                    DatabaseUtils.bindObjectToProgram(statement, i + 1, whereArgs[i]);
                }
            }
            ((SQLiteStatement)statement).execute();
            statement.close();
            numArgs = this.lastChangeCount();
            return numArgs;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, null);
    }

    public int updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, ConflictAlgorithm algorithm) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        if (algorithm != null) {
            sql.append("OR ");
            sql.append(algorithm.value());
            sql.append(" ");
        }
        sql.append(table);
        sql.append(" SET ");
        Set<Map.Entry<String, Object>> entrySet = values.valueSet();
        Iterator<Map.Entry<String, Object>> entriesIter = entrySet.iterator();
        while (entriesIter.hasNext()) {
            Map.Entry<String, Object> entry = entriesIter.next();
            sql.append(entry.getKey());
            sql.append("=?");
            if (!entriesIter.hasNext()) continue;
            sql.append(", ");
        }
        if (!TextUtils.isEmpty(whereClause)) {
            sql.append(" WHERE ");
            sql.append(whereClause);
        }
        this.lock();
        SQLiteStatement statement = null;
        try {
            int i;
            statement = this.compileStatement(sql.toString());
            int size = entrySet.size();
            entriesIter = entrySet.iterator();
            int bindArg = 1;
            for (i = 0; i < size; ++i) {
                Map.Entry<String, Object> entry = entriesIter.next();
                DatabaseUtils.bindObjectToProgram(statement, bindArg, entry.getValue());
                ++bindArg;
            }
            if (whereArgs != null) {
                size = whereArgs.length;
                for (i = 0; i < size; ++i) {
                    statement.bindString(bindArg, whereArgs[i]);
                    ++bindArg;
                }
            }
            statement.execute();
            statement.close();
            int numChangedRows = this.lastChangeCount();
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "Updated " + numChangedRows + " using " + values + " and " + sql);
            }
            int n = numChangedRows;
            return n;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        catch (SQLException e) {
            Log.e(TAG, "Error updating " + values + " using " + sql);
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
    }

    public void execSQL(String sql) throws SQLException {
        boolean logStats = this.mLogStats;
        long timeStart = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.lock();
        try {
            this.native_execSQL(sql);
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            this.unlock();
        }
        if (logStats) {
            this.logTimeStat(false, timeStart, SystemClock.elapsedRealtime());
        }
    }

    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        boolean logStats = this.mLogStats;
        long timeStart = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.lock();
        SQLiteStatement statement = null;
        try {
            statement = this.compileStatement(sql);
            if (bindArgs != null) {
                int numArgs = bindArgs.length;
                for (int i = 0; i < numArgs; ++i) {
                    DatabaseUtils.bindObjectToProgram(statement, i + 1, bindArgs[i]);
                }
            }
            statement.execute();
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
        if (logStats) {
            this.logTimeStat(false, timeStart, SystemClock.elapsedRealtime());
        }
    }

    public void finalize() {
        if (this.isOpen()) {
            if (this.mPrograms.isEmpty()) {
                Log.e(TAG, "Leak found", this.mLeakedException);
            } else {
                IllegalStateException leakProgram = new IllegalStateException("mPrograms size " + this.mPrograms.size(), this.mLeakedException);
                Log.e(TAG, "Leak found", leakProgram);
            }
            this.closeClosable();
            this.onAllReferencesReleased();
        }
    }

    public SQLiteDatabase(String path, CursorFactory factory, int flags) {
        if (path == null) {
            throw new IllegalArgumentException("path should not be null");
        }
        this.mFlags = flags;
        this.mPath = path;
        this.mLogStats = "1".equals(SystemProperties.get("db.logstats"));
        this.mLeakedException = new IllegalStateException(path + " SQLiteDatabase created and never closed");
        this.mFactory = factory;
        this.dbopen(this.mPath, this.mFlags);
        this.mPrograms = new WeakHashMap();
        try {
            this.setLocale(Locale.getDefault());
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Failed to setLocale() when constructing, closing the database", e);
            this.dbclose();
            throw e;
        }
    }

    public boolean isReadOnly() {
        return (this.mFlags & 1) == 1;
    }

    public boolean isOpen() {
        return this.mNativeHandle != 0;
    }

    public boolean needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    public String getPath() {
        return this.mPath;
    }

    public void logTimeStat(boolean read, long begin, long end) {
        EventLog.writeEvent(52000, this.mPath, read ? 0 : 1, end - begin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        this.lock();
        try {
            this.native_setLocale(locale.toString(), this.mFlags);
        }
        finally {
            this.unlock();
        }
    }

    public void dbopen(String string2, int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#dbopen(Ljava/lang/String;I)V", true, this);
    }

    public void native_execSQL(String string2) throws SQLException {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#native_execSQL(Ljava/lang/String;)V", true, this);
    }

    public void native_setLocale(String string2, int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDatabase#native_setLocale(Ljava/lang/String;I)V", true, this);
    }

    public long lastInsertRow() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteDatabase#lastInsertRow()J", true, this);
    }

    public int lastChangeCount() {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteDatabase#lastChangeCount()I", true, this);
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    public static class SyncUpdateInfo {
        public String masterTable;
        public String deletedTable;
        public String foreignKey;

        public SyncUpdateInfo(String masterTable, String deletedTable, String foreignKey) {
            this.masterTable = masterTable;
            this.deletedTable = deletedTable;
            this.foreignKey = foreignKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConflictAlgorithm {
        ROLLBACK("ROLLBACK"),
        ABORT("ABORT"),
        FAIL("FAIL"),
        IGNORE("IGNORE"),
        REPLACE("REPLACE");

        public final String mValue;

        public ConflictAlgorithm(String value) {
            this.mValue = value;
        }

        public String value() {
            return this.mValue;
        }
    }
}

