/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class PermissionInfo
extends PackageItemInfo
implements Parcelable {
    public static final int PROTECTION_NORMAL = 0;
    public static final int PROTECTION_DANGEROUS = 1;
    public static final int PROTECTION_SIGNATURE = 2;
    public static final int PROTECTION_SIGNATURE_OR_SYSTEM = 3;
    public String group;
    public int descriptionRes;
    public CharSequence nonLocalizedDescription;
    public int protectionLevel;
    public static final Parcelable.Creator<PermissionInfo> CREATOR = new Parcelable.Creator<PermissionInfo>(){

        @Override
        public PermissionInfo createFromParcel(Parcel source) {
            return new PermissionInfo(source, null);
        }

        public PermissionInfo[] newArray(int size) {
            return new PermissionInfo[size];
        }
    };

    public PermissionInfo() {
    }

    public PermissionInfo(PermissionInfo orig) {
        super(orig);
        this.group = orig.group;
        this.descriptionRes = orig.descriptionRes;
        this.protectionLevel = orig.protectionLevel;
        this.nonLocalizedDescription = orig.nonLocalizedDescription;
    }

    public CharSequence loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedDescription != null) {
            return this.nonLocalizedDescription;
        }
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, null)) != null) {
            return label;
        }
        return null;
    }

    public String toString() {
        return "PermissionInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeString(this.group);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.protectionLevel);
        TextUtils.writeToParcel(this.nonLocalizedDescription, dest, parcelableFlags);
    }

    public PermissionInfo(Parcel source) {
        super(source);
        this.group = source.readString();
        this.descriptionRes = source.readInt();
        this.protectionLevel = source.readInt();
        this.nonLocalizedDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
    }

    public /* synthetic */ PermissionInfo(Parcel x0, 1 x1) {
        this(x0);
    }
}

