/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser {
    public static final NewPermissionInfo[] NEW_PERMISSIONS = new NewPermissionInfo[]{new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0), new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0)};
    public String mArchiveSourcePath;
    public String[] mSeparateProcesses;
    public int mSdkVersion;
    public String mSdkCodename;
    public int mParseError = 1;
    public static final Object mSync = new Object();
    public static WeakReference<byte[]> mReadBuffer;
    public static boolean sCompatibilityModeEnabled;
    public ParsePackageItemArgs mParseInstrumentationArgs;
    public ParseComponentArgs mParseActivityArgs;
    public ParseComponentArgs mParseActivityAliasArgs;
    public ParseComponentArgs mParseServiceArgs;
    public ParseComponentArgs mParseProviderArgs;
    public static final boolean RIGID_PARSER = false;
    public static final String TAG = "PackageParser";
    public static final int PARSE_IS_SYSTEM = 1;
    public static final int PARSE_CHATTY = 2;
    public static final int PARSE_MUST_BE_APK = 4;
    public static final int PARSE_IGNORE_PROCESSES = 8;
    public static final String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";

    public PackageParser(String archiveSourcePath) {
        this.mArchiveSourcePath = archiveSourcePath;
    }

    public void setSeparateProcesses(String[] procs) {
        this.mSeparateProcesses = procs;
    }

    public void setSdkVersion(int sdkVersion, String codename) {
        this.mSdkVersion = sdkVersion;
        this.mSdkCodename = codename;
    }

    public static boolean isPackageFilename(String name) {
        return name.endsWith(".apk");
    }

    public static PackageInfo generatePackageInfo(Package p, int[] gids, int flags) {
        Activity activity;
        int i;
        int N;
        PackageInfo pi = new PackageInfo();
        pi.packageName = p.packageName;
        pi.versionCode = p.mVersionCode;
        pi.versionName = p.mVersionName;
        pi.sharedUserId = p.mSharedUserId;
        pi.sharedUserLabel = p.mSharedUserLabel;
        pi.applicationInfo = p.applicationInfo;
        if ((flags & 0x100) != 0) {
            pi.gids = gids;
        }
        if ((flags & 0x4000) != 0 && (N = p.configPreferences.size()) > 0) {
            pi.configPreferences = new ConfigurationInfo[N];
            for (i = 0; i < N; ++i) {
                pi.configPreferences[i] = p.configPreferences.get(i);
            }
        }
        if ((flags & 1) != 0 && (N = p.activities.size()) > 0) {
            pi.activities = new ActivityInfo[N];
            for (i = 0; i < N; ++i) {
                activity = p.activities.get(i);
                if (!activity.info.enabled && (flags & 0x200) == 0) continue;
                pi.activities[i] = PackageParser.generateActivityInfo(p.activities.get(i), flags);
            }
        }
        if ((flags & 2) != 0 && (N = p.receivers.size()) > 0) {
            pi.receivers = new ActivityInfo[N];
            for (i = 0; i < N; ++i) {
                activity = p.receivers.get(i);
                if (!activity.info.enabled && (flags & 0x200) == 0) continue;
                pi.receivers[i] = PackageParser.generateActivityInfo(p.receivers.get(i), flags);
            }
        }
        if ((flags & 4) != 0 && (N = p.services.size()) > 0) {
            pi.services = new ServiceInfo[N];
            for (i = 0; i < N; ++i) {
                Service service = p.services.get(i);
                if (!service.info.enabled && (flags & 0x200) == 0) continue;
                pi.services[i] = PackageParser.generateServiceInfo(p.services.get(i), flags);
            }
        }
        if ((flags & 8) != 0 && (N = p.providers.size()) > 0) {
            pi.providers = new ProviderInfo[N];
            for (i = 0; i < N; ++i) {
                Provider provider = p.providers.get(i);
                if (!provider.info.enabled && (flags & 0x200) == 0) continue;
                pi.providers[i] = PackageParser.generateProviderInfo(p.providers.get(i), flags);
            }
        }
        if ((flags & 0x10) != 0 && (N = p.instrumentation.size()) > 0) {
            pi.instrumentation = new InstrumentationInfo[N];
            for (i = 0; i < N; ++i) {
                pi.instrumentation[i] = PackageParser.generateInstrumentationInfo(p.instrumentation.get(i), flags);
            }
        }
        if ((flags & 0x1000) != 0) {
            N = p.permissions.size();
            if (N > 0) {
                pi.permissions = new PermissionInfo[N];
                for (i = 0; i < N; ++i) {
                    pi.permissions[i] = PackageParser.generatePermissionInfo(p.permissions.get(i), flags);
                }
            }
            if ((N = p.requestedPermissions.size()) > 0) {
                pi.requestedPermissions = new String[N];
                for (i = 0; i < N; ++i) {
                    pi.requestedPermissions[i] = p.requestedPermissions.get(i);
                }
            }
        }
        if ((flags & 0x40) != 0 && (N = p.mSignatures.length) > 0) {
            pi.signatures = new Signature[N];
            System.arraycopy(p.mSignatures, 0, pi.signatures, 0, N);
        }
        return pi;
    }

    public Certificate[] loadCertificates(JarFile jarFile, JarEntry je, byte[] readBuffer) {
        try {
            InputStream is = jarFile.getInputStream(je);
            while (is.read(readBuffer, 0, readBuffer.length) != -1) {
            }
            is.close();
            return je != null ? je.getCertificates() : null;
        }
        catch (IOException e) {
            Log.w(TAG, "Exception reading " + je.getName() + " in " + jarFile.getName(), e);
            return null;
        }
    }

    public int getParseError() {
        return this.mParseError;
    }

    public Package parsePackage(File sourceFile, String destFileName, DisplayMetrics metrics, int flags) {
        this.mParseError = 1;
        this.mArchiveSourcePath = sourceFile.getPath();
        if (!sourceFile.isFile()) {
            Log.w(TAG, "Skipping dir: " + this.mArchiveSourcePath);
            this.mParseError = -100;
            return null;
        }
        if (!PackageParser.isPackageFilename(sourceFile.getName()) && (flags & 4) != 0) {
            if ((flags & 1) == 0) {
                Log.w(TAG, "Skipping non-package file: " + this.mArchiveSourcePath);
            }
            this.mParseError = -100;
            return null;
        }
        if ((flags & 2) != 0) {
            Log.d(TAG, "Scanning package: " + this.mArchiveSourcePath);
        }
        XmlResourceParser parser = null;
        AssetManager assmgr = null;
        boolean assetError = true;
        try {
            assmgr = new AssetManager();
            int cookie = assmgr.addAssetPath(this.mArchiveSourcePath);
            if (cookie != 0) {
                parser = assmgr.openXmlResourceParser(cookie, "AndroidManifest.xml");
                assetError = false;
            } else {
                Log.w(TAG, "Failed adding asset path:" + this.mArchiveSourcePath);
            }
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to read AndroidManifest.xml of " + this.mArchiveSourcePath, e);
        }
        if (assetError) {
            if (assmgr != null) {
                assmgr.close();
            }
            this.mParseError = -101;
            return null;
        }
        String[] errorText = new String[1];
        Package pkg = null;
        Exception errorException = null;
        try {
            Resources res = new Resources(assmgr, metrics, null);
            pkg = this.parsePackage(res, parser, flags, errorText);
        }
        catch (Exception e) {
            errorException = e;
            this.mParseError = -102;
        }
        if (pkg == null) {
            if (errorException != null) {
                Log.w(TAG, this.mArchiveSourcePath, errorException);
            } else {
                Log.w(TAG, this.mArchiveSourcePath + " (at " + parser.getPositionDescription() + "): " + errorText[0]);
            }
            parser.close();
            assmgr.close();
            if (this.mParseError == 1) {
                this.mParseError = -108;
            }
            return null;
        }
        parser.close();
        assmgr.close();
        pkg.applicationInfo.sourceDir = destFileName;
        pkg.applicationInfo.publicSourceDir = destFileName;
        pkg.mSignatures = null;
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectCertificates(Package pkg, int flags) {
        block22: {
            WeakReference<byte[]> readBufferRef;
            pkg.mSignatures = null;
            byte[] readBuffer = null;
            Object object = mSync;
            synchronized (object) {
                readBufferRef = mReadBuffer;
                if (readBufferRef != null) {
                    mReadBuffer = null;
                    readBuffer = (byte[])readBufferRef.get();
                }
                if (readBuffer == null) {
                    readBuffer = new byte[8192];
                    readBufferRef = new WeakReference<byte[]>(readBuffer);
                }
            }
            try {
                Object entries;
                JarFile jarFile = new JarFile(this.mArchiveSourcePath);
                Certificate[] certs = null;
                if ((flags & 1) != 0) {
                    JarEntry jarEntry = jarFile.getJarEntry("AndroidManifest.xml");
                    certs = this.loadCertificates(jarFile, jarEntry, readBuffer);
                    if (certs == null) {
                        Log.e(TAG, "Package " + pkg.packageName + " has no certificates at entry " + jarEntry.getName() + "; ignoring!");
                        jarFile.close();
                        this.mParseError = -103;
                        return false;
                    }
                } else {
                    entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry je = entries.nextElement();
                        if (je.isDirectory() || je.getName().startsWith("META-INF/")) continue;
                        Certificate[] localCerts = this.loadCertificates(jarFile, je, readBuffer);
                        if (localCerts == null) {
                            Log.e(TAG, "Package " + pkg.packageName + " has no certificates at entry " + je.getName() + "; ignoring!");
                            jarFile.close();
                            this.mParseError = -103;
                            return false;
                        }
                        if (certs == null) {
                            certs = localCerts;
                            continue;
                        }
                        for (int i = 0; i < certs.length; ++i) {
                            boolean found = false;
                            for (int j = 0; j < localCerts.length; ++j) {
                                if (certs[i] == null || !certs[i].equals(localCerts[j])) continue;
                                found = true;
                                break;
                            }
                            if (found && certs.length == localCerts.length) continue;
                            Log.e(TAG, "Package " + pkg.packageName + " has mismatched certificates at entry " + je.getName() + "; ignoring!");
                            jarFile.close();
                            this.mParseError = -104;
                            return false;
                        }
                    }
                }
                jarFile.close();
                entries = mSync;
                synchronized (entries) {
                    mReadBuffer = readBufferRef;
                }
                if (certs != null && certs.length > 0) {
                    int N = certs.length;
                    pkg.mSignatures = new Signature[certs.length];
                    for (int i = 0; i < N; ++i) {
                        pkg.mSignatures[i] = new Signature(certs[i].getEncoded());
                    }
                    break block22;
                }
                Log.e(TAG, "Package " + pkg.packageName + " has no certificates; ignoring!");
                this.mParseError = -103;
                return false;
            }
            catch (CertificateEncodingException e) {
                Log.w(TAG, "Exception reading " + this.mArchiveSourcePath, e);
                this.mParseError = -105;
                return false;
            }
            catch (IOException e) {
                Log.w(TAG, "Exception reading " + this.mArchiveSourcePath, e);
                this.mParseError = -105;
                return false;
            }
            catch (RuntimeException e) {
                Log.w(TAG, "Exception reading " + this.mArchiveSourcePath, e);
                this.mParseError = -102;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parsePackageName(String packageFilePath, int flags) {
        String packageName;
        String[] errors;
        block17: {
            XmlResourceParser parser = null;
            AssetManager assmgr = null;
            try {
                assmgr = new AssetManager();
                int cookie = assmgr.addAssetPath(packageFilePath);
                parser = assmgr.openXmlResourceParser(cookie, "AndroidManifest.xml");
            }
            catch (Exception e) {
                if (assmgr != null) {
                    assmgr.close();
                }
                Log.w(TAG, "Unable to read AndroidManifest.xml of " + packageFilePath, e);
                return null;
            }
            XmlResourceParser attrs = parser;
            errors = new String[1];
            packageName = null;
            try {
                try {
                    packageName = PackageParser.parsePackageName(parser, attrs, flags, errors);
                }
                catch (IOException e) {
                    Log.w(TAG, packageFilePath, e);
                    Object var9_10 = null;
                    if (parser != null) {
                        parser.close();
                    }
                    if (assmgr != null) {
                        assmgr.close();
                    }
                    break block17;
                }
                catch (XmlPullParserException e) {
                    Log.w(TAG, packageFilePath, e);
                    Object var9_11 = null;
                    if (parser != null) {
                        parser.close();
                    }
                    if (assmgr != null) {
                        assmgr.close();
                    }
                }
                Object var9_9 = null;
                if (parser != null) {
                    parser.close();
                }
                if (assmgr != null) {
                    assmgr.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (parser != null) {
                    parser.close();
                }
                if (assmgr != null) {
                    assmgr.close();
                }
                throw throwable;
            }
        }
        if (packageName == null) {
            Log.e(TAG, "parsePackageName error: " + errors[0]);
            return null;
        }
        return packageName;
    }

    public static String validateName(String name, boolean requiresSeparator) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "bad character '" + c + "'";
        }
        return hasSep || !requiresSeparator ? null : "must have at least one '.' separator";
    }

    public static String parsePackageName(XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws IOException, XmlPullParserException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
        if (type != 2) {
            outError[0] = "No start tag found";
            return null;
        }
        if ((flags & 2) != 0) {
            // empty if block
        }
        if (!parser.getName().equals("manifest")) {
            outError[0] = "No <manifest> tag";
            return null;
        }
        String pkgName = attrs.getAttributeValue(null, "package");
        if (pkgName == null || pkgName.length() == 0) {
            outError[0] = "<manifest> does not specify package";
            return null;
        }
        String nameError = PackageParser.validateName(pkgName, true);
        if (nameError != null && !"android".equals(pkgName)) {
            outError[0] = "<manifest> specifies bad package name \"" + pkgName + "\": " + nameError;
            return null;
        }
        return pkgName.intern();
    }

    public static Signature stringToSignature(String str) {
        int N = str.length();
        byte[] sig = new byte[N];
        for (int i = 0; i < N; ++i) {
            sig[i] = (byte)str.charAt(i);
        }
        return new Signature(sig);
    }

    public Package parsePackage(Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        String str;
        XmlResourceParser attrs = parser;
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        String pkgName = PackageParser.parsePackageName(parser, attrs, flags, outError);
        if (pkgName == null) {
            this.mParseError = -106;
            return null;
        }
        Package pkg = new Package(pkgName);
        boolean foundApp = false;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifest);
        pkg.mVersionCode = sa.getInteger(1, 0);
        pkg.mVersionName = sa.getNonResourceString(2);
        if (pkg.mVersionName != null) {
            pkg.mVersionName = pkg.mVersionName.intern();
        }
        if ((str = sa.getNonResourceString(0)) != null) {
            String nameError = PackageParser.validateName(str, true);
            if (nameError != null && !"android".equals(pkgName)) {
                outError[0] = "<manifest> specifies bad sharedUserId name \"" + str + "\": " + nameError;
                this.mParseError = -107;
                return null;
            }
            pkg.mSharedUserId = str.intern();
            pkg.mSharedUserLabel = sa.getResourceId(3, 0);
        }
        sa.recycle();
        int supportsSmallScreens = 1;
        int supportsNormalScreens = 1;
        int supportsLargeScreens = 1;
        int resizeable = 1;
        int anyDensity = 1;
        int outerDepth = parser.getDepth();
        while (true) {
            int type = parser.next();
            if (type == 1) break;
            if (type == 3 && parser.getDepth() <= outerDepth) break;
            if (type == 3) continue;
            if (type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("application")) {
                if (foundApp) {
                    Log.w(TAG, "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseApplication(pkg, res, parser, attrs, flags, outError)) continue;
                return null;
            }
            if (tagName.equals("permission-group")) {
                if (this.parsePermissionGroup(pkg, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("permission")) {
                if (this.parsePermission(pkg, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("permission-tree")) {
                if (this.parsePermissionTree(pkg, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("uses-permission")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesPermission);
                String name = sa.getNonResourceString(0);
                sa.recycle();
                if (name != null && !pkg.requestedPermissions.contains(name)) {
                    pkg.requestedPermissions.add(name.intern());
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-configuration")) {
                ConfigurationInfo cPref = new ConfigurationInfo();
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesConfiguration);
                cPref.reqTouchScreen = sa.getInt(0, 0);
                cPref.reqKeyboardType = sa.getInt(1, 0);
                if (sa.getBoolean(2, false)) {
                    cPref.reqInputFeatures |= 1;
                }
                cPref.reqNavigation = sa.getInt(3, 0);
                if (sa.getBoolean(4, false)) {
                    cPref.reqInputFeatures |= 2;
                }
                sa.recycle();
                pkg.configPreferences.add(cPref);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-feature")) {
                ConfigurationInfo cPref = new ConfigurationInfo();
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesFeature);
                cPref.reqGlEsVersion = sa.getInt(0, 0);
                sa.recycle();
                pkg.configPreferences.add(cPref);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-sdk")) {
                if (this.mSdkVersion > 0) {
                    sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesSdk);
                    int minVers = 0;
                    String minCode = null;
                    int targetVers = 0;
                    String targetCode = null;
                    TypedValue val = sa.peekValue(0);
                    if (val != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = minCode = ((Object)val.string).toString();
                        } else {
                            targetVers = minVers = val.data;
                        }
                    }
                    if ((val = sa.peekValue(1)) != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = minCode = ((Object)val.string).toString();
                        } else {
                            targetVers = val.data;
                        }
                    }
                    int maxVers = sa.getInt(2, this.mSdkVersion);
                    sa.recycle();
                    if (minCode != null) {
                        if (!minCode.equals(this.mSdkCodename)) {
                            outError[0] = this.mSdkCodename != null ? "Requires development platform " + minCode + " (current platform is " + this.mSdkCodename + ")" : "Requires development platform " + minCode + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                    } else if (minVers > this.mSdkVersion) {
                        outError[0] = "Requires newer sdk version #" + minVers + " (current version is #" + this.mSdkVersion + ")";
                        this.mParseError = -12;
                        return null;
                    }
                    if (targetCode != null) {
                        if (!targetCode.equals(this.mSdkCodename)) {
                            outError[0] = this.mSdkCodename != null ? "Requires development platform " + targetCode + " (current platform is " + this.mSdkCodename + ")" : "Requires development platform " + targetCode + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                        pkg.applicationInfo.targetSdkVersion = 10000;
                    } else {
                        pkg.applicationInfo.targetSdkVersion = targetVers;
                    }
                    if (maxVers < this.mSdkVersion) {
                        outError[0] = "Requires older sdk version #" + maxVers + " (current version is #" + this.mSdkVersion + ")";
                        this.mParseError = -12;
                        return null;
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("supports-screens")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestSupportsScreens);
                supportsSmallScreens = sa.getInteger(1, supportsSmallScreens);
                supportsNormalScreens = sa.getInteger(2, supportsNormalScreens);
                supportsLargeScreens = sa.getInteger(3, supportsLargeScreens);
                resizeable = sa.getInteger(4, supportsLargeScreens);
                anyDensity = sa.getInteger(0, anyDensity);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("protected-broadcast")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestProtectedBroadcast);
                String name = sa.getNonResourceString(0);
                sa.recycle();
                if (name != null && (flags & 1) != 0) {
                    if (pkg.protectedBroadcasts == null) {
                        pkg.protectedBroadcasts = new ArrayList();
                    }
                    if (!pkg.protectedBroadcasts.contains(name)) {
                        pkg.protectedBroadcasts.add(name.intern());
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("instrumentation")) {
                if (this.parseInstrumentation(pkg, res, parser, attrs, outError) != null) continue;
                return null;
            }
            if (tagName.equals("eat-comment")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Log.w(TAG, "Bad element under <manifest>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp && pkg.instrumentation.size() == 0) {
            outError[0] = "<manifest> does not contain an <application> or <instrumentation>";
            this.mParseError = -109;
        }
        for (NewPermissionInfo npi : NEW_PERMISSIONS) {
            if (pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) break;
            if (pkg.requestedPermissions.contains(npi.name)) continue;
            Log.i(TAG, "Impliciting adding " + npi.name + " to old pkg " + pkg.packageName);
            pkg.requestedPermissions.add(npi.name);
        }
        if (pkg.usesLibraries.size() > 0) {
            pkg.usesLibraryFiles = new String[pkg.usesLibraries.size()];
            pkg.usesLibraries.toArray(pkg.usesLibraryFiles);
        }
        if (supportsSmallScreens < 0 || supportsSmallScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x200;
        }
        if (supportsNormalScreens != 0) {
            pkg.applicationInfo.flags |= 0x400;
        }
        if (supportsLargeScreens < 0 || supportsLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x800;
        }
        if (resizeable < 0 || resizeable > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x1000;
        }
        if (anyDensity < 0 || anyDensity > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x2000;
        }
        return pkg;
    }

    public static String buildClassName(String pkg, CharSequence clsSeq, String[] outError) {
        if (clsSeq == null || clsSeq.length() <= 0) {
            outError[0] = "Empty class name in package " + pkg;
            return null;
        }
        String cls = ((Object)clsSeq).toString();
        char c = cls.charAt(0);
        if (c == '.') {
            return (pkg + cls).intern();
        }
        if (cls.indexOf(46) < 0) {
            StringBuilder b = new StringBuilder(pkg);
            b.append('.');
            b.append(cls);
            return b.toString().intern();
        }
        if (c >= 'a' && c <= 'z') {
            return cls.intern();
        }
        outError[0] = "Bad class name " + cls + " in package " + pkg;
        return null;
    }

    public static String buildCompoundName(String pkg, CharSequence procSeq, String type, String[] outError) {
        String proc = ((Object)procSeq).toString();
        char c = proc.charAt(0);
        if (pkg != null && c == ':') {
            if (proc.length() < 2) {
                outError[0] = "Bad " + type + " name " + proc + " in package " + pkg + ": must be at least two characters";
                return null;
            }
            String subName = proc.substring(1);
            String nameError = PackageParser.validateName(subName, false);
            if (nameError != null) {
                outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
                return null;
            }
            return (pkg + proc).intern();
        }
        String nameError = PackageParser.validateName(proc, true);
        if (nameError != null && !"system".equals(proc)) {
            outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
            return null;
        }
        return proc.intern();
    }

    public static String buildProcessName(String pkg, String defProc, CharSequence procSeq, int flags, String[] separateProcesses, String[] outError) {
        if ((flags & 8) != 0 && !"system".equals(procSeq)) {
            return defProc != null ? defProc : pkg;
        }
        if (separateProcesses != null) {
            for (int i = separateProcesses.length - 1; i >= 0; --i) {
                String sp = separateProcesses[i];
                if (!sp.equals(pkg) && !sp.equals(defProc) && !sp.equals(procSeq)) continue;
                return pkg;
            }
        }
        if (procSeq == null || procSeq.length() <= 0) {
            return defProc;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "package", outError);
    }

    public static String buildTaskAffinityName(String pkg, String defProc, CharSequence procSeq, String[] outError) {
        if (procSeq == null) {
            return defProc;
        }
        if (procSeq.length() <= 0) {
            return null;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "taskAffinity", outError);
    }

    public PermissionGroup parsePermissionGroup(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        PermissionGroup perm = new PermissionGroup(owner);
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPermissionGroup);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission-group>", sa, 2, 0, 1)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        perm.info.descriptionRes = sa.getResourceId(3, 0);
        sa.recycle();
        if (!this.parseAllMetaData(res, parser, attrs, "<permission-group>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissionGroups.add(perm);
        return perm;
    }

    public Permission parsePermission(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner);
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPermission);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission>", sa, 2, 0, 1)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        perm.info.group = sa.getNonResourceString(4);
        if (perm.info.group != null) {
            perm.info.group = perm.info.group.intern();
        }
        perm.info.descriptionRes = sa.getResourceId(5, 0);
        perm.info.protectionLevel = sa.getInt(3, 0);
        sa.recycle();
        if (perm.info.protectionLevel == -1) {
            outError[0] = "<permission> does not specify protectionLevel";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, attrs, "<permission>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissions.add(perm);
        return perm;
    }

    public Permission parsePermissionTree(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner);
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPermissionTree);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission-tree>", sa, 2, 0, 1)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        sa.recycle();
        int index = perm.info.name.indexOf(46);
        if (index > 0) {
            index = perm.info.name.indexOf(46, index + 1);
        }
        if (index < 0) {
            outError[0] = "<permission-tree> name has less than three segments: " + perm.info.name;
            this.mParseError = -108;
            return null;
        }
        perm.info.descriptionRes = 0;
        perm.info.protectionLevel = 0;
        perm.tree = true;
        if (!this.parseAllMetaData(res, parser, attrs, "<permission-tree>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissions.add(perm);
        return perm;
    }

    public Instrumentation parseInstrumentation(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestInstrumentation);
        if (this.mParseInstrumentationArgs == null) {
            this.mParseInstrumentationArgs = new ParsePackageItemArgs(owner, outError, 2, 0, 1);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = sa;
        Instrumentation a = new Instrumentation(this.mParseInstrumentationArgs, new InstrumentationInfo());
        if (outError[0] != null) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        String str = sa.getNonResourceString(3);
        a.info.targetPackage = str != null ? str.intern() : null;
        a.info.handleProfiling = sa.getBoolean(4, false);
        a.info.functionalTest = sa.getBoolean(5, false);
        sa.recycle();
        if (a.info.targetPackage == null) {
            outError[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, attrs, "<instrumentation>", a, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.instrumentation.add(a);
        return a;
    }

    public boolean parseApplication(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        String str;
        TypedValue v;
        boolean allowBackup;
        String manageSpaceActivity;
        ApplicationInfo ai = owner.applicationInfo;
        String pkgName = owner.applicationInfo.packageName;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestApplication);
        String name = sa.getNonResourceString(3);
        if (name != null) {
            ai.className = PackageParser.buildClassName(pkgName, name, outError);
            if (ai.className == null) {
                sa.recycle();
                this.mParseError = -108;
                return false;
            }
        }
        if ((manageSpaceActivity = sa.getNonResourceString(4)) != null) {
            ai.manageSpaceActivityName = PackageParser.buildClassName(pkgName, manageSpaceActivity, outError);
        }
        if (allowBackup = sa.getBoolean(17, true)) {
            ai.flags |= 0x4000;
            String backupAgent = sa.getNonResourceString(16);
            if (backupAgent != null) {
                ai.backupAgentName = PackageParser.buildClassName(pkgName, backupAgent, outError);
                Log.v(TAG, "android:backupAgent = " + ai.backupAgentName + " from " + pkgName + "+" + backupAgent);
            }
        }
        if ((v = sa.peekValue(1)) != null && (ai.labelRes = v.resourceId) == 0) {
            ai.nonLocalizedLabel = v.coerceToString();
        }
        ai.icon = sa.getResourceId(2, 0);
        ai.theme = sa.getResourceId(0, 0);
        ai.descriptionRes = sa.getResourceId(13, 0);
        if ((flags & 1) != 0 && sa.getBoolean(8, false)) {
            ai.flags |= 8;
        }
        if (sa.getBoolean(10, false)) {
            ai.flags |= 2;
        }
        if (sa.getBoolean(7, true)) {
            ai.flags |= 4;
        }
        if (sa.getBoolean(14, false)) {
            ai.flags |= 0x20;
        }
        if (sa.getBoolean(5, true)) {
            ai.flags |= 0x40;
        }
        if (sa.getBoolean(15, false)) {
            ai.flags |= 0x100;
        }
        ai.permission = (str = sa.getNonResourceString(6)) != null && str.length() > 0 ? str.intern() : null;
        str = sa.getNonResourceString(12);
        ai.taskAffinity = PackageParser.buildTaskAffinityName(ai.packageName, ai.packageName, str, outError);
        if (outError[0] == null) {
            ai.processName = PackageParser.buildProcessName(ai.packageName, null, sa.getNonResourceString(11), flags, this.mSeparateProcesses, outError);
            ai.enabled = sa.getBoolean(9, true);
        }
        sa.recycle();
        if (outError[0] != null) {
            this.mParseError = -108;
            return false;
        }
        int innerDepth = parser.getDepth();
        while (true) {
            Activity a;
            int type = parser.next();
            if (type == 1) break;
            if (type == 3 && parser.getDepth() <= innerDepth) break;
            if (type == 3) continue;
            if (type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, attrs, flags, outError, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, attrs, flags, outError, true);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.receivers.add(a);
                continue;
            }
            if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, attrs, flags, outError);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.services.add(s);
                continue;
            }
            if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, attrs, flags, outError);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                continue;
            }
            if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, attrs, flags, outError);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, attrs, owner.mAppMetaData, outError);
                if (owner.mAppMetaData != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesLibrary);
                String lname = sa.getNonResourceString(0);
                sa.recycle();
                if (lname != null && !owner.usesLibraries.contains(lname)) {
                    owner.usesLibraries.add(lname.intern());
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            Log.w(TAG, "Unknown element under <application>: " + tagName);
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    public boolean parsePackageItemInfo(Package owner, PackageItemInfo outInfo, String[] outError, String tag, TypedArray sa, int nameRes, int labelRes, int iconRes) {
        TypedValue v;
        String name = sa.getNonResourceString(nameRes);
        if (name == null) {
            outError[0] = tag + " does not specify android:name";
            return false;
        }
        outInfo.name = PackageParser.buildClassName(owner.applicationInfo.packageName, name, outError);
        if (outInfo.name == null) {
            return false;
        }
        int iconVal = sa.getResourceId(iconRes, 0);
        if (iconVal != 0) {
            outInfo.icon = iconVal;
            outInfo.nonLocalizedLabel = null;
        }
        if ((v = sa.peekValue(labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.packageName = owner.packageName;
        return true;
    }

    public boolean parseComponentInfo(Package owner, int flags, ComponentInfo outInfo, String[] outError, String tag, TypedArray sa, int nameRes, int labelRes, int iconRes, int processRes, int enabledRes) {
        if (!this.parsePackageItemInfo(owner, outInfo, outError, tag, sa, nameRes, labelRes, iconRes)) {
            return false;
        }
        if (processRes != 0) {
            outInfo.processName = PackageParser.buildProcessName(owner.applicationInfo.packageName, owner.applicationInfo.processName, sa.getNonResourceString(processRes), flags, this.mSeparateProcesses, outError);
        }
        outInfo.enabled = sa.getBoolean(enabledRes, true);
        return outError[0] == null;
    }

    public Activity parseActivity(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError, boolean receiver) throws XmlPullParserException, IOException {
        int type;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestActivity);
        if (this.mParseActivityArgs == null) {
            this.mParseActivityArgs = new ParseComponentArgs(owner, outError, 3, 1, 2, this.mSeparateProcesses, 7, 5);
        }
        this.mParseActivityArgs.tag = receiver ? "<receiver>" : "<activity>";
        this.mParseActivityArgs.sa = sa;
        this.mParseActivityArgs.flags = flags;
        Activity a = new Activity(this.mParseActivityArgs, new ActivityInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(6);
        if (setExported) {
            a.info.exported = sa.getBoolean(6, false);
        }
        a.info.theme = sa.getResourceId(0, 0);
        String str = sa.getNonResourceString(4);
        a.info.permission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonResourceString(8);
        a.info.taskAffinity = PackageParser.buildTaskAffinityName(owner.applicationInfo.packageName, owner.applicationInfo.taskAffinity, str, outError);
        a.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            a.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            a.info.flags |= 2;
        }
        if (sa.getBoolean(11, false)) {
            a.info.flags |= 4;
        }
        if (sa.getBoolean(20, false)) {
            a.info.flags |= 0x80;
        }
        if (sa.getBoolean(17, false)) {
            a.info.flags |= 8;
        }
        if (sa.getBoolean(12, false)) {
            a.info.flags |= 0x10;
        }
        if (sa.getBoolean(13, false)) {
            a.info.flags |= 0x20;
        }
        if (sa.getBoolean(18, (owner.applicationInfo.flags & 0x20) != 0)) {
            a.info.flags |= 0x40;
        }
        if (!receiver) {
            a.info.launchMode = sa.getInt(14, 0);
            a.info.screenOrientation = sa.getInt(15, -1);
            a.info.configChanges = sa.getInt(16, 0);
            a.info.softInputMode = sa.getInt(19, 0);
        } else {
            a.info.launchMode = 0;
            a.info.configChanges = 0;
        }
        sa.recycle();
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, attrs, flags, intent, outError, !receiver)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Log.w(TAG, "Intent filter for activity " + intent + " defines no actions");
                    continue;
                }
                a.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, attrs, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            if (receiver) {
                Log.w(TAG, "Unknown element under <receiver>: " + parser.getName());
            } else {
                Log.w(TAG, "Unknown element under <activity>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    public Activity parseActivityAlias(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String str;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestActivityAlias);
        String targetActivity = sa.getNonResourceString(6);
        if (targetActivity == null) {
            outError[0] = "<activity-alias> does not specify android:targetActivity";
            sa.recycle();
            return null;
        }
        if ((targetActivity = PackageParser.buildClassName(owner.applicationInfo.packageName, targetActivity, outError)) == null) {
            sa.recycle();
            return null;
        }
        if (this.mParseActivityAliasArgs == null) {
            this.mParseActivityAliasArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, this.mSeparateProcesses, 0, 4);
            this.mParseActivityAliasArgs.tag = "<activity-alias>";
        }
        this.mParseActivityAliasArgs.sa = sa;
        this.mParseActivityAliasArgs.flags = flags;
        Activity target = null;
        int NA = owner.activities.size();
        for (int i = 0; i < NA; ++i) {
            Activity t = owner.activities.get(i);
            if (!targetActivity.equals(t.info.name)) continue;
            target = t;
            break;
        }
        if (target == null) {
            outError[0] = "<activity-alias> target activity " + targetActivity + " not found in manifest";
            sa.recycle();
            return null;
        }
        ActivityInfo info = new ActivityInfo();
        info.targetActivity = targetActivity;
        info.configChanges = target.info.configChanges;
        info.flags = target.info.flags;
        info.icon = target.info.icon;
        info.labelRes = target.info.labelRes;
        info.nonLocalizedLabel = target.info.nonLocalizedLabel;
        info.launchMode = target.info.launchMode;
        info.processName = target.info.processName;
        info.screenOrientation = target.info.screenOrientation;
        info.taskAffinity = target.info.taskAffinity;
        info.theme = target.info.theme;
        Activity a = new Activity(this.mParseActivityAliasArgs, info);
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            a.info.exported = sa.getBoolean(5, false);
        }
        if ((str = sa.getNonResourceString(3)) != null) {
            a.info.permission = str.length() > 0 ? str.toString().intern() : null;
        }
        sa.recycle();
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, attrs, flags, intent, outError, true)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Log.w(TAG, "Intent filter for activity alias " + intent + " defines no actions");
                    continue;
                }
                a.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, attrs, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            Log.w(TAG, "Unknown element under <activity-alias>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    public Provider parseProvider(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestProvider);
        if (this.mParseProviderArgs == null) {
            this.mParseProviderArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, this.mSeparateProcesses, 8, 6);
            this.mParseProviderArgs.tag = "<provider>";
        }
        this.mParseProviderArgs.sa = sa;
        this.mParseProviderArgs.flags = flags;
        Provider p = new Provider(this.mParseProviderArgs, new ProviderInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        p.info.exported = sa.getBoolean(7, true);
        String cpname = sa.getNonResourceString(10);
        p.info.isSyncable = sa.getBoolean(11, false);
        String permission2 = sa.getNonResourceString(3);
        String str = sa.getNonResourceString(4);
        if (str == null) {
            str = permission2;
        }
        p.info.readPermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonResourceString(5);
        if (str == null) {
            str = permission2;
        }
        p.info.writePermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        p.info.grantUriPermissions = sa.getBoolean(13, false);
        p.info.multiprocess = sa.getBoolean(9, false);
        p.info.initOrder = sa.getInt(12, 0);
        sa.recycle();
        if (cpname == null) {
            outError[0] = "<provider> does not incude authorities attribute";
            return null;
        }
        p.info.authority = cpname.intern();
        if (!this.parseProviderTags(res, parser, attrs, p, outError)) {
            return null;
        }
        return p;
    }

    public boolean parseProviderTags(Resources res, XmlPullParser parser, AttributeSet attrs, Provider outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            PatternMatcher pa;
            TypedArray sa;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, attrs, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            if (parser.getName().equals("grant-uri-permission")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestGrantUriPermission);
                pa = null;
                String str = sa.getNonResourceString(0);
                if (str != null) {
                    pa = new PatternMatcher(str, 0);
                }
                if ((str = sa.getNonResourceString(1)) != null) {
                    pa = new PatternMatcher(str, 1);
                }
                if ((str = sa.getNonResourceString(2)) != null) {
                    pa = new PatternMatcher(str, 2);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.uriPermissionPatterns == null) {
                        outInfo.info.uriPermissionPatterns = new PatternMatcher[1];
                        outInfo.info.uriPermissionPatterns[0] = pa;
                    } else {
                        int N = outInfo.info.uriPermissionPatterns.length;
                        PatternMatcher[] newp = new PatternMatcher[N + 1];
                        System.arraycopy(outInfo.info.uriPermissionPatterns, 0, newp, 0, N);
                        newp[N] = pa;
                        outInfo.info.uriPermissionPatterns = newp;
                    }
                } else {
                    Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
                    Log.w(TAG, "No path, pathPrefix, or pathPattern for <path-permission>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                outInfo.info.grantUriPermissions = true;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parser.getName().equals("path-permission")) {
                String writePermission;
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPathPermission);
                pa = null;
                String permission2 = sa.getNonResourceString(0);
                String readPermission = sa.getNonResourceString(1);
                if (readPermission == null) {
                    readPermission = permission2;
                }
                if ((writePermission = sa.getNonResourceString(2)) == null) {
                    writePermission = permission2;
                }
                boolean havePerm = false;
                if (readPermission != null) {
                    readPermission = readPermission.intern();
                    havePerm = true;
                }
                if (writePermission != null) {
                    writePermission = readPermission.intern();
                    havePerm = true;
                }
                if (!havePerm) {
                    Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
                    Log.w(TAG, "No readPermission or writePermssion for <path-permission>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String path = sa.getNonResourceString(3);
                if (path != null) {
                    pa = new PathPermission(path, 0, readPermission, writePermission);
                }
                if ((path = sa.getNonResourceString(4)) != null) {
                    pa = new PathPermission(path, 1, readPermission, writePermission);
                }
                if ((path = sa.getNonResourceString(5)) != null) {
                    pa = new PathPermission(path, 2, readPermission, writePermission);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.pathPermissions == null) {
                        outInfo.info.pathPermissions = new PathPermission[1];
                        outInfo.info.pathPermissions[0] = pa;
                    } else {
                        int N = outInfo.info.pathPermissions.length;
                        PathPermission[] newp = new PathPermission[N + 1];
                        System.arraycopy(outInfo.info.pathPermissions, 0, newp, 0, N);
                        newp[N] = pa;
                        outInfo.info.pathPermissions = newp;
                    }
                } else {
                    Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
                    Log.w(TAG, "No path, pathPrefix, or pathPattern for <path-permission>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            Log.w(TAG, "Unknown element under <provider>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    public Service parseService(Package owner, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String str;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestService);
        if (this.mParseServiceArgs == null) {
            this.mParseServiceArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, this.mSeparateProcesses, 6, 4);
            this.mParseServiceArgs.tag = "<service>";
        }
        this.mParseServiceArgs.sa = sa;
        this.mParseServiceArgs.flags = flags;
        Service s = new Service(this.mParseServiceArgs, new ServiceInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            s.info.exported = sa.getBoolean(5, false);
        }
        s.info.permission = (str = sa.getNonResourceString(3)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        sa.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ServiceIntentInfo intent = new ServiceIntentInfo(s);
                if (!this.parseIntent(res, parser, attrs, flags, intent, outError, false)) {
                    return null;
                }
                s.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                s.metaData = this.parseMetaData(res, parser, attrs, s.metaData, outError);
                if (s.metaData != null) continue;
                return null;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            Log.w(TAG, "Unknown element under <service>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            s.info.exported = s.intents.size() > 0;
        }
        return s;
    }

    public boolean parseAllMetaData(Resources res, XmlPullParser parser, AttributeSet attrs, String tag, Component outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, attrs, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            Log.w(TAG, "Unknown element under " + tag + ": " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    public Bundle parseMetaData(Resources res, XmlPullParser parser, AttributeSet attrs, Bundle data, String[] outError) throws XmlPullParserException, IOException {
        String name;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestMetaData);
        if (data == null) {
            data = new Bundle();
        }
        if ((name = sa.getNonResourceString(0)) == null) {
            outError[0] = "<meta-data> requires an android:name attribute";
            sa.recycle();
            return null;
        }
        name = name.intern();
        TypedValue v = sa.peekValue(2);
        if (v != null && v.resourceId != 0) {
            data.putInt(name, v.resourceId);
        } else {
            v = sa.peekValue(1);
            if (v != null) {
                if (v.type == 3) {
                    CharSequence cs2 = v.coerceToString();
                    data.putString(name, cs2 != null ? ((Object)cs2).toString().intern() : null);
                } else if (v.type == 18) {
                    data.putBoolean(name, v.data != 0);
                } else if (v.type >= 16 && v.type <= 31) {
                    data.putInt(name, v.data);
                } else if (v.type == 4) {
                    data.putFloat(name, v.getFloat());
                } else {
                    Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
                    Log.w(TAG, "<meta-data> only supports string, integer, float, color, boolean, and resource reference types");
                }
            } else {
                outError[0] = "<meta-data> requires an android:value or android:resource attribute";
                data = null;
            }
        }
        sa.recycle();
        XmlUtils.skipCurrentTag(parser);
        return data;
    }

    public boolean parseIntent(Resources res, XmlPullParser parser, AttributeSet attrs, int flags, IntentInfo outInfo, String[] outError, boolean isActivity) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestIntentFilter);
        int priority = sa.getInt(2, 0);
        if (priority > 0 && isActivity && (flags & 1) == 0) {
            Log.w(TAG, "Activity with priority > 0, forcing to 0 at " + parser.getPositionDescription());
            priority = 0;
        }
        outInfo.setPriority(priority);
        TypedValue v = sa.peekValue(0);
        if (v != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.icon = sa.getResourceId(1, 0);
        sa.recycle();
        int outerDepth = parser.getDepth();
        while (true) {
            String value;
            int type = parser.next();
            if (type == 1) break;
            if (type == 3 && parser.getDepth() <= outerDepth) break;
            if (type == 3) continue;
            if (type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("action")) {
                value = attrs.getAttributeValue(ANDROID_RESOURCES, "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addAction(value);
                continue;
            }
            if (nodeName.equals("category")) {
                value = attrs.getAttributeValue(ANDROID_RESOURCES, "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addCategory(value);
                continue;
            }
            if (nodeName.equals("data")) {
                sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestData);
                String str = sa.getNonResourceString(0);
                if (str != null) {
                    try {
                        outInfo.addDataType(str);
                    }
                    catch (IntentFilter.MalformedMimeTypeException e) {
                        outError[0] = e.toString();
                        sa.recycle();
                        return false;
                    }
                }
                if ((str = sa.getNonResourceString(1)) != null) {
                    outInfo.addDataScheme(str);
                }
                String host = sa.getNonResourceString(2);
                String port = sa.getNonResourceString(3);
                if (host != null) {
                    outInfo.addDataAuthority(host, port);
                }
                if ((str = sa.getNonResourceString(4)) != null) {
                    outInfo.addDataPath(str, 0);
                }
                if ((str = sa.getNonResourceString(5)) != null) {
                    outInfo.addDataPath(str, 1);
                }
                if ((str = sa.getNonResourceString(6)) != null) {
                    outInfo.addDataPath(str, 2);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            Log.w(TAG, "Unknown element under <intent-filter>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        outInfo.hasDefault = outInfo.hasCategory("android.intent.category.DEFAULT");
        return true;
    }

    public static boolean copyNeeded(int flags, Package p, Bundle metaData) {
        if ((flags & 0x80) != 0 && (metaData != null || p.mAppMetaData != null)) {
            return true;
        }
        return (flags & 0x400) != 0 && p.usesLibraryFiles != null;
    }

    public static ApplicationInfo generateApplicationInfo(Package p, int flags) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, p, null)) {
            if (!sCompatibilityModeEnabled) {
                p.applicationInfo.disableCompatibilityMode();
            }
            return p.applicationInfo;
        }
        ApplicationInfo ai = new ApplicationInfo(p.applicationInfo);
        if ((flags & 0x80) != 0) {
            ai.metaData = p.mAppMetaData;
        }
        if ((flags & 0x400) != 0) {
            ai.sharedLibraryFiles = p.usesLibraryFiles;
        }
        if (!sCompatibilityModeEnabled) {
            ai.disableCompatibilityMode();
        }
        return ai;
    }

    public static PermissionInfo generatePermissionInfo(Permission p, int flags) {
        if (p == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return p.info;
        }
        PermissionInfo pi = new PermissionInfo(p.info);
        pi.metaData = p.metaData;
        return pi;
    }

    public static PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup pg, int flags) {
        if (pg == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return pg.info;
        }
        PermissionGroupInfo pgi = new PermissionGroupInfo(pg.info);
        pgi.metaData = pg.metaData;
        return pgi;
    }

    public static ActivityInfo generateActivityInfo(Activity a, int flags) {
        if (a == null) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, a.owner, a.metaData)) {
            return a.info;
        }
        ActivityInfo ai = new ActivityInfo(a.info);
        ai.metaData = a.metaData;
        ai.applicationInfo = PackageParser.generateApplicationInfo(a.owner, flags);
        return ai;
    }

    public static ServiceInfo generateServiceInfo(Service s, int flags) {
        if (s == null) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, s.owner, s.metaData)) {
            return s.info;
        }
        ServiceInfo si = new ServiceInfo(s.info);
        si.metaData = s.metaData;
        si.applicationInfo = PackageParser.generateApplicationInfo(s.owner, flags);
        return si;
    }

    public static ProviderInfo generateProviderInfo(Provider p, int flags) {
        if (p == null) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p.owner, p.metaData) || (flags & 0x800) == 0 && p.info.uriPermissionPatterns != null)) {
            return p.info;
        }
        ProviderInfo pi = new ProviderInfo(p.info);
        pi.metaData = p.metaData;
        if ((flags & 0x800) == 0) {
            pi.uriPermissionPatterns = null;
        }
        pi.applicationInfo = PackageParser.generateApplicationInfo(p.owner, flags);
        return pi;
    }

    public static InstrumentationInfo generateInstrumentationInfo(Instrumentation i, int flags) {
        if (i == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return i.info;
        }
        InstrumentationInfo ii = new InstrumentationInfo(i.info);
        ii.metaData = i.metaData;
        return ii;
    }

    public static void setCompatibilityModeEnabled(boolean compatibilityModeEnabled) {
        sCompatibilityModeEnabled = compatibilityModeEnabled;
    }

    static {
        sCompatibilityModeEnabled = true;
    }

    public static class ServiceIntentInfo
    extends IntentInfo {
        public final Service service;

        public ServiceIntentInfo(Service _service) {
            this.service = _service;
        }

        public String toString() {
            return "ServiceIntentInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.service.info.name + "}";
        }
    }

    public static class ActivityIntentInfo
    extends IntentInfo {
        public final Activity activity;

        public ActivityIntentInfo(Activity _activity) {
            this.activity = _activity;
        }

        public String toString() {
            return "ActivityIntentInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.activity.info.name + "}";
        }
    }

    public static class IntentInfo
    extends IntentFilter {
        public boolean hasDefault;
        public int labelRes;
        public CharSequence nonLocalizedLabel;
        public int icon;
    }

    public static class Instrumentation
    extends Component {
        public final InstrumentationInfo info;

        public Instrumentation(ParsePackageItemArgs args, InstrumentationInfo _info) {
            super(args, _info);
            this.info = _info;
        }

        public String toString() {
            return "Instrumentation{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.component.flattenToString() + "}";
        }
    }

    public static class Provider
    extends Component {
        public final ProviderInfo info;
        public boolean syncable;

        public Provider(ParseComponentArgs args, ProviderInfo _info) {
            super(args, _info);
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
            this.syncable = false;
        }

        public Provider(Provider existingProvider) {
            super(existingProvider);
            this.info = existingProvider.info;
            this.syncable = existingProvider.syncable;
        }

        public String toString() {
            return "Provider{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Service
    extends Component<ServiceIntentInfo> {
        public final ServiceInfo info;

        public Service(ParseComponentArgs args, ServiceInfo _info) {
            super(args, _info);
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        public String toString() {
            return "Service{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.component.flattenToString() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Activity
    extends Component<ActivityIntentInfo> {
        public final ActivityInfo info;

        public Activity(ParseComponentArgs args, ActivityInfo _info) {
            super(args, _info);
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        public String toString() {
            return "Activity{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.component.flattenToString() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PermissionGroup
    extends Component<IntentInfo> {
        public final PermissionGroupInfo info;

        public PermissionGroup(Package _owner) {
            super(_owner);
            this.info = new PermissionGroupInfo();
        }

        public PermissionGroup(Package _owner, PermissionGroupInfo _info) {
            super(_owner);
            this.info = _info;
        }

        public String toString() {
            return "PermissionGroup{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Permission
    extends Component<IntentInfo> {
        public final PermissionInfo info;
        public boolean tree;
        public PermissionGroup group;

        public Permission(Package _owner) {
            super(_owner);
            this.info = new PermissionInfo();
        }

        public Permission(Package _owner, PermissionInfo _info) {
            super(_owner);
            this.info = _info;
        }

        public String toString() {
            return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Component<II extends IntentInfo> {
        public final Package owner;
        public final ArrayList<II> intents;
        public final ComponentName component;
        public final String componentShortName;
        public Bundle metaData;

        public Component(Package _owner) {
            this.owner = _owner;
            this.intents = null;
            this.component = null;
            this.componentShortName = null;
        }

        public Component(ParsePackageItemArgs args, PackageItemInfo outInfo) {
            TypedValue v;
            this.owner = args.owner;
            this.intents = new ArrayList(0);
            String name = args.sa.getNonResourceString(args.nameRes);
            if (name == null) {
                this.component = null;
                this.componentShortName = null;
                args.outError[0] = args.tag + " does not specify android:name";
                return;
            }
            outInfo.name = PackageParser.buildClassName(this.owner.applicationInfo.packageName, name, args.outError);
            if (outInfo.name == null) {
                this.component = null;
                this.componentShortName = null;
                args.outError[0] = args.tag + " does not have valid android:name";
                return;
            }
            this.component = new ComponentName(this.owner.applicationInfo.packageName, outInfo.name);
            this.componentShortName = this.component.flattenToShortString();
            int iconVal = args.sa.getResourceId(args.iconRes, 0);
            if (iconVal != 0) {
                outInfo.icon = iconVal;
                outInfo.nonLocalizedLabel = null;
            }
            if ((v = args.sa.peekValue(args.labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
                outInfo.nonLocalizedLabel = v.coerceToString();
            }
            outInfo.packageName = this.owner.packageName;
        }

        public Component(ParseComponentArgs args, ComponentInfo outInfo) {
            this((ParsePackageItemArgs)args, (PackageItemInfo)outInfo);
            if (args.outError[0] != null) {
                return;
            }
            if (args.processRes != 0) {
                outInfo.processName = PackageParser.buildProcessName(this.owner.applicationInfo.packageName, this.owner.applicationInfo.processName, args.sa.getNonResourceString(args.processRes), args.flags, args.sepProcesses, args.outError);
            }
            outInfo.enabled = args.sa.getBoolean(args.enabledRes, true);
        }

        public Component(Component<II> clone) {
            this.owner = clone.owner;
            this.intents = clone.intents;
            this.component = clone.component;
            this.componentShortName = clone.componentShortName;
            this.metaData = clone.metaData;
        }
    }

    public static class Package {
        public final String packageName;
        public final ApplicationInfo applicationInfo = new ApplicationInfo();
        public final ArrayList<Permission> permissions = new ArrayList(0);
        public final ArrayList<PermissionGroup> permissionGroups = new ArrayList(0);
        public final ArrayList<Activity> activities = new ArrayList(0);
        public final ArrayList<Activity> receivers = new ArrayList(0);
        public final ArrayList<Provider> providers = new ArrayList(0);
        public final ArrayList<Service> services = new ArrayList(0);
        public final ArrayList<Instrumentation> instrumentation = new ArrayList(0);
        public final ArrayList<String> requestedPermissions = new ArrayList();
        public ArrayList<String> protectedBroadcasts;
        public final ArrayList<String> usesLibraries = new ArrayList();
        public String[] usesLibraryFiles = null;
        public Bundle mAppMetaData = null;
        public String mPath;
        public int mVersionCode;
        public String mVersionName;
        public String mSharedUserId;
        public int mSharedUserLabel;
        public Signature[] mSignatures;
        public int mPreferredOrder = 0;
        public boolean mForwardLocked;
        public String mScanPath;
        public boolean mDidDexOpt;
        public Object mExtras;
        public final ArrayList<ConfigurationInfo> configPreferences = new ArrayList();

        public Package(String _name) {
            this.packageName = _name;
            this.applicationInfo.packageName = _name;
            this.applicationInfo.uid = -1;
        }

        public String toString() {
            return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }
    }

    public static class ParseComponentArgs
    extends ParsePackageItemArgs {
        public final String[] sepProcesses;
        public final int processRes;
        public final int enabledRes;
        public int flags;

        public ParseComponentArgs(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, String[] _sepProcesses, int _processRes, int _enabledRes) {
            super(_owner, _outError, _nameRes, _labelRes, _iconRes);
            this.sepProcesses = _sepProcesses;
            this.processRes = _processRes;
            this.enabledRes = _enabledRes;
        }
    }

    public static class ParsePackageItemArgs {
        public final Package owner;
        public final String[] outError;
        public final int nameRes;
        public final int labelRes;
        public final int iconRes;
        public String tag;
        public TypedArray sa;

        public ParsePackageItemArgs(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes) {
            this.owner = _owner;
            this.outError = _outError;
            this.nameRes = _nameRes;
            this.labelRes = _labelRes;
            this.iconRes = _iconRes;
        }
    }

    public static class NewPermissionInfo {
        public final String name;
        public final int sdkVersion;
        public final int fileVersion;

        public NewPermissionInfo(String name, int sdkVersion, int fileVersion) {
            this.name = name;
            this.sdkVersion = sdkVersion;
            this.fileVersion = fileVersion;
        }
    }
}

