/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmuilib.log.event.EventDisplay;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EventValueSelector
extends Dialog {
    private static final int DLG_WIDTH = 400;
    private static final int DLG_HEIGHT = 300;
    private Shell mParent;
    private Shell mShell;
    private boolean mEditStatus;
    private Combo mEventCombo;
    private Combo mValueCombo;
    private Combo mSeriesCombo;
    private Button mDisplayPidCheckBox;
    private Combo mFilterCombo;
    private Combo mFilterMethodCombo;
    private Text mFilterValue;
    private Button mOkButton;
    private EventLogParser mLogParser;
    private EventDisplay.OccurrenceDisplayDescriptor mDescriptor;
    private Integer[] mEventTags;
    private final ArrayList<Integer> mSeriesIndices = new ArrayList();

    public EventValueSelector(Shell parent) {
        super(parent, 67680);
    }

    boolean open(Class<? extends EventDisplay.OccurrenceDisplayDescriptor> descriptorClass, EventLogParser logParser) {
        try {
            EventDisplay.OccurrenceDisplayDescriptor descriptor = descriptorClass.newInstance();
            this.setModified();
            return this.open(descriptor, logParser);
        }
        catch (InstantiationException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    boolean open(EventDisplay.OccurrenceDisplayDescriptor descriptor, EventLogParser logParser) {
        if (descriptor instanceof EventDisplay.ValueDisplayDescriptor) {
            this.mDescriptor = new EventDisplay.ValueDisplayDescriptor((EventDisplay.ValueDisplayDescriptor)descriptor);
        } else if (descriptor instanceof EventDisplay.OccurrenceDisplayDescriptor) {
            this.mDescriptor = new EventDisplay.OccurrenceDisplayDescriptor(descriptor);
        } else {
            return false;
        }
        this.mLogParser = logParser;
        this.createUI();
        if (this.mParent == null || this.mShell == null) {
            return false;
        }
        this.loadValueDescriptor();
        this.checkValidity();
        try {
            this.mShell.setMinimumSize(400, 300);
            Rectangle r = this.mParent.getBounds();
            int cx = r.x + r.width / 2;
            int x = cx - 200;
            int cy = r.y + r.height / 2;
            int y = cy - 150;
            this.mShell.setBounds(x, y, 400, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mShell.layout();
        this.mShell.open();
        Display display = this.mParent.getDisplay();
        while (!this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.mEditStatus;
    }

    EventDisplay.OccurrenceDisplayDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    private void createUI() {
        this.mParent = this.getParent();
        this.mShell = new Shell(this.mParent, this.getStyle());
        this.mShell.setText("Event Display Configuration");
        this.mShell.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)this.mShell, 0);
        l.setText("Event:");
        this.mEventCombo = new Combo((Composite)this.mShell, 12);
        this.mEventCombo.setLayoutData((Object)new GridData(768));
        Map eventTagMap = this.mLogParser.getTagMap();
        Map eventInfoMap = this.mLogParser.getEventInfoMap();
        Set keys = eventTagMap.keySet();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer i : keys) {
            if (eventInfoMap.get(i) == null) continue;
            String eventName = (String)eventTagMap.get(i);
            this.mEventCombo.add(eventName);
            list.add(i);
        }
        this.mEventTags = list.toArray(new Integer[list.size()]);
        this.mEventCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventValueSelector.this.handleEventComboSelection();
                EventValueSelector.this.setModified();
            }
        });
        l = new Label((Composite)this.mShell, 0);
        l.setText("Value:");
        this.mValueCombo = new Combo((Composite)this.mShell, 12);
        this.mValueCombo.setLayoutData((Object)new GridData(768));
        this.mValueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventValueSelector.this.handleValueComboSelection();
                EventValueSelector.this.setModified();
            }
        });
        l = new Label((Composite)this.mShell, 0);
        l.setText("Series Name:");
        this.mSeriesCombo = new Combo((Composite)this.mShell, 12);
        this.mSeriesCombo.setLayoutData((Object)new GridData(768));
        this.mSeriesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventValueSelector.this.handleSeriesComboSelection();
                EventValueSelector.this.setModified();
            }
        });
        GridData gd = new GridData();
        new Composite((Composite)this.mShell, 0).setLayoutData((Object)gd);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.mDisplayPidCheckBox = new Button((Composite)this.mShell, 32);
        this.mDisplayPidCheckBox.setText("Also Show pid");
        this.mDisplayPidCheckBox.setEnabled(false);
        this.mDisplayPidCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((EventValueSelector)EventValueSelector.this).mDescriptor.includePid = EventValueSelector.this.mDisplayPidCheckBox.getSelection();
                EventValueSelector.this.setModified();
            }
        });
        l = new Label((Composite)this.mShell, 0);
        l.setText("Filter By:");
        this.mFilterCombo = new Combo((Composite)this.mShell, 12);
        this.mFilterCombo.setLayoutData((Object)new GridData(768));
        this.mFilterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventValueSelector.this.handleFilterComboSelection();
                EventValueSelector.this.setModified();
            }
        });
        l = new Label((Composite)this.mShell, 0);
        l.setText("Filter Method:");
        this.mFilterMethodCombo = new Combo((Composite)this.mShell, 12);
        this.mFilterMethodCombo.setLayoutData((Object)new GridData(768));
        for (EventContainer.CompareMethod method : EventContainer.CompareMethod.values()) {
            this.mFilterMethodCombo.add(method.toString());
        }
        this.mFilterMethodCombo.select(0);
        this.mFilterMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventValueSelector.this.handleFilterMethodComboSelection();
                EventValueSelector.this.setModified();
            }
        });
        l = new Label((Composite)this.mShell, 0);
        l.setText("Filter Value:");
        this.mFilterValue = new Text((Composite)this.mShell, 2052);
        this.mFilterValue.setLayoutData((Object)new GridData(768));
        this.mFilterValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int index;
                if (((EventValueSelector)EventValueSelector.this).mDescriptor.filterValueIndex != -1 && (index = EventValueSelector.this.mEventCombo.getSelectionIndex()) != -1) {
                    int eventTag;
                    ((EventValueSelector)EventValueSelector.this).mDescriptor.eventTag = eventTag = EventValueSelector.this.mEventTags[index].intValue();
                    EventValueDescription valueDesc = ((EventValueDescription[])EventValueSelector.this.mLogParser.getEventInfoMap().get(eventTag))[((EventValueSelector)EventValueSelector.this).mDescriptor.filterValueIndex];
                    ((EventValueSelector)EventValueSelector.this).mDescriptor.filterValue = valueDesc.getObjectFromString(EventValueSelector.this.mFilterValue.getText().trim());
                    EventValueSelector.this.setModified();
                }
            }
        });
        l = new Label((Composite)this.mShell, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite buttonComp = new Composite((Composite)this.mShell, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(6, true);
        buttonComp.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Composite padding = new Composite((Composite)this.mShell, 0);
        padding.setLayoutData((Object)new GridData(768));
        this.mOkButton = new Button(buttonComp, 8);
        this.mOkButton.setText("OK");
        this.mOkButton.setLayoutData((Object)new GridData(2));
        this.mOkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventValueSelector.this.mShell.close();
            }
        });
        padding = new Composite((Composite)this.mShell, 0);
        padding.setLayoutData((Object)new GridData(768));
        padding = new Composite((Composite)this.mShell, 0);
        padding.setLayoutData((Object)new GridData(768));
        Button cancelButton = new Button(buttonComp, 8);
        cancelButton.setText("Cancel");
        cancelButton.setLayoutData((Object)new GridData(2));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventValueSelector.this.mEditStatus = false;
                EventValueSelector.this.mShell.close();
            }
        });
        padding = new Composite((Composite)this.mShell, 0);
        padding.setLayoutData((Object)new GridData(768));
        this.mShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = true;
            }
        });
    }

    private void setModified() {
        this.mEditStatus = true;
    }

    private void handleEventComboSelection() {
        int index = this.mEventCombo.getSelectionIndex();
        if (index != -1) {
            int eventTag;
            this.mDescriptor.eventTag = eventTag = this.mEventTags[index].intValue();
            EventValueDescription[] values = (EventValueDescription[])this.mLogParser.getEventInfoMap().get(eventTag);
            this.mValueCombo.removeAll();
            if (values != null) {
                if (this.mDescriptor instanceof EventDisplay.ValueDisplayDescriptor) {
                    EventDisplay.ValueDisplayDescriptor valueDescriptor = (EventDisplay.ValueDisplayDescriptor)this.mDescriptor;
                    this.mValueCombo.setEnabled(true);
                    for (EventValueDescription value : values) {
                        this.mValueCombo.add(value.toString());
                    }
                    if (valueDescriptor.valueIndex != -1) {
                        this.mValueCombo.select(valueDescriptor.valueIndex);
                    } else {
                        this.mValueCombo.clearSelection();
                    }
                } else {
                    this.mValueCombo.setEnabled(false);
                }
                this.mSeriesCombo.removeAll();
                this.mSeriesCombo.setEnabled(false);
                this.mSeriesIndices.clear();
                int axisIndex = 0;
                int selectionIndex = -1;
                for (EventValueDescription value : values) {
                    if (value.getEventValueType() == EventContainer.EventValueType.STRING) {
                        this.mSeriesCombo.add(value.getName());
                        this.mSeriesCombo.setEnabled(true);
                        this.mSeriesIndices.add(axisIndex);
                        if (this.mDescriptor.seriesValueIndex != -1 && this.mDescriptor.seriesValueIndex == axisIndex) {
                            selectionIndex = axisIndex;
                        }
                    }
                    ++axisIndex;
                }
                if (this.mSeriesCombo.isEnabled()) {
                    this.mSeriesCombo.add("default (pid)", 0);
                    this.mSeriesIndices.add(0, -1);
                    this.mSeriesCombo.select(selectionIndex + 1);
                    if (selectionIndex >= 0) {
                        this.mDisplayPidCheckBox.setSelection(this.mDescriptor.includePid);
                        this.mDisplayPidCheckBox.setEnabled(true);
                    } else {
                        this.mDisplayPidCheckBox.setEnabled(false);
                        this.mDisplayPidCheckBox.setSelection(false);
                    }
                } else {
                    this.mDisplayPidCheckBox.setSelection(false);
                    this.mDisplayPidCheckBox.setEnabled(false);
                }
                this.mFilterCombo.setEnabled(true);
                this.mFilterCombo.removeAll();
                this.mFilterCombo.add("(no filter)");
                for (EventValueDescription value : values) {
                    this.mFilterCombo.add(value.toString());
                }
                this.mFilterCombo.select(this.mDescriptor.filterValueIndex + 1);
                this.mFilterMethodCombo.select(this.getFilterMethodIndex(this.mDescriptor.filterCompareMethod));
                if (this.mDescriptor.filterValueIndex != -1) {
                    EventValueDescription valueInfo = values[this.mDescriptor.filterValueIndex];
                    if (valueInfo.checkForType(this.mDescriptor.filterValue)) {
                        this.mFilterValue.setText(this.mDescriptor.filterValue.toString());
                    } else {
                        this.mFilterValue.setText("");
                    }
                } else {
                    this.mFilterValue.setText("");
                }
            } else {
                this.disableSubCombos();
            }
        } else {
            this.disableSubCombos();
        }
        this.checkValidity();
    }

    private void disableSubCombos() {
        this.mValueCombo.removeAll();
        this.mValueCombo.clearSelection();
        this.mValueCombo.setEnabled(false);
        this.mSeriesCombo.removeAll();
        this.mSeriesCombo.clearSelection();
        this.mSeriesCombo.setEnabled(false);
        this.mDisplayPidCheckBox.setEnabled(false);
        this.mDisplayPidCheckBox.setSelection(false);
        this.mFilterCombo.removeAll();
        this.mFilterCombo.clearSelection();
        this.mFilterCombo.setEnabled(false);
        this.mFilterValue.setEnabled(false);
        this.mFilterValue.setText("");
        this.mFilterMethodCombo.setEnabled(false);
    }

    private void handleValueComboSelection() {
        int index;
        EventDisplay.ValueDisplayDescriptor valueDescriptor = (EventDisplay.ValueDisplayDescriptor)this.mDescriptor;
        valueDescriptor.valueIndex = index = this.mValueCombo.getSelectionIndex();
        int eventIndex = this.mEventCombo.getSelectionIndex();
        int eventTag = this.mEventTags[eventIndex];
        EventValueDescription[] values = (EventValueDescription[])this.mLogParser.getEventInfoMap().get(eventTag);
        valueDescriptor.valueName = values[index].getName();
        this.checkValidity();
    }

    private void handleSeriesComboSelection() {
        int valueIndex;
        int index = this.mSeriesCombo.getSelectionIndex();
        this.mDescriptor.seriesValueIndex = valueIndex = this.mSeriesIndices.get(index).intValue();
        if (index > 0) {
            this.mDisplayPidCheckBox.setEnabled(true);
            this.mDisplayPidCheckBox.setSelection(this.mDescriptor.includePid);
        } else {
            this.mDisplayPidCheckBox.setSelection(false);
            this.mDisplayPidCheckBox.setEnabled(false);
        }
    }

    private void handleFilterComboSelection() {
        int index = this.mFilterCombo.getSelectionIndex();
        this.mDescriptor.filterValueIndex = --index;
        if (index != -1) {
            this.mFilterValue.setEnabled(true);
            this.mFilterMethodCombo.setEnabled(true);
            if (this.mDescriptor.filterValue instanceof String) {
                this.mFilterValue.setText((String)this.mDescriptor.filterValue);
            }
        } else {
            this.mFilterValue.setText("");
            this.mFilterValue.setEnabled(false);
            this.mFilterMethodCombo.setEnabled(false);
        }
    }

    private void handleFilterMethodComboSelection() {
        EventContainer.CompareMethod method;
        int index = this.mFilterMethodCombo.getSelectionIndex();
        this.mDescriptor.filterCompareMethod = method = EventContainer.CompareMethod.values()[index];
    }

    private int getFilterMethodIndex(EventContainer.CompareMethod filterCompareMethod) {
        EventContainer.CompareMethod[] values = EventContainer.CompareMethod.values();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != filterCompareMethod) continue;
            return i;
        }
        return -1;
    }

    private void loadValueDescriptor() {
        int eventIndex = 0;
        int comboIndex = -1;
        Integer[] arr$ = this.mEventTags;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            if (i == this.mDescriptor.eventTag) {
                comboIndex = eventIndex;
                break;
            }
            ++eventIndex;
        }
        if (comboIndex == -1) {
            this.mEventCombo.clearSelection();
        } else {
            this.mEventCombo.select(comboIndex);
        }
        this.handleEventComboSelection();
    }

    private void checkValidity() {
        this.mOkButton.setEnabled(this.mEventCombo.getSelectionIndex() != -1 && (!(this.mDescriptor instanceof EventDisplay.ValueDisplayDescriptor) || this.mValueCombo.getSelectionIndex() != -1));
    }
}

