/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui.model;

import com.android.hierarchyviewer.scene.ViewNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class PropertiesTableModel
extends DefaultTableModel {
    private List<ViewNode.Property> properties;
    private List<ViewNode.Property> privateProperties = new ArrayList<ViewNode.Property>();

    public PropertiesTableModel(ViewNode node) {
        this.properties = node.properties;
        this.loadPrivateProperties(node);
    }

    private void loadPrivateProperties(ViewNode node) {
        int x = node.left;
        int y = node.top;
        ViewNode p = node.parent;
        while (p != null) {
            x += p.left - p.scrollX;
            y += p.top - p.scrollY;
            p = p.parent;
        }
        ViewNode.Property property = new ViewNode.Property();
        property.name = "absolute_x";
        property.value = String.valueOf(x);
        this.privateProperties.add(property);
        property = new ViewNode.Property();
        property.name = "absolute_y";
        property.value = String.valueOf(y);
        this.privateProperties.add(property);
    }

    public int getRowCount() {
        return (this.privateProperties == null ? 0 : this.privateProperties.size()) + (this.properties == null ? 0 : this.properties.size());
    }

    public Object getValueAt(int row, int column) {
        ViewNode.Property property = row < this.privateProperties.size() ? this.privateProperties.get(row) : this.properties.get(row - this.privateProperties.size());
        return column == 0 ? property.name : property.value;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        return column == 0 ? "Property" : "Value";
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }
}

