/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ViewNode {
    public String id;
    public String name;
    public List<Property> properties = new ArrayList<Property>();
    public Map<String, Property> namedProperties = new HashMap<String, Property>();
    public ViewNode parent;
    public List<ViewNode> children = new ArrayList<ViewNode>();
    public Image image;
    public int left;
    public int top;
    public int width;
    public int height;
    public int scrollX;
    public int scrollY;
    public int paddingLeft;
    public int paddingRight;
    public int paddingTop;
    public int paddingBottom;
    public int marginLeft;
    public int marginRight;
    public int marginTop;
    public int marginBottom;
    public int baseline;
    public boolean willNotDraw;
    public boolean hasMargins;
    boolean hasFocus;
    int index;
    public boolean decoded;
    public boolean filtered;
    private String shortName;
    private StateListener listener;

    void decode() {
        this.id = this.namedProperties.get((Object)"mID").value;
        this.left = this.getInt("mLeft", 0);
        this.top = this.getInt("mTop", 0);
        this.width = this.getInt("getWidth()", 0);
        this.height = this.getInt("getHeight()", 0);
        this.scrollX = this.getInt("mScrollX", 0);
        this.scrollY = this.getInt("mScrollY", 0);
        this.paddingLeft = this.getInt("mPaddingLeft", 0);
        this.paddingRight = this.getInt("mPaddingRight", 0);
        this.paddingTop = this.getInt("mPaddingTop", 0);
        this.paddingBottom = this.getInt("mPaddingBottom", 0);
        this.marginLeft = this.getInt("layout_leftMargin", Integer.MIN_VALUE);
        this.marginRight = this.getInt("layout_rightMargin", Integer.MIN_VALUE);
        this.marginTop = this.getInt("layout_topMargin", Integer.MIN_VALUE);
        this.marginBottom = this.getInt("layout_bottomMargin", Integer.MIN_VALUE);
        this.baseline = this.getInt("getBaseline()", 0);
        this.willNotDraw = this.getBoolean("willNotDraw()", false);
        this.hasFocus = this.getBoolean("hasFocus()", false);
        this.hasMargins = this.marginLeft != Integer.MIN_VALUE && this.marginRight != Integer.MIN_VALUE && this.marginTop != Integer.MIN_VALUE && this.marginBottom != Integer.MIN_VALUE;
        this.decoded = true;
    }

    private boolean getBoolean(String name, boolean defaultValue) {
        Property p = this.namedProperties.get(name);
        if (p != null) {
            try {
                return Boolean.parseBoolean(p.value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private int getInt(String name, int defaultValue) {
        Property p = this.namedProperties.get(name);
        if (p != null) {
            try {
                return Integer.parseInt(p.value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void filter(Pattern pattern) {
        this.filtered = pattern == null || pattern.pattern().length() == 0 ? false : pattern.matcher(this.shortName).find() || pattern.matcher(this.id).find();
        this.listener.nodeStateChanged(this);
    }

    void computeIndex() {
        this.index = this.parent == null ? 0 : this.parent.children.indexOf(this);
        this.listener.nodeIndexChanged(this);
    }

    void setShortName(String shortName) {
        this.shortName = shortName;
    }

    void setStateListener(StateListener listener) {
        this.listener = listener;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewNode other = (ViewNode)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    static interface StateListener {
        public void nodeStateChanged(ViewNode var1);

        public void nodeIndexChanged(ViewNode var1);
    }

    public static class Property {
        public String name;
        public String value;

        public String toString() {
            return this.name + '=' + this.value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
                return false;
            }
            return this.value == other.value || this.value != null && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 5;
            hash = 61 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 61 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }
    }
}

