/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.device.Window;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.imageio.ImageIO;

public class CaptureLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadCapture(IDevice device, Window window, String params) {
        Socket socket = null;
        BufferedInputStream in = null;
        BufferedWriter out = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            in = new BufferedInputStream(socket.getInputStream());
            out.write("CAPTURE " + window.encode() + " " + params);
            out.newLine();
            out.flush();
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

