/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdklib.repository.SdkRepository;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RepoSource
implements IDescription {
    private String mUrl;
    private final boolean mUserSource;
    private Package[] mPackages;
    private String mDescription;
    private String mFetchError;

    public RepoSource(String url, boolean userSource) {
        if (url.endsWith("/")) {
            url = url + "repository.xml";
        }
        this.mUrl = url;
        this.mUserSource = userSource;
        this.setDefaultDescription();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepoSource) {
            RepoSource rs = (RepoSource)obj;
            return rs.isUserSource() == this.isUserSource() && rs.getUrl().equals(this.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.mUrl.hashCode() ^ Boolean.valueOf(this.mUserSource).hashCode();
    }

    public boolean isUserSource() {
        return this.mUserSource;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Package[] getPackages() {
        return this.mPackages;
    }

    public void clearPackages() {
        this.mPackages = null;
    }

    public String getShortDescription() {
        return this.mUrl;
    }

    public String getLongDescription() {
        return this.mDescription == null ? "" : this.mDescription;
    }

    public String getFetchError() {
        return this.mFetchError;
    }

    public void load(ITaskMonitor monitor, boolean forceHttp) {
        monitor.setProgressMax(4);
        this.setDefaultDescription();
        String url = this.mUrl;
        if (forceHttp) {
            url = url.replaceAll("https://", "http://");
        }
        monitor.setDescription("Fetching %1$s", url);
        monitor.incProgress(1);
        this.mFetchError = null;
        Exception[] exception = new Exception[]{null};
        ByteArrayInputStream xml = this.fetchUrl(url, exception);
        boolean validated = false;
        if (xml != null) {
            monitor.setDescription("Validate XML", new Object[0]);
            validated = this.validateXml(xml, url, monitor);
        }
        if (!validated && !url.endsWith("repository.xml")) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            if ((xml = this.fetchUrl(url = url + "repository.xml", exception)) != null) {
                validated = this.validateXml(xml, url, monitor);
            }
            if (validated) {
                monitor.setResult("Repository found at %1$s", url);
                this.mUrl = url;
            }
        }
        if (!validated) {
            this.mFetchError = "Failed to fetch URL";
            String reason = "Unknown";
            if (exception[0] != null) {
                if (exception[0] instanceof FileNotFoundException) {
                    reason = "File not found";
                } else if (exception[0] instanceof SSLKeyException) {
                    reason = "SSL error. You might want to force download through http in the settings.";
                } else if (exception[0].getMessage() != null) {
                    reason = exception[0].getMessage();
                }
            }
            monitor.setResult("Failed to fetch URL %1$s, reason: %2$s", url, reason);
        }
        monitor.incProgress(1);
        if (xml != null) {
            monitor.setDescription("Parse XML", new Object[0]);
            monitor.incProgress(1);
            this.parsePackages(xml, monitor);
            this.mDescription = this.mPackages == null || this.mPackages.length == 0 ? this.mDescription + "\nNo packages found." : (this.mPackages.length == 1 ? this.mDescription + "\nOne package found." : this.mDescription + String.format("\n%1$d packages found.", this.mPackages.length));
        }
        monitor.incProgress(1);
    }

    private void setDefaultDescription() {
        this.mDescription = this.mUserSource ? String.format("Add-on Source: %1$s", this.mUrl) : String.format("SDK Source: %1$s", this.mUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream fetchUrl(String urlString, Exception[] outException) {
        ByteArrayInputStream byteArrayInputStream;
        block11: {
            URL url = new URL(urlString);
            InputStream is = null;
            int inc = 65536;
            int curr = 0;
            byte[] result = new byte[inc];
            try {
                int n;
                is = url.openStream();
                while ((n = is.read(result, curr, result.length - curr)) != -1) {
                    if ((curr += n) != result.length) continue;
                    byte[] temp = new byte[curr + inc];
                    System.arraycopy(result, 0, temp, 0, curr);
                    result = temp;
                }
                byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    outException[0] = e;
                    return null;
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byteArrayInputStream;
    }

    private boolean validateXml(ByteArrayInputStream xml, String url, ITaskMonitor monitor) {
        try {
            Validator validator = this.getValidator();
            xml.reset();
            validator.validate(new StreamSource(xml));
            return true;
        }
        catch (Exception e) {
            monitor.setResult("XML verification failed for %1$s.\nError: %2$s", url, e.getMessage());
            return false;
        }
    }

    private Validator getValidator() throws SAXException {
        InputStream xsdStream = SdkRepository.getXsdStream();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        Validator validator = schema.newValidator();
        return validator;
    }

    private boolean parsePackages(ByteArrayInputStream xml, ITaskMonitor monitor) {
        try {
            Document doc = this.getDocument(xml);
            Node root = this.getFirstChild(doc, "sdk-repository");
            if (root != null) {
                Node child;
                ArrayList<AddonPackage> packages = new ArrayList<AddonPackage>();
                HashMap<String, String> licenses = new HashMap<String, String>();
                for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Node id;
                    if (child.getNodeType() != 1 || !"http://schemas.android.com/sdk/android/repository/1".equals(child.getNamespaceURI()) || !child.getLocalName().equals("license") || (id = child.getAttributes().getNamedItem("id")) == null) continue;
                    licenses.put(id.getNodeValue(), child.getTextContent());
                }
                for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1 || !"http://schemas.android.com/sdk/android/repository/1".equals(child.getNamespaceURI())) continue;
                    String name = child.getLocalName();
                    Package p = null;
                    try {
                        if ("add-on".equals(name)) {
                            p = new AddonPackage(this, child, licenses);
                        } else if ("extra".equals(name)) {
                            p = new ExtraPackage(this, child, licenses);
                        } else if (!this.mUserSource) {
                            if ("platform".equals(name)) {
                                p = new PlatformPackage(this, child, licenses);
                            } else if ("doc".equals(name)) {
                                p = new DocPackage(this, child, licenses);
                            } else if ("tool".equals(name)) {
                                p = new ToolPackage(this, child, licenses);
                            }
                        }
                        if (p == null) continue;
                        packages.add((AddonPackage)p);
                        monitor.setDescription("Found %1$s", p.getShortDescription());
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.mPackages = packages.toArray(new Package[packages.size()]);
                return true;
            }
        }
        catch (ParserConfigurationException e) {
            monitor.setResult("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException e) {
            monitor.setResult("Failed to parse XML document", new Object[0]);
        }
        catch (IOException e) {
            monitor.setResult("Failed to read XML document", new Object[0]);
        }
        return false;
    }

    private Node getFirstChild(Node node, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !"http://schemas.android.com/sdk/android/repository/1".equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    private Document getDocument(ByteArrayInputStream xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        xml.reset();
        Document doc = builder.parse(new InputSource(xml));
        return doc;
    }
}

