/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformPackage
extends Package {
    private static final String PROP_VERSION = "Platform.Version";
    private static final String PROP_MIN_TOOLS_REV = "Platform.MinToolsRev";
    private final AndroidVersion mVersion;
    private final String mVersionName;
    private final int mMinToolsRevision;
    public static final int MIN_TOOLS_REV_NOT_SPECIFIED = 0;

    PlatformPackage(RepoSource source, Node packageNode, Map<String, String> licenses) {
        super(source, packageNode, licenses);
        this.mVersionName = XmlParserUtils.getXmlString(packageNode, "version");
        int apiLevel = XmlParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = XmlParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mMinToolsRevision = XmlParserUtils.getXmlInt(packageNode, "min-tools-rev", 0);
    }

    PlatformPackage(IAndroidTarget target, Properties props) {
        super(null, props, target.getRevision(), null, target.getDescription(), null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), target.getLocation());
        this.mVersion = target.getVersion();
        this.mVersionName = target.getVersionName();
        this.mMinToolsRevision = Integer.parseInt(this.getProperty(props, PROP_MIN_TOOLS_REV, Integer.toString(0)));
    }

    @Override
    void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        if (this.mVersionName != null) {
            props.setProperty(PROP_VERSION, this.mVersionName);
        }
        if (this.mMinToolsRevision != 0) {
            props.setProperty(PROP_MIN_TOOLS_REV, Integer.toString(this.mMinToolsRevision));
        }
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    public int getMinToolsRevision() {
        return this.mMinToolsRevision;
    }

    @Override
    public String getShortDescription() {
        String s = this.mVersion.isPreview() ? String.format("SDK Platform Android %1$s (Preview)", this.getVersionName()) : String.format("SDK Platform Android %1$s, API %2$d", this.getVersionName(), this.mVersion.getApiLevel());
        if (this.mMinToolsRevision != 0) {
            s = s + String.format(" (tools rev: %1$d)", this.mMinToolsRevision);
        }
        return s;
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".";
    }

    @Override
    public File getInstallFolder(String osSdkRoot, String suggestedDir, SdkManager sdkManager) {
        for (IAndroidTarget target : sdkManager.getTargets()) {
            if (!target.isPlatform() || !target.getVersion().equals(this.mVersion) || !target.getVersionName().equals(this.getVersionName())) continue;
            return new File(target.getLocation());
        }
        File platforms = new File(osSdkRoot, "platforms");
        File folder = new File(platforms, String.format("android-%s", this.getVersionName()));
        return folder;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof PlatformPackage) {
            PlatformPackage newPkg = (PlatformPackage)pkg;
            return newPkg.getVersion().equals(this.getVersion());
        }
        return false;
    }
}

