/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectProperties {
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_APK_CONFIGS = "apk-configurations";
    public static final String PROPERTY_SDK = "sdk-location";
    public static final String PROPERTY_APP_PACKAGE = "application-package";
    private static final String LOCAL_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n# \n# This file must *NOT* be checked in Version Control Systems,\n# as it contains information specific to your local configuration.\n\n";
    private static final String DEFAULT_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n# \n# This file must be checked in Version Control Systems.\n# \n# To customize properties used by the Ant build system use,\n# \"build.properties\", and override values to adapt the script to your\n# project structure.\n\n";
    private static final String BUILD_HEADER = "# This file is used to override default values used by the Ant build system.\n# \n# This file must be checked in Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source-folder' for the location of your java source folder and\n#  'out-folder' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n";
    private static final Map<String, String> COMMENT_MAP = new HashMap<String, String>();
    private final String mProjectFolderOsPath;
    private final Map<String, String> mProperties;
    private final PropertyType mType;

    public static ProjectProperties load(String projectFolderOsPath, PropertyType type) {
        Map<String, String> map;
        File defaultFile;
        File projectFolder = new File(projectFolderOsPath);
        if (projectFolder.isDirectory() && (defaultFile = new File(projectFolder, type.mFilename)).isFile() && (map = SdkManager.parsePropertyFile(defaultFile, null)) != null) {
            return new ProjectProperties(projectFolderOsPath, map, type);
        }
        return null;
    }

    public ProjectProperties merge(PropertyType type) {
        Map<String, String> map;
        File defaultFile;
        File projectFolder = new File(this.mProjectFolderOsPath);
        if (projectFolder.isDirectory() && (defaultFile = new File(projectFolder, type.mFilename)).isFile() && (map = SdkManager.parsePropertyFile(defaultFile, null)) != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (this.mProperties.containsKey(key) || value == null) continue;
                this.mProperties.put(key, value);
            }
        }
        return this;
    }

    public static ProjectProperties create(String projectFolderOsPath, PropertyType type) {
        return new ProjectProperties(projectFolderOsPath, new HashMap<String, String>(), type);
    }

    public void setProperty(String name, String value) {
        this.mProperties.put(name, value);
    }

    public void setAndroidTarget(IAndroidTarget target) {
        assert (this.mType == PropertyType.DEFAULT);
        this.mProperties.put(PROPERTY_TARGET, target.hashString());
    }

    public String getProperty(String name) {
        return this.mProperties.get(name);
    }

    public String removeProperty(String name) {
        return this.mProperties.remove(name);
    }

    public void save() throws IOException {
        File toSave = new File(this.mProjectFolderOsPath, this.mType.mFilename);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(toSave), "UTF-8");
        writer.write(this.mType.mHeader);
        for (Map.Entry<String, String> entry : this.mProperties.entrySet()) {
            String comment = COMMENT_MAP.get(entry.getKey());
            if (comment != null) {
                writer.write(comment);
            }
            String value = entry.getValue();
            value = value.replaceAll("\\\\", "\\\\\\\\");
            writer.write(String.format("%s=%s\n", entry.getKey(), value));
        }
        writer.close();
    }

    private ProjectProperties(String projectFolderOsPath, Map<String, String> map, PropertyType type) {
        this.mProjectFolderOsPath = projectFolderOsPath;
        this.mProperties = map;
        this.mType = type;
    }

    static {
        COMMENT_MAP.put(PROPERTY_TARGET, "# Project target.\n");
        COMMENT_MAP.put(PROPERTY_APK_CONFIGS, "# apk configurations. This property allows creation of APK files with limited\n# resources. For example, if your application contains many locales and\n# you wish to release multiple smaller apks instead of a large one, you can\n# define configuration to create apks with limited language sets.\n# Format is a comma separated list of configuration names. For each\n# configuration, a property will declare the resource configurations to\n# include. Example:\n#     apk-configurations=european,northamerica\n#     apk-config-european=en,fr,it,de,es\n#     apk-config-northamerica=en,es\n");
        COMMENT_MAP.put(PROPERTY_SDK, "# location of the SDK. This is only used by Ant\n# For customization when using a Version Control System, please read the\n# header note.\n");
        COMMENT_MAP.put(PROPERTY_APP_PACKAGE, "# The name of your application package as defined in the manifest.\n# Used by the 'uninstall' rule.\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyType {
        BUILD("build.properties", "# This file is used to override default values used by the Ant build system.\n# \n# This file must be checked in Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source-folder' for the location of your java source folder and\n#  'out-folder' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n"),
        DEFAULT("default.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n# \n# This file must be checked in Version Control Systems.\n# \n# To customize properties used by the Ant build system use,\n# \"build.properties\", and override values to adapt the script to your\n# project structure.\n\n"),
        LOCAL("local.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n# \n# This file must *NOT* be checked in Version Control Systems,\n# as it contains information specific to your local configuration.\n\n");

        private final String mFilename;
        private final String mHeader;

        private PropertyType(String filename, String header) {
            this.mFilename = filename;
            this.mHeader = header;
        }

        public String getFilename() {
            return this.mFilename;
        }
    }
}

