/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectCreator {
    private static final String PH_JAVA_FOLDER = "PACKAGE_PATH";
    private static final String PH_PACKAGE = "PACKAGE";
    private static final String PH_ACTIVITY_NAME = "ACTIVITY_NAME";
    private static final String PH_PROJECT_NAME = "PROJECT_NAME";
    private static final String FOLDER_TESTS = "tests";
    public static final Pattern RE_PROJECT_NAME = Pattern.compile("[a-zA-Z0-9_]+");
    public static final String CHARS_PROJECT_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_PACKAGE_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+");
    public static final String CHARS_PACKAGE_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_ACTIVITY_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    public static final String CHARS_ACTIVITY_NAME = "a-z A-Z 0-9 _";
    private final OutputLevel mLevel;
    private final ISdkLog mLog;
    private final String mSdkFolder;

    public ProjectCreator(String sdkFolder, OutputLevel level, ISdkLog log) {
        this.mSdkFolder = sdkFolder;
        this.mLevel = level;
        this.mLog = log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createProject(String folderPath, String projectName, String packageName, String activityName, IAndroidTarget target, boolean isTestProject) {
        File projectFolder = new File(folderPath);
        if (!projectFolder.exists()) {
            boolean created = false;
            Exception t = null;
            try {
                created = projectFolder.mkdirs();
            }
            catch (Exception e) {
                t = e;
            }
            if (!created) {
                this.mLog.error(t, "Could not create directory: %1$s", projectFolder);
                return;
            }
            this.println("Created project directory: %1$s", projectFolder);
        } else {
            String error;
            Exception e;
            block21: {
                e = null;
                error = null;
                try {
                    String[] content = projectFolder.list();
                    if (content == null) {
                        error = "Project folder '%1$s' is not a directory.";
                        break block21;
                    }
                    if (content.length != 0) {
                        error = "Project folder '%1$s' is not empty. Please consider using '%2$s update' instead.";
                    }
                }
                catch (Exception e1) {
                    e = e1;
                }
            }
            if (e != null || error != null) {
                this.mLog.error(e, error, projectFolder, SdkConstants.androidCmdName());
            }
        }
        try {
            ProjectProperties localProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL);
            localProperties.setProperty("sdk-location", this.mSdkFolder);
            localProperties.save();
            ProjectProperties defaultProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.DEFAULT);
            defaultProperties.setAndroidTarget(target);
            defaultProperties.save();
            ProjectProperties buildProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.BUILD);
            buildProperties.setProperty("application-package", packageName);
            buildProperties.save();
            HashMap<String, String> keywords = new HashMap<String, String>();
            String packagePath = ProjectCreator.stripString(packageName.replace(".", File.separator), File.separatorChar);
            keywords.put(PH_JAVA_FOLDER, packagePath);
            keywords.put(PH_PACKAGE, packageName);
            if (activityName != null) {
                keywords.put(PH_ACTIVITY_NAME, activityName);
            }
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
            } else if (activityName != null) {
                keywords.put(PH_PROJECT_NAME, activityName);
            } else {
                projectName = projectFolder.getName();
                keywords.put(PH_PROJECT_NAME, projectName);
            }
            String srcFolderPath = "src" + File.separator + packagePath;
            File sourceFolder = this.createDirs(projectFolder, srcFolderPath);
            String javaTemplate = "java_file.template";
            String activityFileName = activityName + ".java";
            if (isTestProject) {
                javaTemplate = "java_tests_file.template";
                activityFileName = activityName + "Test.java";
            }
            this.installTemplate(javaTemplate, new File(sourceFolder, activityFileName), keywords, target);
            srcFolderPath = "gen" + File.separator + packagePath;
            sourceFolder = this.createDirs(projectFolder, srcFolderPath);
            File resourceFodler = this.createDirs(projectFolder, "res");
            this.createDirs(projectFolder, "bin");
            this.createDirs(projectFolder, "libs");
            if (!isTestProject) {
                File valueFolder = this.createDirs(resourceFodler, "values");
                this.installTemplate("strings.template", new File(valueFolder, "strings.xml"), keywords, target);
                File layoutFolder = this.createDirs(resourceFodler, "layout");
                this.installTemplate("layout.template", new File(layoutFolder, "main.xml"), keywords, target);
            }
            String manifestTemplate = "AndroidManifest.template";
            if (isTestProject) {
                manifestTemplate = "AndroidManifest.tests.template";
            }
            this.installTemplate(manifestTemplate, new File(projectFolder, "AndroidManifest.xml"), keywords, target);
            this.installTemplate("build.template", new File(projectFolder, "build.xml"), keywords);
            if (isTestProject) return;
            this.createDirs(projectFolder, FOLDER_TESTS);
            File testProjectFolder = new File(folderPath, FOLDER_TESTS);
            this.createProject(testProjectFolder.getAbsolutePath(), projectName, packageName, activityName, target, true);
            return;
        }
        catch (ProjectCreateException e) {
            this.mLog.error(e, null, new Object[0]);
            return;
        }
        catch (IOException e) {
            this.mLog.error(e, null, new Object[0]);
        }
    }

    public void updateProject(String folderPath, IAndroidTarget target, String projectName) {
        boolean needsBuildXml;
        File projectFolder = new File(folderPath);
        if (!projectFolder.isDirectory()) {
            this.mLog.error(null, "Project folder '%1$s' is not a valid directory, this is not an Android project you can update.", projectFolder);
            return;
        }
        File androidManifest = new File(projectFolder, "AndroidManifest.xml");
        if (!androidManifest.isFile()) {
            this.mLog.error(null, "%1$s not found in '%2$s', this is not an Android project you can update.", "AndroidManifest.xml", folderPath);
            return;
        }
        ProjectProperties props = ProjectProperties.load(folderPath, ProjectProperties.PropertyType.DEFAULT);
        if ((props == null || props.getProperty("target") == null) && target == null) {
            this.mLog.error(null, "There is no %1$s file in '%2$s'. Please provide a --target to the '%3$s update' command.", ProjectProperties.PropertyType.DEFAULT.getFilename(), folderPath, SdkConstants.androidCmdName());
            return;
        }
        if (target != null) {
            if (props == null) {
                props = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.DEFAULT);
            }
            props.setAndroidTarget(target);
            try {
                props.save();
                this.println("Updated %1$s", ProjectProperties.PropertyType.DEFAULT.getFilename());
            }
            catch (IOException e) {
                this.mLog.error(e, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.DEFAULT.getFilename(), folderPath);
                return;
            }
        }
        if ((props = ProjectProperties.load(folderPath, ProjectProperties.PropertyType.LOCAL)) == null) {
            props = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL);
        }
        props.setProperty("sdk-location", this.mSdkFolder);
        try {
            props.save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.LOCAL.getFilename());
        }
        catch (IOException e) {
            this.mLog.error(e, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.LOCAL.getFilename(), folderPath);
            return;
        }
        File buildXml = new File(projectFolder, "build.xml");
        boolean bl = needsBuildXml = projectName != null || !buildXml.exists();
        if (!needsBuildXml) {
            boolean bl2 = needsBuildXml = !this.checkFileContainsRegexp(buildXml, "classname=\"com.android.ant.SetupTask\"");
        }
        if (!needsBuildXml) {
            boolean bl3 = needsBuildXml = !this.checkFileContainsRegexp(buildXml, "<setup(?:\\s|/|$)");
        }
        if (needsBuildXml) {
            this.println("File %1$s is too old and needs to be updated.", "build.xml");
        }
        if (needsBuildXml) {
            HashMap<String, String> keywords = new HashMap<String, String>();
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
            } else {
                this.extractPackageFromManifest(androidManifest, keywords);
                if (keywords.containsKey(PH_ACTIVITY_NAME)) {
                    keywords.put(PH_PROJECT_NAME, keywords.get(PH_ACTIVITY_NAME));
                } else {
                    projectName = projectFolder.getName();
                    keywords.put(PH_PROJECT_NAME, projectName);
                }
            }
            if (this.mLevel == OutputLevel.VERBOSE) {
                this.println("Regenerating %1$s with project name %2$s", "build.xml", keywords.get(PH_PROJECT_NAME));
            }
            try {
                this.installTemplate("build.template", new File(projectFolder, "build.xml"), keywords);
            }
            catch (ProjectCreateException e) {
                this.mLog.error(e, null, new Object[0]);
            }
        }
    }

    private boolean checkFileContainsRegexp(File file, String regexp) {
        Pattern p = Pattern.compile(regexp);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (!p.matcher(line).find()) continue;
                return true;
            }
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private boolean extractPackageFromManifest(File manifestFile, Map<String, String> outKeywords) {
        try {
            String nsPrefix = "android";
            String nsURI = "http://schemas.android.com/apk/res/android";
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    if ("android".equals(prefix)) {
                        return "http://schemas.android.com/apk/res/android";
                    }
                    return "";
                }

                public String getPrefix(String namespaceURI) {
                    if ("http://schemas.android.com/apk/res/android".equals(namespaceURI)) {
                        return "android";
                    }
                    return null;
                }

                public Iterator getPrefixes(String namespaceURI) {
                    if ("http://schemas.android.com/apk/res/android".equals(namespaceURI)) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add("android");
                        return list.iterator();
                    }
                    return null;
                }
            });
            InputSource source = new InputSource(new FileReader(manifestFile));
            String packageName = xpath.evaluate("/manifest/@package", source);
            source = new InputSource(new FileReader(manifestFile));
            String expression = String.format("/manifest/application/activity[intent-filter/action/@%1$s:name='android.intent.action.MAIN' and intent-filter/category/@%1$s:name='android.intent.category.LAUNCHER']/@%1$s:name", "android");
            NodeList activityNames = (NodeList)xpath.evaluate(expression, source, XPathConstants.NODESET);
            if (packageName == null || packageName.length() == 0) {
                this.mLog.error(null, "Missing <manifest package=\"...\"> in '%1$s'", manifestFile.getName());
                return false;
            }
            String activityName = "";
            if (activityNames.getLength() > 0) {
                activityName = activityNames.item(0).getNodeValue();
            }
            if (this.mLevel == OutputLevel.VERBOSE && activityNames.getLength() > 1) {
                this.println("WARNING: There is more than one activity defined in '%1$s'.\nOnly the first one will be used. If this is not appropriate, you need\nto specify one of these values manually instead:", manifestFile.getName());
                for (int i = 0; i < activityNames.getLength(); ++i) {
                    String name = activityNames.item(i).getNodeValue();
                    name = this.combinePackageActivityNames(packageName, name);
                    this.println("- %1$s", name);
                }
            }
            if (activityName.length() == 0) {
                this.mLog.warning("Missing <activity %1$s:name=\"...\"> in '%2$s'.\nNo activity will be generated.", "android", manifestFile.getName());
            } else {
                outKeywords.put(PH_ACTIVITY_NAME, activityName);
            }
            outKeywords.put(PH_PACKAGE, packageName);
            return true;
        }
        catch (IOException e) {
            this.mLog.error(e, "Failed to read %1$s", manifestFile.getName());
        }
        catch (XPathExpressionException e) {
            Throwable t = e.getCause();
            this.mLog.error(t == null ? e : t, "Failed to parse %1$s", manifestFile.getName());
        }
        return false;
    }

    private String combinePackageActivityNames(String packageName, String activityName) {
        int pos = activityName.indexOf(46);
        if (pos == 0) {
            return packageName + activityName;
        }
        if (pos > 0) {
            return activityName;
        }
        return packageName + "." + activityName;
    }

    private void installTemplate(String templateName, File destFile, Map<String, String> placeholderMap, IAndroidTarget target) throws ProjectCreateException {
        String templateFolder = target.getPath(6);
        String sourcePath = templateFolder + File.separator + templateName;
        this.installFullPathTemplate(sourcePath, destFile, placeholderMap);
    }

    private void installTemplate(String templateName, File destFile, Map<String, String> placeholderMap) throws ProjectCreateException {
        String templateFolder = this.mSdkFolder + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER;
        String sourcePath = templateFolder + File.separator + templateName;
        this.installFullPathTemplate(sourcePath, destFile, placeholderMap);
    }

    private void installFullPathTemplate(String sourcePath, File destFile, Map<String, String> placeholderMap) throws ProjectCreateException {
        boolean existed = destFile.exists();
        try {
            String line;
            BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
            BufferedReader in = new BufferedReader(new FileReader(sourcePath));
            while ((line = in.readLine()) != null) {
                for (String key : placeholderMap.keySet()) {
                    line = line.replace(key, placeholderMap.get(key));
                }
                out.write(line);
                out.newLine();
            }
            out.close();
            in.close();
        }
        catch (Exception e) {
            throw new ProjectCreateException(e, "Could not access %1$s: %2$s", destFile, e.getMessage());
        }
        this.println("%1$s file %2$s", existed ? "Updated" : "Added", destFile);
    }

    private void println(String format, Object ... args) {
        if (this.mLevel != OutputLevel.SILENT) {
            if (!format.endsWith("\n")) {
                format = format + "\n";
            }
            this.mLog.printf(format, args);
        }
    }

    private File createDirs(File parent, String name) throws ProjectCreateException {
        File newFolder = new File(parent, name);
        boolean existedBefore = true;
        if (!newFolder.exists()) {
            if (!newFolder.mkdirs()) {
                throw new ProjectCreateException("Could not create directory: %1$s", newFolder);
            }
            existedBefore = false;
        }
        if (newFolder.isDirectory()) {
            if (!newFolder.canWrite()) {
                throw new ProjectCreateException("Path is not writable: %1$s", newFolder);
            }
        } else {
            throw new ProjectCreateException("Path is not a directory: %1$s", newFolder);
        }
        if (!existedBefore) {
            try {
                this.println("Created directory %1$s", newFolder.getCanonicalPath());
            }
            catch (IOException e) {
                throw new ProjectCreateException("Could not determine canonical path of created directory", new Object[]{e});
            }
        }
        return newFolder;
    }

    private static String stripString(String s, char strip) {
        int newStart;
        int sLen = s.length();
        int newEnd = sLen - 1;
        for (newStart = 0; newStart < sLen && s.charAt(newStart) == strip; ++newStart) {
        }
        while (newEnd >= 0 && s.charAt(newEnd) == strip) {
            --newEnd;
        }
        if (newStart >= sLen || ++newEnd < 0) {
            return "";
        }
        return s.substring(newStart, newEnd);
    }

    private static class ProjectCreateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ProjectCreateException(String message) {
            super(message);
        }

        ProjectCreateException(Throwable t, String format, Object ... args) {
            super(format != null ? String.format(format, args) : format, t);
        }

        ProjectCreateException(String format, Object ... args) {
            super(String.format(format, args));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputLevel {
        SILENT,
        NORMAL,
        VERBOSE;

    }
}

