/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.HandshakeIODataStream;
import org.apache.harmony.xnet.provider.jsse.Message;

public class ServerKeyExchange
extends Message {
    public final BigInteger par1;
    public final byte[] bytes1;
    public final BigInteger par2;
    public final byte[] bytes2;
    public final BigInteger par3;
    public final byte[] bytes3;
    public final byte[] hash;
    public RSAPublicKey key;

    public ServerKeyExchange(BigInteger par1, BigInteger par2, BigInteger par3, byte[] hash) {
        this.par1 = par1;
        this.par2 = par2;
        this.par3 = par3;
        this.hash = hash;
        byte[] bb = this.par1.toByteArray();
        if (bb[0] == 0) {
            this.bytes1 = new byte[bb.length - 1];
            System.arraycopy(bb, 1, this.bytes1, 0, this.bytes1.length);
        } else {
            this.bytes1 = bb;
        }
        bb = this.par2.toByteArray();
        if (bb[0] == 0) {
            this.bytes2 = new byte[bb.length - 1];
            System.arraycopy(bb, 1, this.bytes2, 0, this.bytes2.length);
        } else {
            this.bytes2 = bb;
        }
        this.length = 4 + this.bytes1.length + this.bytes2.length;
        if (hash != null) {
            this.length += 2 + hash.length;
        }
        if (par3 == null) {
            this.bytes3 = null;
            return;
        }
        bb = this.par3.toByteArray();
        if (bb[0] == 0) {
            this.bytes3 = new byte[bb.length - 1];
            System.arraycopy(bb, 1, this.bytes3, 0, this.bytes3.length);
        } else {
            this.bytes3 = bb;
        }
        this.length += 2 + this.bytes3.length;
    }

    public ServerKeyExchange(HandshakeIODataStream in, int length, int keyExchange) throws IOException {
        int size = in.readUint16();
        this.bytes1 = in.read(size);
        this.par1 = new BigInteger(1, this.bytes1);
        this.length = 2 + this.bytes1.length;
        size = in.readUint16();
        this.bytes2 = in.read(size);
        this.par2 = new BigInteger(1, this.bytes2);
        this.length += 2 + this.bytes2.length;
        if (keyExchange != CipherSuite.KeyExchange_RSA_EXPORT) {
            size = in.readUint16();
            this.bytes3 = in.read(size);
            this.par3 = new BigInteger(1, this.bytes3);
            this.length += 2 + this.bytes3.length;
        } else {
            this.par3 = null;
            this.bytes3 = null;
        }
        if (keyExchange != CipherSuite.KeyExchange_DH_anon_EXPORT && keyExchange != CipherSuite.KeyExchange_DH_anon) {
            size = in.readUint16();
            this.hash = in.read(size);
            this.length += 2 + this.hash.length;
        } else {
            this.hash = null;
        }
        if (this.length != length) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect ServerKeyExchange");
        }
    }

    public void send(HandshakeIODataStream out) {
        out.writeUint16(this.bytes1.length);
        out.write(this.bytes1);
        out.writeUint16(this.bytes2.length);
        out.write(this.bytes2);
        if (this.bytes3 != null) {
            out.writeUint16(this.bytes3.length);
            out.write(this.bytes3);
        }
        if (this.hash != null) {
            out.writeUint16(this.hash.length);
            out.write(this.hash);
        }
    }

    public RSAPublicKey getRSAPublicKey() {
        if (this.key != null) {
            return this.key;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            this.key = (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(this.par1, this.par2));
        }
        catch (Exception e) {
            return null;
        }
        return this.key;
    }

    public int getType() {
        return 12;
    }
}

