/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Date;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.harmony.luni.util.TwoKeyHashMap;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.ProtocolVersion;
import org.apache.harmony.xnet.provider.jsse.SSLRecordProtocol;

public class SSLSessionImpl
implements SSLSession {
    public static final SSLSessionImpl NULL_SESSION = new SSLSessionImpl(null);
    public long creationTime;
    public boolean isValid = true;
    public TwoKeyHashMap values = new TwoKeyHashMap();
    public byte[] id;
    public long lastAccessedTime;
    public ProtocolVersion protocol;
    public CipherSuite cipherSuite;
    public SSLSessionContext context;
    public java.security.cert.X509Certificate[] localCertificates;
    public java.security.cert.X509Certificate[] peerCertificates;
    public String peerHost;
    public int peerPort = -1;
    public byte[] master_secret;
    public byte[] clientRandom;
    public byte[] serverRandom;
    public boolean isServer = false;

    public SSLSessionImpl(CipherSuite cipher_suite, SecureRandom sr) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        if (cipher_suite == null) {
            this.cipherSuite = CipherSuite.TLS_NULL_WITH_NULL_NULL;
            this.id = new byte[0];
            this.isServer = false;
        } else {
            this.cipherSuite = cipher_suite;
            this.id = new byte[32];
            sr.nextBytes(this.id);
            long time = new Date().getTime() / 1000L;
            this.id[28] = (byte)((time & 0xFFFFFFFFFF000000L) >>> 24);
            this.id[29] = (byte)((time & 0xFF0000L) >>> 16);
            this.id[30] = (byte)((time & 0xFF00L) >>> 8);
            this.id[31] = (byte)(time & 0xFFL);
            this.isServer = true;
        }
    }

    public SSLSessionImpl(SecureRandom sr) {
        this(null, sr);
    }

    public SSLSessionImpl() {
    }

    public int getApplicationBufferSize() {
        return SSLRecordProtocol.MAX_DATA_LENGTH;
    }

    public String getCipherSuite() {
        return this.cipherSuite.getName();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    public Principal getLocalPrincipal() {
        if (this.localCertificates != null && this.localCertificates.length > 0) {
            return this.localCertificates[0].getSubjectX500Principal();
        }
        return null;
    }

    public int getPacketBufferSize() {
        return SSLRecordProtocol.MAX_SSL_PACKET_SIZE;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        X509Certificate[] certs = new X509Certificate[this.peerCertificates.length];
        for (int i = 0; i < certs.length; ++i) {
            try {
                certs[i] = X509Certificate.getInstance(this.peerCertificates[i].getEncoded());
                continue;
            }
            catch (CertificateException e) {
                continue;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return certs;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        return this.peerCertificates;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        return this.peerCertificates[0].getSubjectX500Principal();
    }

    public String getProtocol() {
        return this.protocol.name;
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.context;
    }

    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        return this.values.get(name, AccessController.getContext());
    }

    public String[] getValueNames() {
        Vector v = new Vector();
        AccessControlContext current = AccessController.getContext();
        for (TwoKeyHashMap.Entry entry : this.values.entrySet()) {
            AccessControlContext cont = (AccessControlContext)entry.getKey2();
            if ((current != null || cont != null) && (current == null || !current.equals(cont))) continue;
            v.add(entry.getKey1());
        }
        return v.toArray(new String[0]);
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isValid() {
        if (this.isValid && this.context != null && this.context.getSessionTimeout() != 0 && this.lastAccessedTime + (long)this.context.getSessionTimeout() > System.currentTimeMillis()) {
            this.isValid = false;
        }
        return this.isValid;
    }

    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        Object old = this.values.put(name, AccessController.getContext(), value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old != null && old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        this.values.remove(name, AccessController.getContext());
    }

    public Object clone() {
        SSLSessionImpl ses = new SSLSessionImpl();
        ses.id = this.id;
        ses.creationTime = this.creationTime;
        ses.lastAccessedTime = this.lastAccessedTime;
        ses.isValid = this.isValid;
        ses.cipherSuite = this.cipherSuite;
        ses.localCertificates = this.localCertificates;
        ses.peerCertificates = this.peerCertificates;
        ses.master_secret = this.master_secret;
        ses.clientRandom = this.clientRandom;
        ses.serverRandom = this.serverRandom;
        ses.peerHost = this.peerHost;
        ses.peerPort = this.peerPort;
        ses.isServer = this.isServer;
        ses.context = this.context;
        ses.protocol = this.protocol;
        ses.values = this.values;
        return ses;
    }

    public void setPeer(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }
}

