/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontLoader {
    private static final String FONTS_DEFINITIONS = "fonts.xml";
    private static final String NODE_FONTS = "fonts";
    private static final String NODE_FONT = "font";
    private static final String NODE_NAME = "name";
    private static final String ATTR_TTF = "ttf";
    private static final String[] NODE_LEVEL = new String[]{"fonts", "font", "name"};
    private static final String FONT_EXT = ".ttf";
    private static final String[] FONT_STYLE_DEFAULT = new String[]{"", "-Regular"};
    private static final String[] FONT_STYLE_BOLD = new String[]{"-Bold"};
    private static final String[] FONT_STYLE_ITALIC = new String[]{"-Italic"};
    private static final String[] FONT_STYLE_BOLDITALIC = new String[]{"-BoldItalic"};
    private static final String[][] FONT_STYLES = new String[][]{FONT_STYLE_DEFAULT, FONT_STYLE_BOLD, FONT_STYLE_ITALIC, FONT_STYLE_BOLDITALIC};
    private final Map<String, String> mFamilyToTtf = new HashMap<String, String>();
    private final Map<String, Map<Integer, Font>> mTtfToFontMap = new HashMap<String, Map<Integer, Font>>();

    public static FontLoader create(String fontOsLocation) {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            File f = new File(fontOsLocation + File.separator + FONTS_DEFINITIONS);
            FontDefinitionParser definitionParser = new FontDefinitionParser(fontOsLocation + File.separator);
            parser.parse((InputStream)new FileInputStream(f), (DefaultHandler)definitionParser);
            return definitionParser.getFontLoader();
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private FontLoader(List<FontInfo> fontList) {
        for (FontInfo info : fontList) {
            for (String family : info.families) {
                this.mFamilyToTtf.put(family, info.ttf);
            }
        }
    }

    public synchronized Font getFont(String family, int[] style2) {
        Font f;
        if (family == null) {
            return null;
        }
        String ttf = this.mFamilyToTtf.get(family);
        if (ttf == null) {
            return null;
        }
        Map<Integer, Font> styleMap = this.mTtfToFontMap.get(ttf);
        if (styleMap == null) {
            styleMap = new HashMap<Integer, Font>();
            this.mTtfToFontMap.put(ttf, styleMap);
        }
        if ((f = styleMap.get(style2)) != null) {
            return f;
        }
        switch (style2[0]) {
            case 0: {
                f = this.getFont(ttf, FONT_STYLES[0]);
                break;
            }
            case 1: 
            case 2: {
                f = this.getFont(ttf, FONT_STYLES[style2[0]]);
                if (f != null) break;
                f = this.getFont(ttf, FONT_STYLES[0]);
                style2[0] = 0;
                break;
            }
            case 3: {
                f = this.getFont(ttf, FONT_STYLES[style2[0]]);
                if (f != null) break;
                f = this.getFont(ttf, FONT_STYLES[1]);
                if (f != null) {
                    style2[0] = 1;
                    break;
                }
                f = this.getFont(ttf, FONT_STYLES[2]);
                if (f != null) {
                    style2[0] = 2;
                    break;
                }
                f = this.getFont(ttf, FONT_STYLES[0]);
                style2[0] = 0;
            }
        }
        if (f != null) {
            styleMap.put(style2[0], f);
            return f;
        }
        return null;
    }

    private Font getFont(String ttf, String[] fontFileSuffix) {
        for (String suffix : fontFileSuffix) {
            String name = ttf + suffix + FONT_EXT;
            File f = new File(name);
            if (!f.isFile()) continue;
            try {
                Font font = Font.createFont(0, f);
                if (font == null) continue;
                return font;
            }
            catch (FontFormatException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class FontDefinitionParser
    extends DefaultHandler {
        private final String mOsFontsLocation;
        private int mDepth = 0;
        private FontInfo mFontInfo = null;
        private final StringBuilder mBuilder = new StringBuilder();
        private final List<FontInfo> mFontList = new ArrayList<FontInfo>();

        private FontDefinitionParser(String osFontsLocation) {
            this.mOsFontsLocation = osFontsLocation;
        }

        FontLoader getFontLoader() {
            return new FontLoader(this.mFontList);
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (localName.equals(NODE_LEVEL[this.mDepth])) {
                String ttf;
                ++this.mDepth;
                if (this.mDepth == 2 && (ttf = attributes.getValue(FontLoader.ATTR_TTF)) != null) {
                    this.mFontInfo = new FontInfo();
                    this.mFontInfo.ttf = this.mOsFontsLocation + ttf;
                    this.mFontList.add(this.mFontInfo);
                }
            }
            super.startElement(uri, localName, name, attributes);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mFontInfo != null) {
                this.mBuilder.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (localName.equals(NODE_LEVEL[this.mDepth - 1])) {
                --this.mDepth;
                if (this.mDepth == 2) {
                    if (this.mFontInfo != null) {
                        String family = this.trimXmlWhitespaces(this.mBuilder.toString());
                        this.mFontInfo.families.add(family);
                        this.mBuilder.setLength(0);
                    }
                } else if (this.mDepth == 1) {
                    this.mFontInfo = null;
                }
            }
        }

        private String trimXmlWhitespaces(String value) {
            int index;
            if (value == null) {
                return null;
            }
            while ((index = value.indexOf(10)) != -1) {
                int right;
                int left;
                for (left = index - 1; left >= 0 && Character.isWhitespace(value.charAt(left)); --left) {
                }
                int count = value.length();
                for (right = index + 1; right < count && Character.isWhitespace(value.charAt(right)); ++right) {
                }
                String leftString = null;
                if (left >= 0) {
                    leftString = value.substring(0, left + 1);
                }
                String rightString = null;
                if (right < count) {
                    rightString = value.substring(right);
                }
                if (leftString != null) {
                    value = leftString;
                    if (rightString == null) continue;
                    value = value + " " + rightString;
                    continue;
                }
                value = rightString != null ? rightString : "";
            }
            int length = value.length();
            char[] buffer = value.toCharArray();
            for (int i = 0; i < length; ++i) {
                if (buffer[i] != '\\') continue;
                if (buffer[i + 1] == 'n') {
                    buffer[i + 1] = 10;
                }
                System.arraycopy(buffer, i + 1, buffer, i, length - i - 1);
                --length;
            }
            return new String(buffer, 0, length);
        }
    }

    private static final class FontInfo {
        String ttf;
        final Set<String> families = new HashSet<String>();

        FontInfo() {
        }
    }
}

