/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

public class CharSequences {
    public static CharSequence forAsciiBytes(final byte[] bytes) {
        return new CharSequence(){

            public char charAt(int index) {
                return (char)bytes[index];
            }

            public int length() {
                return bytes.length;
            }

            public CharSequence subSequence(int start, int end) {
                return CharSequences.forAsciiBytes(bytes, start, end);
            }

            public String toString() {
                return new String(bytes);
            }
        };
    }

    public static CharSequence forAsciiBytes(final byte[] bytes, final int start, final int end) {
        CharSequences.validate(start, end, bytes.length);
        return new CharSequence(){

            public char charAt(int index) {
                return (char)bytes[index + start];
            }

            public int length() {
                return end - start;
            }

            public CharSequence subSequence(int newStart, int newEnd) {
                CharSequences.validate(newStart -= start, newEnd -= start, this.length());
                return CharSequences.forAsciiBytes(bytes, newStart, newEnd);
            }

            public String toString() {
                return new String(bytes, start, this.length());
            }
        };
    }

    public static void validate(int start, int end, int length) {
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end > length) {
            throw new IndexOutOfBoundsException();
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        if (a.length() != b.length()) {
            return false;
        }
        int length = a.length();
        for (int i = 0; i < length; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int compareToIgnoreCase(CharSequence me, CharSequence another) {
        int end;
        int myLen = me.length();
        int anotherLen = another.length();
        int myPos = 0;
        int anotherPos = 0;
        int n = end = myLen < anotherLen ? myLen : anotherLen;
        while (myPos < end) {
            int result;
            if ((result = Character.toLowerCase(me.charAt(myPos++)) - Character.toLowerCase(another.charAt(anotherPos++))) == 0) continue;
            return result;
        }
        return myLen - anotherLen;
    }
}

