/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Call {
    public abstract List<Connection> getConnections();

    public abstract State getState();

    public abstract Phone getPhone();

    public boolean hasConnection(Connection c) {
        return c.getCall() == this;
    }

    public boolean hasConnections() {
        List<Connection> connections = this.getConnections();
        if (connections == null) {
            return false;
        }
        return connections.size() > 0;
    }

    public boolean isIdle() {
        return !this.getState().isAlive();
    }

    public Connection getEarliestConnection() {
        long time = Long.MAX_VALUE;
        Connection earliest = null;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return null;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            if (t >= time) continue;
            earliest = c;
        }
        return earliest;
    }

    public long getEarliestCreateTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            time = t < time ? t : time;
        }
        return time;
    }

    public long getEarliestConnectTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getConnectTime();
            time = t < time ? t : time;
        }
        return time;
    }

    public abstract boolean isMultiparty();

    public abstract void hangup() throws CallStateException;

    public boolean isDialingOrAlerting() {
        return this.getState().isDialing();
    }

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        ACTIVE,
        HOLDING,
        DIALING,
        ALERTING,
        INCOMING,
        WAITING,
        DISCONNECTED;


        public boolean isAlive() {
            return this != IDLE && this != DISCONNECTED;
        }

        public boolean isRinging() {
            return this == INCOMING || this == WAITING;
        }

        public boolean isDialing() {
            return this == DIALING || this == ALERTING;
        }
    }
}

