/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.ddm.DdmRegister;
import android.os.Debug;
import android.os.IBinder;
import android.os.ICheckinService;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.server.data.CrashData;
import android.util.Log;
import com.android.internal.logging.AndroidConfig;
import com.android.internal.os.AndroidPrintStream;
import com.android.internal.os.ZygoteInit;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.LogManager;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public class RuntimeInit {
    public static final String TAG = "AndroidRuntime";
    public static boolean initialized;
    public static final AtomicInteger sInReportException;
    public static IBinder mApplicationObject;

    public static void commonInit() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler(null));
        int hasQwerty = RuntimeInit.getQwertyKeyboard();
        if (hasQwerty == 1) {
            System.setProperty("qwerty", "1");
        }
        TimezoneGetter.setInstance(new TimezoneGetter(){

            public String getId() {
                return SystemProperties.get("persist.sys.timezone");
            }
        });
        TimeZone.setDefault(null);
        LogManager.getLogManager().reset();
        new AndroidConfig();
        String trace = SystemProperties.get("ro.kernel.android.tracing");
        if (trace.equals("1")) {
            Log.i(TAG, "NOTE: emulator trace profiling enabled");
            Debug.enableEmulatorTraceOutput();
        }
        initialized = true;
    }

    public static void invokeStaticMain(String className, String[] argv) throws ZygoteInit.MethodAndArgsCaller {
        Method m;
        Class<?> cl;
        VMRuntime.getRuntime().setTargetHeapUtilization(0.75f);
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Missing class when invoking static main " + className, ex);
        }
        try {
            m = cl.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Missing static main on " + className, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Problem getting static main on " + className, ex);
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Main method is not public and static on " + className);
        }
        throw new ZygoteInit.MethodAndArgsCaller(m, argv);
    }

    public static void main(String[] argv) {
        RuntimeInit.commonInit();
        RuntimeInit.finishInit();
    }

    public static void finishInit() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#finishInit()V", true, null);
    }

    public static void zygoteInit(String[] argv) throws ZygoteInit.MethodAndArgsCaller {
        int curArg;
        System.setOut(new AndroidPrintStream(4, "System.out"));
        System.setErr(new AndroidPrintStream(5, "System.err"));
        RuntimeInit.commonInit();
        RuntimeInit.zygoteInitNative();
        for (curArg = 0; curArg < argv.length; ++curArg) {
            String arg = argv[curArg];
            if (arg.equals("--")) {
                ++curArg;
                break;
            }
            if (!arg.startsWith("--")) break;
            if (!arg.startsWith("--nice-name=")) continue;
            String niceName = arg.substring(arg.indexOf(61) + 1);
            Process.setArgV0(niceName);
        }
        if (curArg == argv.length) {
            Log.e(TAG, "Missing classname argument to RuntimeInit!");
            return;
        }
        String startClass = argv[curArg++];
        String[] startArgs = new String[argv.length - curArg];
        System.arraycopy(argv, curArg, startArgs, 0, startArgs.length);
        RuntimeInit.invokeStaticMain(startClass, startArgs);
    }

    public static void zygoteInitNative() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#zygoteInitNative()V", true, null);
    }

    public static int isComputerOn() {
        return OverrideMethod.invokeI("com.android.internal.os.RuntimeInit#isComputerOn()I", true, null);
    }

    public static void turnComputerOn() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#turnComputerOn()V", true, null);
    }

    public static int getQwertyKeyboard() {
        return OverrideMethod.invokeI("com.android.internal.os.RuntimeInit#getQwertyKeyboard()I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void crash(String tag, Throwable t) {
        if (mApplicationObject != null) {
            byte[] crashData = null;
            try {
                Log.e(TAG, Log.getStackTraceString(t));
                crashData = RuntimeInit.marshallException(tag, t);
                if (crashData == null) {
                    throw new NullPointerException("Can't marshall crash data");
                }
            }
            catch (Throwable t2) {
                try {
                    Log.e(TAG, "Error reporting crash: " + Log.getStackTraceString(t2));
                }
                catch (Throwable t3) {
                    // empty catch block
                }
            }
            try {
                String msg = t.getMessage();
                if (msg == null) {
                    msg = t.toString();
                }
                IActivityManager am = ActivityManagerNative.getDefault();
                try {
                    int res = am.handleApplicationError(mApplicationObject, 0, tag, msg, t.toString(), crashData);
                    if (res != 1) return;
                    Debug.waitForDebugger();
                    return;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return;
            }
            catch (Throwable t2) {
                try {
                    Log.e(TAG, "Error reporting crash: " + Log.getStackTraceString(t2));
                    return;
                }
                catch (Throwable t3) {
                    // empty catch block
                }
                return;
            }
            finally {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }
        try {
            Log.e(TAG, "*** EXCEPTION IN SYSTEM PROCESS.  System will crash.");
            Log.e(tag, Log.getStackTraceString(t));
            RuntimeInit.reportException(tag, t, true);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        finally {
            Process.killProcess(Process.myPid());
            System.exit(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportException(String tag, Throwable t, boolean sync) {
        if (!initialized) {
            return;
        }
        int reenter = sInReportException.getAndIncrement();
        if (reenter != 0) {
            sInReportException.decrementAndGet();
            Log.e(TAG, "Crash logging skipped, already logging another crash");
            return;
        }
        try {
            byte[] crashData = RuntimeInit.marshallException(tag, t);
            ICheckinService checkin = ICheckinService.Stub.asInterface(ServiceManager.getService("checkin"));
            if (checkin == null) {
                Log.e(TAG, "Crash logging skipped, no checkin service");
            } else if (sync) {
                checkin.reportCrashSync(crashData);
            } else {
                checkin.reportCrashAsync(crashData);
            }
        }
        catch (Throwable t2) {
            Log.e(TAG, "Crash logging failed: " + t2);
        }
        finally {
            sInReportException.decrementAndGet();
        }
    }

    public static byte[] marshallException(String tag, Throwable t) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            new CrashData(tag, t).write(dout);
            dout.close();
        }
        catch (IOException e) {
            return null;
        }
        return bout.toByteArray();
    }

    public static CrashData unmarshallException(byte[] crashDataBytes) {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(crashDataBytes);
            DataInputStream din = new DataInputStream(bin);
            return new CrashData(din);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void setApplicationObject(IBinder app) {
        mApplicationObject = app;
    }

    static {
        sInReportException = new AtomicInteger();
        DdmRegister.registerHandlers();
    }

    public static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        public UncaughtHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            try {
                Log.e(RuntimeInit.TAG, "Uncaught handler: thread " + t.getName() + " exiting due to uncaught exception");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            RuntimeInit.crash(RuntimeInit.TAG, e);
        }

        public /* synthetic */ UncaughtHandler(1 x0) {
            this();
        }
    }
}

