/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TableRow;
import com.android.internal.R;
import java.util.regex.Pattern;

public class TableLayout
extends LinearLayout {
    public int[] mMaxWidths;
    public SparseBooleanArray mStretchableColumns;
    public SparseBooleanArray mShrinkableColumns;
    public SparseBooleanArray mCollapsedColumns;
    public boolean mShrinkAllColumns;
    public boolean mStretchAllColumns;
    public PassThroughHierarchyChangeListener mPassThroughListener;
    public boolean mInitialized;

    public TableLayout(Context context) {
        super(context);
        this.initTableLayout();
    }

    public TableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        String collapsedColumns;
        String shrinkedColumns;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TableLayout);
        String stretchedColumns = a.getString(0);
        if (stretchedColumns != null) {
            if (stretchedColumns.charAt(0) == '*') {
                this.mStretchAllColumns = true;
            } else {
                this.mStretchableColumns = TableLayout.parseColumns(stretchedColumns);
            }
        }
        if ((shrinkedColumns = a.getString(1)) != null) {
            if (shrinkedColumns.charAt(0) == '*') {
                this.mShrinkAllColumns = true;
            } else {
                this.mShrinkableColumns = TableLayout.parseColumns(shrinkedColumns);
            }
        }
        if ((collapsedColumns = a.getString(2)) != null) {
            this.mCollapsedColumns = TableLayout.parseColumns(collapsedColumns);
        }
        a.recycle();
        this.initTableLayout();
    }

    public static SparseBooleanArray parseColumns(String sequence) {
        String[] columnDefs;
        SparseBooleanArray columns = new SparseBooleanArray();
        Pattern pattern = Pattern.compile("\\s*,\\s*");
        for (String columnIdentifier : columnDefs = pattern.split(sequence)) {
            try {
                int columnIndex = Integer.parseInt(columnIdentifier);
                if (columnIndex < 0) continue;
                columns.put(columnIndex, true);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return columns;
    }

    public void initTableLayout() {
        if (this.mCollapsedColumns == null) {
            this.mCollapsedColumns = new SparseBooleanArray();
        }
        if (this.mStretchableColumns == null) {
            this.mStretchableColumns = new SparseBooleanArray();
        }
        if (this.mShrinkableColumns == null) {
            this.mShrinkableColumns = new SparseBooleanArray();
        }
        this.mPassThroughListener = new PassThroughHierarchyChangeListener(null);
        super.setOnHierarchyChangeListener(this.mPassThroughListener);
        this.mInitialized = true;
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    public void requestRowsLayout() {
        if (this.mInitialized) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).requestLayout();
            }
        }
    }

    public void requestLayout() {
        if (this.mInitialized) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).forceLayout();
            }
        }
        super.requestLayout();
    }

    public boolean isShrinkAllColumns() {
        return this.mShrinkAllColumns;
    }

    public void setShrinkAllColumns(boolean shrinkAllColumns) {
        this.mShrinkAllColumns = shrinkAllColumns;
    }

    public boolean isStretchAllColumns() {
        return this.mStretchAllColumns;
    }

    public void setStretchAllColumns(boolean stretchAllColumns) {
        this.mStretchAllColumns = stretchAllColumns;
    }

    public void setColumnCollapsed(int columnIndex, boolean isCollapsed) {
        this.mCollapsedColumns.put(columnIndex, isCollapsed);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof TableRow)) continue;
            ((TableRow)view).setColumnCollapsed(columnIndex, isCollapsed);
        }
        this.requestRowsLayout();
    }

    public boolean isColumnCollapsed(int columnIndex) {
        return this.mCollapsedColumns.get(columnIndex);
    }

    public void setColumnStretchable(int columnIndex, boolean isStretchable) {
        this.mStretchableColumns.put(columnIndex, isStretchable);
        this.requestRowsLayout();
    }

    public boolean isColumnStretchable(int columnIndex) {
        return this.mStretchAllColumns || this.mStretchableColumns.get(columnIndex);
    }

    public void setColumnShrinkable(int columnIndex, boolean isShrinkable) {
        this.mShrinkableColumns.put(columnIndex, isShrinkable);
        this.requestRowsLayout();
    }

    public boolean isColumnShrinkable(int columnIndex) {
        return this.mShrinkAllColumns || this.mShrinkableColumns.get(columnIndex);
    }

    public void trackCollapsedColumns(View child) {
        if (child instanceof TableRow) {
            TableRow row = (TableRow)child;
            SparseBooleanArray collapsedColumns = this.mCollapsedColumns;
            int count = collapsedColumns.size();
            for (int i = 0; i < count; ++i) {
                int columnIndex = collapsedColumns.keyAt(i);
                boolean isCollapsed = collapsedColumns.valueAt(i);
                if (!isCollapsed) continue;
                row.setColumnCollapsed(columnIndex, isCollapsed);
            }
        }
    }

    public void addView(View child) {
        super.addView(child);
        this.requestRowsLayout();
    }

    public void addView(View child, int index) {
        super.addView(child, index);
        this.requestRowsLayout();
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        super.addView(child, params);
        this.requestRowsLayout();
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        this.requestRowsLayout();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureVertical(widthMeasureSpec, heightMeasureSpec);
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutVertical();
    }

    public void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (child instanceof TableRow) {
            ((TableRow)child).setColumnsWidthConstraints(this.mMaxWidths);
        }
        super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    public void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        this.findLargestCells(widthMeasureSpec);
        this.shrinkAndStretchColumns(widthMeasureSpec);
        super.measureVertical(widthMeasureSpec, heightMeasureSpec);
    }

    public void findLargestCells(int widthMeasureSpec) {
        boolean firstRow = true;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || !(child instanceof TableRow)) continue;
            TableRow row = (TableRow)child;
            ViewGroup.LayoutParams layoutParams = row.getLayoutParams();
            layoutParams.height = -2;
            int[] widths = row.getColumnsWidths(widthMeasureSpec);
            int newLength = widths.length;
            if (firstRow) {
                if (this.mMaxWidths == null || this.mMaxWidths.length != newLength) {
                    this.mMaxWidths = new int[newLength];
                }
                System.arraycopy(widths, 0, this.mMaxWidths, 0, newLength);
                firstRow = false;
                continue;
            }
            int length = this.mMaxWidths.length;
            int difference = newLength - length;
            if (difference > 0) {
                int[] oldMaxWidths = this.mMaxWidths;
                this.mMaxWidths = new int[newLength];
                System.arraycopy(oldMaxWidths, 0, this.mMaxWidths, 0, oldMaxWidths.length);
                System.arraycopy(widths, oldMaxWidths.length, this.mMaxWidths, oldMaxWidths.length, difference);
            }
            int[] maxWidths = this.mMaxWidths;
            length = Math.min(length, newLength);
            for (int j = 0; j < length; ++j) {
                maxWidths[j] = Math.max(maxWidths[j], widths[j]);
            }
        }
    }

    public void shrinkAndStretchColumns(int widthMeasureSpec) {
        if (this.mMaxWidths == null) {
            return;
        }
        int totalWidth = 0;
        for (int width : this.mMaxWidths) {
            totalWidth += width;
        }
        int size = View.MeasureSpec.getSize(widthMeasureSpec) - this.mPaddingLeft - this.mPaddingRight;
        if (totalWidth > size && (this.mShrinkAllColumns || this.mShrinkableColumns.size() > 0)) {
            this.mutateColumnsWidth(this.mShrinkableColumns, this.mShrinkAllColumns, size, totalWidth);
        } else if (totalWidth < size && (this.mStretchAllColumns || this.mStretchableColumns.size() > 0)) {
            this.mutateColumnsWidth(this.mStretchableColumns, this.mStretchAllColumns, size, totalWidth);
        }
    }

    public void mutateColumnsWidth(SparseBooleanArray columns, boolean allColumns, int size, int totalWidth) {
        int column;
        int i;
        int skipped = 0;
        int[] maxWidths = this.mMaxWidths;
        int length = maxWidths.length;
        int count = allColumns ? length : columns.size();
        int totalExtraSpace = size - totalWidth;
        int extraSpace = totalExtraSpace / count;
        if (!allColumns) {
            for (i = 0; i < count; ++i) {
                column = columns.keyAt(i);
                if (!columns.valueAt(i)) continue;
                if (column < length) {
                    int n = column;
                    maxWidths[n] = maxWidths[n] + extraSpace;
                    continue;
                }
                ++skipped;
            }
        } else {
            int i2 = 0;
            while (i2 < count) {
                int n = i2++;
                maxWidths[n] = maxWidths[n] + extraSpace;
            }
            return;
        }
        if (skipped > 0 && skipped < count) {
            extraSpace = skipped * extraSpace / (count - skipped);
            for (i = 0; i < count; ++i) {
                column = columns.keyAt(i);
                if (!columns.valueAt(i) || column >= length) continue;
                if (extraSpace > maxWidths[column]) {
                    maxWidths[column] = 0;
                    continue;
                }
                int n = column;
                maxWidths[n] = maxWidths[n] + extraSpace;
            }
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public static class 1 {
    }

    public class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        public ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        public PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            TableLayout.this.trackCollapsedColumns(child);
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }

        public /* synthetic */ PassThroughHierarchyChangeListener(1 x1) {
            this();
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(-1, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(-1, h, initWeight);
        }

        public LayoutParams() {
            super(-1, -2);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = -1;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

